' Soundex.Bas - Program to demonstrate the Soundex
'               string matching algorithm

CONST FALSE = 0, TRUE = NOT FALSE

DIM SHARED sxData AS STRING * 26

DECLARE SUB Soundex (InLine$, Output$)


' Initialize the soundex letter category table

sxData = "01230120022455012623010202"
FOR I% = 1 TO 26
   IF MID$(sxData, I%, 1) = "0" THEN MID$(sxData, I%, 1) = CHR$(0)
NEXT I%

' Get a word from the user, then generate and display
' the corresponding soundex code.

DO
   InLine$ = "": Output$ = ""
   PRINT : PRINT "Enter a word or press ENTER to quit:";
   INPUT InLine$
   IF LEN(InLine$) THEN
     Soundex InLine$, Output$
     PRINT "The soundex code for "; InLine$; " is "; Output$
   END IF
LOOP WHILE InLine$ <> ""
END


SUB Soundex (InLine$, Output$)
' Soundex - Generate a soundex code for the string in InLine$
'       and return the result in the string Output$

DIM Ix AS INTEGER
DIM Ox AS INTEGER
DIM cTmp AS INTEGER

IF LEN(InLine$) THEN
  Ox = 1
  Output$ = "0000"
  InLen% = LEN(InLine$)
  
  FOR Ch% = 1 TO InLen%
     cTmp = ASC(MID$(InLine$, Ch%, 1)) AND &H5F
     IF Ox = 1 THEN
       MID$(Output$, Ox, 1) = CHR$(cTmp)
       Ox = Ox + 1
     ELSE
       cTmp = ASC(MID$(sxData, cTmp - &H40, 1))
       IF cTmp THEN
         IF ASC(MID$(Output$, Ox - 1, 1)) <> cTmp THEN
           MID$(Output$, Ox, 1) = CHR$(cTmp)
           Ox = Ox + 1
         END IF
       END IF
       IF Ox > 4 THEN EXIT FOR
     END IF
  NEXT Ch%
ELSE  
  Output$ = ""             ' null input string, return null output
END IF

END SUB

