' Dir_Read.Bas - Program to demonstrate the DirFun package.

' $INCLUDE: 'DIRFUN.BI'

DEFINT A-Z

DIM MyDTA AS DataTransferArea
DIM DirEntry AS DirectoryRecord
  
  CLS: INPUT "Enter file specification: "; filespec$
  SetDTA MyDTA
  
  FindStatus = FindFirst(0, filespec$, DirEntry, MyDTA)
  PrintDirEntry DirEntry, FindStatus
  FindStatus = FindNext(DirEntry, MyDTA)
  'IF FindStatus <> 0 then there are no more files
  '   or no match was found or no prev call to FindFirst
  WHILE FindStatus = 0
    PrintDirEntry DirEntry, FindStatus
    FindStatus = FindNext(DirEntry, MyDTA)
    SetDTA MyDTA
  WEND
END

FUNCTION FmtDate$ (FDate)
Day = FDate AND &H1F: Month = (FDate AND &H1E0) \ 32
Year = (FDate AND &HFE00) \ 512 + 1980
FmtDate$ = RStr$(Month, 2) + "-" + RStr$(Day, 2) + "-" + RStr$(Year, 4)
END FUNCTION

FUNCTION FmtTime$ (T%)
Seconds = (T% AND &H1F) * 2: Minutes = (T% AND &H7E0) \ 32
Hours = (T% < 0) * (-16) + ((T% AND &H7FFF) \ 2048)
Abbr$ = " am"
IF Hours = 12 THEN Abbr$ = " pm"
IF Hours = 0 THEN Hours = 12
IF Hours > 12 THEN   'Reset to 12 hour clock
  Hours = Hours MOD 12: Abbr$ = " pm"
END IF
FmtTime$ = RStr$(Hours, 2) + ":" + RStr$(Minutes, 2) + ":" _
          + RStr$(Seconds, 2) + Abbr$
END FUNCTION

SUB PrintDirEntry (DR AS DirectoryRecord, FindStatus)
FmtStr$ = "\          \  ##,###,###  " + "\        \ \           \  ###"
IF FindStatus = 0 THEN
  PRINT USING FmtStr$; DR.FileName; DR.FileSize; _
              FmtDate$(DR.FileDate); FmtTime$(DR.FileTime); DR.FileAttb
ELSE
  PRINT "Error on file lookup"
END IF
END SUB

FUNCTION RStr$ (X%, LX%)
X$ = STR$(X%)
RStr$ = RIGHT$("00000" + RIGHT$(X$, LEN(X$) - 1), LX%)
END FUNCTION
