TITLE  'Draw string EGA'
NAME   DRAWSTR
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1991 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
;     mod1:      24 Jan 91 added foreground only mode-chh               |
;     mod2:      27 Jan 91 pixel precision                              |
; function:      Draw a string in EGA/VGA (W for window bound)          |
;   caller:      FAR call (QuickBASIC convention)                       |
;                nx = DRAWSTR(0,"HELLO",0,0,7,0,8)                      |
;                nx = DRAWSTRW(0,"HELLO",0,0,7,0,8)                     |
;    stack:     +06 = gap between characters/or zero for proportional   |
;                08 = bg                                                |
;                10 = fg                                                |
;                12 = y0                                                |
;                14 = x0                                                |
;                16 = string descriptor offset                          |
;                18 = replacement type(if bit 7 then foreground only)   |
;  returns:      next x position                                        |
;     NOTE:     SS overrides used to access some BSS data               |
;     NOTE:     proportional character width in 256 byte table following|
;               active font data (if gap=0)                             |
;-----------------------------------------------------------------------|

PARMS           = 7
ARGaddtype      EQU [bp+18]
ARGdesc         EQU [bp+16]
ARGx            EQU [bp+14]
ARGy            EQU [bp+12]
ARGfg           EQU [bp+10]
ARGbg           EQU [bp+08]
ARGgap          EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

DrawStr_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:DrawStr_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  DrawStr,DrawStrW
DrawStr         PROC    FAR

                mov     InWindow,0
                jmp     short DrawStr0

DrawStrW        LABEL FAR
                mov     InWindow,1

DrawStr0:       push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGdesc
                mov     ax,[bx]
                or      ax,ax
                jnz     DS00a
                jmp     Lexit3          ;must have length

DS00a:          mov     StrLen,ax
                mov     ax,[bx+2]
                mov     StrOff,ax
                mov     bx,ARGx
                mov     ax,[bx]
                mov     x0,ax
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                mov     bx,ARGfg
                mov     ax,[bx]
                mov     fg,ax
                mov     bx,ARGbg
                mov     ax,[bx]
                mov     bg,ax
                mov     bx,ARGgap
                mov     ax,[bx]
                mov     gap,ax

                mov     PixelRows,0     ;zero for later check
                cmp     InWindow,0      ;window bound?
                je      DrawStr0a       ;no

                mov     ax,x0           ;check if xpos is in window
DS00:           cmp     ax,X0clip2      ;is left side ok?
                jae     DS01            ; yes
                dec     StrLen          ;no,move right a character
                jz      DSxit           ;if possible
                add     ax,8            ;move 8 pixels at a time
                mov     x0,ax           ;next char's position
                inc     StrOff          ;next char
                jmp     short DS00

DS01:           cmp     ax,X1clip2      ;right side?
                ja      DSxit           ; no good
                mov     ax,y0           ;check if ypos is in window
                cmp     ax,Y0clip2      ;is ypos < window top?
                jb      DSxit           ;yes,no good
                cmp     ax,Y1clip2      ;is ypos > window bottom?
                jae     DSxit           ;yes,no good
                push    ds
                sub     ax,ax
                mov     ds,ax
                mov     ax,ds:[0485h]   ;POINTS (actual number)
                pop     ds
                mov     bx,Y1clip2      ;bottom y of window
                sub     bx,y0           ;- top y of string position
                                        ;(do not allow last line to be used)
                cmp     ax,bx           ;are POINTS <= remaining lines?
                jbe     Drawstr0a       ;no
                mov     PixelRows,bx    ;yes

DrawStr0a:      cmp     StrLen,0
                ja      DrawStr1        ;must have length!
                jmp     Lexit3

DSxit:          mov     ax,-1
                jmp     Lexit3bad

                ;set up graphics controller

DrawStr1:       mov     dx,03CEh        ;controller port address
                mov     ax,0A05h        ;al = mode reg
                                        ;ah = write mode 2 (bits 0-1)
                                        ;     read mode 1 (bit 4)
                out     dx,ax
                mov     ah,byte ptr RMWbits
                and     ah,7Fh          ;bit 7 off
                mov     al,3            ;al = data rotate/func select reg
                out     dx,ax

                mov     ax,0007         ;ah = color don't care bits
                                        ;al = color don't care reg
                out     dx,ax           ;don't care for all bit planes

                ;let's get ready

                push    ds
                sub     ax,ax
                mov     ds,ax           ;ds->0 seg
                ASSUME ds:nothing
                mov     cx,ds:[0485h]   ;cx = POINTS
                mov     ss:points,cx
                cmp     ss:PixelRows,0  ;already have lines to do?
                jne     Dx1             ;yes
                mov     ss:PixelRows,cx ;no,lines=points then

Dx1:            mov     bx,043h * 4     ;ds:bx->int 43h vector
                les     di,[bx]         ;es:di->start of char table
                pop     ds
                ASSUME ds:dgroup
                mov     segXY,es

                mov     offXY,di        ;es:offXY->start of char table
                mov     ax,256
                mul     cx
                add     ax,di
                mov     offXYp,ax       ;es:offXYp->start of width table

                mov     cx,StrLen
                mov     si,StrOff
                mov     dx,03CEh        ;restore GC after the 16 multiply

                mov     bp,bpl          ;let's speed things up a bit
                test    byte ptr RMWbits,80h  ;doing foreground only?
                jz      DoString        ;no
                jmp     xDoString       ;yes

DoString:       lodsb                   ;get character from string
                xor     ah,ah
                mov     char,ax         ;save it
                push    cx
                push    si
                push    ds

                ;calculate first pixel address

                mov     PMask,000FFh
                mov     ax,x0
                add     ax,8            ;max end of this character+1
                cmp     ax,X1clip2
                jb      L01             ;already ok
                sub     ax,X1clip2      ;bits too many at end of character
                mov     cl,al
                mov     ax,0FFh         ;start with all bits valid
                mov     byte ptr PMask+1,al ;flag last character clip
                shl     ax,cl           ;zero the bad bits
                mov     byte ptr PMask,al   ;al=valid mask for last character

L01:            mov     ax,y0
                mov     bx,x0
                mov     cx,bp           ;bpl
                call    PixelAddr       ;es:bx -> buffer
                                        ;cl = bits to shift left to mask pixel

                inc     cx
                and     cl,7            ;cl = bits to shift to mask char

                mov     ch,0FFh
                shl     ch,cl           ;ch = bit mask for right side of char
                mov     Shift,cx

                push    es
                mov     si,bx           ;si = video buffer offset

                ;set up character definition addressing

                mov     es,segXY
                mov     cx,points
                mov     di,offXY        ;es:di->start of char table
                mov     ax,char
                mul     cl              ;ax=offset into char def table
                                        ;char<=FF so use cl and save dx
                add     di,ax           ;di->char def

                mov     cx,PixelRows

                pop     ds              ;ds:si -> video buffer
                ASSUME ds:nothing

                ;select output routine depending if byte-aligned

                mov     bl,byte ptr ss:fg
                mov     bh,byte ptr ss:bg
                cmp     byte ptr ss:Shift,0     ;test bits to shift
                jne     L20             ;jump if char not byte-aligned

                cmp     byte ptr PMask+1,0FFh ;last character needs to be clip?
                je      L10a            ;yes

                ;routine for byte-aligned characters (no clip)

                mov     al,8            ;al = bit mask reg
L10:            mov     ah,es:[di]      ;ah = pattern for next row of pixels
                out     dx,ax           ;update bit mask reg
                and     [si],bl         ;update fg pixels
                not     ah
                out     dx,ax
                and     [si],bh         ;update bg pixels
                inc     di              ;es:di -> next byte in char def table
                add     si,bp           ;increment to next line (bp=bpl)
                loop    L10
                jmp     short Lexit

                ;routine for byte-aligned characters (last character clip)
                ;mod2-chh

L10a:           mov     al,8            ;al = bit mask reg
L10b:           mov     ah,es:[di]      ;ah = pattern for next row of pixels
                and     ah,byte ptr PMask ;clip it
                out     dx,ax           ;update bit mask reg
                and     [si],bl         ;update fg pixels
                not     ah
                out     dx,ax
                and     [si],bh         ;update bg pixels
                inc     di              ;es:di -> next byte in char def table
                add     si,bp           ;increment to next line (bp=bpl)
                loop    L10b
                jmp     short Lexit

                ;-------
                ;routine for non-byte-aligned characters

L20:            push    cx
                mov     cx,ss:Shift     ;ch = mask for left side of char
                                        ;cl = bits to shift left
                ;left side of character

                mov     al,es:[di]      ;al = bits for next row of pixels
                and     al,byte ptr PMask ;clip it mod2-chh
                xor     ah,ah
                shl     ax,cl           ;ah = bits for left side of char
                                        ;al = bits for right side of char

                push    ax              ;save bits for right side

                mov     al,8            ;al = bit mask reg
                out     dx,ax           ;set bit mask for fg pixels

                and     [si],bl         ;update fg pixels

                not     ch              ;ch = mask for left side of char
                xor     ah,ch           ;ah = bits for bg pixels
                out     dx,ax           ;set bit mask

                and     [si],bh         ;update bg pixels

                ;right side of character

                pop     ax
                mov     ah,al           ;ah = bits for right side of char
                mov     al,8
                out     dx,ax           ;set bit mask

                inc     si              ;ds:si -> right side of char buffer
                and     [si],bl         ;update fg pixels

                not     ch              ;ch = mask for right side of char
                xor     ah,ch           ;ah = bits for bg pixels
                out     dx,ax           ;set bit mask

                and     [si],bh         ;update background pixels

                ;increment to next row of pixels in character

                inc     di              ;es:di -> next byte in char def table
                dec     si
                add     si,bp           ;ds:si -> next line (bp=bpl)

                pop     cx
                loop    L20

                ;loop end check of string

Lexit:          pop     ds
                ASSUME ds:dgroup

                mov     ax,gap          ;proportional or fixed?
                or      ax,ax
                jnz     Lexit1          ;if ax=0 then fall through

                mov     bx,offXYp       ;start of width table
                mov     al,byte ptr char;es:[bx+al]->width for this char
                db 26h
                xlat                    ;get width byte for this char

Lexit1:         add     ax,x0           ;add to previous x pos
                mov     x0,ax           ;update x pos
                pop     si
                pop     cx
                dec     cx
                jz      Lexit1_2

Lexit1_1:       cmp     InWindow,0      ;window bound?
                je      Lexit1a         ;no

                cmp     ax,X1clip2      ;next char >= window right
                ja      Lexit1_2        ;yes,exit
                                        ;else starting x position is ok
Lexit1a:        jmp     DoString
Lexit1_2:       jmp     Lexit2          ;done

                ;---------------------------------------------
                ;--------------------------------chh 24 Jan 91
                ;---------------------------------------------
                ;DO TRANSPARANT BACKGROUND (bit 7 of mode set)

xDoString:      lodsb                   ;get character from string
                xor     ah,ah
                mov     char,ax         ;save it
                push    cx
                push    si
                push    ds

                ;calculate first pixel address

                mov     PMask,000FFh
                mov     ax,x0
                add     ax,8
                cmp     ax,X1clip2
                jb      xL01            ;already ok
                sub     ax,X1clip2      ;bits too many at end of character
                mov     cl,al
                mov     ax,0FFh         ;start with all bits valid
                mov     byte ptr PMask+1,al ;flag last character clip
                shl     ax,cl           ;zero the bad bits
                mov     byte ptr PMask,al   ;al=valid mask for last character

xL01:           mov     ax,y0
                mov     bx,x0
                mov     cx,bp           ;bp=bpl
                call    PixelAddr       ;es:bx -> buffer
                                        ;cl = bits to shift left to mask pixel

                inc     cx
                and     cl,7            ;cl = bits to shift to mask char

                mov     ch,0FFh
                shl     ch,cl           ;ch = bit mask for right side of char
                mov     Shift,cx

                push    es
                mov     si,bx           ;si = video buffer offset

                ;set up character definition addressing

                mov     es,segXY
                mov     cx,points
                mov     di,offXY        ;es:di->start of char table
                mov     ax,char
                mul     cl              ;ax=offset into char def table
                                        ;char<=FF so use cl and save dx
                add     di,ax           ;di->char def

                mov     cx,PixelRows

                pop     ds              ;ds:si -> video buffer
                ASSUME ds:nothing

                ;select output routine depending if byte-aligned

                mov     bl,byte ptr ss:fg       ;skip bg (bh reg is free)
                cmp     byte ptr ss:Shift,0     ;test bits to shift
                jne     xL20            ;jump if char not byte-aligned

                cmp     byte ptr PMask+1,0FFh
                je      xL10a

                ;routine for byte-aligned characters

                mov     al,8            ;al = bit mask reg
xL10:           mov     ah,es:[di]      ;ah = pattern for next row of pixels
                out     dx,ax           ;update bit mask reg
                and     [si],bl         ;update fg pixels
                ;------                 ;skip background pixels
                inc     di              ;es:di -> next byte in char def table
                add     si,bp           ;increment to next line (bp=bpl)
                loop    xL10
                jmp     short xLexit

                ;routine for byte-aligned characters (with clip)
                ;mod2-chh

xL10a:          mov     al,8            ;al = bit mask reg
xL10b:          mov     ah,es:[di]      ;ah = pattern for next row of pixels
                and     ah,byte ptr PMask ;clip it
                out     dx,ax           ;update bit mask reg
                and     [si],bl         ;update fg pixels
                ;------                 ;skip background pixels
                inc     di              ;es:di -> next byte in char def table
                add     si,bp           ;increment to next line (bp=bpl)
                loop    xL10b
                jmp     short xLexit

                ;routine for non-byte-aligned characters

xL20:           push    cx
                mov     cx,ss:Shift     ;ch = mask for left side of char
                                        ;cl = bits to shift left
                ;left side of character

                mov     al,es:[di]      ;al = bits for next row of pixels
                and     al,byte ptr PMask ;clip it mod2-chh
                xor     ah,ah
                shl     ax,cl           ;ah = bits for left side of char
                                        ;al = bits for right side of char
                mov     bh,al           ;save bits for right side

                mov     al,8            ;al = bit mask reg
                out     dx,ax           ;set bit mask for fg pixels

                and     [si],bl         ;update fg pixels
                ;------                 ;skip background pixels

                ;right side of character

                mov     ah,bh           ;ah = bits for right side of char
                mov     al,8
                out     dx,ax           ;set bit mask

                inc     si              ;ds:si -> right side of char buffer
                and     [si],bl         ;update fg pixels
                ;------                 ;skip background pixels

                ;increment to next row of pixels in character

                inc     di              ;es:di -> next byte in char def table
                dec     si
                add     si,bp           ;ds:si -> next line (bp=bpl)

                pop     cx
                loop    xL20

                ;loop end check of string

xLexit:         pop     ds
                ASSUME ds:dgroup

                mov     ax,gap          ;proportional or fixed?
                or      ax,ax
                jnz     xLexit1         ;if ax=0 then fall through

                mov     bx,offXYp       ;start of width table
                mov     al,byte ptr char;es:[bx+al]->width for this char
                db 26h
                xlat                    ;get width byte for this char

xLexit1:        add     ax,x0           ;add to previous x pos
                mov     x0,ax           ;update x pos
                pop     si
                pop     cx
                dec     cx
                jz      Lexit2

                cmp     InWindow,0      ;window bound?
                je      xLexit1a        ;no

                cmp     ax,X1clip2      ;next char >= window right
                ja      Lexit2          ;yes,exit
                                        ;else starting x position is ok
xLexit1a:       jmp     xDoString

                ;both leave to here
                ;restore default graphics controller state and return to caller

Lexit2:         mov     ax,0FF08h
                out     dx,ax           ;restore bit mask reg
                mov     ax,0005
                out     dx,ax           ;restore mode reg
                mov     ax,0003
                out     dx,ax           ;data rotate\function select reg
                mov     ax,0F07h
                out     dx,ax           ;default color don't care
Lexit3:         mov     ax,x0           ;return next x position
Lexit3bad:      xor     dx,dx
                pop     di
                pop     si
                pop     ds
                ASSUME ds:dgroup
                pop     bp
                RET     PARMS*2

DrawStr         ENDP
DrawStr_TEXT    ENDS
                END

