DECLARE SUB ShowHelpScreen ()
DECLARE SUB SaveMasmFile (Masmfile$, callname$)
DECLARE SUB SaveDataFile (datafile$)
DECLARE SUB ToggleBit ()
DECLARE SUB DoCursorBit ()
DECLARE SUB TypeText ()
DECLARE SUB CopyReAlt ()
DECLARE SUB CopyReEd ()
DECLARE SUB PutWidth (wid%)
DECLARE SUB PopChar ()
DECLARE SUB ShowBits1 ()
DECLARE SUB PushChar ()
DECLARE SUB ShowBitsR ()
DECLARE SUB ShowBits0 ()
DECLARE SUB TableTog ()
DECLARE SUB GotoChar ()
DECLARE SUB DoXkeys (k%)
DECLARE SUB ShowWTR (char%, fg%, bg%)
DECLARE SUB SetFont (FONT%)
DECLARE SUB ShowWT0 (char%, fg%, bg%)
DECLARE SUB ShowEW1 ()
DECLARE SUB ShowCS0 (char%, fg%, bg%)
DECLARE SUB ShowCSR (char%, fg%, bg%)
DECLARE SUB SaveFont ()
DECLARE SUB LoadFont ()
DECLARE SUB ShowHelp ()
DECLARE SUB ShowActive ()
DECLARE SUB GetCMD ()
DECLARE SUB ShowTIT ()
DECLARE SUB ShowEW0 ()
DECLARE SUB ShowEWR ()
DECLARE SUB MakeBox (border%, x0%, y0%, x1%, y1%)
DECLARE SUB ClrBox (value%, x0%, y0%, x1%, y1%)
DECLARE SUB ShowMW ()
DECLARE SUB InitFE ()
DECLARE FUNCTION GetFileR% (file$, x0%, y0%)
DECLARE FUNCTION GetFile0% (file$, x0%, y0%)
DECLARE FUNCTION GetUI$ (x%, y%, length%, fg%, bg%)
DECLARE FUNCTION GetUIP$ (x%, y%, length%, fg%, bg%)
DECLARE FUNCTION GetKey% ()

DEFINT A-Z
REM $INCLUDE: 'QBEVGFX.BI'
'{font editor/16 Jan 91}

REM $STATIC
CONST MaxHi = 25, MaxBuff = MaxHi * 256 + 256
DIM SHARED EW0buff(0 TO MaxBuff) AS STRING * 1
DIM SHARED EW1buff(0 TO MaxHi) AS STRING * 1
DIM SHARED EWRbuff(0 TO MaxBuff) AS STRING * 1
DIM SHARED NIX AS STRING * 1

REM $DYNAMIC

DIM SHARED OrgPal AS STRING * 17
DIM SHARED OrgW2 AS WINDOW2Dtype
DIM SHARED NewW2 AS WINDOW2Dtype

DIM SHARED DefSub
DIM SHARED IsVGA, MidY, MaxY
DIM SHARED file0$, fileR$

DIM SHARED EW0max, EW0hi, EWRmax, EWRhi
DIM SHARED EW0active

DIM SHARED LB0, WT0, CC0
DIM SHARED LBR, WTR, CCR
DIM SHARED WT0active, WTRactive

DIM SHARED CursorX, CursorY

ON ERROR GOTO ErrorEnd
InitFE
ShowMW
ShowHelp
GetCMD
SETMODE &H3
SYSTEM

ErrorEnd:
SETMODE &H3
PRINT
PRINT "FONTED R/T error:"; ERR
PRINT "program stopped."
PRINT
SYSTEM

REM $STATIC
SUB ClrBox (value, x0, y0, x1, y1)

'clear a box

FOR y = y0 TO y1: DRAWLN 0, value, x0, y, x1, y: NEXT

END SUB

SUB CopyReAlt

'make sure we have a font loaded for both and re is active

IF NOT EW0active AND (WT0 AND WTR) THEN
   ptrR = CCR * EWRhi
   min = EWRhi: IF EW0hi < min THEN min = EW0hi
   FOR i = 0 TO (min - 1): EW1buff(i) = EWRbuff(ptrR + i): NEXT
   ShowBits1
END IF

END SUB

SUB CopyReEd

'make sure we have a font loaded for both and re is active

IF NOT EW0active AND (WT0 AND WTR) THEN
   DoCursorBit
   CursorX = 1: CursorY = 1
   ptr0 = CC0 * EW0hi
   ptrR = CCR * EWRhi
   min = EWRhi: IF EW0hi < min THEN min = EW0hi
   FOR i = 0 TO (min - 1): EW0buff(ptr0 + i) = EWRbuff(ptrR + i): NEXT
   ShowBits0
   ShowCS0 CC0, 15, 0
   DoCursorBit
END IF

END SUB

SUB DoCursorBit

x0 = 161: y0 = 3 + (EW0max - EW0hi) * 9
FONTSYS08
DRAWCH 24, 8, x0 + (CursorX - 1) * 9, y0 + (CursorY - 1) * 9, 7, 0
FONTSYS14

END SUB

SUB DoXkeys (k)

'handle extended keys

null$ = CHR$(0)
DEF SEG = 0: SD = PEEK(&H417) AND 3: DEF SEG
SELECT CASE k
CASE 1059       'F1 help screen
   ShowHelpScreen
CASE 1063       'F5 for the 123'ers
   GotoChar
CASE 1072       'up
   IF EW0active AND WT0 AND SD <> 0 THEN
      DoCursorBit
      ptr = CC0 * EW0hi
      FOR i = 1 TO (EW0hi - 1)
         EW0buff(ptr) = EW0buff(ptr + 1)
         ptr = ptr + 1
      NEXT
      EW0buff(ptr) = null$
      ShowBits0
      ShowCS0 CC0, 15, 0
      DoCursorBit
   ELSEIF EW0active THEN
      DoCursorBit
      CursorY = CursorY - 1
      IF CursorY = 0 THEN
         CursorX = CursorX - 1: IF CursorX = 0 THEN CursorX = 8
         CursorY = EW0hi
      END IF
      DoCursorBit
   END IF
CASE 1080       'down
   IF EW0active AND WT0 AND SD <> 0 THEN
      DoCursorBit
      ptr = CC0 * EW0hi + (EW0hi - 2)
      FOR i = 1 TO (EW0hi - 1)
         EW0buff(ptr + 1) = EW0buff(ptr)
         ptr = ptr - 1
      NEXT
      EW0buff(ptr + 1) = null$
      ShowBits0
      ShowCS0 CC0, 15, 0
      DoCursorBit
   ELSEIF EW0active THEN
      DoCursorBit
      CursorY = CursorY + 1
      IF CursorY > EW0hi THEN
         CursorX = CursorX + 1: IF CursorX = 9 THEN CursorX = 1
         CursorY = 1
      END IF
      DoCursorBit
   END IF
CASE 1077       'right
   IF EW0active AND WT0 AND SD <> 0 THEN
      DoCursorBit
      ptr = CC0 * EW0hi
      FOR i = 0 TO EW0hi
         t$ = CHR$(ASC(EW0buff(ptr + i)) \ 2)
         EW0buff(ptr + i) = t$
      NEXT
      ShowBits0
      ShowCS0 CC0, 15, 0
      DoCursorBit
   ELSEIF EW0active THEN
      DoCursorBit
      CursorX = CursorX + 1
      IF CursorX = 9 THEN
         CursorX = 1
         CursorY = CursorY + 1: IF CursorY > EW0hi THEN CursorY = 1
      END IF
      DoCursorBit
   END IF
CASE 1075       'left
   IF EW0active AND WT0 AND SD <> 0 THEN
      DoCursorBit
      ptr = CC0 * EW0hi
      FOR i = 0 TO EW0hi
         t$ = CHR$((ASC(EW0buff(ptr + i)) * 2) AND 255)
         EW0buff(ptr + i) = t$
      NEXT
      ShowBits0
      ShowCS0 CC0, 15, 0
      DoCursorBit
   ELSEIF EW0active THEN
      DoCursorBit
      CursorX = CursorX - 1
      IF CursorX = 0 THEN
         CursorX = 8
         CursorY = CursorY - 1: IF CursorY = 0 THEN CursorY = EW0hi
      END IF
      DoCursorBit
   END IF
CASE 1073 'WT0/R is 0 when no font loaded (pgup)
   IF EW0active AND WT0 THEN
      DoCursorBit
      ShowCS0 CC0, 7, 1
      CC0 = CC0 - 1: IF CC0 < 0 THEN CC0 = 255
      ShowCS0 CC0, 15, 0
      ShowBits0
      CursorX = 1: CursorY = 1
      DoCursorBit
   ELSEIF WTR THEN
      ShowCSR CCR, 7, 1
      CCR = CCR - 1: IF CCR < 0 THEN CCR = 255
      ShowCSR CCR, 15, 0
      ShowBitsR
   END IF
CASE 1081       '(pgdn)
   IF EW0active AND WT0 THEN
      DoCursorBit
      ShowCS0 CC0, 7, 1
      CC0 = CC0 + 1: IF CC0 > 255 THEN CC0 = 0
      ShowCS0 CC0, 15, 0
      ShowBits0
      CursorX = 1: CursorY = 1
      DoCursorBit
   ELSEIF WTR THEN
      ShowCSR CCR, 7, 1
      CCR = CCR + 1: IF CCR > 255 THEN CCR = 0
      ShowCSR CCR, 15, 0
      ShowBitsR
   END IF
CASE ELSE
END SELECT

END SUB

SUB GetCMD

'command dispatcher

DoCursorBit
DO
   k = GetKey
   'LOCATE 1, 71: PRINT k; "  "
   SELECT CASE k
   CASE IS > 999
      DoXkeys k
   CASE 1
      CopyReAlt
   CASE 5
      CopyReEd
   CASE 9
      EW0active = NOT EW0active
      ShowActive
   CASE 27
      nx = DRAWSTR(0, "Y/N?_", 47, 274, 15, 1, 8)
      k = GetKey
      nx = DRAWSTR(0, "     ", 47, 274, 7, 1, 8)
      IF k = 89 OR k = 121 THEN EXIT DO
   CASE 32
      ToggleBit
   CASE 43
      PushChar
   CASE 45
      PopChar
   CASE 71, 103
      GotoChar
   CASE 76, 108
      LoadFont
   CASE 83, 115
      SaveFont
   CASE 84, 116
      TypeText
   CASE 87, 119
      TableTog
   CASE &H31 TO &H3F
      'make sure we're not shifting on number keys (width upto 15 allowed)
      ok = 1
      DEF SEG = 0: t = PEEK(&H417) AND 3: DEF SEG
      IF k <= &H39 THEN IF t <> 0 THEN ok = 0
      IF ok THEN PutWidth k - &H30
   CASE ELSE
   END SELECT
LOOP

END SUB

FUNCTION GetFile0 (file$, x0, y0)

'load ed file

dp$ = ""
IF DefSub THEN
   drv = INSTR(file$, ":")
   dir = INSTR(file$, "\")
   IF drv + dir = 0 THEN dp$ = "DAT\"
END IF

stat = 0
ERASE EW0buff
OPEN dp$ + file$ FOR BINARY AS #1
sz& = LOF(1)
IF sz& = 0 THEN GOTO xitGF0

nx = DRAWSTR(0, STR$(sz&), x0 + 88, y0 + 28, 7, 0, 8)
GF0a:
inab$ = GetUI$(x0 + 168, y0 + 52, 2, 7, 0)
IF inab$ = CHR$(27) THEN GOTO xitGF0a
AB0 = VAL(inab$)
inlb$ = GetUI$(x0 + 168, y0 + 66, 2, 7, 0)
IF inlb$ = CHR$(27) THEN GOTO xitGF0a
LB0 = VAL(inlb$)
IF AB0 < 1 OR LB0 < 1 THEN GOTO GF0a
IF LB0 > EW0max THEN GOTO GF0a

IF LB0 > AB0 THEN B0 = AB0 ELSE B0 = LB0
WT0 = (((sz& - 256) \ AB0) = 256)
FOR char = 0 TO 255
   FOR byte = 0 TO B0 - 1
      inx = char * LB0 + byte
      GET #1, , EW0buff(inx)
   NEXT
   IF AB0 > LB0 THEN
      FOR skip = 1 TO (AB0 - LB0): GET #1, , NIX: NEXT
   ELSEIF LB0 > AB0 THEN
      FOR pad = 1 TO (LB0 - AB0): inx = inx + 1: EW0buff(inx) = CHR$(0): NEXT
   END IF
NEXT
IF WT0 THEN
   FOR i = 0 TO 255
      inx = inx + 1
      GET #1, , EW0buff(inx)
   NEXT
ELSE
   FOR i = 0 TO 255
      inx = inx + 1
      EW0buff(inx) = CHR$(8)
   NEXT
   WT0 = -1
END IF
CLOSE #1
GetFile0 = stat
WTRactive = 0
EXIT FUNCTION

xitGF0:         'file not found stat = 1
   CLOSE #1
   KILL dp$ + file$
   GetFile0 = 1
   EXIT FUNCTION
xitGF0a:        'Esc pressed
   GetFile0 = 2
   
END FUNCTION

FUNCTION GetFileR (file$, x0, y0)

'load re file

dp$ = ""
IF DefSub THEN
   drv = INSTR(file$, ":")
   dir = INSTR(file$, "\")
   IF drv + dir = 0 THEN dp$ = "DAT\"
END IF

stat = 0
ERASE EWRbuff
OPEN dp$ + file$ FOR BINARY AS #1
sz& = LOF(1)
IF sz& = 0 THEN GOTO xitGFR

nx = DRAWSTR(0, STR$(sz&), x0 + 88, y0 + 28, 7, 0, 8)
GFRa:
inab$ = GetUI$(x0 + 168, y0 + 52, 2, 7, 0)
ABR = VAL(inab$)
inlb$ = GetUI$(x0 + 168, y0 + 66, 2, 7, 0)
LBR = VAL(inlb$)
IF ABR < 1 OR LBR < 1 THEN GOTO GFRa
IF LBR > EWRmax THEN GOTO GFRa

IF LBR > ABR THEN BR = ABR ELSE BR = LBR
WTR = (((sz& - 256) \ ABR) = 256)
FOR char = 0 TO 255
   FOR byte = 0 TO BR - 1
      inx = char * LBR + byte
      GET #1, , EWRbuff(inx)
   NEXT
   IF ABR > LBR THEN
      FOR skip = 1 TO (ABR - LBR): GET #1, , NIX: NEXT
   ELSEIF LBR > ABR THEN
      FOR pad = 1 TO (LBR - ABR): inx = inx + 1: EWRbuff(inx) = CHR$(0): NEXT
   END IF
NEXT
IF WTR THEN
   FOR i = 0 TO 255
      inx = inx + 1
      GET #1, , EWRbuff(inx)
   NEXT
ELSE
   FOR i = 0 TO 255
      inx = inx + 1
      EWRbuff(inx) = CHR$(8)
   NEXT
   WTR = -1
END IF
CLOSE #1
WT0active = 0
GetFileR = stat
EXIT FUNCTION

xitGFR:         'file not found stat = 1
   CLOSE #1
   KILL dp$ + file$
   GetFileR = 1

END FUNCTION

FUNCTION GetKey

'get a key

DO
   DoCursorBit
   xit = -1
   k$ = INKEY$
   IF LEN(k$) = 2 THEN
      k = 1000 + ASC(RIGHT$(k$, 1))
   ELSEIF LEN(k$) = 1 THEN
      k = ASC(k$)
   ELSE
      xit = 0
   END IF
   WAITVS 1
   DoCursorBit
   WAITVS 1
LOOP UNTIL xit
GetKey = k

END FUNCTION

FUNCTION GetUI$ (x, y, length, fg, bg)

'get user input

ui$ = SPACE$(length)
cx = x: ptr = 0
DO
   DRAWCH 18, 95, cx, y, fg, bg
   in$ = INKEY$ + CHR$(0)
   SELECT CASE ASC(in$)
   CASE 8
      IF cx > x THEN
         MID$(ui$, ptr, 1) = " "
         ptr = ptr - 1
         DRAWCH 0, 32, cx, y, fg, bg
         cx = cx - 8
         DRAWCH 0, 32, cx, y, fg, bg
      END IF
   CASE 13
      DRAWCH 0, 32, cx, y, fg, bg
      EXIT DO
   CASE 27
      nx = DRAWSTR(0, SPACE$(length + 1), x, y, fg, bg, 8)
      ptr = 0
      EXIT DO
   CASE 32 TO 127
      IF ptr < length THEN
         ptr = ptr + 1
         MID$(ui$, ptr, 1) = in$
         DRAWCH 0, ASC(in$), cx, y, fg, bg
         cx = cx + 8
      END IF
   CASE ELSE
   END SELECT
LOOP
GetUI$ = LEFT$(ui$, ptr)

END FUNCTION

FUNCTION GetUIP$ (x, y, length, fg, bg)

'get user input (edit font)

ui$ = ""
ptr = 0
DRAWCH 18, 95, x, y, fg, bg
DO
   in$ = INKEY$
   IF in$ <> "" THEN
      in = ASC(in$)
      IF (in = 16 AND altflag = 0) THEN
         altflag = 1: in$ = ""
         nx = DRAWSTR(0, ui$ + "  ", x, y, fg, bg, 0)
      END IF
      IF altflag = 0 AND in = 8 THEN
         IF ptr > 0 THEN
            ptr = ptr - 1
            ui$ = LEFT$(ui$, ptr)
            nx = DRAWSTR(0, ui$ + "_  ", x, y, fg, bg, 0)
         END IF
      ELSEIF (altflag = 0) AND (in = 13 OR in = 27) THEN
         EXIT DO
      ELSEIF in$ <> "" THEN
         altflag = 0
         IF nx < 620 THEN
            ptr = ptr + 1
            ui$ = ui$ + LEFT$(in$, 1)
            nx = DRAWSTR(0, ui$ + "_  ", x, y, fg, bg, 0)
         END IF
      END IF
   END IF
LOOP

END FUNCTION

SUB GotoChar

'jump to char set char

DoCursorBit
in$ = GetUI$(102, 106, 4, 15, 1)
nx = DRAWSTR(0, "     ", 102, 106, 7, 1, 8)
IF UCASE$(RIGHT$(in$, 1)) = "H" THEN in$ = "&H" + LEFT$(in$, LEN(in$) - 1)
cc = VAL(in$)
IF cc >= 0 AND cc <= 255 THEN
   IF WT0 AND EW0active THEN
      ShowCS0 CC0, 7, 1
      CC0 = cc
      ShowCS0 CC0, 15, 0
      ShowBits0
   ELSEIF WTR THEN
      'either EW0 or EWR is active
      ShowCSR CCR, 7, 1
      CCR = cc
      ShowCSR CCR, 15, 0
      ShowBitsR
    END IF
END IF
CursorX = 1: CursorY = 1
DoCursorBit

END SUB

SUB InitFE

'init

cmd$ = COMMAND$
fonted$ = UCASE$(ENVIRON$("FONTED"))
IF INSTR(fonted$, "V") THEN cmd$ = cmd$ + "/V"
IF INSTR(fonted$, "D") THEN DefSub = -1
IF EGAVIDEO THEN
   IF INSTR(cmd$, "V") OR (INSTR(cmd$, "E") = 0 AND VGAVIDEO) THEN
      IsVGA = -1
      SETMODE &H12
      SETSCNBUFF 640, 480
      EW0max = 25: EWRmax = 25
      EW0hi = 16: EWRhi = 16
      MaxY = 479: MidY = 242
   ELSE
      SETMODE &H10
      SETSCNBUFF 640, 350
      EW0max = 18: EWRmax = 18
      EW0hi = 14: EWRhi = 14
      MaxY = 349: MidY = 176
   END IF
   EW0active = -1
   WT0active = 0: WTRactive = 0
   CursorX = 1: CursorY = 1
ELSE
   PRINT "Requires EGA compatible video."
   SYSTEM
END IF

END SUB

SUB LoadFont

'load font data from disk

DoCursorBit
x0 = 320 - 150: y0 = MaxY \ 2 - 56: x1 = 320 + 150: y1 = MaxY \ 2 + 56
sz& = DIMBLOCK&(15, x0 - 1, y0 - 1, x1 + 1, y1 + 1)
REDIM MiscBuff(0 TO sz& \ 2)
vseg = VARSEG(MiscBuff(0)): voff = VARPTR(MiscBuff(0))
GETBLOCK 15, x0 - 1, y0 - 1, x1 + 1, y1 + 1, vseg, voff
ClrBox 0, x0, y0, x1, y1
MakeBox 7, x0, y0, x1, y1
IF EW0active THEN txt$ = "Ed file:" ELSE txt$ = "Re file:"
nx = DRAWSTR(0, txt$, x0 + 24, y0 + 12, 7, 0, 8)
txt$ = "size:"
nx = DRAWSTR(0, txt$, x0 + 48, y0 + 28, 7, 0, 8)
txt$ = "Actual bytes/char:"
nx = DRAWSTR(0, txt$, x0 + 16, y0 + 52, 7, 0, 8)
txt$ = "Logical bytes/char:"
nx = DRAWSTR(0, txt$, x0 + 8, y0 + 66, 7, 0, 8)
txt$ = "<Esc> to Quit"
nx = DRAWSTR(0, txt$, x0 + 96, y0 + 96, 7, 0, 8)
infn$ = LTRIM$(RTRIM$(GetUI$(x0 + 96, y0 + 12, 24, 7, 0)))
IF EW0active AND infn$ <> "" THEN
   stat = GetFile0(infn$, x0, y0)
   IF stat = 0 THEN EW0hi = LB0
   nx = DRAWSTR(0, SPACE$(15), 7, 24, 7, 1, 8)
ELSEIF EW0active = 0 AND infn$ <> "" THEN
   stat = GetFileR(infn$, x0, y0)
   IF stat = 0 THEN EWRhi = LBR
   nx = DRAWSTR(0, SPACE$(15), 7, 38, 7, 1, 8)
ELSE
   stat = -3
END IF
PUTBLOCK 0, x0 - 1, y0 - 1, vseg, voff
IF stat = 0 THEN
   IF EW0active THEN
      file0$ = infn$
      nx = DRAWSTR(0, "Ed:" + RIGHT$(file0$, 12), 7, 24, 7, 1, 8)
      ShowEW0
      ShowEW1
      ShowCS0 -1, 7, 1
      CC0 = 65
      ShowCS0 CC0, 15, 0
      ShowBits0
   ELSE
      fileR$ = infn$
      nx = DRAWSTR(0, "Re:" + RIGHT$(fileR$, 12), 7, 38, 7, 1, 8)
      ShowEWR
      ShowCSR -1, 7, 1
      CCR = 65
      ShowCSR CCR, 15, 0
      ShowBitsR
   END IF
   ShowActive
ELSEIF stat = 1 THEN
   IF EW0active THEN
      nx = DRAWSTR(0, "Ed:Not found", 7, 24, 15, 1, 8)
   ELSE
      nx = DRAWSTR(0, "Re:Not found", 7, 38, 15, 1, 8)
   END IF
END IF
CursorX = 1: CursorY = 1
DoCursorBit

END SUB

SUB MakeBox (border, x0, y0, x1, y1)

'make a box

SETSTEP x0 - 1, y0 - 1
DRAWLNS 0, border, x1 + 1, y0 - 1
DRAWLNS 0, border, x1 + 1, y1 + 1
DRAWLNS 0, border, x0 - 1, y1 + 1
DRAWLNS 0, border, x0 - 1, y0 - 1

END SUB

SUB PopChar

'make sure we're active and have a font loaded

IF EW0active AND WT0 THEN
   DoCursorBit
   CursorX = 1: CursorY = 1
   ptr = CC0 * EW0hi
   FOR i = 0 TO (EW0hi - 1): EW0buff(ptr + i) = EW1buff(i): NEXT
   ShowBits0
   ShowCS0 CC0, 15, 0
   DoCursorBit
END IF

END SUB

SUB PushChar

'make sure we're active and have a font loaded

IF EW0active AND WT0 THEN
   ptr = CC0 * EW0hi
   FOR i = 0 TO (EW0hi - 1): EW1buff(i) = EW0buff(ptr + i): NEXT
   ShowBits1
END IF

END SUB

SUB PutWidth (wid)

IF EW0active THEN
   IF WT0active THEN
      ptr = (LB0 * 256) + CC0
      EW0buff(ptr) = CHR$(wid)
      ShowWT0 CC0, 15, 0
   END IF
ELSE
   IF WTRactive THEN
      ptr = (LBR * 256) + CCR
      EWRbuff(ptr) = CHR$(wid)
      ShowWTR CCR, 15, 0
   END IF
END IF

END SUB

SUB SaveDataFile (file$)

dp$ = ""
IF DefSub THEN
   drv = INSTR(file$, ":")
   dir = INSTR(file$, "\")
   IF drv + dir = 0 THEN dp$ = "DAT\"
END IF

OPEN dp$ + file$ FOR BINARY AS #1
FOR i = 0 TO ((LB0 * 256) + 256 - 1): PUT #1, , EW0buff(i): NEXT
CLOSE #1

END SUB

SUB SaveFont

'save font data to disk

IF NOT EW0active OR WT0 = 0 THEN EXIT SUB
DoCursorBit
x0 = 320 - 150: y0 = MaxY \ 2 - 56: x1 = 320 + 150: y1 = MaxY \ 2 + 56
sz& = DIMBLOCK&(15, x0 - 1, y0 - 1, x1 + 1, y1 + 1)
REDIM MiscBuff(0 TO sz& \ 2)
vseg = VARSEG(MiscBuff(0)): voff = VARPTR(MiscBuff(0))
GETBLOCK 15, x0 - 1, y0 - 1, x1 + 1, y1 + 1, vseg, voff
ClrBox 0, x0, y0, x1, y1
MakeBox 7, x0, y0, x1, y1
txt$ = "Data file:"
nx = DRAWSTR(0, txt$, x0 + 8, y0 + 12, 7, 0, 8)
txt$ = "Masm file:"
nx = DRAWSTR(0, txt$, x0 + 8, y0 + 28, 7, 0, 8)
txt$ = "Call name:"
nx = DRAWSTR(0, txt$, x0 + 8, y0 + 44, 7, 0, 8)
txt$ = "<Esc> to Quit"
nx = DRAWSTR(0, txt$, x0 + 96, y0 + 96, 7, 0, 8)
infn$ = LTRIM$(RTRIM$(GetUI$(x0 + 96, y0 + 12, 24, 7, 0)))
IF infn$ <> "" THEN
   datafile$ = infn$
   infn$ = LTRIM$(RTRIM$(GetUI$(x0 + 96, y0 + 28, 24, 7, 0)))
   IF infn$ <> "" THEN
      Masmfile$ = infn$
      infn$ = LTRIM$(RTRIM$(GetUI$(x0 + 96, y0 + 44, 10, 7, 0)))
      IF infn$ <> "" THEN
         callname$ = infn$
         txt$ = "working..."
         nx = DRAWSTR(0, txt$, x0 + 32, y0 + 68, 7, 0, 8)
         SaveDataFile datafile$
         SaveMasmFile Masmfile$, callname$
      END IF
   END IF
END IF
PUTBLOCK 0, x0 - 1, y0 - 1, vseg, voff
CursorX = 1: CursorY = 1
DoCursorBit

END SUB

SUB SaveMasmFile (file$, callname$)

tb$ = SPACE$(16)
cn$ = UCASE$(LTRIM$(RTRIM$(LEFT$(callname$, 10))))
t1$ = cn$ + "_TEXT" + SPACE$(11 - LEN(cn$)) + "SEGMENT WORD PUBLIC 'CODE'"
t2$ = tb$ + "ASSUME cs:" + cn$ + "_TEXT"
t3$ = tb$ + "PUBLIC " + cn$
t4$ = cn$ + SPACE$(16 - LEN(cn$)) + "PROC    FAR"
c1$ = tb$ + "push    di"
c2$ = tb$ + "sub     ax,ax"
c3$ = tb$ + "mov     es,ax"
c4$ = tb$ + "mov     word ptr es:[0485h]," + LTRIM$(STR$(LB0))
c5$ = tb$ + "mov     ax,offset " + cn$ + "data"
c6$ = tb$ + "mov     di,043h * 4"
c7$ = tb$ + "mov     es:[di],ax"
c8$ = tb$ + "mov     es:[di+2],cs"

c9$ = tb$ + "push    bp                         ;*new code for text mode*"
ca$ = tb$ + "mov     bh,byte ptr es:[0485h]     ;points"
cb$ = tb$ + "mov     bl,0                       ;use char set slot 0"
cc$ = tb$ + "mov     cx,256                     ;256 characters of data"
cd$ = tb$ + "mov     dx,0                       ;first ASCII code=0"
ce$ = tb$ + "les     bp,es:[di]                 ;font table at"
cf$ = tb$ + "mov     ax,1110h                   ;user alpha load, w/CRTC program"
cf1$ = tb$ + ";mov     ax,1100h                  ;user alpha load, no CRTC program"
cg$ = tb$ + "int 10h"
ch$ = tb$ + "pop     bp"

ci$ = tb$ + "pop     di"
cj$ = tb$ + "RET"
d1$ = cn$ + "data:"

w1$ = cn$ + "width:"

t5$ = cn$ + SPACE$(16 - LEN(cn$)) + "ENDP"
t6$ = cn$ + "_TEXT" + SPACE$(11 - LEN(cn$)) + "ENDS"
t7$ = tb$ + "END"

dp$ = ""
IF DefSub THEN
   drv = INSTR(file$, ":")
   dir = INSTR(file$, "\")
   IF drv + dir = 0 THEN dp$ = "ASM\"
END IF
OPEN dp$ + file$ FOR OUTPUT AS #1
PRINT #1, t1$
PRINT #1, t2$
PRINT #1, t3$
PRINT #1, t4$
PRINT #1, c1$
PRINT #1, c2$
PRINT #1, c3$
PRINT #1, c4$
PRINT #1, c5$
PRINT #1, c6$
PRINT #1, c7$
PRINT #1, c8$
PRINT #1, c9$
PRINT #1, ca$
PRINT #1, cb$
PRINT #1, cc$
PRINT #1, cd$
PRINT #1, ce$
PRINT #1, cf$
PRINT #1, cf1$
PRINT #1, cg$
PRINT #1, ch$
PRINT #1, ci$
PRINT #1, cj$
PRINT #1, d1$
FOR char = 0 TO 255
   PRINT #1, "db ";
   FOR byte = 0 TO LB0 - 2
      inx = char * LB0 + byte
      PRINT #1, LTRIM$(STR$(ASC(EW0buff(inx)))) + ",";
   NEXT
   inx = inx + 1
   PRINT #1, LTRIM$(STR$(ASC(EW0buff(inx)))) + "; (" + LTRIM$(STR$(char)) + ")"
NEXT
PRINT #1, w1$
FOR i = 1 TO 8
   PRINT #1, "db ";
   FOR j = 1 TO 31
      inx = inx + 1
      PRINT #1, LTRIM$(STR$(ASC(EW0buff(inx)))) + ",";
   NEXT
   inx = inx + 1
   PRINT #1, LTRIM$(STR$(ASC(EW0buff(inx))))
NEXT
PRINT #1, t5$
PRINT #1, t6$
PRINT #1, t7$
CLOSE #1

END SUB

SUB SetFont (FONT)

'set int 43h to font's char set data

IF FONT = 0 THEN
   'ed data
   vseg = VARSEG(EW0buff(0)): voff = VARPTR(EW0buff(0))
   nol = PEEK(VARPTR(voff)): noh = PEEK(VARPTR(voff) + 1)
   nsl = PEEK(VARPTR(vseg)): nsh = PEEK(VARPTR(vseg) + 1)
   DEF SEG = 0
   ol = PEEK(&H43 * 4): oh = PEEK(&H43 * 4 + 1)
   sl = PEEK(&H43 * 4 + 2): sh = PEEK(&H43 * 4 + 3)
   POKE (&H43 * 4), nol: POKE (&H43 * 4 + 1), noh
   POKE (&H43 * 4 + 2), nsl: POKE (&H43 * 4 + 3), nsh
   POKE &H485, LB0
   DEF SEG
ELSEIF FONT = 1 THEN
   're data
   vseg = VARSEG(EWRbuff(0)): voff = VARPTR(EWRbuff(0))
   nol = PEEK(VARPTR(voff)): noh = PEEK(VARPTR(voff) + 1)
   nsl = PEEK(VARPTR(vseg)): nsh = PEEK(VARPTR(vseg) + 1)
   DEF SEG = 0
   ol = PEEK(&H43 * 4): oh = PEEK(&H43 * 4 + 1)
   sl = PEEK(&H43 * 4 + 2): sh = PEEK(&H43 * 4 + 3)
   POKE (&H43 * 4), nol: POKE (&H43 * 4 + 1), noh
   POKE (&H43 * 4 + 2), nsl: POKE (&H43 * 4 + 3), nsh
   POKE &H485, LBR
   DEF SEG
ELSE
   STOP
END IF

END SUB

SUB ShowActive

'make active window

IF EW0active THEN
   x0 = 160: y0 = 2 + (EW0max - EW0hi) * 9: x1 = x0 + 72: y1 = y0 + (EW0hi * 9)
   MakeBox 15, x0, y0, x1, y1
   x0 = 160: y0 = MidY + 8: x1 = x0 + 72: y1 = y0 + (EWRhi * 9)
   MakeBox 7, x0, y0, x1, y1
   'if re width table on
   IF WTRactive THEN
      WTRactive = 0
      ShowCS0 -1, 7, 1
      ShowCS0 CC0, 15, 0
   END IF
ELSE
   x0 = 160: y0 = MidY + 8: x1 = x0 + 72: y1 = y0 + (EWRhi * 9)
   MakeBox 15, x0, y0, x1, y1
   x0 = 160: y0 = 2 + (EW0max - EW0hi) * 9: x1 = x0 + 72: y1 = y0 + (EW0hi * 9)
   MakeBox 7, x0, y0, x1, y1
   'if ed width table on
   IF WT0active THEN
      WT0active = 0
      ShowCSR -1, 7, 1
      ShowCSR CCR, 15, 0
   END IF
END IF

END SUB

SUB ShowBits0

x0 = 160: y0 = 2 + (EW0max - EW0hi) * 9: x1 = x0 + 72: y1 = y0 + (EW0hi * 9)
ClrBox 0, x0, y0, x1, y1
y = y0 + 1
ptr = CC0 * EW0hi
FONTSYS08
FOR ptrbyte = ptr TO ptr + (EW0hi - 1)
   byte = ASC(EW0buff(ptrbyte))
   x = x0 + 1
   FOR ptrbit = 7 TO 0 STEP -1
      v = GETBIT(byte, ptrbit)
      IF v THEN char = 219 ELSE char = 32
      DRAWCH 0, char, x, y, 7, 0
      x = x + 9
   NEXT
   y = y + 9
NEXT
FONTSYS14

END SUB

SUB ShowBits1

x0 = 236: y0 = 2 + (EW0max - EW0hi) * 9: x1 = x0 + 72: y1 = y0 + (EW0hi * 9)
ClrBox 0, x0, y0, x1, y1
y = y0 + 1
FONTSYS08
FOR ptrbyte = 0 TO (EW0hi - 1)
   byte = ASC(EW1buff(ptrbyte))
   x = x0 + 1
   FOR ptrbit = 7 TO 0 STEP -1
      v = GETBIT(byte, ptrbit)
      IF v THEN char = 219 ELSE char = 32
      DRAWCH 0, char, x, y, 7, 0
      x = x + 9
   NEXT
   y = y + 9
NEXT
FONTSYS14

END SUB

SUB ShowBitsR

x0 = 160: y0 = MidY + 8: x1 = x0 + 72: y1 = y0 + (EWRhi * 9)
ClrBox 0, x0, y0, x1, y1
y = y0 + 1
ptr = CCR * EWRhi
FONTSYS08
FOR ptrbyte = ptr TO ptr + (EWRhi - 1)
   byte = ASC(EWRbuff(ptrbyte))
   x = x0 + 1
   FOR ptrbit = 7 TO 0 STEP -1
      v = GETBIT(byte, ptrbit)
      IF v THEN char = 219 ELSE char = 32
      DRAWCH 0, char, x, y, 7, 0
      x = x + 9
   NEXT
   y = y + 9
NEXT
FONTSYS14

END SUB

SUB ShowCS0 (char, fg, bg)

'show ed char set/hilite

IF char < 0 THEN
   x = 320: y = MidY - LB0 - (LB0 \ 2)
   FOR ln = 15 TO MidY: DRAWLN 0, 1, x, ln, x + (8 * 39), ln: NEXT
END IF
IF WT0 = 0 THEN EXIT SUB
x$ = ""
IF CC0 < 100 THEN x$ = " "
IF CC0 < 10 THEN x$ = "  "
nx = DRAWSTR(0, LTRIM$(STR$(CC0) + x$), 320, MidY - ((LB0 + 1) * 8), 7, 1, 8)
SetFont 0
IF char < 0 THEN
   'show all char
   x = 344
   FOR i = 7 TO 0 STEP -1
      FOR j = 0 TO 31
         DRAWCH 0, ((i * 32) + j), x, y, fg, bg
         x = x + 8
         IF j THEN IF (j + 1) MOD 8 = 0 THEN x = x + 8
      NEXT
      y = y - LB0
      x = 344
   NEXT
ELSE
   'hilite char
   i = char \ 32
   j = char - (i * 32)
   j = j - (j > 7) - (j > 15) - (j > 23)
   x = 344 + (j * 8): y = MidY - (LB0 * 8) + (i * LB0) - (LB0 \ 2)
   DRAWCH 0, char, x, y, fg, bg
   IF WT0active THEN ShowWT0 char, fg, bg
END IF
   
FONTSYS14

END SUB

SUB ShowCSR (char, fg, bg)

'show re char set/hilite

IF char < 0 THEN
   x = 320: y = MidY + 8
   FOR ln = MidY + 8 TO MaxY: DRAWLN 0, 1, x, ln, x + (8 * 39), ln: NEXT
END IF
IF WTR = 0 THEN EXIT SUB
x$ = ""
IF CCR < 100 THEN x$ = " "
IF CCR < 10 THEN x$ = "  "
nx = DRAWSTR(0, LTRIM$(STR$(CCR) + x$), 320, MidY + 8, 7, 1, 8)
SetFont 1
IF char < 0 THEN
   'show all char
   x = 344
   FOR i = 0 TO 7
      FOR j = 0 TO 31
         DRAWCH 0, ((i * 32) + j), x, y, fg, bg
         x = x + 8
         IF j THEN IF (j + 1) MOD 8 = 0 THEN x = x + 8
      NEXT
      y = y + LBR
      x = 344
   NEXT
ELSE
   'hilite char
   i = char \ 32
   j = char - (i * 32)
   j = j - (j > 7) - (j > 15) - (j > 23)
   x = 344 + (j * 8): y = MidY + (i * LBR) + 8
   DRAWCH 0, char, x, y, fg, bg
   IF WTRactive THEN ShowWTR char, fg, bg
END IF
  
FONTSYS14

END SUB

SUB ShowEW0

'show ed window

x0 = 160: y0 = 2 + (EW0max - EW0hi) * 9: x1 = x0 + 72: y1 = y0 + (EW0hi * 9)
ClrBox 1, x0 - 17, 1, x1 + 1, y1 + 1
ClrBox 0, x0, y0, x1, y1
MakeBox 7, x0, y0, x1, y1
x = x0 - 24: y = y1 - 8
FONTSYS08
FOR i = EW0hi TO 1 STEP -1
   n$ = STR$(i): IF LEN(n$) = 2 THEN n$ = " " + n$
   nx = DRAWSTR(0, n$, x, y, 7, 1, 7)
   y = y - 9
NEXT
nx = DRAWSTR(0, "12345678", 162, MidY - 6, 7, 1, 9)
FONTSYS14

END SUB

SUB ShowEW1

'show ed push/pop window

x0 = 236: y0 = 2 + (EW0max - EW0hi) * 9: x1 = x0 + 72: y1 = y0 + (EW0hi * 9)
ClrBox 1, x0 - 1, 1, x1 + 1, y1 + 1
ClrBox 0, x0, y0, x1, y1
MakeBox 7, x0, y0, x1, y1

END SUB

SUB ShowEWR

'show re window

x0 = 160: y0 = MidY + 8: x1 = x0 + 72: y1 = y0 + (EWRhi * 9)
ClrBox 1, x0 - 17, y0, x1 + 1, MaxY
ClrBox 0, x0, y0, x1, y1
MakeBox 7, x0, y0, x1, y1
x = x0 - 24: y = y1 - 8
FONTSYS08
FOR i = EWRhi TO 1 STEP -1
   n$ = STR$(i): IF LEN(n$) = 2 THEN n$ = " " + n$
   nx = DRAWSTR(0, n$, x, y, 7, 1, 7)
   y = y - 9
NEXT
FONTSYS14

END SUB

SUB ShowHelp

'show help

x = 7: y = 64
txt$ = "Active     Tab"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "LoadFont   L"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "SaveFont   S"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "GotoChar   G"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "PrevChar   PgUp"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "NextChar   PgDn"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "Cursor     "
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "Set/Clr    SPC"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "ShiftChar  -"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "CopyReEd   ^-E"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "CopyReAlt  ^-A"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "PushEd     +"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "PopEd      -"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "WidthTable W"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "TypeText   T"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 14
txt$ = "Quit       Esc"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8): y = y + 20
txt$ = "Help       F1"
nx = DRAWSTR(0, txt$, x, y, 7, 1, 8)

END SUB

SUB ShowHelpScreen

sz& = DIMBLOCK(15, 0, 0, 639, MaxY)
REDIM ScrnBuff(0 TO sz& \ 8) AS STRING * 8
vseg = VARSEG(ScrnBuff(0)): voff = VARPTR(ScrnBuff(0))
GETBLOCK 15, 0, 0, 639, MaxY, vseg, voff
FILLSCN 0, MaxY + 1, 1
FONTGUI14
t$ = "FONTED HELP SCREEN  press any key to return"
x = 0: y = 0: GOSUB prt: y = y + 20
t$ = "Use the TAB to select (hilite) the active window. You can only edit while in the EDit"
GOSUB prt: y = y + 14
t$ = "window. The other two are used for REference and temporary save (push/pop)."
GOSUB prt: y = y + 22
t$ = "To load a font to edit press L. Enter the pathname. FONTED returns the file's size."
GOSUB prt: y = y + 14
t$ = "Enter the actual bytes/char (usually filesize/256) and logical bytes (8pt font is 8)."
GOSUB prt: y = y + 14
t$ = "FONTED will save the file using its logical byte size saving on empty font space."
GOSUB prt: y = y + 22
t$ = "To save a font press S. Enter the data filename (raw data), MASM and call name, e.g.,"
GOSUB prt: y = y + 14
t$ = "8x8.raw,8x8.asm,FONT8X8). The data file can be used with USERFONT and FONTED. The ASM"
GOSUB prt: y = y + 14
t$ = "file needs to be assembled and linked (and used) as any other object module."
GOSUB prt: y = y + 22
t$ = "To move around the character set use G, PgUp, or PgDn. G will prompt for input."
GOSUB prt: y = y + 22
t$ = "To move the cursor use the arrow keys. To toggle a pixel use the space bar. To"
GOSUB prt: y = y + 14
t$ = "shift the character up/down, left/right use Shifted-arrow keys."
GOSUB prt: y = y + 22
t$ = "FONTED always saves fonts with a width table. To view the active table press W. A"
GOSUB prt: y = y + 14
t$ = "dot means width=8. For proportional fonts, shift character and adjust width table."
GOSUB prt: y = y + 22
t$ = "To copy a REference char to the EDit window, TAB to the RE window and use CTRL-E."
GOSUB prt: y = y + 14
t$ = "Use CTRL-A to copy to the ALT (save) window. To copy to and from the EDit window"
GOSUB prt: y = y + 14
t$ = "through the save window use + or -. "
GOSUB prt
t$ = "TO USE A WINDOW IT MUST HAVE A FONT LOADED."
nx = DRAWSTR(0, t$, nx, y, 15, 1, 0): y = y + 20
t$ = "To see how a font looks when typed use T and type some text."
GOSUB prt: y = y + 22
t$ = "To quit FONTED use Esc"
GOSUB prt
DO: LOOP WHILE INKEY$ = ""
PUTBLOCK 0, 0, 0, vseg, voff
ERASE ScrnBuff
EXIT SUB

prt:
nx = DRAWSTR(0, t$, x, y, 7, 1, 0)
RETURN

END SUB

SUB ShowMW

'show main menu

FILLSCN 0, MaxY + 1, 1
ShowTIT
ShowEW0
ShowEW1
ShowEWR
ShowActive

END SUB

SUB ShowTIT

'show title

FONTSYS14
tit$ = "EVGFX FONTED 1.10"
nx = DRAWSTR(0, tit$, 0, 0, 7, 1, 8)
FONTGUI14
tit$ = CHR$(1) + CHR$(2) + "1991 Cornel Huth"
nx = DRAWSTR(0, tit$, 2, MaxY - 14, 7, 1, 0)
FONTSYS14

END SUB

SUB ShowWT0 (char, fg, bg)

'show width table for ed file/hilite/off

IF WT0 = 0 THEN EXIT SUB
FONTSYS14
IF char = -1 THEN
   'show all the table
   x = 320: y = MidY + 8: ptr = LB0 * 256
   FOR ln = MidY + 8 TO MaxY: DRAWLN 0, 1, x, ln, x + (8 * 39), ln: NEXT
   x = 344
   FOR i = 0 TO 7
      FOR j = 0 TO 31
         wid = ASC(EW0buff(ptr))
         IF wid <> 8 THEN
            DRAWCH 0, wid + &H30, x, y, fg, bg
         ELSE
            DRAWCH 0, 46, x, y, fg, bg
         END IF
         ptr = ptr + 1
         x = x + 8
         IF j THEN IF (j + 1) MOD 8 = 0 THEN x = x + 8
      NEXT
      y = y + 14
      x = 344
   NEXT
ELSEIF char >= 0 THEN
   'highlight the current char's width
   i = char \ 32
   j = char - (i * 32)
   j = j - (j > 7) - (j > 15) - (j > 23)
   x = 344 + (j * 8): y = MidY + (i * 14) + 8
   ptr = LB0 * 256 + char
   wid = ASC(EW0buff(ptr))
   IF wid <> 8 THEN
      DRAWCH 0, wid + &H30, x, y, fg, bg
   ELSE
      DRAWCH 0, 46, x, y, fg, bg
   END IF
END IF

END SUB

SUB ShowWTR (char, fg, bg)

'show width table for re file/hilite/off

IF WTR = 0 THEN EXIT SUB
FONTSYS14
IF char = -1 THEN
   'show all the table
   x = 320 + (8 * 39): y = MidY - 21: ptr = LBR * 256
   FOR ln = 15 TO MidY: DRAWLN 0, 1, x, ln, x - (8 * 39), ln: NEXT
   x = 344 + (8 * 34)
   FOR i = 7 TO 0 STEP -1
      FOR j = 31 TO 0 STEP -1
         wid = ASC(EWRbuff(ptr + 255))
         IF wid <> 8 THEN
            DRAWCH 0, wid + &H30, x, y, fg, bg
         ELSE
            DRAWCH 0, 46, x, y, fg, bg
         END IF
         ptr = ptr - 1
         x = x - 8
         IF j <> 31 THEN IF (j) MOD 8 = 0 THEN x = x - 8
      NEXT
      y = y - 14
      x = 344 + (8 * 34)
   NEXT
ELSEIF char >= 0 THEN
   'highlight the current char's width
   i = char \ 32
   j = char - (i * 32)
   j = j - (j > 7) - (j > 15) - (j > 23)
   x = 344 + (j * 8): y = MidY - 119 + (i * 14)
   ptr = LBR * 256 + char
   wid = ASC(EWRbuff(ptr))
   IF wid <> 8 THEN
      DRAWCH 0, wid + &H30, x, y, fg, bg
   ELSE
      DRAWCH 0, 46, x, y, fg, bg
   END IF
END IF

END SUB

SUB TableTog

'toggle width table (with blank or char set)

IF EW0active THEN
   WT0active = NOT WT0active
   IF WT0active THEN
      ShowWT0 -1, 7, 1
      ShowWT0 CC0, 15, 0
   ELSE
      ShowCSR -1, 7, 1
      ShowCSR CCR, 15, 0
   END IF
ELSE
   WTRactive = NOT WTRactive
   IF WTRactive THEN
      ShowWTR -1, 7, 1
      ShowWTR CCR, 15, 0
   ELSE
      ShowCS0 -1, 7, 1
      ShowCS0 CC0, 15, 0
   END IF
END IF

END SUB

SUB ToggleBit

IF EW0active AND WT0 THEN
   DoCursorBit
   ptrbyte = (CC0 * EW0hi) + CursorY - 1
   byte = ASC(EW0buff(ptrbyte))
   byte = XORBIT(byte, (8 - CursorX))
   EW0buff(ptrbyte) = CHR$(byte)
   ShowBits0
   ShowCS0 CC0, 15, 0
   DoCursorBit
END IF

END SUB

SUB TypeText

IF EW0active AND WT0 THEN
   nx = DRAWSTR(0, "TYPE>", 320, 0, 7, 1, 8)
   SetFont 0
   t$ = GetUIP$(360, 0, 34, 7, 1)
   ClrBox 1, 320, 0, 639, EW0hi
   FONTSYS14
END IF

END SUB

