TITLE  'Set/get step point'
NAME   SETSTEP
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      set/get step point                                     |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call SETSTEP(320,160)                                  |
;                call GETSTEP(x,y)                                      |
;    stack:     +06 = y-coordinate                                      |
;                08 = x-coordinate                                      |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 2
ARGx            EQU [bp+08]
ARGy            EQU [bp+06]

include EXTRNDAT.INC

EXTRN PixelAddr:far

dgroup          group _BSS,_DATA

SetStep_TEXT    SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:SetStep_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  SetStep,GetStep
SetStep         PROC    FAR

                push    bp
                mov     bp,sp

                mov     bx,ARGx
                mov     bx,[bx]
                mov     x0,bx
                mov     bx,ARGy
                mov     ax,[bx]
                mov     y0,ax
                pop     bp
                RET     PARMS * 2

GetStep         LABEL FAR
                push    bp
                mov     bp,sp

                mov     bx,ARGx
                mov     ax,x0
                mov     [bx],ax
                mov     bx,ARGy
                mov     ax,y0
                mov     [bx],ax
                pop     bp
                RET     PARMS*2

SetStep         ENDP
SetStep_TEXT    ENDS
                END

