TITLE  'USERFONT'
NAME   USERFONT
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      Make user font active                                  |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call USERFONT(vseg,voff,pts)                           |
;    stack:     +06 = height of font                                    |
;                08 = offset of font data                               |
;                10 = segment                                           |
;------------------------------------------------------------------------

PARMS           = 3
ARGpts          EQU [bp+06]
ARGoff          EQU [bp+08]
ARGseg          EQU [bp+10]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

USERFONT_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:USERFONT_TEXT
                PUBLIC USERFONT
USERFONT        PROC    FAR

                push    bp
                mov     bp,sp
                push    di
                push    si

                mov     bx,ARGpts
                mov     cx,[bx]
                mov     bx,ARGoff
                mov     si,[bx]
                mov     bx,ARGseg
                mov     bp,[bx]         ;bp:si->user font data

                sub     ax,ax
                mov     es,ax
                mov     word ptr es:[0485h],cx
                mov     di,043h * 4
                mov     es:[di],si
                mov     es:[di+2],bp

                pop     si
                pop     di
                pop     bp
                RET     PARMS*2

USERFONT        ENDP
USERFONT_TEXT   ENDS
                END
