comment @
 
  Changes made by Scott McNay (1:395/11) July 26, 1992, to allow routine to be
  used with code compiled with BC's /Fs option.  (Most) changes marked with
  ;BCFS0726.  May have optimized some code also.  This is a plug-in replacement
  for the original code.
 
  BCFS0801: Standardized code format.  Made sure that DI, SI, BP, and DS are
  saved to meet requirements of BC 7.x.

 *  FINDWORD
 *----------------------------------------------------------------------------
 *
 *  Routine to find the next (direction = 1)  or previous (direction = 0)
 *  word position in a QuickBASIC string
 *
 *  Author: Tom Collins
 *	    09-20-90
 *
 *  Typical Calling Sequence:
 *
 *     WordPos% = 1
 *     A$ = "This is a test"
 *     CALL FindWord(A$ ,1 ,WordPos%)
 *
 *  Assemble with: TASM upcase.asm [/Zi]   or,
 *		   MASM upcase.asm [/Zi]
 *  (Zi = Debug info for CV)
 *

	@

	extrn	StringAddress:far

	.MODEL	MEDIUM, BASIC

	.CODE

	PUBLIC	FINDWORD

FINDWORD proc	USES si di, STRDES:ptr, Direction:ptr, Z:ptr

; The registers are used as follows:
;
;    AH    = Direction flag
;    BL    = Z value
;    BH    = New return value
;    CL    = String length
;    CH    = Current string index in main loop
;    DS:SI = Current string index + 1 address

	push	ds		; Save DS

	push	STRDES							      ;BCFS0726
	call	StringAddress	; DX:AX = address, CX = length		      ;BCFS0726
	mov	si,ax		; save offset of string			      ;BCFS0726

	mov	di, Direction	; DS:DI -> Direction indicator
	mov	ah, [di]	; AH = Direction

	mov	di, Z		; DS:DI -> Z value
	mov	bl, [di]	; BL = Where we're at now (Z value)

	mov	ds,dx

; Test for invalid conditions

	mov	bh, bl		; Assume no change in Z value
	jcxz	FW100		; Null string?  Leave.			      ;BCFS0726
	or	ch,ch		; Check string too long			      ;BCFS0726
	jnz	FW100		; We have a screen line > 255??  Wow!	      ;BCFS0726

	inc	ch		; CH = String index counter		      ;BCFS0726

	cmp	cl, bl		; See if we're starting past string end
	jge	FW00		; No
	and	ah, ah		; Yes. Test the direction.
	jnz	FW100		; Forward.  Return
;	mov	bh, cl		; Backward.  Set return value to str len + 1
;	inc	bh
;	jmp	FW100		; Return

; Initialize the default return value based on the direction

FW00:	mov	bh, cl		; Assume string length + 1
	inc	bh
	and	ah, ah		; Set the flags
	jnz	FW01		; Backwards
	mov	bh, 1		; Backwards.  Assume length of 1

; Main loop.

FW01:	lodsb			; Get a character from string into AL
	cmp	al, ' '		; Is it a space?
	je	FW02		; Yes
	cmp	al, 0FAh	; Is is a soft space?
	jne	FW10		; No

; Found a space or soft space.  See what the next character is.

FW02:	mov	al, [si]	; Get next character			      ;BCFS0726
	cmp	al, ' '		; Is it a space?
	je	FW10		; Yes. Continue loop
	cmp	al, 0FAh	; Is is a soft space?
	je	FW10		; Yes

; Found a word position.  See which direction we're going in.

	and	ah, ah
	jz	FW04		; Backwards

; Forward direction.  If index > Z, set return value and exit.  Otherwise,
; keep looking.

FW03:	cmp	ch, bl		; See if index > Z
	jl	FW10		; No. Keep looking.
	inc	ch		; Yes. Save current index + 1 in return loc
	mov	bh, ch
	jmp	short FW100	; Return

; Reverse direction.  If we're >= Z, return.  Otherwise set new value
; and look for the next word position.

FW04:	push	cx		; Save CX temporarily
	inc	ch		; Add one to CH for comparison
	cmp	ch, bl		; See if index < Z
	pop	cx		; Restore CX
	jge	FW100		; Yes.  Return
	mov	bh, ch		; No. Save current index + 1 in return loc
	inc	bh
	jmp	short FW10	; Continue loop

; Continue loop while not at the end of the string

FW10:	inc	ch		; Increment string index
	cmp	cl, ch		; Test for equal to string length
	jge	FW01		; Not equal.  Continue loop.

; Return to the calling program

FW100:	pop	ds		; Restore BASIC's DS so we can return value   ;BCFS0726
	mov	di, Z		; DS:DI -> Z
	mov	[di], bh	; Load return value
	ret			; Return

FINDWORD endp

	end
