;---------------
; 
;  BASNOV 0.01 
; 
;  ASSEMBLE WITH MASM 5.1 
; 
;---------------
		.model	medium,basic
;---------------
		.data

FileName	db	128 dup (0)		; buffer for filename
;---------------
		.code
;---------------
; CheckNovell(Err%)
;
; return values for Err% :
;
;    0	if Netware installed
;   -1	if Netware not installed
;
CheckNovell	proc	Err:word

		mov	ax,0B600h		; get station number
		int	21h
		or	al,al			; Netware loaded ?
		jz	Error

		xor	ax,ax			; return  0 if no error
		jmp	short Exit

Error:		mov	ax,-1			; return -1 if error

Exit:		mov	bx,[Err]		; set result to Err%
		mov	[bx],ax
		ret

CheckNovell	endp
;---------------
;  SetSharedAttr(FileName$, Err%)
;
;  return values for Err% :
;
;     0     no error reported by DOS
;    -1        error reported by DOS
;
SetSharedAttr	proc	Filename:ptr, Err:word

		mov	bx,[Filename]		; ptr to string descriptor
		mov	si,[bx+2]		; fetch string address
		mov	cx,[bx] 		; length of string

		mov	ax,@data		; ES:DI points to local buffer
		mov	es,ax
		mov	di,offset FileName
		mov	dx,di			; copy offset into DX
		rep	movsb			; copy string contents
		mov	al,0			; make string ASCIIZ
		stosb

		push	ds			; save DS temp

		mov	ax,es			; make DS equal to ES
		mov	ds,ax

		mov	ax,04300h		; CHMOD, get attribute
		int	21h
		jc	Error			; check for error

		or	cx,0080h		; set shared bit

		mov	ax,04301h		; CHMOD, set attribute
		int	21h
		jc	Error			; check for error

		xor	ax,ax			; set Err% to  0
		jmp	short Exit

Error:		mov	ax,-1			; set Err% to -1

Exit:		pop	ds			; restore DS
		mov	bx,[Err]		; offset of Err%
		mov	[bx],ax 		; store result
		ret				; return

SetSharedAttr	endp
;---------------
		end
