CSEG     SEGMENT BYTE PUBLIC 'CODE'
         ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG
         PUBLIC  LPLKIT
         PUBLIC  LOKIT
         PUBLIC  UNLOKIT
LOOPLOCK EQU     0
LOCK     EQU     1
UNLOCK   EQU     2
REQUEST  DB      ?                 ; TYPE OF REQUEST
DRIVE    DB      ?                 ; INPUT DRIVE NUMBER
LENLOK   DW      ?                 ; LENGTH OF LOCK NAME
POINTER  DW      ?                 ; POINTER TO LOCK NAME
LOCKNAME DB      64 DUP(?)         ; INPUT LOCK NAME
NEWNAME  DB      '\'               ; REBUILT LOCK NAME WITH PATH
CURPATH  EQU     $                 ; CURRENT PATH FOR INPUT DRIVE
         DB      64 DUP(?)         ; REBUILT LOCK NAME WITH PATH
LENPATH  EQU     $-CURPATH
LPLKIT   PROC    FAR
         MOV     CS:REQUEST,LOOPLOCK
         JMP     PROCESS
LPLKIT   ENDP
LOKIT    PROC    FAR
         MOV     CS:REQUEST,LOCK
         JMP     PROCESS
LOKIT    ENDP
UNLOKIT  PROC    FAR
         MOV     CS:REQUEST,UNLOCK
PROCESS:
         PUSH    BP                ; SAVE BP
         MOV     BP,SP             ; SAVE SP INTO BP FOR PARM ADDRESSING
         PUSH    DS                ; SAVE BASIC'S DATA SEGMENT
         PUSH    ES                ; SAVE BASIC'S EXTRA SEGMENT
         MOV     BX,[BP+8]         ; GET ADDRESS OF STRING DESCRIPTOR
         MOV     DX,[BX+2]         ; GET ADDRESS OF STRING
         MOV     CS:POINTER,DX     ; SAVE POINTER TO STRING
         MOV     CX,[BX]           ; GET LENGTH OF STRING
         MOV     CS:LENLOK,CX      ; SAVE LENGTH OF THE STRING
         MOV     BX,[BP+10]        ; GET ADDRESS OF DRIVE NUMBER
         MOV     AL,[BX]           ; GET LOW ORDER BYTE OF DRIVE ADDRESS
         MOV     CS:DRIVE,AL       ; SAVE THE DRIVE NUMBER
         PUSH    CS                ; MOV CS TO ES VIA STACK
         POP     ES                ; TARGET IS IN OUR CSEG
         MOV     SI,DX             ; OFFSET OF BASIC'S STRING
         MOV     DI,OFFSET LOCKNAME; OFFSET OF WORK AREA
         CLD                       ; START FROM THE BOTTOM
         REP     MOVSB             ; COPY BASIC'S STRING TO OUR WORK AREA
         PUSH    CS                ; MOV CS TO DS VIA STACK
         POP     DS                ; OUR CSEG SEGMENT INTO DS
         MOV     DI,OFFSET CURPATH ; ADDRESS OF AREA TO BLANK
         MOV     CX,LENPATH        ; LENGTH OF AREA TO BLANK
         MOV     AL,' '            ; A BLANK (NATURALLY)
         REP     STOSB             ; BLANK THE AREA OUT
         MOV     SI,OFFSET CURPATH ; SET UP FOR CURRENT PATH CALL
         MOV     AH,47H            ; ASK FOR CURRENT PATH
         MOV     DL,DRIVE          ; REQUEST PATH FOR INDICATED DRIVE
         INC     DL                ; 1 ORIGIN FOR PATH CALL
         INT     21H               ; CALL DOS
         MOV     DI,OFFSET CURPATH ; START SCAN FOR ZERO BYTE AT START OF PATH
         CMP     BYTE PTR [DI],0   ; SEE IF WE ARE IN THE BASE DIRECTORY
         JE      ROOT              ; IF [DI]=0 THEN WE ARE IN THE BASE DIR
         MOV     CX,LENPATH        ; ONLY GO FOR LENGTH OF PATH
         SUB     AL,AL             ; SCANNING FOR THE 0 BYTE
         REPNE   SCASB             ; SCAN THE STRING WHILE [DI] <> 00H
         DEC     DI
         MOV     BYTE PTR [DI],'\' ; PUT IN THE ENDING '\' BEFORE FILE NAME
         INC     DI                ; DI NOW POINTS TO THE ENDING 0
ROOT:
         MOV     SI,OFFSET LOCKNAME+2 ; START MOVE AFTER THE ':'
         MOV     CX,LENLOK         ; LENGTH OF STRING
         DEC     CX                ; MINUS 1
         DEC     CX                ; MINUS 1
         REP     MOVSB             ; COPY FILENAME AFTER PATH NAME
         MOV     DX,OFFSET NEWNAME ; POINT TO NEW NAME
         MOV     AL,DRIVE          ; GET DRIVE FOR LOCK
         MOV     AH,REQUEST        ; RETRIEVE LOCK REQUEST TYPE
         INT     67h               ; CALL LOCK MANAGER
         POP     ES                ; GET BACK BASIC'S EXTRA SEGMENT
         POP     DS                ; GET BACK BASIC'S DATA SEGMENT
         MOV     DI,[BP+6]         ; GET ADDRESS OF RESULT VARIABLE
         MOV     [DI],AL           ; STORE RETURN CODE FROM LOCK MANAGER
         POP     BP
         RET     6
UNLOKIT  ENDP
CSEG     ENDS
         END
                                                                                                                                                                                                                                                                                                                              