1 ' YOU WILL NEED THE FILES "MAP.DAT","ELEMENTS.DAT" AND "GROUND.DAT" TO RUN THIS PROGRAM
2 ' THE PROGRAM WAS ENHANCED by Don Harter Jr. 9-27-1991 11-2-1992 1-4-1993 01-30-1994; 
3 ' DISK OUTPUT WAS ADDED; ARRAY SIZES WERE INCREASED; LEAP YEAR FIXED ; SATELLITE CAPACITY INCREASED
5 ' LATEST SIDEREAL TIME CONSTANTS WERE ADDED; TIME DIFFERENCE FROM UTC; UTC DATE CALCULATED 
6 ' COMMENTS WERE ADDED; ORBIT NUMBER FIELD SIZE WAS INCREASED; NASA 2 LINE ELEMENTS; ECT.
7 ' POSSIBLE ENHANCEMENTS THAT COULD BE MADE: VGA MODE, 
8 '      BEEP WHEN ANY SATELLITE IS ABOVE THE HORIZON, IMPROVED ORBIT CALCULATION,
9 '      CONVERSION OF NASA SATELLITE NUMBER TO COMMON NAME (USE A FILE), MAP SATELLITE INDICATORS
10 '     CREATE A DATABASE FILE OUTPUT FOR ORBITAL PREDICTION
11 '     DISPLAY OLD ELEMENTS DURING A CHANGE OF ELEMENTS FOR A SATELLITE
12 ' TO INCREASE THE SATELLITE CAPACITY CHANGE "ARRAYSIZE%=" STATEMENTS, AND
13 '      DIM STATEMENTS WITH THE SAME NUMBER AS THE PREVIOUS ARRAYSIZE%
14 ' 01-30-94 BUGS FIXED- RECOGNIZE EOF ON A READ; DELETE OLD ELEMENTS.DAT FILE
15 '          Y1 AND G3 DIMENSION STATEMENTS ARE REPEATED AFTER THE CLEAR STATEMENT
18 '**** SATAUS Menuprogramm de OE1HSI VERSION 1.5  26.JAN. 1985
19 ' MAIN ROUTINES RETURN HERE USING A GOTO
20 KEY OFF:SCREEN 0,1:WIDTH 80:COLOR 14,1,0:CLS:CLEAR:PRINT:PRINT
22 CLOSE :P$="s": 'CLOSE ANY OPEN FILES TO AVOID ERRORS;DEFAULT SCREEN OUTPUT
25 ARRAYSIZE%=40
30 ON ERROR GOTO 0
40 KEY(9) OFF:KEY(10) OFF
50 PRINT:PRINT"            SELECT ONE OF THE FOLLOWING OPTIONS:"
60 PRINT:PRINT" (P) ORBITAL PREDICTION PROGRAM"
70 PRINT:PRINT" (R) REALTIME TRACKING AND HIGH RESOLUTION SCREEN"
80 PRINT:PRINT" (C) CHANGE, ADD, DELETE ELEMENTS OF SATELLITES"
90 PRINT:PRINT" (G) CHANGE OR ENTER GROUNDSTATION DATA"
95 PRINT:PRINT" (N) CONVERT NASA TWO LINE ELEMENT FILE TO THE FORMAT USED BY THIS PROGRAM"
100 COLOR 12,1,0:LOCATE 16,1:PRINT" (D) RETURN TO DOS":COLOR 14,1,0
110 BEEP
120 LOCATE 19,3:PRINT"ENTER SELECTION (P,R,C,G,D,N)--> "
130 Z$="PpRrCcDdGgNn"
140 K$=INKEY$:IF K$="" THEN 140
150 COLOR 14,1,0:K=INSTR(Z$,K$)
151 CLOSE ' CLOSE ANY OPEN FILES FROM ANOTHER ROUTINE
152 'IF (P$="d" OR P$="D") THEN OPEN "SAT.OUT" FOR APPEND AS # 3 : P%=3
154 'IF (P$="P" OR P$="p") THEN OPEN "LPT1:" FOR OUTPUT AS #3 : P%=3
156 'IF (P$="S" OR P$="s") THEN OPEN "SCRN:" FOR OUTPUT AS # 3 : P%=3
160 ON K GOTO 5000,5000,2000,2000,200,200,180,180,1450,1450,9000,9000
170 BEEP:COLOR 28,1,0:GOTO 110
180 SYSTEM
200 ' ****** SATFILE.BAS - VERSION 1.0, ISSUE 1.0 - HSIMODIF.1/25/85 ******
210 KEY OFF:SCREEN 0,1:WIDTH 80:COLOR 14,1,0:CLS
220 DEFDBL T,N
230 OPEN "ELEMENTS.DAT" AS #1 LEN =56
240 FIELD #1, 10 AS I$, 2 AS Y3$, 8 AS T0$, 4 AS I0$, 4 AS O0$, 4 AS E0$, 4 AS W0$, 4 AS M0$, 8 AS N0$, 4 AS K0$, 4 AS F1$
250 V1$="":PRINT
260 PRINT "Elements of the following SATELLITES are in the file:":PRINT
270 FOR J%=1 TO ARRAYSIZE% :GET #1,J%
280 IF ASC(I$)<33 THEN 300 ELSE IF ASC(I$)>126 THEN 300
290 PRINT I$:NEXT
300 PRINT:PRINT "Do you wish to Add (A) , Change (C) , or Delete (D) a  satellite ?"
310 PRINT "record or Exit (E) from this program ?"
320 Z$="EeAaCcDd"
330 K$=INKEY$:IF K$="" THEN 330
340 K=INSTR(Z$,K$)
350 ON K GOTO 1430,1430,390,390,420,420,540,540
360 BEEP:GOTO 330
370 '
380 ' ****** ADD A NEW RECORD ******
390 GOSUB 670:GOSUB 1270:GOSUB 920:GOSUB 960:GOTO 630
400 '
410 ' ****** CHANGE AN EXISTING RECORD ******
420 GOSUB 660:IF I$<>U$ THEN CLS:PRINT "Record not found":GOTO 250
430 GOSUB 750
440 PRINT "Do you wish to update elements of this satellite ?  (Y/N) "
450 Z$="YyNn"
460 K$=INKEY$:IF K$="" THEN 460
470 K=INSTR(Z$,K$)
480 ON K GOTO 500,500,510,510
490 BEEP:GOTO 460
500 CLS:PRINT " Type enter to keep the same value for a parameter.  "
505 GOSUB 970:GOTO 630
510 CLS:GOTO 250
520 '
530 ' ****** DELETE AN EXISTING RECORD ******
540 GOSUB 660:IF I$<>U$ THEN CLS:PRINT "Record not found":GOTO 250
550 COLOR 28:PRINT :PRINT "DO YOU REALLY MEAN IT ?? (Y/N) ":COLOR 14
560 Z$="YyNn"
570 K$=INKEY$:IF K$="" THEN 570
580 K=INSTR(Z$,K$)
590 ON K GOTO 620,620,610,610
600 BEEP:GOTO 570
610 CLS:GOTO 250
620 GOSUB 920:GOSUB 1150:GOSUB 1210
630 CLS:PRINT "Update complete.":GOTO 250
640 '
650 ' ****** FIND SATELLITE RECORD ******
660 PRINT:INPUT "Which satellite?  Use matching case. ",V1$:IF V1$="" THEN 300
670 U$=SPACE$(10):LSET U$=V1$
680 FOR J%=1 TO ARRAYSIZE%:GET #1,J%
690 IF I$=U$ THEN 720 ELSE IF ASC(I$)<33 THEN 720 ELSE IF ASC(I$)>122 THEN 720
695 ' SEARCH FOR A MATCH OR THE END OF THE FILE; 2 ENTRY POINTS
700 IF LEFT$(I$,1)="" THEN 720
710 NEXT
720 RETURN
730 '
740 ' ****** DISPLAY SATELLITE RECORD ******
750 CLS:Y3=CVI(Y3$)
760 T0=CVD(T0$):I0=CVS(I0$):O0=CVS(O0$):E0=CVS(E0$):W0=CVS(W0$)
770 M0=CVS(M0$):N0=CVD(N0$):K0=CVS(K0$):F1=CVS(F1$)
780 PRINT "Satellite       = ";I$
790 PRINT "Epoch year      = ";Y3
800 PRINT "Epoch day       = ";T0
810 PRINT "Inclination     = ";I0
820 PRINT "R.A.A.N.        = ";O0
830 PRINT "Eccentricity    = ";E0
840 PRINT "Arg. of perigee = ";W0
850 PRINT "Mean anomaly    = ";M0
860 PRINT "Mean motion     = ";N0
870 PRINT "Epoch orbit no. = ";K0
880 PRINT "Beacon freq.    = ";F1
890 PRINT:RETURN
900 '
910 ' ****** SETUP SATELLITE ELEMENTS FOR DELETE ACTION ******
920 Q$=SPACE$(10):Y3=0:T0=0:I0=0:O0=0:E0=0:W0=0:M0=0:N0=0:K0=0:F1=0
930 CLS:RETURN
940 '
950 ' ****** UPDATE/DELETE SATELLITE ELEMENTS ******
960 PRINT: PRINT "New satellite, input following items:": PRINT
970 INPUT "SATELLITE DESIGNATION  = ",U$:IF U$<>"" THEN Q$=U$ ELSE Q$=I$
980 INPUT "EPOCH YEAR (YY)        = ",U$:IF U$<>"" THEN Y3=VAL(U$)
990 INPUT "EPOCH DAY (DD.DDDD-)   = ",U$:IF U$<>"" THEN T0=VAL(U$)
1000 INPUT "INCLINATION (DEG.)     = ",U$:IF U$<>"" THEN I0=VAL(U$)
1010 INPUT "R.A.A.N. (DEG.)        = ",U$:IF U$<>"" THEN O0=VAL(U$)
1020 INPUT "ECCENTRICITY           = ",U$:IF U$<>"" THEN E0=VAL(U$)
1030 INPUT "ARG. OF PERIGEE (DEG.) = ",U$:IF U$<>"" THEN W0=VAL(U$)
1040 INPUT "MEAN ANOMALY (DEG.)    = ",U$:IF U$<>"" THEN M0=VAL(U$)
1050 INPUT "MEAN MOTION (ORB/DAY)  = ",U$:IF U$<>"" THEN N0=VAL(U$)
1060 INPUT "EPOCH ORBIT NO.        = ",U$:IF U$<>"" THEN K0=VAL(U$)
1070 INPUT "BEACON FREQUENCY (Mhz) = ",U$:IF U$<>"" THEN F1=VAL (U$)
1080 PRINT:PRINT "Is this CORRECT? (Y/N) "
1090 Z$="YyNn"
1100 K$=INKEY$:IF K$="" THEN 1100
1110 K=INSTR(Z$,K$)
1120 ON K GOTO 1150,1150,1140,1140
1130 BEEP:GOTO 1100
1140 CLS:GOTO 970
1150 LSET I$=Q$:RSET Y3$=MKI$(Y3):RSET T0$=MKD$(T0):RSET I0$=MKS$(I0)
1160 RSET O0$=MKS$(O0):RSET E0$=MKS$(E0):RSET W0$=MKS$(W0):RSET M0$=MKS$(M0)
1170 RSET N0$=MKD$(N0):RSET K0$=MKS$(K0):RSET F1$=MKS$(F1)
1180 PUT #1,J%:CLS:RETURN
1190 '
1200 ' ****** ADJUST RECORDS TO FILL DELETED RECORD SPACE ******
1210 FOR K%=J% TO (ARRAYSIZE%-1)
1220 GET #1,K%+1:PUT #1,K%:NEXT
1230 GOSUB 920:J%=ARRAYSIZE%:GOSUB 1150
1240 RETURN
1250 '
1260 ' ****** ADJUST RECORDS TO INSERT NEW RECORD ******
1270 PRINT
1280 PRINT "Do you wish to insert the record in a specific postion ? (Y/N) "
1290 Z$="YyNn"
1300 K$=INKEY$:IF K$="" THEN 1300
1310 K=INSTR(Z$,K$)
1320 ON K GOTO 1340,1340,1400,1400
1330 BEEP:GOTO 1300
1340 PRINT "Which position ? ( 1 to";J%-1;")";
1350 INPUT R%:IF R%=0 THEN 1280
1360 IF R%>J%-1 THEN 1340
1370 J%=R%
1380 FOR K%=(ARRAYSIZE%-1) TO R% STEP-1
1390 GET #1,K%:PUT #1,K%+1:NEXT
1400 RETURN
1410 '
1420 ' ****** END OF JOB ROUTINE ******
1430 CLOSE #1:GOTO 10
1440 'END PART CHANGE/ADD/DELETE ELEMENTS
1450 REM ******* Groundsation data change v.1.0 OE1HSI jan.-1985**********
1460 SCREEN 0,1:WIDTH 80:COLOR 14,1,0:CLS
1470 PRINT"CURRENT GROUND STATION DATA":PRINT:GOSUB 1780
1480 PRINT"Do you want to CHANGE this DATA ? (Y/N)"
1490 Z$="YyNn"
1500 K$=INKEY$:IF K$=""THEN 1500
1510 K=INSTR(Z$,K$)
1520 ON K GOTO 1610,1610,1890,1890
1530 BEEP:COLOR 28:GOTO 1480
1540 PRINT:PRINT:GOSUB 1810
1550 PRINT"Do you want a further CHANGE ? (Y/N) "
1560 Z$="YyNn"
1570 K$=INKEY$:IF K$=""THEN 1570
1580 K=INSTR(Z$,K$)
1590 ON K GOTO 1610,1610,1880,1880
1600 BEEP:COLOR 28:GOTO 1550
1610 COLOR 14:PRINT:PRINT "ENTER NEW DATA OR <RETURN> FOR UNCHANGED DATA":
1620 OPEN "GROUND.DAT" AS #2 LEN=44
1630 FIELD #2, 10 AS GR$,20 AS GL$,4 AS GH$,4 AS LO$, 4 AS LA$, 2 AS UTCDIFF$
1640 PRINT:INPUT "CALL max. 10 chrs.)                          : ",U$: IF U$ <>"" THEN GS$=U$ ELSE GS$=GR1$
1650 INPUT "Location of station (max. 20 chrs.)          : ",U$: IF U$ <>"" THEN GC$=U$ ELSE GC$=GL1$
1660 INPUT "Groundstation height above sealevel in mtrs. : ",U$: IF U$ <>"" THEN SH=VAL(U$) ELSE  SH=CVS(GH1$)
1670 PRINT "LONGITUDE WEST of Greenwich (max +360) or East of Greenw. entered as -0 to -180"
1672 PRINT:INPUT "Enter (with decimals)                 : ",U$
1675 IF U$ <>"" THEN LO=VAL(U$) ELSE LO=CVS(LO1$)
1680 IF LO < 0 THEN LO=360+LO
1690 PRINT "LATITUDE NORTH of Equator + (max 90) SOUTH of Equator - (max 90)"
1692 PRINT:INPUT "ENTER (With decimals)                 : ",U$: IF U$ <>"" THEN LA=VAL(U$) ELSE LA=CVS(LA1$)
1694 PRINT:INPUT "UTC time - local time                   ",UTCDIFFT$
1696 IF (UTCDIFFT$ <> "") THEN UTCDIFF%=VAL(UTCDIFFT$)
1700 LSET GR$=GS$
1710 LSET GL$=GC$
1720 RSET GH$=MKS$(SH)
1730 RSET LO$=MKS$(LO)
1740 RSET LA$=MKS$(LA)
1745 RSET UTCDIFF$=MKI$(UTCDIFF%)
1750 PUT #2,1
1760 CLOSE 2
1770 GOTO 1540
1780 OPEN "GROUND.DAT" AS #2 LEN=44
1790 FIELD #2, 10 AS GR$,20 AS GL$,4 AS GH$,4 AS LO$, 4 AS LA$, 2 AS UTCDIFF$
1800 GET #2,1
1810 PRINT "CALL IS                    : ";GR$
1820 PRINT "LOCATION IS                : ";GL$
1830 PRINT USING "HEIGHT AB. SEAL. (mtrs.)=  :  #####";CVS(GH$)
1840 PRINT USING "WESTERN LONGITUDE (deg.)=  : ###.##";CVS(LO$)
1850 PRINT USING "LATITUDE (deg.)=           : +##.##";CVS(LA$)
1855 PRINT USING "UTC TIME - LOCAL TIME=           ###";CVI(UTCDIFF$):PRINT
1860 GR1$=GR$:GL1$=GL$:GH1$=GH$:LO1$=LO$:LA1$=LA$
1870 CLOSE 2:RETURN
1880 COLOR 14:PRINT:PRINT "DATA SAVED AS GROUND.DAT":GOTO 1900
1890 COLOR 14:PRINT:PRINT "DATA NOT CHANGED"
1900 GOTO 20 'MAIN MENU
1910 '**** END PROGRAM GROUNDSTATION DATA CHANGE/STORAGE OE1HSI  JAN. 1985 ****
2000 ' ****** ORBITS2 - VERSION 1.0, ISSUE 1.2 -11/1/83 ******
2010 CLS:KEY OFF:SCREEN 2,0:WIDTH 80
2020 OUT 985,10      ' Set foreground color for high resolution screen
2025 ' *********************************
2030 LOCATE 2
2040 PRINT"   SATELLITE TRACKING PROGRAM de W0SL - May,1983"
2050 PRINT"        COPYRIGHT 1983 by R. D. Welch, W0SL"
2060 PRINT"                          908 Dutch Mill Drive"
2070 PRINT"                          Manchester, Mo. 63011":PRINT
2080 PRINT"   Enhanced by OE1HSI JAN 26 1985"
2090 PRINT"               Ing. Herbert F. Strasser"
2100 PRINT"               176 Rud. Waisenhorngasse"
2110 PRINT"               A 1238 VIENNA / AUSTRIA"
2112 PRINT"   Enhanced by DONALD HARTER JR.; version 01-30-1994"
2113 PRINT"               3084 Lakeshore Rd.; Manistee, MI; 49660"
2115 LOCATE 25,3:PRINT"F9 TOGGLES THE GRAPH/TABLE     F10 TO SELECT SINGLE SAT IN GRAPH   ESC TO END";
2130 '
2140 ' ****** HOUSE KEEPING ITEMS ******
2150 OPEN "ELEMENTS.DAT" AS #1 LEN=56
2160 FIELD #1, 10 AS I$, 2 AS Y3$, 8 AS T0$, 4 AS I0$, 4 AS O0$, 4 AS E0$, 4 AS W0$, 4 AS M0$, 8 AS N0$, 4 AS K0$, 4 AS F1$
2170 DEFDBL T:DEFINT J:OPTION BASE 1
2180 DEF FNMTH=VAL(LEFT$(D$,2)):DEF FNDAY=VAL(MID$(D$,4,2))
2190 DEF FNYR=VAL(RIGHT$(D$,2)):DEF FNHR=VAL(LEFT$(T$,2))
2200 DEF FNMIN=VAL(MID$(T$,4,2)):DEF FNSEC=VAL(RIGHT$(T$,2))
2210 DIM C(3,2),Y1(25),G3(25),SAT(16),SATL(40,2)
2212 ' Y1 AND G3 ARE USED FOR SIDEREAL TIME CONSTANT TABLES
2213 ' SAT HOLDS A BIT MAPPED GRAPHIC IMAGE; 
2214 ' SATL STORES THE SATELLITES PREVIOUS CALCULATED LOCATION
2215 DIM I$(40),Y3(40),T0(40),I0(40),O0(40),E0(40),W0(40),M0(40),N0(40)
2217 DIM K0(40),F1(40),A0(40)
2218 ' BASIC HAS A DEFAULT DIMENSION WHICH WAS BEING USED BEFORE THE CHANGE
2220 DIM PKT(16),KEP(16),SCRSAV(40,16),FLG0(40) ' **** HIGHER RESOLUTION GRAPHICS MAY NEED MORE SPACE
2222 ' PKT HOLDS A GRAPHIC IMAGE; SCRSAV IS SCREEN SAVED DATA; FLG0 IS A FIRST TIME FLAG
2223 '      FOR EACH SATELLITE; KEP STORES GRAPHIC DATA
2225 ARRAYSIZE%=40
2230 '
2240 ' ****** SETUP UTC DATE AND TIME ******
2250 GOSUB 8000: GOSUB 7800   ' GET UTC TIME DIFFERENCE AND CALCULATE THE TIME
2255 GOSUB 11000    " CALCULATE UTC DATE
2260 LOCATE 15,30,0:PRINT "UTC TIME = ";UTCTIME$
2270 LOCATE 20,3:INPUT "ENTER NEW UTC TIME (HH:MM:SS)?..  IF NO CHANGE TYPE <RETURN> ",T$
2280 IF T$="" THEN T$=UTCTIME$
2285 LOCATE 20,50:PRINT SPACE$(14)
2290 LOCATE 15,30,0:PRINT "UTC DATE = ";UTCDATE$
2300 LOCATE 20,3:INPUT "ENTER NEW UTC DATE (MM-DD-YY)?.. IF NO CHANGE TYPE <RETURN> ",D$
2310 IF D$="" THEN D$=UTCDATE$
2340 CLS
2350 '
2360 ' ****** DRAW AND STORE SATELLITE INDICATOR ******
2370 CLS
2380 LINE (4,0)-(4,4):LINE (0,2)-(8,2)
2390 GET (0,0)-(8,4),SAT:PUT (0,0),SAT ' THIS GENERATES THE SATELLITE ICON
2400 CLS
2410 LINE (4,1)-(4,3):LINE (3,2)-(5,2)
2420 GET (0,0)-(8,4),PKT
2430 '
2440 ' ****** NUMERIC CONSTANTS ******
2450 P1=3.1415926535#             ' Value of PI
2460 R0=6378.16:F=298.16     ' Earth's radius, 1/Earth flattening coef.
2470 G0=75369793000000#      ' GM of Earth in (Orbits/day)^2/km^3
2480 G1=1.0027379093#             ' Sidereal/Solar time rate ratio
2490 '
2500 ' ****** GROUND STATION CONSTANTS ******
2510 OPEN "GROUND.DAT" AS #2 LEN=44
2520 FIELD #2, 10 AS GR$,20 AS GL$,4 AS GH$,4 AS LO$, 4 AS LA$, 2 AS UTCDIFF$
2530 GET #2,1
2540 L9=CVS(LA$):W9=CVS(LO$):H9=CVS(GH$):UTCDIFF%=CVI(UTCDIFF$)
2550 CLOSE #2
2560 'L9=Latitude in degrees
2570 'W9=Longitude in degrees
2580 'H9=Height above sea level in meters
2590 'C$=GRUND STATION CALL+LOCATION STRING
2600 FOR I=1 TO 10 '**** I = STRING LENGTH TO BE STRIPPED OF TRAILING SPACES****
2610 GRT$=MID$(GR$,11-I,1)
2620 IF GRT$ <> " " THEN GRR$=LEFT$(GR$,11-I):I=10 ' GRR$ IS GR$ STRIPPED OF TRAILING PADDED SPACES
2630 NEXT
2640 I=0
2650 FOR I=1 TO 20 '**** I = STRING LENGTH TO BE STRIPPED OF TRAILING SPACES****
2660 GLT$=MID$(GL$,21-I,1)
2670 IF GLT$ <> " " THEN GLR$=LEFT$(GL$,21-I):I=20 ' GLR$ IS GL$ STRIPPED OFTRAILING PADDED SPACES
2680 NEXT
2690 C$=GRR$+" "+GLR$ '**** END PROGRAM STRIP TRAILING SPACES, HSI JAN.1985
2700 '
2710 ' ****** DERIVED CONSTANTS ******
2720 P2=2*P1:P0=P1/180:F=1/F:L8=L9*P0:S9=SIN(L8):C9=COS(L8)
2730 S8=SIN(-W9*P0):C8=COS(W9*P0)
2740 R9=R0*(1-(F/2)+(F/2)*COS(2*L8))+H9/1000
2750 L8=ATN((1-F)^2*S9/C9):Z9=R9*SIN(L8)
2760 X9=R9*COS(L8)*C8:Y9=R9*COS(L8)*S8
2770 '
2780 ' ****** ESTABLISH SIDEREAL TIME TABLE MATRIX ******
2790 RESTORE 2900:FLG1=0:FLG2=0:CLS
2800 FOR I1=1 TO 25
2810 READ Y1(I1), G3(I1)   ' Read sidereal time table
2820 IF Y1(I1)=FNYR THEN FLG1=1
2830 IF Y1(I1)=FNYR-1 THEN FLG2=1
2840 IF Y1(I1)=0 THEN 2860
2845 IF FLG1=1 AND FLG2=1 THEN 2970
2850 NEXT
2860 IF FLG1=1 AND FLG2=1 THEN 2970
2870 PRINT "UNABLE TO FIND CURRENT AND/OR PRECEEDING YEAR IN SIDERAL TIME TABLE":GOTO 2970
2880 '
2890 ' ****** SIDEREAL TIME TABLE ******
2895 ' THESE MUST BE IN NUMERICAL ORDER
2900 DATA 84, 0.2746066342
2910 DATA 85, 0.2766814244
2915 DATA 86, 0.276007
2920 DATA 87, 0.275347
2921 DATA 88, 0.27469296
2922 DATA 89, .27676776
2924 DATA 90, .27610467
2926 DATA 91, .27544157
2927 DATA 92, .27477847
2928 DATA 93, .27685328
2929 DATA 94, .27619018
2930 DATA 95, .27552707
2931 DATA 96, .27486398
2933 DATA 97, .27693879
2935 DATA 98, .27627569
2937 DATA 99, .27561259
2940 DATA 0,0
2950 '
2960 ' ****** ESTABLISH SATELLITE ELEMENT MATRIX ******
2970 I=0
2980 I=I+1:IF I>ARRAYSIZE% THEN 3120
2990 GET #1,I
3020 IF EOF(1) THEN GOTO 3120
3030 IF (I$=SPACE$(10)) THEN 3120
3040 I$(I)=I$
3050 IF ( (LEFT$(I$,1)=SPACE$(1)) OR (LEFT$(I$,1)=CHR$(0)) ) THEN 3120
3060 Y3(I)=CVI(Y3$):T0(I)=CVD(T0$):I0(I)=CVS(I0$):O0(I)=CVS(O0$)
3070 E0(I)=CVS(E0$):W0(I)=CVS(W0$):M0(I)=CVS(M0$):N0(I)=CVD(N0$)
3080 K0(I)=CVS(K0$):F1(I)=CVS(F1$)
3090 IF Y3(I)=FNYR THEN 2980 ELSE IF Y3(I)=FNYR-1 THEN 2980 
3095 PRINT "ELEMENTS FOR SATELLITE ";I$(I);" NOT FROM CURRENT OR PRECEEDING YEAR.":GOTO 2980
3100 '
3110 ' ****** SET UP KEY TRAPPING ******
3120 ON KEY(9) GOSUB 4610:KEY(9) STOP
3130 ON KEY(10) GOSUB 4640:KEY(10) OFF
3140 FLG9=0:FLG10=0::GOSUB 4180
3150 '
3160 ' ****** ORBIT DETERMINATION LOOP STARTS HERE ******
3165 START%=1  'ONLY 8 WILL FIT ON THE SCREEN
3170 GOSUB 8100 ' CHECK FOR PAGE UP / PAGE DOWN, DECIDE WHICH SATELLITES TO DISPLAY
3175 FOR J=START% TO ENDJ%
3180 Q$=INKEY$
3185 IF Q$=CHR$(27) THEN CLOSE #1: GOTO 20
3190 GOSUB 3270
3200 IF FLG9=0 THEN 3220 'DISPLAY TABULAR DATA
3210 GOSUB 3720:GOSUB 3780
3220 GOSUB 3930
3230 NEXT
3240 GOTO 3170
3250 '
3260 ' ****** ORBIT CALCULATION ROUTINE ******
3270 A0(J)=((G0/(N0(J)*N0(J)))^(1/3))
3280 E2=1-E0(J)*E0(J):E1=SQR(E2):Q0=M0(J)/360+K0(J)
3290 K2=9.95*((R0/A0(J))^3.5)/(E2*E2)
3300 S1=SIN(I0(J)*P0):C1=COS(I0(J)*P0)
3310 T=INT(30.55*(FNMTH+2))-2*(INT(.1*(FNMTH+7)))-91
3320 IF FNMTH>2 THEN IF ( (FNYR MOD 4)=0 AND (NOT(FNYR MOD 100)=0) ) THEN T=T+1
3325 IF FNMTH>2 THEN IF (  (FNYR MOD 400)=0 ) THEN T=T+1
3330 IF Y3(J)=FNYR-1 THEN T=T+365 ELSE 3350
3340 IF Y3(J)/4=INT(Y3(J)/4) THEN T=T+1
3350 GOSUB 7800:T$=UTCTIME$:T=T+FNDAY+FNHR/24+FNMIN/1440+FNSEC/86400!
3360 O=O0(J)-(T-T0(J))*K2*C1:S0=SIN(O*P0):C0=COS(O*P0)
3370 W=W0(J)+(T-T0(J))*K2*(2.5*(C1*C1)-.5)
3380 S2=SIN(W*P0):C2=COS(W*P0)
3390 C(1,1)=+(C2*C0)-(S2*S0*C1):C(1,2)=-(S2*C0)-(C2*S0*C1)
3400 C(2,1)=+(C2*S0)+(S2*C0*C1):C(2,2)=-(S2*S0)+(C2*C0*C1)
3410 C(3,1)=+(S2*S1):C(3,2)=+(C2*S1)
3420 Q=N0(J)*(T-T0(J))+Q0:K=INT(Q):M=(Q-K)*P2
3430 E=M+E0(J)*SIN(M)+.5*(E0(J)*E0(J))*SIN(2*M)
3440 S3=SIN(E):C3=COS(E):R3=1-E0(J)*C3:M1=E-E0(J)*S3
3450 M5=M1-M:IF ABS(M5)<.000001 THEN 3470 ELSE E=E-M5/R3
3460 GOTO 3440
3470 X0=A0(J)*(C3-E0(J)):Y0=A0(J)*E1*S3:R=A0(J)*R3
3480 X1=X0*C(1,1)+Y0*C(1,2):Y1=X0*C(2,1)+Y0*C(2,2):Z1=X0*C(3,1)+Y0*C(3,2)
3490 FOR I2=1 TO I1:IF Y3(J)=Y1(I2) THEN G2=G3(I2)
3500 NEXT
3510 G7=T*G1+G2:G7=(G7-INT(G7))*P2:S7=-SIN(G7):C7=COS(G7)
3520 X=+(X1*C7)-(Y1*S7):Y=+(X1*S7)+(Y1*C7):Z=Z1
3530 X5=(X-X9):Y5=(Y-Y9):Z5=(Z-Z9):R5=SQR(X5*X5+Y5*Y5+Z5*Z5)
3540 Z8=+(X5*C8*C9)+(Y5*S8*C9)+(Z5*S9)
3550 X8=-(X5*C8*S9)-(Y5*S8*S9)+(Z5*C9):Y8=+(Y5*C8)-(X5*S8)
3560 S5=Z8/R5:C5=SQR(1-S5*S5):E9=ATN(S5/C5)/P0
3570 IF X8<0 THEN A9=P1+ATN(Y8/X8) ELSE 3590
3580 GOTO 3620
3590 IF X8>0 AND Y8>=0 THEN A9=ATN(Y8/X8) ELSE IF X8>0 THEN A9=P2+ATN(Y8/X8) ELSE 3610
3600 GOTO 3620
3610 IF Y8<0 THEN A9=3*P1/2 ELSE A9=P1/2
3620 A9=A9/P0
3630 IF X<0 THEN W5=P1+ATN(Y/X) ELSE 3650
3640 GOTO 3680
3650 IF X>0 AND Y>=0 THEN W5=ATN(Y/X) ELSE IF X>0 THEN W5=P2+ATN(Y/X) ELSE 3670
3660 GOTO 3680
3670 IF Y<0 THEN W5=3*P1/2 ELSE W5=P1/2
3680 W5=360-W5/P0:B5=Z/R:L5=ATN(B5/(SQR(1-B5^2)))/P0
3690 RETURN
3700 '
3710 ' ****** LAT./LONG. PLOT ROUTINE ******
3720 Y6=CINT(.7111*(90-L5)+3)
3730 IF W5<=270 AND W5>=0 THEN X6=CINT(477-W5*1.7444)
3740 IF W5>270 AND W5<=360 THEN X6=CINT(1105-W5*1.7444)
3745 ' X IS FROM 0-634; Y IS FROM 3-131
3750 RETURN
3760 '
3770 ' ****** PUT SATELLITE ON SCREEN ROUTINE ******
3780 IF FLG0(J)=0 THEN 3830 'DO NOT RESTORE THE FIRST TIME
3785 FOR SUB% = 1 TO 16
3800 KEP(SUB%)=SCRSAV(J,SUB%)
3810 NEXT SUB%
3820 PUT (SATL(J,1),SATL(J,2)),KEP,PSET 'RESTORE THE SCREEN AT THE OLD LOCATION
3830 FLG0(J)=1    ' SET FIRST TIME FLAG
3835 PRESET (X6,Y6),3   'MAKE A TRAIL OF PAST LOCATIONS
3836 IF ((X6-4)<0) THEN XSAVEU=0 ELSE XSAVEU=X6-4  ' CHECK LIMITS OF THE MAP
3837 IF ((Y6-4)<3) THEN YSAVEU=3 ELSE YSAVEU=Y6-4
3838 IF ((X6+4)>634) THEN XSAVEL=634 ELSE XSAVEL=X6+4 
3839 IF ((Y6+4)>131) THEN YSAVEL=131 ELSE YSAVEL=Y6+4
3840 GET(XSAVEU,YSAVEU)-(XSAVEL,YSAVEL),KEP ' SAVE THE SCREEN AREA BEFORE A PLOT
3850 FOR SUB% = 1 TO  16 'RESTRICTION ON GET AND PUT ARRAYS REQUIRED THIS
3860 SCRSAV(J,SUB%)=KEP(SUB%)
3870 NEXT SUB%
3880 PUT (X6-4,Y6-2),SAT,OR
3882 'PRESET (X6-1,Y6-1),3:PRESET (X6-1,Y6+1),3:PRESET (X6+1,Y6+1),3
3883 'LINE (X6,Y6+1)-(X6,Y6-1),3:LINE (X6-2,Y6)-(X6+2,Y6),3
3884 'PRESET (X6+1,Y6-1),3:PRESET (X6,Y6),3
3890 SATL(J,1)=XSAVEU:SATL(J,2)=YSAVEU ' SAVE THE OLD LOCATION  (OFFSET)
3900 RETURN
3910 '
3920 ' ****** PRINT SATELLITE DETAILS ROUTINE ******
3930 KEY(9) ON:KEY(10) ON
3940 KEY(10) STOP:KEY(9) STOP
3950 IF FLGK=1 THEN GOSUB 4160
3960 IF FLG9=0 GOTO 4050
3970 IF FLG10=1 THEN GOSUB 4420
3980 IF FLG10=0 THEN 4010 ELSE V$=SPACE$(10):LSET V$=I$(J)
3985 ' J IS THE SATELLITE NUMBER
3990 IF V$<>U$ THEN 4130
4000 LOCATE 25,74:PRINT "CHOSEN";
4010 LOCATE 25,1:PRINT SPACE$(68);
4020 LOCATE 25,1:PRINT RIGHT$(I$(J),13);
4030 LOCATE 25,15
4040 GOTO 4110
4050 COLOR 3:LOCATE 3,44:PRINT D$:LOCATE 4,37:PRINT T$
4060 IF E9>=0 THEN COLOR 12 ELSE 4080
4065 ' SATELLITE IS ABOVE THE HORIZON
4070 IF E9>0 AND E9<1 THEN COLOR 28:BEEP
4075 ' HERE YOU COULD CHECK ALL SATELLITES; RETURN IF NOT ON CURRENT PAGE
4077 ' SATELLITES THAT WERE ON ANOTHER PAGE WOULD BEEP BUT NOT BE DISPLAYED
4078 ' 3175 WOULD HAVE TO BE CHANGED
4080 ROW%=2*((J-START%+1) MOD 9)+7
4085 LOCATE ROW%,1:PRINT SPACE$(80);
4090 LOCATE ROW%,1:PRINT RIGHT$(I$(J),13)
4100 LOCATE ROW%,15
4110 PRINT USING "###   ###  #####    #####  ###.#   ###.#    ######   ###.#";A9,E9,R5,(R-R0),L5,W5,K,M/P0;
4120 IF FLG9=0 GOTO 4130 ELSE LOCATE 20,48:PRINT UTCTIME$;
4130 RETURN
4140 '
4150 ' ****** SET UP SCREEN DISPLAY ROUTINE ******
4160 CLS:FOR SUB%=1 TO ARRAYSIZE% : FLG0(SUB%)=0 : NEXT SUB% :FLGK=0
4170 IF FLG9=1 THEN 4260 'IF FLG9=0 THEN FLG9=1:GOTO 8280
4180 ' FLG9=0
4190 SCREEN 0,1:COLOR 2,0,0
4200 LOCATE 1,40-LEN(C$)/2,0:PRINT C$
4210 LOCATE 2,28:PRINT "REALTIME SATELLITE TRACKING"
4220 LOCATE 3,29:PRINT "COORDINATES ON"
4230 LOCATE 4,34:PRINT "AT":LOCATE 4,46:PRINT "UTC"
4235 LOCATE 25,3:PRINT"F9 TOGGLES THE GRAPH/TABLE     F10 TO SELECT SINGLE SAT IN GRAPH   ESC TO END";
4237 LOCATE 24,3:PRINT"USE PAGE UP/PAGE DOWN TO DISPLAY DIFFERENT SATELLITES";
4240 L1=6:L2=7:L3=8
4250 GOTO 4330
4260 GOSUB 4560:SCREEN 2,0:OUT 985,3
4265 ' *****************************
4270 DEF SEG=&HB800:BLOAD "MAP.DAT",0:DEF SEG=0
4280 W5=W9:L5=L9:GOSUB 3720
4290 CIRCLE (X6,Y6),2   ' AT (X,Y) RADIUS 2
4300 GOSUB 4490:L1=22:L2=23:L3=24
4310 LOCATE 20,3:PRINT "DATA FOR GROUNDSTATION             AT TIME=           UTC  ON: ";D$
4320 LOCATE 20,26:PRINT GRR$
4330 LOCATE L1,3
4340 PRINT "  NAME OR   AZ    EL   RANGE   HEIGHT   LAT.   LONG.    ORBIT    M. A. "
4350 LOCATE L2,3
4360 PRINT "DESIGNATOR  DEG   DEG    KM      KM     DEG     DEG       NO.     DEG "
4370 LOCATE L3,3
4380 PRINT "----------  ---   ---  -----   ------  -----   -----    ------   -----";
4390 RETURN
4400 '
4410 ' ****** SELECT SINGLE SATELLITE ROUTINE ******
4420 LOCATE 25,1:PRINT SPACE$(79);
4430 LOCATE 25,1:INPUT; "WHICH SATELLITE? (CR FOR ALL)";I1$
4432 'FOR QQQ = 1 TO LEN(I1$)
4433 'IF MID$(I1$,QQQ,1) > CHR$(&H60) AND MID$(I1$,QQQ,1) < CHR$(&H7B) THEN MID$(I1$,QQQ,1) = CHR$(ASC(MID$(I1$,QQQ,1)) AND 223)
4434 'NEXT QQQ  
4435 'this changed letters to capital
4440 IF I1$="" THEN FLG10=0:GOTO 4460
4450 U$=SPACE$(10):LSET U$=I1$:FLG10=2
4460 LOCATE 25,1:PRINT SPACE$(79);
4470 RETURN
4480 CLOSE #1:GOTO 20
4490  GOTO 4530
4500 DEF SEG =0
4510 POKE &H410,(PEEK(&H410) OR &H30)
4515 ' *********************************
4520 SCREEN 0
4530 WIDTH 80
4540 LOCATE ,,1,12,13  'turn cursor on for scan line 12-13
4550 RETURN
4560 ' SWITCH TO COLOR
4570 DEF SEG=0
4580 POKE &H410,(PEEK(&H410) AND &HCF) OR &H10
4585 ' *********************************
4590 OUT 980,2:OUT 981,85 ' THIS SHIFTS THE OUTPUT DISPLAY
4600 RETURN
4610 IF FLG9=0 THEN FLG9=1:GOTO 4630 'FLAG9 TOGGELN
4620 FLG9=0
4630 FLGK=1:RETURN 3940
4640 IF FLG9=1 THEN FLG10=1 ELSE FLG10=0:RETURN 3940
4645 ' F10 IS ONLY USED IN THE MAP MODE
4650 RETURN 3940
4660 GOTO 20 'ENDE PROGRAMMTEIL ECHTZEITDISPLAY
5000 '****** ORBIT2 - VERSION 2.0, ISSUE 1.0/HSI - 17/01/85 *****
5010 KEY OFF:SCREEN 0,1:WIDTH 80:COLOR 14,1,0:CLS         'dls
5020 PRINT" AMSAT ORBITAL PREDICTION PROGRAM de W3IWI - May,1980"
5030 PRINT" COPYRIGHT 1980 by Dr. Thomas A. Clark, W3IWI"
5040 PRINT"                   6388 Guilford Road"
5050 PRINT"                   Clarksville, MD. 21029"
5060 PRINT
5070 PRINT"REVISED & MODIFIED FOR IBM-PC by R. D. Welch, W0SL - May, 1983"
5080 PRINT"                                 908 Dutch Mill Dr."
5090 PRINT"                                 Manchester, Mo. 63011
5100 PRINT
5110 PRINT"ENHANCED AND DEBUGGED BY Ing. H.F.STRASSER OE1HSI- JAN. 1985"
5120 PRINT"                                 A 1238 VIENNA/AUSTRIA":PRINT:
5124 PRINT"Enhanced by DONALD HARTER JR.; 9-27-1991, 11-9-1992, 01-30-1994"
5126 PRINT"               3084 Lakeshore Rd.; Manistee, MI; 49660"
5130 PRINT" Permission granted for non-commercial use providing"
5140 PRINT" credit is given to the author, AMSAT and ORBIT Magazine.":PRINT
5150 '
5160 ' ****** HOUSEKEEPING ITEMS ******
5170 CLEAR
5180 '
5190 '
5200 DEFDBL H,T
5205 DIM C(3,2),Y1(25),G3(25),SAT(16),SATL(40,2)
5210 DIM T$(40),II$(40),CC(3,2)
5215 DIM I$(40),Y3(40),T0(40),I0(40),O0(40),E0(40),W0(40),M0(40),N0(40)
5217 DIM K0(40),F1(40),A0(40)
5218 ' BASIC HAS A DEFAULT DIMENSION WHICH WAS BEING USED BEFORE THE CHANGE
5219 ARRAYSIZE%=40
5220 C8$=CHR$(10)+CHR$(10)+CHR$(10)+CHR$(10)
5230 C9$=CHR$(12)+CHR$(7)
5240 DEF FNT$(D)=CHR$(48+INT(D/10))+CHR$(48+D-10*INT(D/10))
5250 YY=0
5260 '****** NUMERIC CONSTANTS ******
5270 P1=3.1415926535#            ' Value of PI
5280 R0=6378.16:F=298.16    ' Earth's radius, 1/Earth flattening coef.
5290 G0=75369793000000#     ' GM of Earth in (orbits/day)^2/km^3
5300 G1=1.0027379093#:C=299792.5   ' Sidereal/Solar time rate ratio
5310 '
5320 ' ****** GROUND STATION CONSTANTS ******
5330 OPEN "GROUND.DAT" AS #2 LEN=44 
5340 FIELD #2, 10 AS GR$,20 AS GL$,4 AS GH$,4 AS LO$, 4 AS LA$, 2 AS UTCDIFF$
5350 GET #2,1
5360 L9=CVS(LA$):W9=CVS(LO$):H9=CVS(GH$):UTCDIFF%=CVI(UTCDIFF$)
5370 CLOSE #2
5380 'L9=Latitude in degrees
5390 'W9=Longitude in degrees
5400 'H9=Height above sea level in meters
5410 'C$=GROUND STATION CALL+LOCATION STRING
5420 FOR I=1 TO 10 '**** I = STRINGLENGHT TO BE STRIPPED OF TRAILING SPACES****
5430 GRT$=MID$(GR$,11-I,1)
5440 IF GRT$ <> " " THEN GRR$=LEFT$(GR$,11-I):I=10 ' GRR$ IS GR$ STRIPPED OFTRAILING PADDED SPACES
5450 NEXT
5460 I=0
5470 FOR I=1 TO 20 '**** I = STRINGLENGHT TO BE STRIPPED OF TRAILING SPACES****
5480 GLT$=MID$(GL$,21-I,1)
5490 IF GLT$ <> " " THEN GLR$=LEFT$(GL$,21-I):I=20 ' GLR$ IS GL$ STRIPPED OFTRAILING PADDED SPACES
5500 NEXT
5510 C$=GRR$+" "+GLR$ '**** END PROGRAM STRIP TRAILING SPACES, HSI JAN.1985
5520 '
5530 ' ****** DERIVED CONSTANTS ******
5540 P2=2*P1:P0=P1/180:F=1/F:L8=L9*P0:S9=SIN(L8):C9=COS(L8)
5550 S8=SIN(-W9*P0):C8=COS(W9*P0)
5560 R9=R0*(1-(F/2)+(F/2)*COS(2*L8))+H9/1000
5570 L8=ATN((1-F)^2*S9/C9):Z9=R9*SIN(L8)
5580 X9=R9*COS(L8)*C8:Y9=R9*COS(L8)*S8
5590 GOTO 5620
5600 BEEP:COLOR 12:PRINT"  enter YEAR 1982 or higher !":COLOR 14,1,0
5610 ' ****** INPUT DATA ******
5620 INPUT; "Start: Year (19YY) ( <enter> for default date) = ",Y:
5621 GOSUB 8000 : GOSUB 7800  ' GET UTC TIME DIFFERENCE AND CALCULATE THE TIME
5622 GOSUB 11000    " CALCULATE UTC DATE
5623 IF (Y=0) THEN Y=VAL(RIGHT$(UTCDATE$,4)): PRINT Y
5625 IF Y<1982 GOTO 5600 ELSE YY=Y:Y=Y/100:Y=INT(100*(Y-INT(Y))+.1)
5630 PRINT:INPUT; "   Month (1-12) = ",M
5635 IF (M=0) THEN M=VAL(LEFT$(UTCDATE$,2)): PRINT M;
5636 INPUT; "   Day = ",D
5637 IF (D=0) THEN D=VAL(MID$(UTCDATE$,4,2)): PRINT D
5640 T$=FNT$(Y)+"/"+FNT$(M)+"/"+FNT$(D)+" at "
5650 TE$=FNT$(D)+"."+FNT$(M)+"."+FNT$(Y)+" at "
5660 D8=D+INT(30.55*(M+2))-2*(INT(.1*(M+7)))-91
5670 IF M>2 THEN IF ( (Y MOD 4)=0 AND (NOT(Y MOD 100)=0) ) THEN D8=D8+1
5674 IF M>2 THEN IF ( (Y MOD 4)=0 AND ((Y MOD 400)=0) ) THEN D8=D8+1
5680 PRINT "     Day #  ";D8:PRINT
5690 INPUT; "Start: UTC Hours(HH) = ",H
5695 IF (H=0) THEN GOSUB 7800: H=VAL(LEFT$(UTCTIME$,2)):PRINT H;
5700 INPUT; "    Min. = ",M
5705 IF (M=0) THEN GOSUB 7800: M=VAL(MID$(UTCTIME$,4,2)):PRINT M
5708 T7=D8+H/24+M/1440
5710 T$=T$+FNT$(H)+FNT$(M)+ ":00 H"
5720 INPUT; " Duration :      Hours = ",H1
5730 INPUT "    Min. = ",M1:T8=T7+H1/24+M1/1440
5740 INPUT; "Timestep :      Min. = ",M2:T9=M2/1440
5750 PRINT USING "    From ###.####### to ###.#######";T7,T8
5760 PRINT:INPUT "MINIMUM ELEVATION ? (DEFAULT 0) Deg. = ",E8
5770 GOTO 5790
5780 COLOR 28,1,0:BEEP
5790 PRINT:INPUT "Output to Printer (P), Screen (S) or Disk (D) ?--> ",P$
5800 IF ( P$="P" OR P$="p" OR P$="S" OR P$="s" OR P$="d" OR P$="D") THEN 5810: ELSE 5780
5810 COLOR 14,1,0:IF P$="P" OR P$="p" THEN P%=2 ELSE P%=3
5820 IF (P$="s" OR P$="S" OR P$="d" OR P$="D") THEN C9$=C8$: GOTO 5920
5830 CLS:COLOR 12:LOCATE 12,20:PRINT"IS THE PRINTER READY ??":LOCATE 14,9
5840 PRINT "SWITCH PRINTER ON AND ALIGN PAGE !! (Y/N) ":COLOR 14
5850 Z$="YyNn"
5860 K$=INKEY$:IF K$="" THEN 5860
5870 K=INSTR(Z$,K$)
5880 ON K GOTO 5920,5920,5900,5900
5890 BEEP:GOTO 5860
5900 BEEP:BEEP:BEEP:GOTO 5830
5910 ' ****** ESTABLISH SIDEREAL TIME TABLE MATRIX ******
5920 RESTORE 6030:FLG1=0:FLG2=0:CLS
5930 FOR I1=1 TO 25
5940 READ Y1(I1), G3(I1)
5950 IF Y1(I1)=Y THEN FLG1=1
5960 IF Y1(I1)=Y-1 THEN FLG2=1
5970 IF Y1(I1)=0 THEN 5990
5975 IF FLG1=1 AND FLG2=1 THEN 6120
5980 NEXT
5990 IF FLG1=1 AND FLG2=1 THEN 6120
6000 PRINT "UNABLE TO FIND INQUIRY YEAR AND/OR PREVIOUS YEAR IN SIDERAL TIMETABLE.":STOP
6010 '
6020 ' ****** SIDEREAL TIME TABLE ******
6025 ' THESE MUST BE IN NUMERICAL ORDER
6030 DATA 84, 0.2746066342
6060 DATA 85, 0.2766814244
6070 DATA 86, 0.276007
6071 DATA 87, 0.275347
6072 DATA 88, 0.27469296
6073 DATA 89, .27676776
6074 DATA 90, .27610467
6076 DATA 91, .27544157
6077 DATA 92, .27477847
6078 DATA 93, .27685328
6079 DATA 94, .27619018
6080 DATA 95, .27552707
6081 DATA 96, .27486398
6083 DATA 97, .27693879
6085 DATA 98, .27627569
6087 DATA 99, .27561259
6090 DATA 0,0
6100 '
6110 ' ****** ESTABLISH SATELLITE ELEMENT MATRIX ******
6120 I=0
6130 OPEN "ELEMENTS.DAT" AS #1 LEN=56
6140 FIELD #1, 10 AS II$, 2 AS Y3$, 8 AS T0$, 4 AS I0$, 4 AS O0$, 4 AS E0$, 4 AS W0$, 4 AS M0$, 8 AS N0$, 4 AS K0$, 4 AS F1$
6150 I=I+1:IF I>ARRAYSIZE% THEN 6290
6160 GET #1,I
6165 IF EOF(1) THEN CLOSE #1 :GOTO 6290
6170 IF (II$=SPACE$(10)) THEN CLOSE #1 :GOTO 6290 ' CHECK FOR END OF FILE
6200 II$(I)=II$
6220 IF ( (LEFT$(II$,1)=SPACE$(1)) OR (LEFT$(II$,1)=CHR$(0) ) ) THEN 6290
6230 Y3(I)=CVI(Y3$):T0(I)=CVD(T0$):I0(I)=CVS(I0$):O0(I)=CVS(O0$)
6240 E0(I)=CVS(E0$):W0(I)=CVS(W0$):M0(I)=CVS(M0$):N0(I)=CVD(N0$)
6250 K0(I)=CVS(K0$):F1(I)=CVS(F1$)
6260 IF Y3(I)=Y THEN 6150 ELSE IF Y3(I)=Y-1 THEN 6150 
6265 PRINT "ELEMENTS for satellite";II$(I);" NOT from CURRENT or PRECEEDING YEAR.":GOTO 6150
6270 '
6280 ' ****** SELECT SATELLITE FROM MENU ******
6290 PRINT "SATELLITE SELECTION MENU":PRINT
6300 FOR J=1 TO I-1
6310 PRINT "Entry #  ";J;" for ";II$(J)
6320 NEXT
6330 PRINT:INPUT "SELECT Entry # : ",J
6340 IF J<1 OR J>ARRAYSIZE% THEN 6300
6350 PRINT :PRINT "Doppler calculated for frequency = ";F1(J);" MHz"
6360 INPUT " Change frequency to: (0 for default) ",D
6370 IF D<>0 THEN F1(J)=D
6372 IF (P$="d" OR P$="D") THEN OPEN "SAT.OUT" FOR APPEND AS # 3 : P%=3
6374 IF (P$="P" OR P$="p") THEN OPEN "LPT1:" FOR OUTPUT AS #3 : P%=3
6376 IF (P$="S" OR P$="s") THEN OPEN "SCRN:" FOR OUTPUT AS # 3 : P%=3
6380 PRINT#P%, :PRINT#P%, "Orbital ELEMENTS for ";II$(J)
6390 PRINT#P%,
6400 PRINT#P%, "Reference epoch = ";Y3(J);" +";T0(J)
6410 PRINT#P%, "Starting  epoch = ";Y;" +";T7;" = ";T$
6420 PRINT#P%,
6430 PRINT#P%, "Parameter";TAB(20);"Reference";TAB(40);"Starting"
6440 T=T7
6450 IF Y3(J)=Y-1 THEN T=T+365:T8=T8+365 ELSE 6470
6460 IF ( (Y3(J) MOD 4)=0 AND (NOT(Y3(J) MOD 100)=0) ) THEN T=T+1:T8=T8+1
6465 IF ( (Y3(J) MOD 400)=0 ) THEN T=T+1:T8=T8+1
6470 FOR I2=1 TO I1:IF Y3(J)=Y1(I2) THEN G2=G3(I2)
6480 NEXT
6490 GOSUB 6990
6500 PRINT#P%, "Orbit Number ";TAB(20);K0(J);TAB(40);K
6510 PRINT#P%, "Mean Anomaly ";TAB(20);M0(J);TAB(40);M/P0
6520 PRINT#P%, "Inclination  ";TAB(20);I0(J)
6530 PRINT#P%, "Eccentricity ";TAB(20);E0(J)
6540 PRINT#P%, "Mean Motion  ";TAB(20);N0(J)
6550 PRINT#P%, "S.M.A.,km    ";TAB(20);A0(J)
6560 PRINT#P%, "Arg. Perigee ";TAB(20);W0(J);TAB(40);W
6570 PRINT#P%, "R. A. A. N.  ";TAB(20);O0(J);TAB(40);O
6580 PRINT#P%, "Freq.,MHz    ";TAB(20);F1(J):K9=9E+07:K8=9E+07
6590 '
6600 '****** COMPUTATION LOOP ******
6610  T=T+T9:K7=INT(T):GOSUB 6990
6620 IF K7=K8 THEN 6640
6630 K8=9E+07:K9=9E+07
6640 GOSUB 7120:IF E9<E8 THEN 6790
6650 IF K7=K8 AND K=K9 THEN 6710
6660 IF K7=K8 THEN 6700 ELSE GOSUB 6900
6670 K8=K7
6680 PRINT#P%, " U.T.C.    AZ    EL  DOPPLER   RANGE   HEIGHT  LAT.  LONG.  PHASE M. A."
6690 PRINT#P%, "HHMM:SS   deg   deg    Hz       km       km    deg    deg   <256>  deg
6700 PRINT#P%, TAB(21) "- - - ORBIT #";K;"- - -"
6710 K9=K:T4=T-K7:S4=INT(T4*86400!):H4=INT(S4/3600+.000001)
6720 M4=INT((S4-H4*3600)/60+.000001)
6730 S4=S4-3600*H4-60*M4
6740 T$=FNT$(H4)+FNT$(M4)+":"+FNT$(S4)
6750 F9=-F1(J)*1000000!*R8/C
6760 PRINT#P%, T$;
6770 PRINT#P%, USING "   ###   ###  #####";A9;E9;F9;
6780 PRINT#P%, USING "    #####    #####  ###.#  ###.#   ###  ###.#";R5;(R-R0);L5;W5;M9;M/P0
6790 IF T<T8 THEN GOTO 6610
6800 PRINT#P%, C9$
6810 PRINT "Do YOU have another INQUIRY  ?  (Y/N) "
6820 PRINT:PRINT"Else you return to the MAIN MENU !":PRINT
6830 Z$="YyNn"
6840 K$=INKEY$:IF K$="" THEN 6840
6850 K=INSTR(Z$,K$)
6860 ON K GOTO 5010,5010,6880,6880
6870 BEEP:GOTO 6840
6880 CLOSE :GOTO 20
6890 '****** PAGE HEADER SUBROUTINE ******
6900 PRINT#P%, C9$;C$;"   Lat.=";L9;"  W.Long.=";W9;"  Ht.=";H9;
6910 P=P+1:PRINT#P%, TAB(70) "Page # ";P
6920 PRINT#P%, TAB(15)" - - - Minimum Elevation = ";E8;"Deg. - - -"
6930 PRINT#P%,
6940 DN=K7:GOSUB 7440
6950 PRINT#P%, TAB(14) "- - - DAY #";K7;"- - -  ";M$;" ";DD;",";YY;"- - -"
6960 PRINT#P%, :RETURN
6970 '
6980 '****** ORBIT DETERMINATION AND UTILITY ROUTINES ******
6990 A0(J)=((G0/(N0(J)*N0(J)))^(1/3))
7000 E2=1-E0(J)*E0(J):E1=SQR(E2):Q0=M0(J)/360+K0(J)
7010 K2=9.95*((R0/A0(J))^3.5)/(E2*E2)
7020 S1=SIN(I0(J)*P0):C1=COS(I0(J)*P0)
7030 O=O0(J)-(T-T0(J))*K2*C1
7040 S0=SIN(O*P0):C0=COS(O*P0)
7050 W=W0(J)+(T-T0(J))*K2*(2.5*(C1*C1)-.5)
7060 S2=SIN(W*P0):C2=COS(W*P0)
7070 CC(1,1)=+(C2*C0)-(S2*S0*C1):CC(1,2)=-(S2*C0)-(C2*S0*C1)
7080 CC(2,1)=+(C2*S0)+(S2*C0*C1):CC(2,2)=-(S2*S0)+(C2*C0*C1)
7090 CC(3,1)=+(S2*S1):CC(3,2)=+(C2*S1)
7100 Q=N0(J)*(T-T0(J))+Q0:K=INT(Q):M9=INT((Q-K)*256):M=(Q-K)*P2
7110 RETURN
7120 E=M+E0(J)*SIN(M)+.5*(E0(J)*E0(J))*SIN(2*M)
7130 S3=SIN(E):C3=COS(E):R3=1-E0(J)*C3:M1=E-E0(J)*S3
7140 M5=M1-M:IF ABS(M5)<.000001 THEN 7160 ELSE E=E-M5/R3
7150 GOTO 7130
7160 X0=A0(J)*(C3-E0(J)):Y0=A0(J)*E1*S3:R=A0(J)*R3
7170 X1=X0*CC(1,1)+Y0*CC(1,2):Y1=X0*CC(2,1)+Y0*CC(2,2):Z1=X0*CC(3,1)+Y0*CC(3,2)
7180 G7=T*G1+G2:G7=(G7-INT(G7))*P2:S7=-SIN(G7):C7=COS(G7)
7190 X=+(X1*C7)-(Y1*S7):Y=+(X1*S7)+(Y1*C7):Z=Z1
7200 X5=(X-X9):Y5=(Y-Y9):Z5=(Z-Z9):R5=SQR(X5*X5+Y5*Y5+Z5*Z5)
7210 IF T6<>T THEN R8=((R6-R5)/(T6-T))/86400! ELSE R8=-9000000000#
7220 R6=R5:T6=T
7230 Z8=+(X5*C8*C9)+(Y5*S8*C9)+(Z5*S9)
7240 X8=-(X5*C8*S9)-(Y5*S8*S9)+(Z5*C9):Y8=+(Y5*C8)-(X5*S8)
7250 S5=Z8/R5:C5=SQR(1-S5*S5):E9=ATN(S5/C5)/P0
7260 IF X8<0 THEN A9=P1+ATN(Y8/X8) ELSE 7280
7270 GOTO 7310
7280 IF X8>0 AND Y8>=0 THEN A9=ATN(Y8/X8) ELSE IF X8>0 THEN A9=P2+ATN(Y8/X8) ELSE 7300
7290 GOTO 7310
7300 IF Y8<0 THEN A9=3*P1/2 ELSE A9=P1/2
7310 A9=A9/P0
7320 IF X<0 THEN W5=P1+ATN(Y/X) ELSE 7340
7330 GOTO 7370
7340 IF X>0 AND Y>=0 THEN W5=ATN(Y/X) ELSE IF X>0 THEN W5=P2+ATN(Y/X) ELSE 7360
7350 GOTO 7370
7360 IF Y<0 THEN W5=3*P1/2 ELSE W5=P1/2
7370 W5=360-W5/P0
7380 B5=Z/R:L5=ATN(B5/(SQR(1-B5^2)))/P0
7390 RETURN
7400 INPUT"DAY OF YEAR NUMBER:";DN
7410 GOSUB 7440
7420 PRINT DD,M$
7430 GOTO 7400
7440 ' ****** DATE FROM DAY OF YEAR NUMBER ******
7450 '
7460 DD=0
7470 YS=Y3(J)
7480 DN=DN-31:IF DN<=0 GOTO 7630
7490 IF ((YS MOD 4)=0 AND NOT( (YS MOD 100)=0 ) ) GOTO 7760 ' LEAP YEAR EXCEPT CERTAIN CENTURIES
7495 IF ( (YS MOD 400)=0 ) GOTO 7760
7500 DN=DN-28: IF DN<=0 GOTO 7650
7510 DN=DN-31: IF DN<=0 GOTO 7660
7520 DN=DN-30: IF DN<=0 GOTO 7670
7530 DN=DN-31: IF DN<=0 GOTO 7680
7540 DN=DN-30: IF DN<=0 GOTO 7690
7550 DN=DN-31: IF DN<=0 GOTO 7700
7560 DN=DN-31: IF DN<=0 GOTO 7710
7570 DN=DN-30: IF DN<=0 GOTO 7720
7580 DN=DN-31: IF DN<=0 GOTO 7730
7590 DN=DN-30: IF DN<=0 GOTO 7740
7600 DN=DN-31: IF DN<=0 GOTO 7750
7610 YS=YS+1
7620 GOTO 7480
7630 M$="JAN": DD=DN+31: RETURN
7640 M$="FEB": DD=DN+29: RETURN
7650 M$="FEB": DD=DN+28: RETURN
7660 M$="MAR": DD=DN+31: RETURN
7670 M$="APR": DD=DN+30: RETURN
7680 M$="MAY": DD=DN+31: RETURN
7690 M$="JUN": DD=DN+30: RETURN
7700 M$="JLY": DD=DN+31: RETURN
7710 M$="AUG": DD=DN+31: RETURN
7720 M$="SEP": DD=DN+30: RETURN
7730 M$="OCT": DD=DN+31: RETURN
7740 M$="NOV": DD=DN+30: RETURN
7750 M$="DEC": DD=DN+31: RETURN
7760 DN=DN-29: IF DN<=0 THEN 7640 ELSE 7510
7770 GOTO 200 'END
7800 TEMPTIME$=TIME$: TEMPHOUR%=VAL(MID$(TEMPTIME$,1,2))
7860 UTCDIFF%=CVI(UTCDIFF$)
7870 TEMPH%=TEMPHOUR%+UTCDIFF%
7872 DATEDIFF%=0
7874 IF (TEMPH%<0) THEN DATEDIFF%=-1 ' UTC DATE IS YESTERDAY
7876 IF (TEMPH%>=24) THEN DATEDIFF%=1 ' UTC DATE IS TOMORROW
7880 TEMPHOUR%=(TEMPHOUR%+24+UTCDIFF%) MOD 24
7890 MID$(TEMPTIME$,1,2)=RIGHT$(STR$(TEMPHOUR%),2)
7900 UTCTIME$=TEMPTIME$
7910 RETURN 
8000 OPEN "GROUND.DAT" AS #2 LEN=44 ' GET UTCDIFF%
8020 FIELD #2, 10 AS GR$,20 AS GL$,4 AS GH$,4 AS LO$, 4 AS LA$, 2 AS UTCDIFF$
8030 GET #2,1
8040 UTCDIFF%=CVI(UTCDIFF$)
8050 CLOSE #2
8060 RETURN
8100 KB$=INKEY$ 
8110 IF (LEN(KB$)=2 AND LEFT$(KB$,1)=CHR$(0) AND RIGHT$(KB$,1)=CHR$(73)) THEN START%=START%-8
8120 IF (LEN(KB$)=2 AND LEFT$(KB$,1)=CHR$(0) AND RIGHT$(KB$,1)=CHR$(81)) THEN START%=START%+8
8130 IF (START% >(I-1) ) THEN START%=(I-1)-7
8140 IF (START%<1) THEN START%=1
8150 ENDJ%=START%+7  ' ONLY 8 WILL FIT ON THE SCREEN
8160 IF (ENDJ%>(I-1)) THEN ENDJ%=I-1
8170 IF ((ENDJ%-START%)<8) THEN START%=START%-(8-(ENDJ%-START%+1))
8180 RETURN
9000 ' THIS CONVERTS NASA TWO LINE ELEMENT FORMAT THE THE FORMAT USED BY THIS PROGRAM
9010 PRINT: PRINT " THIS WILL OVERWRITE THE FILE- ELEMENTS.DAT "
9020 INPUT " DO YOU WISH TO CONTINUE Y/N";YN$
9030 IF (YN$<>"Y" AND YN$<>"y") THEN GOTO 20
9040 INPUT "NASA TWO ELEMENT FILE NAME (THE DEFAULT IS AMATEUR.DAT) ";NF$
9050 IF (NF$="") THEN NF$="AMATEUR.DAT"
9060 OPEN NF$ FOR INPUT AS #3
9065 KILL "ELEMENTS.DAT"
9070 OPEN "ELEMENTS.DAT" AS #1 LEN =56
9080 FIELD #1, 10 AS I$, 2 AS Y3$, 8 AS T0$, 4 AS I0$, 4 AS O0$, 4 AS E0$, 4 AS W0$, 4 AS M0$, 8 AS N0$, 4 AS K0$, 4 AS F1$
9090 RECNUM%=0
9095 LNUM$="1"
9100 IF (EOF(3)) THEN CLOSE : GOTO 20
9110 LINE INPUT #3,LNE$
9120 IF (LEFT$(LNE$,1)<>"1" AND LEFT$(LNE$,1)<>"2") THEN 9095
9130 IF (LEFT$(LNE$,1) <> LNUM$) THEN PRINT "INVALID NASA FILE FORMAT":GOSUB 10000: CLOSE #1:GOTO 50
9135 IF (LEFT$(LNE$,1)="2" AND (SNAME1$<> MID$(LNE$,3,5)) ) THEN PRINT "INVALID NASA FILE FORMAT":GOSUB 10000:CLOSE #1:GOTO 50
9140 IF (LEFT$(LNE$,1)="1") THEN GOSUB 9200  ' LINE 1
9150 IF (LEFT$(LNE$,1)="2") THEN GOSUB 9300:GOSUB 9500 ' LINE 2; WRITE IT
9160 GOTO 9100
9200 LNUM$="2" 'LINE 1
9205 SNAME1$=MID$(LNE$,3,5)
9210 LSET I$=SNAME1$
9220 RSET Y3$=MKI$(VAL(MID$(LNE$,19,2)))
9230 RSET T0$=MKD$(VAL(MID$(LNE$,21,12)))
9240 RETURN
9300 LNUM$="1" ' LINE 2
9310 RSET I0$=MKS$(VAL(MID$(LNE$,9,8)))
9320 RSET O0$=MKS$(VAL(MID$(LNE$,18,8)))
9330 RSET E0$=MKS$(VAL("." + MID$(LNE$,27,7)))
9440 RSET W0$=MKS$(VAL(MID$(LNE$,35,8)))
9450 RSET M0$=MKS$(VAL(MID$(LNE$,44,8)))
9460 RSET N0$=MKD$(VAL(MID$(LNE$,53,11)))
9470 RSET K0$=MKS$(VAL(MID$(LNE$,64,5)))
9490 RETURN
9500 RECNUM%=RECNUM%+1' WRITE THE RECORD
9510 PUT #1,RECNUM%
9520 RETURN
10000 FOR DELAY%=1 TO 5000: NEXT DELAY%
10010 ' THE DELAY IS SO THE ERROR MESSAGE WILL BE SEEN
10020 RETURN
11000 UTCDATE$=DATE$
11010 MONTH=VAL(LEFT$(UTCDATE$,2)):DAY=VAL(MID$(UTCDATE$,4,2)):YEAR=VAL(RIGHT$(UTCDATE$,4))
11015 DAYS%=0
11020 ON MONTH GOTO 11200,11190,11174,11170,11160,11150,11140,11130,11120,11115,11110,11100
11025 'CALCULATE THE NUMBER OF DAYS SO FAR THIS YEAR
11100 DAYS%=DAYS%+30     'NOVEMBER
11110 DAYS%=DAYS%+31     'OCTOBER
11115 DAYS%=DAYS%+30     'SEPTEMBER
11120 DAYS%=DAYS%+31     'AUGUST
11130 DAYS%=DAYS%+31     'JULY
11140 DAYS%=DAYS%+30     'JUNE
11150 DAYS%=DAYS%+31     'MAY
11160 DAYS%=DAYS%+30     'APRIL
11170 DAYS%=DAYS%+31     'MARCH
11174 IF ( (YEAR MOD 400)=0 ) THEN DAYS%=DAYS%+29:LY$="Y": GOTO 11190
11176 IF ((YEAR MOD 4)=0 AND NOT( (YEAR MOD 100)=0 ) ) THEN DAYS%=DAYS%+29: LY$="Y" :GOTO 11190 ' LEAP YEAR EXCEPT FOR SOME CENTURIES
11178 LY$="N" ' NO LEAP YEAR
11180 DAYS%=DAYS%+28     'FEBRUARY
11190 DAYS%=DAYS%+31     'JANUARY
11200 DAYS%=DAYS%+DAY
11240 DAY%=DAYS%+DATEDIFF% ' UTC TIME HAS A DIFFERENT DATE THAN LOCAL TIME
11260 IF (LY$= "Y" AND DAY%>366) THEN YEAR=YEAR+1:DAY%=1:MONTH=1
11270 IF (LY$= "N" AND DAY%>365) THEN YEAR=YEAR+1:DAY%=1:MONTH=1
11272 IF ( DAY%<=0) THEN YEAR=YEAR-1:DAYS%=31:MONTH=12:GOTO 11276
11274 GOSUB 11280 ' COMVERT DAY NUMBER TO THE DATE
11276 UTCDATE$=RIGHT$(STR$(MONTH),2)+"-"+RIGHT$(STR$(DAYS%),2)+"-"+RIGHT$(STR$(YEAR),4)
11279 RETURN
11280 DAYS%=0 ' CONVERT DAY NUMBER TO DATE
11285 DAY%=DAY%-31:IF DAY%<=0 GOTO 11430
11290 IF ((YEAR MOD 4)=0 AND NOT( (YEAR MOD 100)=0 ) ) GOTO 11560 ' LEAP YEAR EXCEPT CERTAIN CENTURIES
11295 IF ( (YEAR MOD 400)=0 ) GOTO 11560
11300 DAY%=DAY%-28: IF DAY%<=0 GOTO 11450
11310 DAY%=DAY%-31: IF DAY%<=0 GOTO 11460
11320 DAY%=DAY%-30: IF DAY%<=0 GOTO 11470
11330 DAY%=DAY%-31: IF DAY%<=0 GOTO 11480
11340 DAY%=DAY%-30: IF DAY%<=0 GOTO 11490
11350 DAY%=DAY%-31: IF DAY%<=0 GOTO 11500
11360 DAY%=DAY%-31: IF DAY%<=0 GOTO 11510
11370 DAY%=DAY%-30: IF DAY%<=0 GOTO 11520
11380 DAY%=DAY%-31: IF DAY%<=0 GOTO 11530
11390 DAY%=DAY%-30: IF DAY%<=0 GOTO 11540
11400 DAY%=DAY%-31: IF DAY%<=0 GOTO 11550
11410 STOP
11430 MONTH=1 : MO$="JAN": DAYS%=DAY%+31: RETURN
11440 MONTH=2 : MO$="FEB": DAYS%=DAY%+29: RETURN
11450 MONTH=2 : MO$="FEB": DAYS%=DAY%+28: RETURN
11460 MONTH=3  : MO$="MAR": DAYS%=DAY%+31: RETURN
11470 MONTH=4  : MO$="APR": DAYS%=DAY%+30: RETURN
11480 MONTH=5  : MO$="MAY": DAYS%=DAY%+31: RETURN
11490 MONTH=6  : MO$="JUN": DAYS%=DAY%+30: RETURN
11500 MONTH=7  : MO$="JLY": DAYS%=DAY%+31: RETURN
11510 MONTH=8  : MO$="AUG": DAYS%=DAY%+31: RETURN
11520 MONTH=9  : MO$="SEP": DAYS%=DAY%+30: RETURN
11530 MONTH=10  : MO$="OCT": DAYS%=DAY%+31: RETURN
11540 MONTH=11  : MO$="NOV": DAYS%=DAY%+30: RETURN
11550 MONTH=12  : MO$="DEC": DAYS%=DAY%+31: RETURN
11560 DAY%=DAY%-29: IF DAY%<=0 THEN 11440 ELSE 11310
