                   /* * * * * * * * * * * * * * * * * * * *
                    * ANSI-COM.C (c) 1994, Jim Groeneveld *
                    * * * * * * * * * * * * * * * * * * * *
                                Program ANSI-COM
                                  Version 1.0
                               Date 30 April 1994

------------------------------------------------------------------------------
 Y. (Jim) Groeneveld, Schoolweg 14, 8071 BC Nunspeet, Nederland, 03412 60413.
Email (work): groeneveld@tno.nl, groeneveld@cmi.tno.nl, groeneveld@nipg.tno.nl
------------------------------------------------------------------------------
 *
 * Demonstration of incompatibility of ANSI.COM vs. 1.3 with other ANSI.SYS's.
 *
 * It has appeared that with ANSI.COM vs. 1.3 ((C) 1988 Ziff Communications Co.
 * PC Magazine by Michael J. Mefford) output to CON is intercepted and handled
 * correctly (as by other standard ANSI.SYS's) but that other ANSI.SYS send
 * feedback (CPR escape sequence) via CON and intercept keys, that have been
 * redefined, via CON, while ANSI.COM causes the CPR to go to stdin and only
 * sees keys as being redefined if they are being read via stdin. This program
 * demonstrates this last type of incompatibility quite simply: it redefines
 * a key (the slash, assuming the user did not redefine it already) by sending
 * a redefinition sequence (KKR, Keyboard Key Reassignment) to CON and then
 * reads input from stdin and subsequently via CON. In both cases the user is
 * invited to enter something, at least a slash, to see the effect of the
 * redefinition. The redefinition is visible in the first case, not in the
 * second one, where the original key is read. (With standard ANSI.SYS in
 * both cases the redefined key should be visible, because reading CON is the
 * same as reading not-redirected stdin.) Finally the redefined slash gets
 * defined to itself again (leaving a 3 byte definition in the keyboard buffer
 * reassignment memory space).

Disclaimer
----------
The author is not liable for any negative consequences of the use or misuse
of this program.

 */

#include <stdio.h>
#include <string.h>

main()
{ char String[128]; FILE *fp;
/* Redefine a slash as a backslash using an ANSI escape sequence */
  fprintf(stderr,"%s\n\n%s\n%s\n%s\n%s\n%s\n%s\n\n",
    "ANSI-COM, version 1.0, by Jim Groeneveld, 30 April 1994.",
    "This program demonstrates the incompatibility of ANSICOM vs. 1.3 with",
    "other (standard) ANSI.SYS programs. It assumes ANSI.COM (or another",
    "ANSI.SYS) loaded and the slash not being redefined. It will redefine",
    "the slash key into a backslash which will be visible during input from",
    "CON (including not-redirected stdin) with standard ANSI.SYS and only",
    "during input from not-redirected stdin (not from CON) with ANSI.COM 1.3");

  fprintf(stderr,"%s\n%s\n%s\n",
    "\x1B[47;92pSlash (/) now redefined as backslash (\\)",
    "Enter line with a.o. redefined slash and see backslashes:",
    "(this line will be read via stdin and shown via stderr)");
  fgets(String,128,stdin);
  fprintf(stderr,"%s\n%s","Input was:",String);
  fprintf(stderr,"Line length, incl. newline was: %d\n\n",strlen(String));

  fprintf(stderr,"%s\n%s\n",
    "Enter line with a.o. redefined slash and see slashes:",
    "(this line will be read via CON and shown via stderr)");
  fp=fopen("CON","r");
  fgets(String,128,fp);
  fclose(fp);
  fprintf(stderr,"%s\n%s","Input was:",String);
  fprintf(stderr,"Line length, incl. newline was: %d\n\n",strlen(String));

/* Redefine a slash as itself again; this takes up 3 extra bytes in the
 * keyboard reassignment buffer permanently, until reboot or the command
 * "ANSI /C" from the DOS prompt (see ANSI.COM vs. 1.3 documentation).
 */
  fprintf(stderr,"\x1B[47;47pSlash (/) now redefined as itself again\n");
}
