                   /* * * * * * * * * * * * * * * * * * * *
                    * ANSICHK.C  (c) 1994, Jim Groeneveld *
                    * * * * * * * * * * * * * * * * * * * *
                                Program ANSICHK
                                  Version 1.0
                               Date 30 April 1994

------------------------------------------------------------------------------
 Y. (Jim) Groeneveld, Schoolweg 14, 8071 BC Nunspeet, Nederland, 03412 60413.
Email (work): groeneveld@tno.nl, groeneveld@cmi.tno.nl, groeneveld@nipg.tno.nl
------------------------------------------------------------------------------

 * ANSICHK detects the presence of ANSI.SYS by using the function ChkAnsiKKR.
 *
 * Usage (from the DOS prompt): ANSICHK [>nul]
 * Example: see ANSIPRMT.BAT
 *
 * Exit codes:   0 = ANSI.SYS not detected
 *               1 = ANSI.SYS detected
 *             ( 2 = unknown, unable to open SCREEN for write )
 *             ( 3 = unknown, unable to open KEYBOARD for read )
 *             ( 4 = unknown, unable to read KEYBOARD )
 *               5 = unknown, unable to detect ANSI.SYS (out of test keys)
 * Check these with ERRORLEVEL from DOS.
 *
 * Side effects: (partial) clearing of screen and filling of keyboard
 * reassignment buffer space by 3 bytes (necessary, see comments in sources)

Disclaimer
----------
The author is not liable for any negative consequences of the use or misuse
of this program.

-----------------------------------------------------------------------
*/

/*-----------------------------------DEFINE-----------------------------------*/

/*----------------------------------INCLUDE-----------------------------------*/
#include <stdio.h>
#include "ansi-chk.h"

/*------------------------------------MAIN------------------------------------*/
main ()
{ int AnsiSys;

/* Program header */
  if ((AnsiSys=ChkAnsiKKR())==1) printf ("\x1B[1;33;44m");
  printf (" ANSICHK, version 1.0, by Jim Groeneveld, 30 April 1994. ");

/* ANSI.SYS report */
  if (AnsiSys==1)
  { printf ("\x1B[1;37;42m ANSI.SYS detected. \x1B[0m\n");
    exit (1);                           /* signal ANSI.SYS loaded */
  } else if (AnsiSys==5)
  { printf ("\n  Unable to detect ANSI.SYS, out of scratch test keys.\n");
    exit (5);                           /* signal ANSI.SYS unknown */
  } else
  { printf ("ANSI.SYS not detected.\n");
    exit (0);                           /* signal ANSI.SYS not loaded */
  }

}

/*---------------------------- That's all folks! -----------------------------

   ---------------------------------History-----------------------------------
Vs. 1.0    Initial working release
30/04-94

   ----------------------------------Future-----------------------------------

   ---------------------------------Remarks-----------------------------------
*/
