#include <ctype.h>

int asctoi (int *rtn, char *s, unsigned radix)
//converts a string (in base "radix") to integer
//radix must be between 2 and 36, inclusive.
 {
	unsigned register a0; //converted value
	unsigned register a1,a2; //auxiliar variables
	a0=0;
	if (radix<2 || radix >36)
	 {
		*rtn=a0;
		return -3; //radix value is incorrect
	 }
	while (*s)
	 {
		a1=toupper (*s);
		if(a1>='0' && a1<='9')
			a1-='0';
		else if(a1>='A' && a1<='Z')
			a1-='7';
		else
		 {
			*rtn=a0;
			return -1; //unexpected character
		 }
		if (a1>=radix)
		 {
			*rtn=a0;
			return -2; //digit is out of range
		 }
		a2=a0;
		a0*=radix;
		a0+=a1;
		if ((a0/radix)!=a2)
		 {
			*rtn=a0;
			return -4; //overflow
		 }
		s++;
	 }
	*rtn=a0;
	return 0;
 }
// rtn is the converted value (until the point the error occured).
// hextoi returns 0 if sucessful. On error returns:
// -1 -> unexpected character in "s"
// -2 -> digit is out of range given by radix
// -3 -> radix value is incorrect
// -4 -> overflow
