//Simple program that changes a palette color.
//by Marcio A. A. Fialho

// To be able to recompile it, read COMPILE.TXT

#include <crt.h>
#include <stdio.h>
#include <string.h>

#include "asctoi.c"

void main (int n_ent, char *ent[5])
 {
	int an[4]; //palette register number, color intensities (red, green, blue)
	int a4; //conversion checkup
	int a5; //conversion radix
	int a6; //auxiliar variable
	int c0; //counter

	if (n_ent==1)
	 {
		fputs("\
SETPAL ver 1.1 - Replaces a palette color\n\n\
\tUsage: SETPAL <reg num> <red> <green> <blue>\n\n\
\t<reg num> => palette register number (or color number) (0-15) or (0-F)h\n\
\t<red> => color intensity in red (0 - 63) or (0 - 3F)h\n\
\t<green> => color intensity in green (0 - 63) or (0 - 3F)h\n\
\t<blue> => color intensity in blue (0 - 63) or (0 - 3F)h\n\
\n\n\
by Mrcio Afonso Arimura Fialho.\n\
Freeware / Public Domain",stdout);
		return;
	 }
	else if (n_ent<5)
	 {
		fputs ("ERROR: Missing Arguments.",stdout);
		goto jmp_error;
	 }

	a4=0;

	for (c0=1;c0<5;c0++)
	 {
		a5=10; //default radix
		a6=strlen(ent[c0])-1;
		if (toupper( *(ent[c0]+a6))=='H')
		 {
			a5=16;
			*(ent[c0]+a6)=0;
		 }
		a4|=asctoi(&an[c0-1],ent[c0],a5); //reads palette register number, RGB intensities
	 }

	if (a4)
	 {
		fputs("ERROR: Incorrect input parameters.",stdout);
		goto jmp_error;
	 }

	a4=0;
	if ((unsigned)an[0]>15U)
		a4++;

	for (c0=1;c0<4;c0++)
		if ((unsigned)an[c0]>63U)
			a4++;

	if (a4)
	 {
		fputs("ERROR: At least one input parameter is out of range.",stdout);
	  jmp_error:
		fputs("\nType SETPAL with no parameters to get help.",stdout);
		return;
	 }

	setdacreg(getpalreg(an[0]),an[1],an[2],an[3]); //changes palette register color
 }