;After running ACAD (INT10MDA and QC2 still loaded, on Mono)
; VGA mode gets set, but no text shows and
; Alt-LShft puts top line of PMS on bottom line of Mono
; Alt-RShft copies top line all the way down screen.  PMS is still running OK.

;POST-7ZX 10/00
;TSR posts current screen on alternate display, for two-monitor systems with
; both a mono card and a SVGA capable of Mode 62h.
; (tested with Trident 9880 'Blade 3D' = Jaton Video-107 AGP)
;ALT-RightShift and ALT-LeftShift are the hot keys.
;Source screen must be in an 80 X 25 mode (Mono, or VGA mode 3 - CGA emulation).
;It works in a Win 95 DOS window from SVGA to Mono.
;Some Borland stuff (like Turbo Pascal) grabs the keyboard INT from this pgm.

;To put the Trident card in Mono mode (from the 8900 docs):
;3DD=0
;3C5.0E=0 (New Mode Control Reg 1) - disables EGA protect
;3C5.0D=0 (Old Mode Ctl Reg 2) - set VGA mode
;  (write 3C5.0B with anything to select 3C5.0D)
;Int 10h func 0 to set Mode 7 (Mono)
; (may need Int 10h func12h to set 350 scan lines first)
;3B5.11=0Eh (disable CRTC protect)
;3C2=66h (set 28.3 MHz clock)
;3D9=0
;3BF=3
;Set MDA Mode, use Int 42h (same as Int 10h)
;3C5.0D=2Ch (write 3C5.0B with anything to select 3C5.0D)

;Note:	Writing to index 0Bh selects old mode registers.
;	Reading from index 0Bh toggles between old and new mode registers.
;	Do the write with two 8-bit writes, not one 16-bit write.

;Int 10h AH=1Ch is Save/Restore Video State
;Int 33h (mouse) AH=0, AL=28h is Set Video Mode


cseg	segment
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

cr	equ	0Dh
lf	equ	0Ah

	org	100h

start:	jmp	SWAPV			;reset INT 9 vector and go resident

	db	' Post-7ZX.COM 11/00',cr,lf
	db	'ALT-Shift Copies present screen to alternate monitor.',cr,lf
	db	'ALT-Right Shift copies Mono to upper half, ALT-LeftShift '
	db	'to lower half',cr,lf
	db	'of SVGA screen'
	db	cr,lf,'Source display must be 80 X 25 Text mode',cr,lf,cr,lf
	db	'Works in most text programs in Win 9x (not graphics modes)'
	db	cr,lf,'By J. E. Arkay',cr,lf,1Ah

OldKbdInt	dw	0,0		;address of existing INT 9
LowerFlag	db	0
ColBuf		db	0

;the new keyboard interrupt
POST:	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	pushf				;must PUSHF before FAR CALL to an INT,
					; because its IRET will POPF, too.
	call	dword ptr CS:OldKbdInt	;call pre-existing keyboard INT
;note: jumping to old int at Done crashes after 1st use
	xor	ax,ax
	mov	ds,ax			;now DS=0
	mov	al,ds:[417h]		;get kbd flag. Alt=bit 3, RShift=bit 0
	and	al,0Bh			;isolate ALT & RShift & LShift
	mov	cs:LowerFlag,0
	cmp	al,9			;ALT-RShift ?
	jz	DoIt
	mov	cs:LowerFlag,1
	cmp	al,0Ah			;ALT-LShift ?
	jnz	Done$			;if not, finished
;Alt + a Shift are depressed, so continue
; check video mode - quit if not monochrome, color 80*25 or bw 80*25
; Remember, DS now = 0.
DoIt:	mov	ax,ds:[450h]		;save cursor position, used when on Mono
	mov	WORD PTR cs:At450,ax
	mov	al,byte ptr ds:[410h]	;get equipment byte
	and	al,00110000b		;filter out video mode bits
	cmp	al,30h			;Mono ?
	jnz	TryOthers
	mov	al,7			;report Mono
	jmp	short ScrnOK
	
TryOthers:
	mov	ah,0Fh			;get video mode
	int	10h
	and	al,01111111b		;mask out 'Clear Screen' bit
	cmp	al,3			;is it color text?
	jnbe	Done$			;no, graphics mode: quit
	cmp	al,1			;is screen 40 char?
	jnbe	ScrnOK
Done$:	jmp	Done			;yes, quit

ScrnOK:	mov	bx,ds:[410h]		;current equipment flag. Video=bit 4 & 5
	mov	cs:At410,bx		;save both hdw bytes
	mov	bl,al			;save mode
;set DS and ES to move screen data
	mov	ax,0b800h
	mov	ds,ax			;DS = Color segment
	mov	ax,0b000h
	mov	es,ax			;ES = Mono segment
	cmp	bl,7	 		;copying from mono?
	jz	MonoTo
	jmp	ColorTo 		;no, move data from color to mono

MonoTo:
;Copying from Mono to SVGA
;INT 10h mode function kills the mouse on the Mono screen !
; Using PMS' C-A-I or A-U-S restores it...
; Disabling mouse driver so Int 10h won't screw it up DIDN'T WORK

; Set the SVGA to mode 62h
	xor	ah,ah			;set mode, kills mouse on Mono
	mov	al,62h
	or	al,80h			;set bit 7 => don't CLS
	xor	bh,bh			;page, for possible bug in Int 10h
	int	10h
;can't use AH=13h write string, it treats BEL and TAB as commands
	mov	dx,02Ch			;start at line 0, col 45d
	cmp	cs:LowerFlag,1
	jnz	CopyToSVGA
	mov	dx,1703h		;start at line 23, col 3
CopyToSVGA:
	mov	cs:ColBuf,dl
	mov	ax,0B000h
	mov	ds,ax			;now DS=mono segment
	xor	si,si
	mov	cx,25			;do 25d lines (will overwrite 2 lines)
	xor	bh,bh			;page 0
LineLoop:
	push	cx
	mov	cx,80			;chars to write
CharLoop:
	lodsw				;get char & attrib
	mov	bl,ah			;attrib
;Change Inverse attrib so shows clearly (only foregnd used in graphic modes)
	cmp	bl,7			;plain white ?
	jz	AttribSet
	or	bl,0Ch			;make bright, picked just for looks
AttribSet:
	mov	ah,2			;set crsr position per DX
	int	10h
	mov	ah,9			;write char in AL & attrib in BL
	push	cx
	mov	cx,1			;chars to write
	int	10h
	pop	cx
	inc	dl			;column
	loop	CharLoop

	inc	dh			;next row
	mov	dl,cs:ColBuf		;reset start column
	pop	cx
	loop	LineLoop

;reset lo RAM stuff to show Mono (using INT 10h clears the @#^*%!! screen)
	push	cs
	pop	ds
	xor	ax,ax
	mov	es,ax
	mov	cx,At410
	mov	es:[410h],cx
	mov	cx,30			;DECIMAL
	mov	si,offset At449
	mov	di,449h
	rep	movsb
	mov	di,484h
	mov	cx,7
	rep	movsb
	jmp	Done

At410	DW	0			  ;2 hardware bytes
At449	DB	7,50h,0,0,10h,0,0
At450	DB	16 dup(0)		  ;16 DECIMAL
	DB	0Ah,0Fh,0,0B4h,3,29h,30h  ;last is 466h
At484	DB	18h,0Eh,0,68h,9,10h,0Ch

ColorTo:xor	di,di			;start at zero
	xor	si,si
	mov	cx,2000 		;2000d chars + attributes per screen
	cld				;make sure move is forward
	rep	movsw			;DS:[SI] to ES:[DI], 2000h words
Done:	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	iret				;return to system

;-----------------------------------------------------------------
;set new keyboard int 9 vector

SWAPV:	push	ds			;for DOS return?
	xor	ax,ax
	mov	ds,ax
	cli				;disable interrupts
	mov	ax,ds:[(9*4)]		;original kbd INT vector
	mov	cs:OldKbdInt,ax	;store it
	mov	ax,ds:[(9*4+2)]
	mov	cs:[(OldKbdInt+2)],ax	;store CS of original kbd INT vector
	mov	word ptr ds:[(9*4)],offset POST  ;our routine's start offset
	mov	ds:[(9*4+2)],cs		;and seg
	sti				;enable interrupts
	mov	dx,offset InsMsg
	push	cs
	pop	ds
	mov	ah,9
	int	21h			;show message
	mov	dx,offset SWAPV 	;start of non-resident part of program
	int	27h			;terminate & stay resident

InsMsg	DB	cr,lf,'Post-7ZX 11/00',cr,lf,cr,lf,'$'

cseg	ends
	end	start
