/***************************************************************************/
/* ab.c  -- Program definitions specific to program version and sound      */
/* card being used.                                                        */
/* Copyright (c) 1996 John A. Ball                                         */
/*                                                                         */
/* This source is available for your own personal use only! You may make   */
/* any changes you wish but please do not distribute modified source code. */
/* Please notify me of any errors or improvements.                         */
/*                                                                         */
/* AB Sound File Utility                                                   */
/*                                                                         */
/* by John A. Ball   December 6, 1996                                      */
/***************************************************************************/

#define PROGRAM                 "AB"
#define PURPOSE                 " Sound File Player Utility"
#define VERSION                 "AB ver 1.11  by John A. Ball  December 6, 1996"
#define CARD                    "Sound Blaster"
#define COPYRIGHT               "This program may be freely copied and distributed!"
#define OWNER                   "This copy of AB is registered to UNREGISTERED"
#define SERIAL                  "Serial # 111-000000"
#define MINVOLUME 0
#define MIDVOLUME 50
#define MAXVOLUME 100

/***************************************************************************/
/* ab.c  -- Routines Sound Blaster Card                                    */
/* Copyright (c) 1996 John A. Ball                                         */
/*                                                                         */
/* This source is available for your own personal use only! You may make   */
/* any changes you wish but please do not distribute modified source code. */
/* Please notify me of any errors or improvements.                         */
/*                                                                         */
/* by John A. Ball   May 5, 1996                                           */
/***************************************************************************/

#pragma pack(1)
/***************************************************************************/
/* #define DEBUG */
/***************************************************************************/
#include "nplay.c"

#include <stdio.h>
#include <dos.h>
#include <errno.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <malloc.h>
#include <string.h>

#define SB_ADDRESS      0x210           /* starting i/o address for SB */
#define TRUE 1
#define NOCOMPRESS 100

struct SNDSTRUC snd;
extern int debug;
extern int verbose;
extern int volume;
extern int compression;
extern int magnitude;
extern int default_bits;
extern int stop;
extern int repeat;
extern int error;
extern int multi_error;
extern int conversion_table;
extern unsigned int play_rate;
extern unsigned int pitch;
extern char _far **fbuffer;
extern unsigned int dma_size;
extern struct CARD_INFO card_info;
extern int sb_info;
int sb_address=0;

int sb_card(void);
int find_sb(void);
int get_sb_info(void);
int reset_sb(int address);
int opensnd(void);
int closesnd(void);
int dacplay(char _far *fbuffer,int k,int frequency,int mode,int volume);
int find_digpak(void);
int get_card_type(void);
int play_block(struct SOUND *hp, int source_handle);
char _far * normalize(char _far *p, unsigned int dma_size);

int  sb_card(void)
{
	int error=0;
	int blaster=0;

	error=get_sb_info();
	blaster=card_info.io_addr;
	if(error > 0){
	  printf("Error in Sound Blaster Environment %i\n",error);
	  switch(error)
	   {
	  case 10:
	     printf("A (Address ie A220) Parameter not found!\n");
	     break;
	  case 20:
	     printf("I (Irq ie I5) Parameter not found!\n");
	     break;
	  case 30:
	     printf("D (DMA ie D1) Parameter not found!\n");
	     break;
	  case 40:
	     printf("T (Type ie T3) Parameter not found!\n");
	     break;
	   }
	   blaster=find_sb();
	  }
	else{
	  if((error < 0) && debug)
	    printf("No BLASTER parameters found in environment\n");
	  if(error < 0){
	    blaster=find_sb();
	  }

	  if(!error){
	   error=reset_sb(blaster);
	   if(error){
	    blaster=find_sb();
	    printf("Environment BLASTER=A (Address) parameter is not correct.\n");
	   }
	  }
	  if(blaster){
	   card_info.io_addr=blaster;
	  }
	}

	if(blaster){
	  if(reset_sb(blaster))
	    printf("Sound Blaster not responding to reset!\n");
	  card_info.io_addr=blaster;
	  sb_address=blaster;
	}
	return(blaster);
}

/* Make sure Sound Blaster Available */

int find_sb(void)
{
	int blaster=0;

	_asm{
	     push bx
	     mov bx,0
	h0:
	     mov al,1
	     mov dx,SB_ADDRESS
	     add dx,6
	     add dx,bx
	     out dx,al
	     in al,dx
	     in al,dx
	     in al,dx
	     in al,dx
	     mov al,0
	     out dx,al
	     add dx,4
	     mov cx,0ffffh
	h1:
	     in al,dx
	     cmp al,0aah
	     je h2
	     loop h1
	     add bx,010h
	     cmp bx,050h
	     jle h0
	     mov ax,0
	     mov blaster,ax
	     jmp h3
	h2:
	     mov ax,SB_ADDRESS
	     add ax,bx
	     mov blaster,ax
	h3:  pop bx
	}
	if(debug && blaster)printf("Found Sound Blaster Board @ %x\n",blaster);
	return(blaster);
}

int get_sb_info(void)
{
   char *pe;
   char v[80];
   char *pv;
   char b[80];
   int i=0;
   int error=0;

   pe=getenv("BLASTER");
   if(pe!=NULL){
     strcpy( v, pe );

     pv=strpbrk(v,"A");
     if(pv!=NULL){
       if(debug)printf("Environment parameter BLASTER=%s\n",pv);
       pv++;
       i=0;
      while(( *pv != '\x20' || '\x0' ) && i<80)
      {
	b[i]=*pv++;
	i++;
      }
      b[i]='\x0';
      i=atoi(b);
      i=(i-200)/10;
      card_info.io_addr=0x200 + i*16;
     }
    else error=10;

     pv=strpbrk(v,"I");
     if(pv!=NULL){
       pv++;
       i=0;
       while((*pv != ' ' || '\0') && i<80)
       {
	b[i]=*pv++;
	i++;
       }
       b[i]='\0';
       card_info.irq=atoi(b);
     }
     else error=20;

     pv=strpbrk(v,"D");
     if(pv!=NULL){
       pv++;
       i=0;
       while((*pv != ' ' || '\0') && i<80)
       {
	b[i]=*pv++;
	i++;
       }
       b[i]='\0';
       card_info.dma=atoi(b);
     }
     else error=30;

     pv=strpbrk(v,"H");
     if(pv!=NULL){
       pv++;
       i=0;
       while((*pv != ' ' || '\0') && i<80)
       {
	b[i]=*pv++;
	i++;
       }
       b[i]='\0';
       card_info.dma16=atoi(b);
     }

     pv=strpbrk(v,"T");
     if(pv!=NULL){
       pv++;
       i=0;
       while((*pv != ' ' || '\0') && i<80)
       {
	b[i]=*pv++;
	i++;
       }
       b[i]='\0';
       card_info.card_ver=atoi(b);
     }
     else error=40;

   return(error);
   }
   else return(-1);
}

int opensnd(void)
{
	int error=0;

	 if(card_info.type & BLASTER){
	   card_info.dma_buffer=_fmalloc((size_t) 64000);
	   error=snddev(OPENSND,&card_info);
	   if(card_info.version > 0x300)card_info.type=BLASTERPRO;
	   if(card_info.version > 0x400)card_info.type=BLASTER16;
	 }
	return(error);
}

int closesnd(void)
{
	int error=0;
	char *dmabuf;
	struct SND_STATUS snddev_status;

	 if(card_info.type & BLASTER){
	   do{
	     error=snddev(GET_STATUS,&snddev_status);
	    error=io_wait();
	   }
	   while(snddev_status.dma_flag!=0);
	  error=snddev(CLOSESND,&card_info);
	  dmabuf=card_info.dma_buffer;
	  free(dmabuf);
	 }
	return(error);
}

int reset_sb(int address)
{
	_asm{
	     mov bx,0
	h0:
	     mov al,1
	     mov dx,address
	     add dx,6
	     out dx,al
	     in al,dx
	     in al,dx
	     in al,dx
	     in al,dx
	     mov al,0
	     out dx,al
	     add dx,4
	     mov cx,0ffffh
	h1:
	     in al,dx
	     cmp al,0aah
	     je h6
	     loop h1
	     mov ax,1                   ;error
	     jmp h3
	h6:
	     add dx,4
	     mov cx,0ffffh
	h4:
	     in al,dx
	     OR AL,AL
	     JNS H2
	     LOOP H4
	     mov ax,1                   ;error
	     jmp h3
	h5:
	     add bx,010h
	     cmp bx,050h
	     jle h0
	     mov ax,1                   ;error
	     jmp h3
	h2:
	     mov ax,0                   ;ok
	h3:
	}
}
void show_card_info(void)
{
	int type=0;

	type=card_info.version/0x100;
	switch(type)
	{
	case 0:
	   break;
	case 1:
	case 2:
	   type=2;
	   if(card_info.version > 0x200)type=3;
	   break;
	case 3:
	   type=4;
	   break;
	case 4:
	   type=6;
	   break;
	default:
	   type=0;
	   break;
	}
	if(debug && ((card_info.type & 0xfff0)==BLASTER))printf("Sound Blaster DSP version %X I/O %x IRQ %i DMA %i"
	,card_info.version,card_info.io_addr,card_info.irq,card_info.dma);
	if(debug && (card_info.type==BLASTER16))printf(" DMA16 %i",card_info.dma16);
	if(debug && ((card_info.type & 0xfff0)==BLASTER))printf(" Type %i\n",card_info.card_ver);
	if(debug && card_info.type & PCSPEAKER)printf("No sound card found using pc speaker!\n");
}

void delay(char tc, int period)
{
      if(card_info.type & BLASTER)sbdelay(tc,period);
}

int dacplay(char _far *fbuffer,int k,int frequency,int mode,int volume)
{
  static int position=0;
	 int error=0;
	 int flag=0;
	 int bits=0;
	 char _far *p1;
	 char _far *p2;
	 struct SOUND sound_info;
	 struct SND_STATUS snddev_status;

	 sound_info.sample_len=k;
	 sound_info.frequency=frequency;
	 sound_info.volume=volume;
	 sound_info.compression=mode;

	 position=(position & 0x0001);
	 p1=normalize(card_info.dma_buffer,card_info.dma_size);
	 p1=p1 + card_info.dma_size*position/2;
	 p2=p1+k;
	 sound_info.buffer=p1;
	 _fmemcpy(p1,fbuffer,k);
	 position++;

	 if(mode & 0x0003)bits=8;
	 if(mode & 0x000c)bits=16;
	 if(mode & BIT_MINUS)bits=-bits;

	 if(card_info.type & BLASTER){

	 error=snddev(SET_VOLUME,&sound_info);
/*         if(debug)printf("mode=%x\n",mode); */

	 sound_info.bits=bits;

	 mode=(mode & 0x7ffe);

	 switch(mode)
	 {
	 case 0:
	 case BIT8_M:
	 case BIT8_S:
	 case ADPCM4:
	 case ADPCM26:
	 case ADPCM2:
	 case BIT16_M:
	 case BIT16_S:
	   do{
	     error=io_wait();
	     if(!error)error=snddev(GET_STATUS,&snddev_status);
	   }
	   while(snddev_status.dma_flag!=0 && !error);
	   if(!error)error=snddev(PLAYSND,&sound_info);
	   break;
	 default:
	   if(verbose)printf("Type of Compression not supported!\n");
	   multi_error=TRUE;
	   error=NOCOMPRESS;
	   break;
	 }
	 }
	 return(error);
}

void show_dac_error(int error)
{

	  if(card_info.type & BLASTER)printf("Problem with Sound Blaster ");
	  switch(error)
	  {
	    case 1:
	      printf("Error 1 DMA already in use!\n");
	      break;
	    case 2:
	      printf("Error 2 IRQ not responding!\n");
	      break;
	    case 3:
	      printf("Error 3 DSP not responding!\n");
	      break;
	    case 4:
	      printf("Error 4 Could not read DSP version!\n");
	      break;
	    case 5:
	      printf("Error 5 DMA channel not working (must be 0, 1, or 3)!\n");
	      break;
	    case 6:
	      printf("Error 6 I (IRQ) parameter in environment is not correct!\n");
	      break;
	    case 7:
	      printf("Error 7 IRQ not valid (must be 2, 3, 5, 7, or 10)!\n");
	      break;
	    case 8:
	      printf("Error 8 number of samples is zero!\n");
	      break;
	    case NOCOMPRESS:
	      break;
	    default:
	      printf("Unknown error! %i\n",error);
	      break;
	  }
}

/* Check for a Sound Card */

int get_card_type(void)
{
	int type=PCSPEAKER;
	if(sb_card())type=BLASTER;
	return(type);
}

char _far * normalize(char _far *p,unsigned int dma_size)
{
char _far   *np;
int          page=0;
unsigned int poffset=0;
unsigned int laddr=0;
long         lin_addr=0;

	np=p;
	_asm{
	   push bx
	   push cx
	   mov ax,np
	   mov laddr,ax
	   mov dx,np+2
	   mov bx,dx
	   and bx,0f000h        ;get page
	   mov page,bx
	   mov bx,dx
	   and bx,0fffh         ;get offset
	   shl bx,1
	   shl bx,1
	   shl bx,1
	   shl bx,1
	   mov poffset,bx
	   pop cx
	   pop bx
	}
	lin_addr=(long)poffset+(long)laddr+(long)(dma_size);
	if(lin_addr > 65536){
	  page+=0x1000;
	  _asm{
	     mov dx,page
	     mov ax,0
	     mov np+2,dx
	     mov np,ax
	  }
	}
	return(np);
}
