/* sound.h - header for sound functions                                  */
/* John A. Ball   May 19, 1996                                           */

/* Sound Structure used by Sound Player Utility                          */

struct SOUND{
    char _far     *buffer;              /* Pointer to sound data         */
    unsigned int  sample_len;           /* Number of bytes to play       */
    unsigned long length;               /* Number of bytes               */
    unsigned long number_samples;       /* Number of PCM Samples         */
    unsigned long frequency;            /* Frequency of playback         */
    unsigned int  volume;               /* Volume to play sample         */
    int           bits;                 /* Bits per Channel & sign       */
    unsigned int  channels;             /* Number of Channels            */
    unsigned int  compression;          /* Type of Hardware Compression  */
    int           byte_format;          /* Intel/Motorola byte format    */
    int (_far *fpcallback)();           /* Pointer to call back function */
    int           file_handle;          /* Source file handle            */
    unsigned long file_type;            /* File type (wav, snd, etc.)    */
};

struct CARD_INFO{
    unsigned int drv_ver;               /* Driver version number */
    unsigned int type;                  /* Type of Sound Card */
    unsigned int version;               /* Version id of sound card */
    unsigned int io_addr;               /* I/O Address of sound card */
    unsigned int irq;                   /* IRQ used by sound card  */
    unsigned int dma;                   /* DMA channel used by sound card */
    unsigned int mode;                  /* Type of data format */
    unsigned int irq16;                 /* IRQ for 16 bit mode */
    unsigned int dma16;                 /* DMA channel used for 16 bit data */
    char _far    *dma_buffer;           /* Pointer to DMA buffer */
    unsigned int dma_size;              /* Size of DMA buffer */
};

struct SND_STATUS{
    int  _far    *pdma_flag;            /* Pointer to DMA in use Flag */
    int          dma_flag;              /* DMA in use FLAG */
    unsigned int dma_count;             /* Remaining count for dma */
    char _far    *buffer;               /* Pointer to next buffer */
    int _far     *perror;               /* Pointer to Error flag */
    int          error;                 /* Soundcard/Driver error flag */
};

struct SOUNDOBJ{
    unsigned int mem_type;              /* Conventional, EMS, XMS */
    unsigned int num_blocks;            /* Number of sound blocks */
    int          mem_handle;            /* EMS/XMS Handle  */
    char _far    *mem_array;            /* Pointer to array of pointers or */
};                                      /* EMS buffer page pointer */

struct SND_API_ERROR{
    int          api_error;             /* Error number */
    char _far    *api_err_msg;          /* Pointer to error message */
};

/* Define Types of Sound Boards/Systems */

#define PCSPEAKER        0
#define TANDYSND      0x10
#define BLASTER       0x20
#define BLASTER2      0x21
#define BLASTERPRO    0x22
#define BLASTER16     0x28
#define WSS           0x30
#define DIGPAK        0x40
#define CODEC         0x50

/* Define Commands for Sound Driver */

#define OPENSND        0x01     /* Open sound driver/device */
#define PLAYSND        0x02     /* Play block of PCM sound data */
#define CLOSESND       0x03     /* Close sound driver/device */
#define STOPSND        0x04     /* Stop sound playing */
#define PAUSESND       0x05     /* Pause sound playing */
#define RESUMESND      0x06     /* Resume sound playing */
#define GET_STATUS     0x07     /* Get status of driver/device */
#define GET_RES_INFO   0x08     /* Get resources used by driver/device */
#define PLAYCSND       0x09     /* Play using continuous DMA mode */
#define SET_VOLUME     0x0A     /* Set the playback volume */

/* Define data format & data compression types */

#define BIT_PLUS        0x00
#define BIT_MINUS       0x8000
#define BIT8_M  0x01            /* 8 Bit Mono PCM data */
#define BIT8_S  0x02            /* 8 Bit Stereo */
#define BIT16_M 0x04            /* 16 Bit Mono */
#define BIT16_S 0x08            /* 16 Bit Stereo */
#define ULAW    0x10            /* Ulaw Compression */
#define ALAW    0x20            /* Alaw Compression */
#define MSADPCM 0x40            /* Microsoft ADPCM Compression */
#define ADPCM   0x80            /* ADPCM Compression 4-bit */
#define TCOMP   0x100           /* Tandy Compression */
#define ADPCM4  0x200           /* ADPCM 4-bit Compression */
#define ADPCM26 0x400           /* ADPCM 2.6 bit Compression */
#define ADPCM2  0x800           /* ADPCM 2 bit Compression */
#define MACCOMP 0x1000          /* MAC compression */
#define UNKNOWN 0x4000          /* Unknown type compression */
#define INTEL   0x0000          /* Intel byte format for 16 bit sound */
#define MM      0xffff          /* Motorolo byte format for 16 bit sound */

/* Sound structure for use by DIGPAK drivers */

struct SNDSTRUC{
    unsigned char _far *sound;          /* Pointer to sound data */
    unsigned short sndlen;              /* Length of audio data */
    short _far *IsPlaying;              /* Pointer to play status flag */
    short  frequency;                   /* Playback frequency */
};

/* Sound File Formats  */

#define TANDY_type 0xffff00ff

/* Old Tandy Sound File Format */

struct OLDTANDY{
        char id;                        /* 1a */
        char compression;               /* 0 = none */
        char number_clips;
        char voice;
        char name[10];                  /* asciiz */
        unsigned int frequency;
};
struct OLDTANDY_R{
        unsigned long type;             /* ff 00 ff ff */
        unsigned long start;
        unsigned long length;
        unsigned long unknown;
        unsigned long number_samples;
        unsigned long unknown1;
        unsigned long unknown2;
};
/* My version of Deskmate's SND Format */

struct TANDY{
    char name[44];                      /* asciiz Instrument or desc */
    unsigned int  id;                   /* 1a 80 for last version */
    unsigned int  number_clips;         /* Sound Count */
    unsigned char voice;                /* Instrument number */
    unsigned char unknown[17];
    unsigned int  compression;          /* Compression Type */
    unsigned char unknown1[20];         /* Compression info */
    unsigned int  frequency;            /* Sampling Rate */
    unsigned char unknown2[24];
};
struct TANDY_R{
    unsigned long link;
    unsigned char unknown1[2];
    unsigned long type;                 /* FF 00 FF FF          */
    unsigned long start;
    unsigned long length;
    unsigned long number_samples;
    unsigned char unknown2[24];
};

/* Creative Labs VOC File Format */

#define TERMINATE       0x00
#define VOICE           0x01
#define CONTINUE        0x02
#define SILENCE         0x03
#define MARKER          0x04
#define ASCII           0x05
#define REPEAT          0x06
#define VOCEND          0x07
#define EXTEND          0x08
#define NEWVOC          0x09

struct LABS{
    char id[19];                        /* "Creative Voice File" */
    char magic;                         /* 1A EOF marker         */
    unsigned int offset;                /* Offset of first Data Block */
    unsigned char minor_version;
    unsigned char major_version;
    unsigned int type;                  /* 2's compliment of Ver # + 1234h */
    };
struct LABSV110{                        /* Type 01 Sound Data    */
    unsigned char number_samples1;
    unsigned char number_samples2;
    unsigned char number_samples3;
    unsigned char frequency;            /* Sample Rate */
    unsigned char compression;          /* Compression Type */
};
struct LABSV120{                        /* Type 09 New Sound Data  */
    unsigned char number_samples1;
    unsigned char number_samples2;
    unsigned char number_samples3;
    unsigned char frequency1;           /* Sample Rate   */
    unsigned char frequency2;
    char unknown[2];
    unsigned char bits_per_sample;
    unsigned char channels;
    unsigned char compression;
    char reserved[5];
};

/* Microsoft WAV File Format */

#define RIFF  0x46464952
#define WAVE  0x45564157
#define FMT   0x20746d66
#define WDATA 0x61746164
#define WLIST 0x5453494c
#define INAM  0x494e414d                /* "INAM" Name of Data */
#define ICOP  0x49434f50                /* "ICOP" Copywrite notice */
#define ISFT  0x49534654                /* "ISFT"  Name of Creating Software*/
#define ICRD  0x49435244                /* "ICRD"  Creation Date */
#define FACT  0x74636166                /* "fact" */

struct RIFFWAVE{
    unsigned long id;                   /* "RIFF" */
    unsigned long chunk_size;
    unsigned long form_type;            /* "WAVE" */
};
struct SUBCHUNK{
   unsigned long id;
   unsigned long subchunk_size;
};

/* Extended WAVE Format */

struct WAVEfmt{
   unsigned int format_tag;
   unsigned int channels;
   unsigned long number_samples_per_second;
   unsigned long bytes_per_second;
   unsigned int block_align;
   unsigned int bits_per_sample;
   unsigned int cbsize;
   char         icoef1;
   char         icoef2;
};

struct RIFFLIST{
   unsigned long id;                    /* "LIST" */
   unsigned long chunk_size;
   unsigned long form_type;             /* "INFO" */
};

struct FACTinfo{
   unsigned long number_samples;
};

/* Apple & Electronic Arts IFF files */

#define FORM 0x4d524f46
#define SVX  0x58565338
#define VHDR 0x52444856
#define BODY 0x59444f42
#define ANNO 0x4f4e4e41
#define AUTH 0x48545541
#define NAME 0x454D414E
#define AIFF 0x46464941
#define COMM 0x4d4d4f43
#define INST 0x54534e49
#define SSND 0x444e5353

struct SOUNDIFF{
    unsigned long id;                   /* "FORM" */
    unsigned long chunk_size;
    unsigned long form_type;            /* "8SVX" */
};

struct IFFvhdr{
   unsigned long number_samples;        /* samples 1-shot part */
   unsigned long repeat_samples;        /* samples repeat part */
   unsigned long samples_per_cycle;     /* samples per second if repeat */
   unsigned int samples_per_second;     /* samples per second */
   unsigned char octaves;               /* number of octaves */
   unsigned char compression;           /* 0=none, 1=Fibonacci-delta */
   unsigned long volume;                /* 65536 means full volume */
};

struct AIFFCOMM{
   unsigned int channels;               /* number of channels */
   unsigned long number_samples;        /* number of samples */
   unsigned int bits_per_sample;        /* sample width */
   double long frequency;               /* frequency in ieee format */
};

/* Amiga Protraker Module Format */

#define M_k_ 0x2E4B2E4D                 /* M.K. */
#define FLT4 0x34544C46                 /* FLT4 */

struct MODhdr{
    char name[20];                     /* ascii */
};

struct MODsample{
    char name[22];                     /* ascii */
    unsigned int number_samples;         /* MM format in Words */
    char finetune;                       /* Fine tune nibble */
    char volume;                         /* Volume 0-64 */
    unsigned int r_start;                /* Repeat point in mm words */
    unsigned int r_length;               /* Repeat length in mm words */
};

struct MODsong{
    char s_length;                       /* Song length 1 to 128 */
    char unknown;                        /* frequently 7f */
    char sequence[128];                  /* Play sequences 0-127 */
};

struct MODraw{
    char *psam;                          /* Pointer to sample */
    long int number_samples;             /* Number of samples */
    unsigned int frequency;              /* Playback frequency */
};

/* Define maximum header size for unknown file types */

#define MAX_HEADER 128

/* MAC Binary Header Format */

struct MACBINARY {

   char zerobyte;                        /* always zero */
   char length;                          /* 0 - 31 */
   char name[63];                        /* name and some filler */
   long type;                            /* MAC file type */
   long creator;                         /* MAC file creator */
   char filler[10];
   long datafork_size;                   /* length of MAC data fork */
   long rsrcfork_size;                   /* length of MAC resource fork */
   long creation_date;                   /* time of file's creation */
   long modif_date;                      /* time of file's modification */
   char filler2[29];
};

#define MACTYPE 0x44535346
#define HCOM    0x4d4f4348

/* SUN au header format */

struct SUN {

   long id;                              /* .snd */
   long chunk_size;                      /* Size of header */
   long data_size;                       /* Number of samples */
   long compression;                     /* type of encoding */
   long frequency;                       /* Sample rate */
   long channels;                        /* Number of sound channels */
};

#define AU_SND  0x646e732e
/* STEVE files header format */

struct STEVE {
   char id[5];                          /* STEVE */
   char version;                        /* 1 or 2 */
   char H;                              /* H */
   long number_samples;                 /* Number of samples */
   char filler[19];                     /* Unknown or unused */
   unsigned int frequency;              /* Playback frequency for type 2 */
};
