#include "bcd.c"
#include "allegro.h"
#include <conio.h>
#include <stdio.h>
#include <jgmod.h>
#include <libamp.h>
#include <time.h>


#include "main.h"


#define CDP_VERSION "2.10"


static char *card(int c) {
  return c == 1 ? "" : "s";
}

static void print_hsg(int hsg) {
  int hours, minutes, seconds;
  seconds = hsg / 75;
  minutes = seconds / 60;
  seconds %= 60;
  hours = minutes / 60;
  minutes %= 60;
  printf("%2d:%02d:%02d", hours, minutes, seconds);
}



void list_cd()
{
      int nd = 0, na = 0, audio_time = 0,t;
      if (!bcd_get_audio_info()) {
        printf("Error getting audio info\n");
      } else if (lowest_track == 0) {
        printf("No audio tracks\n");
      } else {
        for (t = lowest_track; t <= highest_track; t++) {
          printf("Track %2d: ", t);
          print_hsg(tracks[t].start);
          printf(" -> ");
          print_hsg(tracks[t].end);
          printf(" (");
          print_hsg(tracks[t].len);
          if (tracks[t].is_audio) {
            na++;
            printf(") audio");
            audio_time += tracks[t].len;
          } else {
            nd++;
            printf(") data ");
          }
          printf(" (HSG: %06d->%06d)\n", tracks[t].start, tracks[t].end);
        }
        printf("%d audio track%s, %d data track%s\n", na, card(na), nd, card(nd));
        if (audio_time) {
          printf("Audio time: ");
          print_hsg(audio_time);
          printf("\n");
        }
      }

}

volatile int zeit = 0;
void time_process()
      {
      zeit++;

      }

END_OF_FUNCTION(time_process);



int main(int argc, char *argv[])
{

int ii;
char t;
int break_program = 0;
int vol = 255;
//int i;
int process_counter = 0;
char pprocess[] =
{
'-',
'\\',
'|',
'/'
};

printf("\ninstall ...\r");

allegro_init();
install_timer();
install_keyboard();

printf("FreeCDP " CDP_VERSION " Plays AUD,MIDI,WAV,MOD,XM,S3M,JGM,UMX,MP3,MP2 files & CDs\n\r");
printf("Copyright (c) 1999,2000 Florian Xaver\n\r");




init_Sound();

_setcursortype(_NOCURSOR);


//printf("\n\nDigital sound driver: %s", digi_driver->name);
//printf("\nDescription: %s", digi_driver->desc);
//printf("\nVoices: %d", digi_driver->voices);
//printf("\nMidi music driver: %s", midi_driver->name);
//printf("\nDescription: %s", midi_driver->desc);
//printf("\nVoices: %d", midi_driver->voices);

//s = bcd_device_status();
//printf("\nMSCDEX version %d.%d", mscdex_version >> 8,
//            mscdex_version & 0xff);
//printf("\nDevice status word ");

//print_binary(s,16);


//if (argc - 1 != 1) printf("\n\nThere are %d files in the list\n", argc - 1);
//if (argc - 1 < 10)  for (ii = 1; ii < argc; ii++ )
//                        {
//                           printf("\n%d.%s", ii, argv[ii]);
//                        }

//if (argc - 1 > 1 && argc - 1 < 10)
//   printf("\n\npress a number 1-%d to play this files", argc - 1);
//else if (argc - 1 > 1) printf("\n\npress n for next and f for forward file");
//   printf(  "\npress -/+ to change the volume");

//printf("\n");



install_int_ex(time_process, SECS_TO_TIMER(1));
LOCK_VARIABLE(zeit);








for (ii = 1; ii < argc && break_program == 0; ii++ )
{
    if (*argv[ii] == '-' || *argv[ii] == '/') strcpy(argv[ii], argv[ii]+1);

    if (!strcmp(argv[ii], "?"))
      {
        printf("\nUsage: %s [-D:x] [-switch[...] file(s)\nfiles can be: AUD,MIDI,WAV,MOD,XM,S3M,JGM,UMX,MP3,MP2,CD(tracknum.cd)", argv[0]);
        printf("\nSwitches can be:");
        printf("\n-D:x\tx=number of cd rom, must only be used, if there are more than 1 cd drive");
        printf("\n-open   \topens cd-rom");
        printf("\n-close  \tcloses cd-rom");
        printf("\n-lock   \tlocks cd-rom");
        printf("\n-unlock \tunlocks cd-rom");
        printf("\n");        
        printf("\nfiles\tfile(s), FreeCDP wildcards:");
        printf("\n     \t?\tany single character");
        printf("\n     \t*\tzero or more arbitrary characters, including a dot");
        printf("\n     \t[aA_]\tany one of characters `a', `A', or `_'");
        printf("\n     \t[a-d]\tany one of characters `a', `b', `c', or `d'");
        printf("\n     \t[!a-z]\tanything but a lowercase letter");
        printf("\n     \t...\tall the subdirectories, recursively (VMS aficionados, rejoice!)");
        printf("\n     \t.../*\tall the files in all subdirectories, recursively");
        printf("\n");        
        printf("\n     \tUnlike DOS, the * and ? meta-characters can appear anywhere in the ");
        printf("\n     \tfilename pattern, like in [a-z]*[0-9].*pp. You can also use * instead");
        printf("\n     \tof directories, like in */*/*.c, but not on drive letters ");
        printf("\n     \t(e.g., [a-c]:/ won't work)");
        return 255;
      }

    else if (*argv[ii] == 'D' )
      {
        printf ("Set drive to %d", (int)(*(argv[ii] + 2) - '0'));
        if (bcd_get_drive_letter( (int)(*(argv[ii] + 2) - '0')))
        
          printf(": %c:\\",bcd_get_drive_letter( (int)(*(argv[ii] + 2) - '0')));
        else
          printf(", Error: %s", bcd_error());

      }

    else if (!strcmp(argv[ii], "open"))
      {
      bcd_open_door();
      return 1;
      }
    else if (!strcmp(argv[ii], "close"))
      {
      bcd_close_door();
      return 1;
      }
    else if (!strcmp(argv[ii], "lock"))
      {
      bcd_lock(1);
      return 1;
      }
    else if (!strcmp(argv[ii], "unlock"))
      {
      bcd_lock(0);
      return 1;
      }
    else if (!strcmp(argv[ii], "list"))
      {
      list_cd();
      return 1;
      }
      

    else

      {


printf("\n");


printf("\ninit file: %s...\r", argv[ii]); clreol();

if (init_file(argv[ii])== 1) {
                             printf("can't load!");
                             clreol();
                             }


set_all_volume(vol);

if (play_file())
              {
              printf("can't play");
              clreol();
              }

zeit = 0;
              
if (m_h.mode == MP3)
   {

   printf ("[Artist:%-31s|Titel:%-31s]\n",artist, titel);
   printf ("[Album: %-31s|Com.: %-30s ]\n", album, comment);
   printf ("[Year:  %-31s|Genre:%-31s]\n", year, GenreStr[genre]);
   }

   printf("[File: %70s]\n", get_filename(argv[ii]));

while(is_playing_ticker())
  {
  process_counter ++;
  if (process_counter > 3)  process_counter = 0;

  printf("\r[%d.%02d %s playing %c]", zeit/60, zeit - ((int)(zeit/60))*60,return_file_info(), pprocess[process_counter]);
  clreol();

  if (keypressed())
     {
     t = readkey();

     if ((t & 0xff) >= '1' && (t & 0xff) <= '9')
         {
         ii = (t & 0xff) - '1';
         break;
         }

     else if ((t & 0xff) == 'n' || (key[KEY_ENTER] & KB_NORMAL)) //next
        {
        break;
        }

     else if ((t & 0xff) == 'f' || key[KEY_BACKSPACE])
        {
        ii -= 2;
        if (ii < 0) ii = 0;
        break;
        }

        
     else if ((t & 0xff) == 27)
         {
         break_program = 1;

         stop_file();
         break;
         }

     
     else if ((t & 0xff) == '-') vol --;
     else if ((t & 0xff) == '+') vol ++;


     
     if (vol < 0)   vol = 0;
     if (vol > 255) vol = 255;
     set_all_volume(vol);
     }
  }


stop_file();

   }

}

exit_Sound();
_setcursortype(_NORMALCURSOR);

return 0;
}


