/*
 *  Graphics function remaps for use with the SRGP graphics library.
 *
 *  Copyright (C) 1995  Philip VanBaren
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "freq.h"
#include "display.h"

int _font_color;
int _font_width;
int _font_height;

void draw_init(void)
{
   DOUT("draw_init");
}

void setup_graphics(void)
{
   int textd;

   SRGP_begin("Spectrum Analyzer",640,480,4,FALSE);
   SRGP_setBackgroundColor(0);
   SRGP_setFont(0);
   SRGP_inquireTextExtent("H", &_font_width, &_font_height, &textd);
   SRGP_setFillStyle(SOLID);
   SRGP_setLineStyle(CONTINUOUS);
   SRGP_setLineWidth(1);
   SRGP_setKeyboardProcessingMode(RAW);
   SRGP_setInputMode(KEYBOARD,EVENT);
}

void cleanup_graphics(void)
{
   SRGP_end();
}

void draw_fontcolor(int c)
{
   _font_color=c;
}

void draw_text_left(int x,int y,char *string)
{
   SRGP_setColor(_font_color);
   SRGP_text(SRGP_defPoint(x,480-_font_height-y),string);
}

void draw_text_centered(int x,int y,char *string)
{
   SRGP_setColor(_font_color);
   SRGP_text(SRGP_defPoint(x-strlen(string)*_font_width/2,480-_font_height-y),string);
}

void draw_text_right(int x,int y,char *string)
{
   SRGP_setColor(_font_color);
   SRGP_text(SRGP_defPoint(x-strlen(string)*_font_width,480-_font_height-y),string);
}

void draw_text_vertical(int x,int y,char *string)
{
   char buf[2];
   buf[1]=0;
   SRGP_setColor(_font_color);
   while(*string)
   {
      buf[0]=*string;
      SRGP_text(SRGP_defPoint(x,480-_font_height-y),buf);
      y+=_font_height;
      string++;
   }
}

void draw_rectangle(int x1,int y1,int x2,int y2,int c)
{
   SRGP_setColor(c);
   SRGP_rectangleCoord(x1,479-y2,x2,479-y1);
}

void draw_pixel(int x,int y,int c)
{
   SRGP_setColor(c);
   SRGP_pointCoord(x,479-y);
}

void draw_line(int x1,int y1,int x2,int y2,int c)
{
   SRGP_setColor(c);
   SRGP_lineCoord(x1,479-y1,x2,479-y2);
}

void draw_bar(int x1,int y1,int x2,int y2,int c)
{
   SRGP_setColor(c);
   SRGP_fillRectangleCoord(x1,479-y2,x2,479-y1);
}

void draw_setpalette(int n,int r,int g,int b)
{
   SRGP_loadSingleColor(n,r*1024,g*1024,b*1024);
}

int draw_getch(void)
{
   char buffer[2];
   buffer[0]=0;
   while(SRGP_waitEvent(0)!=KEYBOARD);
   SRGP_getKeyboard(buffer,2);
   return buffer[0];
}

int draw_getkey(void)
{
   char buffer[2];
   buffer[0]=0;
   if(SRGP_waitEvent(0)==KEYBOARD)
      SRGP_getKeyboard(buffer,2);
   return buffer[0];
}
