#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "allegro.h"
#include "lmuse.h"

/* extern interpret.c */
extern float maxx,maxy,maxz,minx,miny,minz;
/*extern lmuse.c*/
extern char screendumpextension[];
extern int vw;


int maxcolor=255;
float wtlx,wtly,wbrx,wbry;
float virxmult,virymult;
float drawingscale=1;
int drawleftx;
int drawrightx;
int drawbottomy;
int drawtopy;



int getdrawinglimits(){

        /* drawing limits */
        float h=0,v=0,l=0,r=0,b=0,t=0,wsize;

        float aspect=(float)(SCREEN_W-4*DRAWBORDERWIDE-2*BUTTONWIDTH)/(float)(SCREEN_H-DRAWINGTOP-4*DRAWBORDERWIDE);

        if( vw == XY){
                h = fabs(maxx - minx);
                v = fabs(maxy - miny);
                l = minx; r = maxx; b = miny; t = maxy;
        }
        else if (vw == ZY){
                h = fabs(maxz - minz);
                v = fabs(maxy - miny);
                l = minz; r = maxz; b = miny; t = maxy;
        }
        else if( vw == ZX){
                h = fabs(maxz - minz);
                v = fabs(maxx - minx);
                l = minz; r = maxz; b = minx; t = maxx;
        }
        if (h == 0 && v == 0){
                return -1;
        }
        if (isinf(h)||isinf(v)){
                return -2;
        }
        if( h > v * aspect){
                wsize = h;
                wtlx=l;
                wtly=b+v/2-wsize/2;
                wbrx=l+wsize;

                wbry=b+v/2+wsize/2/aspect;
        }
        else{
                wsize = v;
                wtlx=l+h/2-wsize*aspect/2;
                wtly=b;
                wbrx=l+h/2+wsize*aspect/2;
                wbry=b+wsize;
        }

        virxmult= (float)(SCREEN_W-4*DRAWBORDERWIDE-2*BUTTONWIDTH)/(drawingscale*(wbrx-wtlx));
        virymult= (float)(SCREEN_H-DRAWINGTOP-4*DRAWBORDERWIDE)/(drawingscale*(wbry-wtly));
        if(isnan(virxmult)||isnan(virymult)){
                return -3;
        }
        drawleftx=2*DRAWBORDERWIDE+2*BUTTONWIDTH;
        drawbottomy=SCREEN_H-2*DRAWBORDERWIDE;

        drawrightx=(int)drawleftx+(int)(virxmult*(wbrx-wtlx));
        drawtopy=(int)drawbottomy-(int)(virymult*(wbry-wtly));
        return 0;
}


inline void virline(BITMAP * bmp,float x1,float y1, float x2, float y2, int clr){
/* These lines are the only L-drawing commands*/
      int rx1=(int)(drawleftx+virxmult*(x1-wtlx));
      int ry1=drawbottomy-(int)(virymult*(y1-wtly));
      int rx2=(int)(drawleftx+virxmult*(x2-wtlx));
      int ry2=drawbottomy-(int)(virymult*(y2-wtly));
      if(clr>=DRAWBG){
            clr=clr+1;
      }
      line(bmp,rx1,ry1,rx2,ry2,clr%maxcolor);

}

inline void drawline(float x,float y,float z,float xl,float yl,float zl,int clr){
            show_mouse(NULL);
            if( vw == XY){
                    virline(screen, x, y,x + xl, y + yl, clr);
            }
            else if ( vw == ZY){
                    virline(screen, z, y,z + zl, y + yl, clr);
            }
            else if ( vw == ZX ){
                    virline(screen, z, x,z + zl, x + xl,clr);
            }
            show_mouse(screen);
}
int dump_drawing(){

       int dumpnumber=0;
          BITMAP *bmp;
          PALETTE pal;
          char filename[80];

          sprintf(filename,"draw%03d.%s",dumpnumber,screendumpextension);
          while (exists(filename)){
                dumpnumber++;
                sprintf(filename,"draw%03d.%s",dumpnumber,screendumpextension);
          }

          get_palette(pal);
          show_mouse(NULL);
          bmp = create_sub_bitmap(screen, drawleftx-4,drawtopy-4, drawrightx-drawleftx+8,drawbottomy-drawtopy+8);

          save_bitmap(filename, bmp, pal);
          show_mouse(screen);
          destroy_bitmap(bmp);

          alert("Drawing saved to",filename,NULL,"OK",NULL,13,0);

          return D_O_K;
}
