/* lmuse.c: the main file*/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>

#include "allegro.h"
#include "midifile.h"
#include "lmuse.h"
#include "ldat.h"

//#define NOTALWAYSSOUND

DECLARE_COLOR_DEPTH_LIST(
            COLOR_DEPTH_8
        )

/*extern prod.c*/
int L_mutate(void); char * formatline(char *line);
void initrules(); int readrulefile(FILE *fp);
int makeproduction(int maxlevel);
extern char productionmessage[];
extern char *production;
extern long maxstringlength;
extern char *rules[];
extern int numrules;
extern FILE *rulefilefp;
extern char axiom[];
extern char commentchar;

/* extern play.c*/
void all_notes_off(int channel);
extern DIALOG play_dialog[];

/*extern scales.c*/
extern int numpredefinedscales;
extern SCALE scales[];
extern char * scalenames[];
extern char scalenamestring[];
extern char scalefnnamestring[];
extern int (*scalefunctions[])(int,SCALE *);
extern int (*scalefn)(int, SCALE*);
extern char * scalefnnames[];
extern char scalestring[];
int scalemenu_proc(int msg, DIALOG*d, int c);
int scalefnmenu_proc(int msg, DIALOG*d, int c);
void scale2scalestring(SCALE* scale);
SCALE * string2scale(char * str);

/*extern draw.c*/
extern int maxcolor;
extern float drawingscale;
extern int drawleftx;
extern int drawrightx;
extern int drawbottomy;
extern int drawtopy;
int getdrawinglimits();
void virline(BITMAP * bmp,float x1,float y1, float x2, float y2, int clr);
int dump_drawing();

/*extern interpret.c*/
int interpret (int mode);
void free_midi_note_list( MIDINOTELIST  * M);
void print_curstate();
void sprint_curstate(char *buffer);
extern float maxx,maxy,maxz,minx,miny,minz;
extern float fmaxx,fmaxy,fmaxz,fminx,fminy,fminz;
extern float umaxx,umaxy,umaxz,uminx,uminy,uminz;
extern float lmaxx,lmaxy,lmaxz,lminx,lminy,lminz;
extern float maxlength, minlength;
extern float maxdrawlength, mindrawlength;
extern float maxthickness, minthickness;
extern VARIABLE pitchvariable, durationvariable, velocityvariable;
extern VARIABLE statevariablearray[];
extern VARIABLE constantvar;
extern float dmultiplier, pspread, dspread, vspread;
extern int numobjects;
extern unsigned char trackchannel[];
extern unsigned char trackflags[];
extern long maxcumtime;
extern float deltaanglerad;
extern MIDINOTELIST * tracklist[];
extern MIDINOTELIST * tracklastnode[];
extern MIDINOTELIST * tracknextnode[];
extern char curstatestring[];
/*-------------------*/

BITMAP *waitmouset,*waitmouseb,*waitmouseu,*waitmousep,*pointup;
BITMAP * lmtitle;
BITMAP *connect_bmp;

char exit_error_message[80]="";
int allegroexiterror(char * s){
     alert(s,"Exiting..",NULL, "OK",NULL,13,0);
     allegro_exit();
     exit(1);
}
int esc_or_right_mouse_button_pressed(){
     return (keypressed()&&((readkey() >> 8) == KEY_ESC))||(mouse_b&2);
}

#if defined(SCREENDUMPS)
int dump_screen();
#endif

int soundcard=DIGI_AUTODETECT,midicard= MIDI_AUTODETECT;

char * changefileext(char * origfilename,char * newfilename, char * newext);
int popup_file_select(char *message, char *path, char *ext);
FILE *savemf_fp;
int savemidi();
int myputc(int c) {return(putc(c,savemf_fp));}
char savemfname[256] = "";
char mutatefilename[256]="mutation.lm";
char inifile[256]="lmuse.ini";

char productionfilename[256]="prod.out";
char productionname[80];

char rulefile[256]="";
char rulefilename[80]="";
char playrulefilename[80]="";

char editor[256]="";

int readconfigfile();
int writeconfigfile();

char *rulesstring=NULL;

char numrecursestring[8]="";
char deltaanglestring[80]="10.0";
char transposestring[10];

char numrulesstring[80]="transformation rules (0):";
unsigned rstart,seed;
unsigned lastseed;

int maxlevel;
float thick=10.0;
float deltaangledeg=10.0;


MAP maps[MAXMAPS];
int cureditmap=0;

char screendumpextension[4]="PCX";

/* various flags */
int originalmutated=0;
int unsavedrulechanges=0;
int unsavedmapchanges=0;
int autoplay=1;
int writeparameters_p=1;
int factstacks_p=0;
int transposestack_p=0;
int randomize_p=1;
int soundoff=0;

int division=DIVISION;
long mtempo;
long tempo=120;
int baset;

char introinfo1[80]="";
DIALOG intro_dialog[]={
/*   (dialog proc)           (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */

   { d_shadow_box_proc,      0,    0,    209,  140,  255,96,    0,    0,      0,   0,    NULL},
   { d_bitmap_proc,          5,    5,    199,  114,  255,96,    0,    0,      0,   0,    NULL},

   { d_ctext_proc,           104,    123,  0,    0,    255,96,    0,0,0,0, introinfo1},

   { d_button_proc,          120,   62,  30,   16,   255, 0,     13,  D_EXIT,  0,   0,    "OK" },
#if defined(SCREENDUMPS)
   {d_keyboard_proc,    0,    0,   0,    0,    0,    0,     'p'-'a'+1,   0,       0,   0,    dump_screen},
#endif
   { NULL,              0,    0,   0,    0,    0,    0,       0,    0,      0,   0,    NULL }
};
#define INTROLOGOBMP 1
#define INTROTEXT1 2
#define INTROOKBUTTON 3

#if defined(SCREENDUMPS)
int dump_screen(){

       int dumpnumber=0;
          BITMAP *bmp;
          PALETTE pal;
          char filename[80];

          sprintf(filename,"scrdmp%02d.%s",dumpnumber,screendumpextension);
          while (exists(filename)){
                dumpnumber++;
                sprintf(filename,"scrdmp%02d.%s",dumpnumber,screendumpextension);
          }
          get_palette(pal);
          show_mouse(NULL);
          bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W-1, SCREEN_H-1);

          save_bitmap(filename, bmp, pal);
          show_mouse(screen);
          destroy_bitmap(bmp);

          alert("Screen saved to",filename,NULL,"OK",NULL,13,0);

          return D_O_K;
}
#endif

unsigned makeseed(){
     struct time t;
     gettime(&t);
     return (unsigned)(t.ti_hund*t.ti_sec);
}

void randomize (){

     lastseed=makeseed();
     srand (lastseed);

}
volatile long int_t1;
void t_int1(){
     int_t1++;

}
END_OF_FUNCTION (t_int1);

void timertempo(long tempo){
        mtempo=60000000/tempo;
        baset=division*tempo;
        if(install_int_ex(t_int1,BPM_TO_TIMER(baset))<0){
                allegroexiterror("Error initializing timer (too many timers?)");
                //printf("Error initializing timer (too many timers?)");
                //exit(1);
        }
}


int do_makeandinterpret();
int do_remakeandinterpret();
int do_makeproduction();
int do_remakeproduction();
int do_interpret();
int do_interpretremap();
int do_getproduction();
int do_testplay();
int quitter();
int do_dosshell();
int editrulefile();
int editrules();
int geteditor();
int mutaterules();
int mutateandremake();
int savemutation();
int saverulesas();
int getinifile();
int saveinifile();
int do_viewproduction();
int do_playmidifile();
int do_stopmidifile();

int loadnewrules();
MENU production_menu[] =
{
   { "Load, &Make && Interpret",do_makeandinterpret,   NULL },
   { "    Load Rules",             loadnewrules,     NULL },
   { "    Ma&ke Production",       do_makeproduction,     NULL,D_DISABLED },
   { "    &Interpret Production",  do_interpret,          NULL, D_DISABLED},
   { "  R&eMake && Interpret",       do_remakeandinterpret, NULL,D_DISABLED },
   { "  &Re-Interpret (Remap)",      do_interpretremap,     NULL, D_DISABLED},
   { "  &Play",                      do_testplay,           NULL, D_DISABLED},
   { "",                             NULL,                  NULL },
   { "Save Rule File &As ...",       saverulesas,           NULL, D_DISABLED},
   { "",                             NULL,                  NULL },
   { "&View/Save Production",        do_viewproduction,     NULL},
   { "&Get Production",              do_getproduction,      NULL },
   { "",                             NULL,                  NULL },
   { "&Save interpretation as MIDI", savemidi,              NULL, D_DISABLED},

   { "",                             NULL,                  NULL },
   { "Load a Map file",              getinifile,           NULL },
   { "Save Map",                     saveinifile,           NULL },
   { "",                             NULL,                  NULL },
   { "Save Drawing",                     dump_drawing,           NULL },
   { "",                             NULL,                  NULL },
   { "P&lay a MIDI file",              do_playmidifile,       NULL},
   { "St&op Playing MIDI file\tCTRL-s",do_stopmidifile,     NULL,D_DISABLED},
   { "",                             NULL,                  NULL },
   { "&DOS shell",                    do_dosshell,           NULL},
   { "",                             NULL,                  NULL },
   { "&Quit\tCTRL-q",                quitter,               NULL },
   { NULL,                           NULL,                  NULL }
};
#define PRODMAKE 2
#define PRODINTERP 3
#define PRODREMAKE 4
#define PRODINTERPREMAP 5
#define PRODPLAY 6
#define PRODSAVERULES 8
#define PRODVIEW 10
#define PRODSAVE 13

#define PRODSTOPPLAY 21

int do_remap0(), do_remap1(),do_remap2(), do_remap3(), do_remap4(),
do_remap5(),do_remap6(),do_remap7(),do_remap8(),do_remap9();

MENU map_menu[] =
{
   { "&0",               do_remap0,           NULL },
   { "&1",               do_remap1,           NULL },
   { "&2",               do_remap2,           NULL },
   { "&3",               do_remap3,           NULL },
   { "&4",               do_remap4,           NULL },
   { "&5",               do_remap5,           NULL },
   { "&6",               do_remap6,           NULL },
   { "&7",               do_remap7,           NULL },
   { "&8",               do_remap8,           NULL },
   { "&9",               do_remap9,           NULL },

   { NULL,                 NULL,                   NULL }
};
MENU edit_menu[] =
{
   { "&Edit rule file",    editrulefile,           NULL},
   { "Edit &Rules in memory\tCTRL-e",editrules,NULL},
   { "&Pick editor",            geteditor,              NULL},
   { NULL,                 NULL,                   NULL }
};
#define EDITEDIT 0


MENU mutate_menu[] =
{
   { "&Mutate rules\tCTRL-m",          mutaterules,           NULL,D_DISABLED},
   { "Mutate && &Remake/Interpret",    mutateandremake,       NULL,D_DISABLED},
   { "&Save Mutated rules",            savemutation,          NULL,D_DISABLED},

   { NULL,                 NULL,                   NULL }
};
#define MUTATEMUTATE 0
#define MUTATEREMAKE 1
#define MUTATESAVE 2

int vw; /* view */
DIALOG view_dialog[]=
{

   {d_box_proc,               300,  30,   220,  192,   255,   0,       0,   0,      0,   0,   NULL},
   {d_text_proc,              310,  44,   0,    0,     255,   0,       0,   0,      0,   0,   "View Plane"},
   {d_radio_proc,             310,  60,   40,   10,     255,   0,       0,   0,      0,   0,   "XY"},
   {d_radio_proc,             310,  72,   40,   10,     255,   0,       0,   0,      0,   0,   "ZY"},
   {d_radio_proc,             310,  84,   40,   10,     255,   0,       0,   0,      0,   0,   "ZX"},

   {d_text_proc,              310,  104,   0,    0,     255,   0,       0,   0,      0,   0,   "Size"},
   {d_radio_proc,             310,  120,   40,   10,     255,   0,       0,   0,      1,   0,   "Full"},
   {d_radio_proc,             310,  132,   40,   10,     255,   0,       0,   0,      1,   0,   "1/2"},
   {d_radio_proc,             310,  144,   40,   10,     255,   0,       0,   0,      1,   0,   "1/3"},
   {d_radio_proc,             310,  156,   40,   10,     255,   0,       0,   0,      1,   0,   "1/4"},
   {d_radio_proc,             310,  168,   40,   10,     255,   0,       0,   0,      1,   0,   "1/8"},

   {d_text_proc,              390,  144,   0,    0,     255,   0,       0,   0,      0,   0,   "File Type for"},
   {d_text_proc,              390,  156,   0,    0,     255,   0,       0,   0,      0,   0,   "Saved Drawings"},
   {d_radio_proc,             390,  172,   40,   10,     255,   0,       0,   0,      2,   0,   "BMP"},
   {d_radio_proc,             390,  184,   40,   10,     255,   0,       0,   D_SELECTED,      2,   0,   "PCX"},
   {d_radio_proc,             390,  196,   40,   10,     255,   0,       0,   0,      2,   0,   "TGA"},

   { d_button_proc,           310,  192,   30,   24,    255,  0,       13,D_EXIT,    0,   0,    "OK" },
   { NULL,                    0,    0,     0,    0,     0,     0,       0,   0,      0,   0,    NULL }
};
#define VIEWRADIO1 2
#define SIZERADIO1 6
#define SAVEDRAWINGTYPERADIO1 13
int do_view_dialog(){
    int i;
    int ret;
    int ndrawscale=0;

    for(i=0;i<3;i++){
            view_dialog[VIEWRADIO1+i].flags &= ~D_SELECTED;
    }
    for(i=0;i<5;i++){
            view_dialog[SIZERADIO1+i].flags &= ~D_SELECTED;
    }
    view_dialog[VIEWRADIO1+vw].flags |= D_SELECTED;
    switch((int)drawingscale){
        case 1: ndrawscale=0; break;
        case 2: ndrawscale=1; break;
        case 3: ndrawscale=2; break;
        case 4: ndrawscale=3; break;
        case 8: ndrawscale=4; break;
    }
    view_dialog[SIZERADIO1+ndrawscale].flags |= D_SELECTED;

    for(i=0;i<3;i++){
        view_dialog[SAVEDRAWINGTYPERADIO1+i].flags &= ~D_SELECTED;

    }
    if(!stricmp(screendumpextension,"BMP"))
         view_dialog[SAVEDRAWINGTYPERADIO1+0].flags |= D_SELECTED;
    else if(!stricmp(screendumpextension,"PCX"))
         view_dialog[SAVEDRAWINGTYPERADIO1+1].flags |= D_SELECTED;
    else if(!stricmp(screendumpextension,"TGA"))
         view_dialog[SAVEDRAWINGTYPERADIO1+2].flags |= D_SELECTED;


    ret=popup_dialog(view_dialog,0);

    for(i=0;i<3;i++){
            if(view_dialog[VIEWRADIO1+i].flags&D_SELECTED)
                 vw=i;
            view_dialog[VIEWRADIO1+i].flags &= ~D_SELECTED;
   }
    for(i=0;i<5;i++){
            if(view_dialog[SIZERADIO1+i].flags&D_SELECTED)
                 switch(i){
                    case 0: drawingscale=1; break;
                    case 1: drawingscale=2; break;
                    case 2: drawingscale=3; break;
                    case 3: drawingscale=4; break;
                    case 4: drawingscale=8; break;
                 }
                 //drawingscale=i+1;
            view_dialog[SIZERADIO1+i].flags &= ~D_SELECTED;
   }

   if(view_dialog[SAVEDRAWINGTYPERADIO1+0].flags& D_SELECTED)
             strcpy(screendumpextension,"BMP");
   else if(view_dialog[SAVEDRAWINGTYPERADIO1+1].flags& D_SELECTED)
             strcpy(screendumpextension,"PCX");

   else if(view_dialog[SAVEDRAWINGTYPERADIO1+2].flags& D_SELECTED)
             strcpy(screendumpextension,"TGA");
   for(i=0;i<3;i++){
            view_dialog[SAVEDRAWINGTYPERADIO1+i].flags &= ~D_SELECTED;
   }

   return D_O_K;
}
int soundtoggle();
int drawtoggle();
int autoplaytoggle();
int writeparameterstoggle();
int do_maxstringsizedialog();
MENU options_menu[] =
{
   { " Sound",            soundtoggle,          NULL },
   { " Draw",             drawtoggle,           NULL },
   { " Auto Play",        autoplaytoggle,       NULL },
   { " Write info into MIDI file",writeparameterstoggle, NULL},
   { "",               NULL,NULL},
   { "View...",           do_view_dialog,       NULL },
   { "Maximum production string size",do_maxstringsizedialog,NULL},

   { NULL,                 NULL,                   NULL }
};

#define SOUNDTOGGLE 0
#define DRAWTOGGLE 1
#define AUTOPLAYTOGGLE 2
#define WRITEPARAMETERSTOGGLE 3
#define MAXSTRING 6

int symbolshelp();
int lsystemshelp();
int menushelp();
int scaleshelp();
int playhelp();
int credithelp();
int fileshelp();
int overview();
int troublehelp();
int rulefilehelp();
int maphelp();
int instrumentshelp();
int commandlinehelp();
MENU help_menu[] =
{
   { "&L-Systems",                  lsystemshelp,           NULL },
   { "Process &Overview",           overview,               NULL },
   { "&Menus, etc",                 menushelp,              NULL },
   { "&Symbols",                    symbolshelp,            NULL },
   { "M&ap / Map file",             maphelp,                NULL },
   { "&Rule File Format",           rulefilehelp,           NULL },
   { "s&Cales",                     scaleshelp,             NULL },
   { "&Instrument/Timbre Numbers",  instrumentshelp,        NULL },
   { "&Play",                       playhelp,               NULL },
   { "&Files/Compatibility",        fileshelp,              NULL },
   { "&DOS command line",           commandlinehelp,        NULL },
   { "&Trouble",                    troublehelp,            NULL },
   { "&About",                      credithelp,             NULL },
   { NULL,                          NULL,                   NULL }
};

MENU topmenu[] =
{ 
   { "&Production",                 NULL,            production_menu },
   { "&Maps",                       NULL,            map_menu},
   { "&Edit",                       NULL,            edit_menu},
   { "M&utate",                     NULL,            mutate_menu},
   { "&Options",                    NULL,            options_menu},
   { "&Help",                       NULL,            help_menu },

   { NULL,                          NULL,            NULL }
};
#define TOPMUTATE 3


char process_status_string[80]="";

int d_quit_icon_proc(int msg,DIALOG *d, int c);
int d_remap_icon_proc(int msg,DIALOG *d, int c);
int d_interpret_icon_proc(int msg,DIALOG *d, int c);
int d_play_icon_proc(int msg,DIALOG *d, int c);
int d_savemidi_icon_proc(int msg,DIALOG *d, int c);
int d_makeandinterpret_icon_proc(int msg,DIALOG *d, int c);
int d_remake_icon_proc(int msg,DIALOG *d, int c);
int d_loadrules_icon_proc(int msg,DIALOG *d, int c);
int d_make_icon_proc(int msg,DIALOG *d, int c);
int d_edit_icon_proc(int msg,DIALOG *d, int c);
int d_editrules_icon_proc(int msg,DIALOG *d, int c);
int d_mutate_icon_proc(int msg,DIALOG *d, int c);
int d_mutateandinterpret_icon_proc(int msg,DIALOG *d, int c);
int d_saverules_icon_proc(int msg,DIALOG *d, int c);
int loadini_proc(int msg,DIALOG *d, int c);
int saveini_proc(int msg,DIALOG *d, int c);
int rulesinfo_proc(int msg, DIALOG *d, int c);


/*   (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG dialog1[] =
{

   { d_box_proc,        0,    0,   639,  479,  255,  BG1,   0,      0,     0,   0,    NULL},
   { d_box_proc,        DRAWBORDERWIDE,DRAWBORDERWIDE+DRAWINGTOP,639-2*DRAWBORDERWIDE,480-2*DRAWBORDERWIDE-DRAWINGTOP,255,  EMPTYBG,   0,      0,     0,   0,    NULL},
   { d_menu_proc,       0,    0,   0,    0,    0,    0,     0,      0,     0,   0,   topmenu },

/**/ /* buttons */
   { d_shadow_box_proc,              PMBL,   PMBD, 2*BUTTONWIDTH, 9*BUTTONHEIGHT,                    255,PMBG,0,    0,                0,   0,    NULL},

   { rulesinfo_proc,                 PMBL+1,  PMBD+9*BUTTONHEIGHT-18+5,  2*BUTTONWIDTH-2,     16,      15,  0, 'r',  D_EXIT,  0,   0,   rulefilename },

   { d_loadrules_icon_proc,          PMBL+0, PMBD+0,BUTTONWIDTH,BUTTONHEIGHT,                        255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},
   { d_make_icon_proc,               PMBL+0, PMBD+BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,                        255,PMBG,0,  D_EXIT|D_DISABLED,             2,   2,    NULL,NULL,NULL},
   { d_makeandinterpret_icon_proc,   PMBL+BUTTONWIDTH,PMBD+0,BUTTONWIDTH,2*BUTTONHEIGHT,               255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},

   { d_interpret_icon_proc,          PMBL+0,PMBD+2*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,              255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_remake_icon_proc,             PMBL+BUTTONWIDTH,PMBD+2*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,    255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},

   { d_remap_icon_proc,              PMBL+0,PMBD+3*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,            255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_play_icon_proc,               PMBL+BUTTONWIDTH,PMBD+3*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,  255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},

   { d_mutate_icon_proc,             PMBL+0,PMBD+4*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,           255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_mutateandinterpret_icon_proc, PMBL+BUTTONWIDTH, PMBD+4*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},


   { d_savemidi_icon_proc,           PMBL+0,PMBD+5*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_saverules_icon_proc,          PMBL+BUTTONWIDTH,PMBD+5*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT, 255,PMBG,0,  D_EXIT|D_DISABLED, 2,   2,    NULL,NULL,NULL},

   { d_edit_icon_proc,               PMBL+0,PMBD+6*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,            255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},
   { d_editrules_icon_proc,          PMBL+BUTTONWIDTH,PMBD+6*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,            255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},

   { d_quit_icon_proc,               PMBL+BUTTONWIDTH/2, PMBD+7*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,255,PMBG,0,  D_EXIT,  2,   2,    NULL,NULL,NULL},
/**/
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     0,      0, KEY_ESC, 0,   quitter },
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('q'), 0,     0,   0,   quitter },

   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('m'), 0,     0,   0,    mutaterules },
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('s'), 0,     0,   0,    do_stopmidifile },
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('e'), 0,     0,   0,    editrules },

   { loadini_proc,                 PMBL+1,  PMBD+9*BUTTONHEIGHT-36+5,  2*BUTTONWIDTH-2,     16,      15,  0, 0,  D_EXIT,  0,   0,   "Load Map" },
   { saveini_proc,                 PMBL+1,  PMBD+9*BUTTONHEIGHT-54+5,  2*BUTTONWIDTH-2,     16,      15,  0, 0,  D_EXIT,  0,   0,   "Save Map" },

   { d_text_proc,        400,    5,   239,  12,  18,  BG1,   0,      0,     0,   0,    process_status_string},
#if defined (SCREENDUMPS)
   {d_keyboard_proc,    0,    0,   0,    0,    0,    0,     'p'-'a'+1,   0,       0,   0,    dump_screen},
#endif
   {d_keyboard_proc,    0,    0,   0,    0,    0,    0,     'd'-'a'+1,   0,       0,   0,    dump_drawing},
   { NULL,              0,    0,   0,    0,    0,    0,      0,    0,      0,    0,   NULL }
};

#define DRAWBOX 1
#define TOPMENU 2
#define DIALOG1RULES 4
/**/
#define PROCLOADBUT 5
#define PROCMAKEBUT 6
#define PROCMAKEANDBUT 7
#define PROCINTERPBUT  8
#define PROCREMAKEBUT 9
#define PROCREMAPBUT 10
#define PROCPLAYBUT  11
#define PROCMUTATEBUT 12
#define PROCMUTANDBUT  13
#define PROCSAVEMIDIBUT  14
#define PROCSAVERULESBUT 15
#define PROCEDITBUT  16
#define PROCEDITRULESBUT 17

#define PROCQUITBUT  18

#define PROCESSSTATUSTEXT 26

int showprocessstatus(char *message){
     int obj;
     int elength,tlength;
     DIALOG *d=&dialog1[PROCESSSTATUSTEXT];

     elength=text_length(font,d->dp);
     rectfill(screen,d->x, d->y, d->x+d->w, d->y+d->h, BG1);
     tlength=text_length(font,message);
     strcpy(process_status_string,message);
     d->w=tlength;
     dialog_message(d, MSG_DRAW, 0, &obj);
     return 0;
}
int d_connect_l_proc(int msg,DIALOG *d, int c);
int d_connect_r_proc(int msg,DIALOG *d, int c);
int d_connect_box_proc(int msg,DIALOG *d,int c);
int dumblit_proc(int msg,DIALOG *d,int c);
int connect_helpbutton_proc(int msg,DIALOG *d, int c);
int getinibutton_proc(int msg,DIALOG *d, int c);

int d_gotomapbutton_proc(int msg,DIALOG *d, int c);
int d_copymapbutton_proc(int msg,DIALOG *d, int c);

#define CONNECT_W 320
#define CONNECT_H 260

#define PCOLOR 1
#define DCOLOR 12
#define VCOLOR 10
char dmultbuf[20];
char pspreadbuf[20];
char dspreadbuf[20];
char vspreadbuf[20];
int setdmult(void *dp3, int d2);
int setpspread(void *dp3, int d2);
int setdspread(void *dp3, int d2);
int setvspread(void *dp3, int d2);
int seelimits_proc(int msg, DIALOG *d, int c);
char mapnumberstring[10]="Map #";
/*   (dialog proc)           (x)   (y)   (w)   (h)       (fg)  (bg)    (key) (flags)  (d1) (d2)   (dp) */
DIALOG connect_dialog[] =
{
   { d_box_proc,              0,0,CONNECT_W,CONNECT_H+156,255,  0,       0,    0,      0,   0,    NULL},
   { d_connect_box_proc,      0,0,CONNECT_W,CONNECT_H,    255,CONNECTBG, 0,    0,      0,   0,    NULL},

   { d_connect_l_proc,        20,   20,   70,    10,      255,  0,       0,    0,      -1,PCOLOR, "pitch"},
   { d_connect_l_proc,        20,   100,   70,    10,      255,  0,       0,    0,      -1,DCOLOR, "duration"},
   { d_connect_l_proc,        20,   180,  70,    10,      255,  0,       0,    0,      -1,VCOLOR, "volume"},

   { d_connect_r_proc,        200,  20,   100,   10,      255,  0,       0,    0,      0,   0,    "x"},
   { d_connect_r_proc,        200,  35,   100,   10,      255,  0,       0,    0,      0,   0,    "y"},
   { d_connect_r_proc,        200,  50,   100,   10,      255,  0,       0,    0,      0,   0,    "z"},
   { d_connect_r_proc,        200,  65,   100,   10,      255,  0,       0,    0,      0,   0,    "forward x"},
   { d_connect_r_proc,        200,  80,   100,   10,      255,  0,       0,    0,      0,   0,    "forward y"},
   { d_connect_r_proc,        200,  95,   100,   10,      255,  0,       0,    0,      0,   0,    "forward z"},
   { d_connect_r_proc,        200,  110,  100,   10,      255,  0,       0,    0,      0,   0,    "up x"},
   { d_connect_r_proc,        200,  125,  100,   10,      255,  0,       0,    0,      0,   0,    "up y"},
   { d_connect_r_proc,        200,  140,  100,   10,      255,  0,       0,    0,      0,   0,    "up z"},

   { d_connect_r_proc,        200,  155,  100,   10,      255,  0,       0,    0,      0,   0,    "left x"},
   { d_connect_r_proc,        200,  170,  100,   10,      255,  0,       0,    0,      0,   0,    "left y"},
   { d_connect_r_proc,        200,  185,  100,   10,      255,  0,       0,    0,      0,   0,    "left z"},
   
   { d_connect_r_proc,        200,  200,  100,   10,      255,  0,       0,    0,      0,   0,    "state length"},
   { d_connect_r_proc,        200,  215,  100,   10,      255,  0,       0,    0,      0,   0,    "draw length"},
   { d_connect_r_proc,        200,  230,  100,   10,      255,  0,       0,    0,      0,   0,    "thickness"},


   { d_text_proc,             160,CONNECT_H+10,0,0,       255,  0,       0,    0,      0,   0,    "Scale:" },
   { scalemenu_proc,          210,CONNECT_H+10,100,10,    255,  0,       0,    0,      0,   0,    scalenamestring},
   { scalefnmenu_proc,        210,CONNECT_H+24,100,10,    255,  0,       0,    0,      0,   0,    scalefnnamestring},

   { d_text_proc,             150,5,           0,  0,     255, CONNECTBG,0,    0,      0,   0,    mapnumberstring},
   { dumblit_proc,            10, 10,          0,  0,CONNECTBG,CONNECTBG,0,    0,      0,   0,    NULL },


   { d_text_proc,             160,CONNECT_H+60, 0,0,      255,  0,       0,    0,      0,   0,    "multiply durations:" },
   { d_slider_proc,           210,CONNECT_H+70,100,10,    255,  0,       0,    0,      400, 0,    NULL,     setdmult},
   { d_edit_proc,             240,CONNECT_H+82,60, 10,    255,  8,       0,    0,      8,   0,    dmultbuf },

   { d_text_proc,             160,CONNECT_H+40, 0,  0,     255,  0,       0,    0,      0,   0,    "Transpose:"},
   { d_edit_proc,             240,CONNECT_H+40, 50, 16,    255,  8,       0 ,   0,      3,   0,    transposestring},

   /*spreads*/
   { d_text_proc,             20,37, 0,0,                 255,  CONNECTBG,       0,    0,      0,   0,    "spread:" },
   { d_slider_proc,           20,50,80,10,                255,  CONNECTBG,       0,    0,      70, 0,    NULL,     setpspread},
   { d_edit_proc,             30,62,60, 10,               255,  0,       0,    0,      8,   0,    pspreadbuf },

   { d_text_proc,             20,117, 0,0,                255,  CONNECTBG,       0,    0,      0,   0,    "spread:" },
   { d_slider_proc,           20,130,80,10,               255,  CONNECTBG,       0,    0,      70, 0,    NULL,     setdspread},
   { d_edit_proc,             30,142,60, 10,              255,  0,       0,    0,      8,   0,    dspreadbuf },

   { d_text_proc,             20,197, 0,0,                255,  CONNECTBG,       0,    0,      0,   0,    "spread:" },
   { d_slider_proc,           20,210,80,10,               255,  CONNECTBG,       0,    0,      70, 0,    NULL,     setvspread},
   { d_edit_proc,             30,222,60, 10,              255,  0,       0,    0,      8,   0,    vspreadbuf },

   { seelimits_proc, CONNECT_W/2-45,CONNECT_H-12,90,12,    255,  0,       0, D_EXIT,  0,   0,    "see limits" },

   { d_text_proc,             10,CONNECT_H+80, 0,  0,     1,  0,       0,    0,      0,   0,    "angle:"},
   { d_edit_proc,             60,CONNECT_H+80, 60, 16,    255,  8,       0 ,   0,      6,   0,    deltaanglestring},


   { d_check_proc,            138,CONNECT_H+100,180,10,     255,  0,       't',    0,      0,   0,    "Use &Transpose stack?"},
   { d_check_proc,            160,CONNECT_H+112,130,10,     255,  0,       'f',    0,      0,   0,    "&Factor stacks?"},

   { d_text_proc,             10,CONNECT_H+10, 0,  0,     255,  0,       0,    0,      0,   0,    "Go to Map #:"},
   { d_gotomapbutton_proc,           10,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    0,   0,    "0" },
   { d_gotomapbutton_proc,           20,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    1,   0,    "1" },
   { d_gotomapbutton_proc,           30,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    2,   0,    "2" },
   { d_gotomapbutton_proc,           40,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    3,   0,    "3" },
   { d_gotomapbutton_proc,           50,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    4,   0,    "4" },
   { d_gotomapbutton_proc,           60,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    5,   0,    "5" },
   { d_gotomapbutton_proc,           70,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    6,   0,    "6" },
   { d_gotomapbutton_proc,           80,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    7,   0,    "7" },
   { d_gotomapbutton_proc,           90,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    8,   0,    "8" },
   { d_gotomapbutton_proc,           100,CONNECT_H+22,10,12,    255,  0,       '0',D_EXIT,    9,   0,    "9" },

   { d_text_proc,             10,CONNECT_H+38, 0,  0,     255,  0,       0,    0,      0,   0,    "Copy Map #:"},
   { d_copymapbutton_proc,           10,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    0,   0,    "0" },
   { d_copymapbutton_proc,           20,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    1,   0,    "1" },
   { d_copymapbutton_proc,           30,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    2,   0,    "2" },
   { d_copymapbutton_proc,           40,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    3,   0,    "3" },
   { d_copymapbutton_proc,           50,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    4,   0,    "4" },
   { d_copymapbutton_proc,           60,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    5,   0,    "5" },
   { d_copymapbutton_proc,           70,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    6,   0,    "6" },
   { d_copymapbutton_proc,           80,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    7,   0,    "7" },
   { d_copymapbutton_proc,           90,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    8,   0,    "8" },
   { d_copymapbutton_proc,           100,CONNECT_H+50,10,12,    255,  0,       '0',D_EXIT,    9,   0,    "9" },

   { d_button_proc,           80,CONNECT_H+128,60,24,    255,  0,       13,D_EXIT,    0,   0,    "Done" },
   { d_button_proc,           150,CONNECT_H+128,60,24,    255,  0,       27,D_EXIT,    0,   0,    "Stop" },
   { connect_helpbutton_proc, 270,CONNECT_H+128,40,18,    255,  0,      'h',D_EXIT,    0,   0,    "&Help" },

   { getinibutton_proc,       10, CONNECT_H+100,120,18,    255,  0,      'm',D_EXIT,    0,   0,    "Load a &Map" },

#if defined (SCREENDUMPS)
   {d_keyboard_proc,          0,    0,          0, 0,     0,    0,   'd'-'a'+1,   0,       0,   0,    dump_screen},
#endif

   { NULL,                    0,   0,           0, 0,     0,    0,       0,    0,      0,   0,    NULL }
};
#define CONNECTBOX 1
#define NUMLCONNECT 3
#define LCONNECT1 2
#define RCONNECT1 LCONNECT1+NUMLCONNECT
#define NUMRCONNECT 15
#define SCALEBUTTON 21
#define SCALEFNBUTTON 22
#define CONNECTDRAWCHECK 25
#define DMULTSLIDER 26
#define DMULTTEXT 27
#define TRANSPOSESTACKCHECK 42
#define FACTORSTACKSCHECK 43
#define GOTOMAPBUTTON0 45
#define COPYMAPBUTTON0 56
#define CONNECTDONE 66
#define CONNECTCANCEL 67
#define CONNECTHELP 68

#define PSPREADSLIDER 31
#define PSPREADTEXT   32
#define DSPREADSLIDER 34
#define DSPREADTEXT   35
#define VSPREADSLIDER 37
#define VSPREADTEXT   38


#define PITCH    0
#define DURATION 1
#define VOLUME 2


void setconnectdialogto(int mnum);
void setmapfromdialog(int mnum);

int d_gotomapbutton_proc(int msg,DIALOG *d, int c){
       int ret=d_button_proc(msg, d, c);
       if(ret==D_CLOSE){
           setmapfromdialog(cureditmap);
           cureditmap=d->d1;
           setconnectdialogto(cureditmap);

           broadcast_dialog_message(MSG_DRAW,0);
           return D_O_K;
       }

       return ret;
}
int d_copymapbutton_proc(int msg,DIALOG *d, int c){
       int i;
       int ret=d_button_proc(msg, d, c);
       int copyfrom;
       if(ret==D_CLOSE){

        copyfrom=d->d1;
        maps[cureditmap].pitch=maps[copyfrom].pitch;
        maps[cureditmap].duration=maps[copyfrom].duration;
        maps[cureditmap].volume=maps[copyfrom].volume;
        maps[cureditmap].pspread=maps[copyfrom].pspread;
        maps[cureditmap].dspread=maps[copyfrom].dspread;
        maps[cureditmap].vspread=maps[copyfrom].vspread;
        maps[cureditmap].scale=maps[copyfrom].scale;
        strcpy(maps[cureditmap].scalename,maps[copyfrom].scalename);
        maps[cureditmap].scalefn=maps[copyfrom].scalefn;
        maps[cureditmap].dmultiplier=maps[copyfrom].dmultiplier;
        maps[cureditmap].transpose=maps[copyfrom].transpose;
        maps[cureditmap].tstack=maps[copyfrom].tstack;
        maps[cureditmap].fstacks=maps[copyfrom].fstacks;

        sprintf(transposestring,"%d",maps[cureditmap].transpose);

        scale2scalestring(&(maps[cureditmap].scale));
        strcpy(scalenamestring,maps[cureditmap].scalename);

        for (i=0;i<3;i++){
           if(maps[cureditmap].scalefn==scalefunctions[i])
               strcpy(scalefnnamestring,scalefnnames[i]);
        }
        for(i=0;i<NUMSTATEVARS;i++){
            if(maps[cureditmap].pitch->v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+PITCH].d1=i;
            if(maps[cureditmap].duration->v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+DURATION].d1=i;
            if(maps[cureditmap].volume->v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+VOLUME].d1=i;

        }
        connect_dialog[DMULTSLIDER].d2=(int)( (maps[cureditmap].dmultiplier)/4.0*100);
        sprintf(connect_dialog[DMULTTEXT].dp,"%1.3f",(maps[cureditmap].dmultiplier)/4.0);

        connect_dialog[PSPREADSLIDER].d2=(int)((maps[cureditmap].pspread+PSPREADMAX)/(2*PSPREADMAX)*70);
        sprintf(connect_dialog[PSPREADTEXT].dp,"%1.3f",maps[cureditmap].pspread);

        connect_dialog[DSPREADSLIDER].d2=(int)((maps[cureditmap].dspread+DSPREADMAX)/(2*DSPREADMAX)*70);
        sprintf(connect_dialog[DSPREADTEXT].dp,"%1.3f",maps[cureditmap].dspread);

        connect_dialog[VSPREADSLIDER].d2=(int)((maps[cureditmap].vspread+VSPREADMAX)/(2*VSPREADMAX)*70);
        sprintf(connect_dialog[VSPREADTEXT].dp,"%1.3f",maps[cureditmap].vspread);

        if(maps[cureditmap].tstack)
             connect_dialog[TRANSPOSESTACKCHECK].flags |= D_SELECTED;
        else connect_dialog[TRANSPOSESTACKCHECK].flags &= ~D_SELECTED;
        if(maps[cureditmap].fstacks)
             connect_dialog[FACTORSTACKSCHECK].flags |= D_SELECTED;
        else connect_dialog[FACTORSTACKSCHECK].flags &= ~D_SELECTED;

   
        broadcast_dialog_message(MSG_DRAW,0);
        return D_O_K;
       }
       return ret;
}

int connect_helpbutton_proc(int msg,DIALOG *d, int c){

        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           ret=maphelp();

           return ret;
        }
        return(ret);
}
int draw_p=1;
int d_connect_box_proc(int msg,DIALOG *d, int c){
    int ret;

    ret=d_box_proc(msg,d,c);
    if(msg==MSG_START){
         connect_bmp= create_bitmap(d->w,d->h);
         clear(connect_bmp);
    }
    else if(msg==MSG_END){
         destroy_bitmap(connect_bmp);
    }

    return ret;
}
int dumblit_proc(int msg,DIALOG *d,int c){
 int ret;
 if(msg==MSG_DRAW){
              /*show_mouse(NULL);*/
              blit(screen,connect_bmp,0,0,0,0,CONNECT_W,CONNECT_H);
              /*show_mouse(screen);*/
 }
 ret=d_box_proc(msg,d,c);
 return(ret);
}

void circlelineproc(BITMAP * bmp,int x, int y,int c){
             circlefill(bmp,x,y,1,c);
}
int d_connect_l_proc(int msg,DIALOG *d, int c){
    int ret;
    int i;
    int mx=mouse_x,my=mouse_y;
    int omx=mx,omy=my;
    int tlx=connect_dialog[0].x;
    int tly=connect_dialog[0].y;
    DIALOG * endb;

    if(msg==MSG_CLICK){
              unsavedmapchanges=1;
              broadcast_dialog_message(MSG_DRAW,0);
              show_mouse(NULL);
              blit(screen,connect_bmp,tlx,tly,0,0,CONNECT_W,CONNECT_H);
              show_mouse(screen);
              while(mouse_b&1){
                  mx=mouse_x;my=mouse_y;
                  if((omx!=mx || omy!=my) ){
                       show_mouse(NULL);
                       blit(connect_bmp,screen,0,0,tlx,tly,CONNECT_W,CONNECT_H);
                       if(mx<tlx+CONNECT_W-1 && my<tly+CONNECT_H-1 && mx>d->x+d->w && my>tly){
                          /*line(screen,d->x+d->w,d->y,mx,my,d->d2);*/
                          do_line(screen,d->x+d->w,d->y+1,mx,my+1,d->d2,circlelineproc);
                       }
                       show_mouse(screen);
                  }
                  omx=mx;omy=my;

              }

              for(i=0;i<NUMRCONNECT;i++){
                       endb=&connect_dialog[RCONNECT1+i];
                       if(mx>endb->x && mx<endb->x+endb->w && my>endb->y&&my<endb->y+endb->h)
                            break;
              }

              if(i<NUMRCONNECT){
                     d->d1=i;

              }
              else {
                 d->d1=-1;
              }
              d->flags &= ~D_SELECTED;
              broadcast_dialog_message(MSG_DRAW,0);
 
    }
    else if(msg==MSG_DRAW&& d->d1>=0){
          do_line(screen,d->x+d->w,d->y+1,connect_dialog[RCONNECT1+d->d1].x,connect_dialog[RCONNECT1+d->d1].y+1,d->d2,circlelineproc);
    }

    ret=d_button_proc(msg,d,c);
    return ret;
}

int d_connect_r_proc(int msg,DIALOG *d, int c){

    int ret2=d_button_proc(msg,d,c);
    d->flags&=~D_SELECTED;
    return ret2;
}

char mapbuf[MAXMAPS][NUMLCONNECT][80];

void setconnectdialogto(int mnum){
   int i;
   MAP * m=&(maps[mnum]);

   sprintf(mapnumberstring,"Map #%d",mnum);
   scale2scalestring(&(m->scale));
   strcpy(scalenamestring,m->scalename);
   sprintf(transposestring,"%d",m->transpose);
   for(i=0;i<MAXMAPS;i++){
          connect_dialog[GOTOMAPBUTTON0+i].flags &= ~D_DISABLED;
          connect_dialog[COPYMAPBUTTON0+i].flags &= ~D_DISABLED;
   }
   connect_dialog[GOTOMAPBUTTON0+mnum].flags |= D_DISABLED;
   connect_dialog[COPYMAPBUTTON0+mnum].flags |= D_DISABLED;
   for (i=0;i<3;i++){
      if(m->scalefn==scalefunctions[i])
          strcpy(scalefnnamestring,scalefnnames[i]);
   }
   for(i=0;i<NUMSTATEVARS;i++){
            if(m->pitch->v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+PITCH].d1=i;
            if(m->duration->v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+DURATION].d1=i;
            if(m->volume->v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+VOLUME].d1=i;

   }

   if(m->dmultiplier>4.0*DMULTMAX) m->dmultiplier=4.0*DMULTMAX;
   if(m->dmultiplier<0) m->dmultiplier=0;
   connect_dialog[DMULTSLIDER].d2=(int)( (m->dmultiplier)/4.0*100);
   sprintf(connect_dialog[DMULTTEXT].dp,"%1.3f",(m->dmultiplier)/4.0);

   if(m->pspread>PSPREADMAX) m->pspread=PSPREADMAX;
   if(m->pspread<-PSPREADMAX) m->pspread=-PSPREADMAX;
   connect_dialog[PSPREADSLIDER].d2=(int)((m->pspread+PSPREADMAX)/(2*PSPREADMAX)*70);
   sprintf(connect_dialog[PSPREADTEXT].dp,"%1.3f",m->pspread);

   if(m->dspread >  DSPREADMAX) m->dspread =  DSPREADMAX;
   if(m->dspread < -DSPREADMAX) m->dspread = -DSPREADMAX;
   connect_dialog[DSPREADSLIDER].d2=(int)((m->dspread+DSPREADMAX)/(2*DSPREADMAX)*70);
   sprintf(connect_dialog[DSPREADTEXT].dp,"%1.3f",m->dspread);

   if(m->vspread>VSPREADMAX) m->vspread=VSPREADMAX;
   if(m->vspread<-VSPREADMAX) m->vspread=-VSPREADMAX;
   connect_dialog[VSPREADSLIDER].d2=(int)((m->vspread+VSPREADMAX)/(2*VSPREADMAX)*70);
   sprintf(connect_dialog[VSPREADTEXT].dp,"%1.3f",m->vspread);

   if(m->tstack)
      connect_dialog[TRANSPOSESTACKCHECK].flags |= D_SELECTED;

   else connect_dialog[TRANSPOSESTACKCHECK].flags &= ~D_SELECTED;
   if(m->fstacks)
      connect_dialog[FACTORSTACKSCHECK].flags |= D_SELECTED;

   else connect_dialog[FACTORSTACKSCHECK].flags &= ~D_SELECTED;

   sprintf(deltaanglestring,"%3.2f",deltaangledeg);
}
void setmapfromdialog(int mnum){
   int i;
   DIALOG *d;
   MAP * m=&(maps[mnum]);
   if(connect_dialog[TRANSPOSESTACKCHECK].flags&D_SELECTED)
         m->tstack=1;
   else m->tstack=0;


   if(connect_dialog[FACTORSTACKSCHECK].flags&D_SELECTED)
         m->fstacks=1;
   else m->fstacks=0;

   deltaangledeg=atof(deltaanglestring);

   m->dmultiplier=4.0*atof(dmultbuf);
   if(m->dmultiplier>4.0*DMULTMAX) m->dmultiplier=4.0*DMULTMAX;
   if(m->dmultiplier<0) m->dmultiplier=0;
   m->pspread=atof(pspreadbuf);
   if(m->pspread>PSPREADMAX) m->pspread=PSPREADMAX;
   if(m->pspread<-PSPREADMAX) m->pspread=-PSPREADMAX;

   m->dspread=atof(dspreadbuf);
   if(m->dspread>DSPREADMAX) m->dspread=DSPREADMAX;
   if(m->dspread<-DSPREADMAX) m->dspread=-DSPREADMAX;

   m->vspread=atof(vspreadbuf);
   if(m->vspread>VSPREADMAX) m->vspread=VSPREADMAX;
   if(m->vspread<-VSPREADMAX) m->vspread=-VSPREADMAX;

   m->transpose=atoi(transposestring);

   for (i=0;i<NUMLCONNECT;i++){
            d=&connect_dialog[LCONNECT1+i];
            if (d->d1 >=0){
               switch(i){
                    case PITCH:
                         m->pitch=&statevariablearray[d->d1];
                         break;
                    case DURATION:
                         m->duration=&statevariablearray[d->d1];
                         break;
                    case VOLUME:
                         m->volume=&statevariablearray[d->d1];
                         break;

               }

               sprintf(mapbuf[mnum][i],"%s=%s",(char *)d->dp,(char *)connect_dialog[RCONNECT1+d->d1].dp);

            }
            else{
               sprintf(mapbuf[mnum][i],"%s=nothing",(char *)d->dp);
               switch(i){
                    case PITCH:
                         m->pitch=&constantvar;
                         break;
                    case DURATION:
                         m->duration=&constantvar;
                         break;
                    case VOLUME:
                         m->volume=&constantvar;
                         break;

               }
            }
   }

}


int  do_mconnect_dialog(int mnum){

   int ret=0;

   cureditmap=mnum;
   setconnectdialogto(mnum);

   centre_dialog(connect_dialog);
   ret=popup_dialog(connect_dialog,0);

   if(ret==CONNECTCANCEL||ret==-1){

           return ret;
   }
   setmapfromdialog(cureditmap);
   return ret;
}

#define LBG 8
char limitstring[16][120];
DIALOG seelimits_dialog[]={

   {d_box_proc,      0,   0,    260,  310,   255,  LBG,       0,   0,      0,   0,   NULL},

   {d_text_proc,     10,  30,    0,    0,    255,  3,       0,   0,      0,   0,   limitstring[0]},
   {d_text_proc,     10,  46,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[1]},
   {d_text_proc,     10,  62,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[2]},
   {d_text_proc,     10,  78,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[3]},
   {d_text_proc,     10,  94,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[4]},
   {d_text_proc,     10,  110,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[5]},
   {d_text_proc,     10,  126,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[6]},
   {d_text_proc,     10,  142,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[7]},
   {d_text_proc,     10,  158,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[8]},
   {d_text_proc,     10,  174,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[9]},
   {d_text_proc,     10,  190,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[10]},
   {d_text_proc,     10,  206,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[11]},
   {d_text_proc,     10,  222,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[12]},
   {d_text_proc,     10,  238,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[13]},
   {d_text_proc,     10,  254,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[14]},
   {d_text_proc,     10,  270,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[15]},

   { d_button_proc,  5,   5,    16,   16,    255,  0,         13,  D_EXIT, 0,   0,    "X" },
   { d_button_proc,  114, 290,  32,   16,    255,  0,         13,  D_EXIT, 0,   0,    "OK" },
   { NULL,           0,   0,    0,    0,    0,    0,       0,   0,      0,   0,    NULL }
};

int seelimits_proc(int msg, DIALOG *d, int c){
    int ret=d_button_proc(msg,d,c);
    if(ret==D_CLOSE){
          sprintf(limitstring[0], "variable        min      max ");
          sprintf(limitstring[1], "x            %7.2f  %7.2f",minx,maxx);
          sprintf(limitstring[2], "y            %7.2f  %7.2f",miny,maxy);
          sprintf(limitstring[3], "z            %7.2f  %7.2f",minz,maxz);
          sprintf(limitstring[4], "forward x    %7.2f  %7.2f",fminx,fmaxx);
          sprintf(limitstring[5], "forward y    %7.2f  %7.2f",fminy,fmaxy);
          sprintf(limitstring[6], "forward z    %7.2f  %7.2f",fminz,fmaxz);
          sprintf(limitstring[7], "up x         %7.2f  %7.2f",uminx,umaxx);
          sprintf(limitstring[8], "up y         %7.2f  %7.2f",uminy,umaxy);
          sprintf(limitstring[9], "up z         %7.2f  %7.2f",uminz,umaxz);
          sprintf(limitstring[10],"left x       %7.2f  %7.2f",lminx,lmaxx);
          sprintf(limitstring[11],"left y       %7.2f  %7.2f",lminy,lmaxy);
          sprintf(limitstring[12],"left z       %7.2f  %7.2f",lminz,lmaxz);
          sprintf(limitstring[13],"state length %7.2f  %7.2f",minlength,maxlength);
          sprintf(limitstring[14],"draw length  %7.2f  %7.2f",mindrawlength,maxdrawlength);
          sprintf(limitstring[15],"thickness    %7.2f  %7.2f",minthickness,maxthickness);
          centre_dialog(seelimits_dialog);
          popup_dialog(seelimits_dialog,-1);
          return D_O_K;
    }
    return ret;
}
int do_remap0(){
        do_mconnect_dialog(0);
        return D_O_K;
}

int do_remap1(){
        do_mconnect_dialog(1);
        return D_O_K;
}
int do_remap2(){
        do_mconnect_dialog(2);
        return D_O_K;
}
int do_remap3(){
        do_mconnect_dialog(3);
        return D_O_K;
}
int do_remap4(){
        do_mconnect_dialog(4);
        return D_O_K;
}
int do_remap5(){
        do_mconnect_dialog(5);
        return D_O_K;
}
int do_remap6(){
        do_mconnect_dialog(6);
        return D_O_K;
}
int do_remap7(){
        do_mconnect_dialog(7);
        return D_O_K;
}
int do_remap8(){
        do_mconnect_dialog(8);
        return D_O_K;
}
int do_remap9(){
        do_mconnect_dialog(9);
        return D_O_K;
}

float holddmultiplier;
int setdmult(void *dp3 __attribute__ ((unused)), int d2)
{
        DIALOG *dtext=&connect_dialog[DMULTTEXT];
        holddmultiplier=4.0*(float)(d2)/100;

        sprintf(connect_dialog[DMULTTEXT].dp,"%1.3f",holddmultiplier/4.0);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_edit_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);

        return(0);
}
float holdpspread;
int setpspread(void *dp3 __attribute__ ((unused)), int d2)
{
        DIALOG *dtext=&connect_dialog[PSPREADTEXT];

        holdpspread=-PSPREADMAX+2*PSPREADMAX*(float)(d2)/70;
        sprintf(connect_dialog[PSPREADTEXT].dp,"%1.3f",holdpspread);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_edit_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        unsavedmapchanges=1;
        return(0);
}
float holddspread;
int setdspread(void *dp3 __attribute__ ((unused)), int d2)
{
        DIALOG *dtext=&connect_dialog[DSPREADTEXT];

        holddspread=-DSPREADMAX+2*DSPREADMAX*(float)(d2)/70;

        sprintf(connect_dialog[DSPREADTEXT].dp,"%1.3f",holddspread);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_edit_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        unsavedmapchanges=1;
        return(0);
}

float holdvspread;
int setvspread(void *dp3 __attribute__ ((unused)), int d2)
{
        DIALOG *dtext=&connect_dialog[VSPREADTEXT];

        holdvspread=-VSPREADMAX+2*VSPREADMAX*(float)(d2)/70;

        sprintf(connect_dialog[VSPREADTEXT].dp,"%1.3f",holdvspread);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_edit_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        unsavedmapchanges=1;
        return(0);
}

int do_openrulefiledialog(){
     int fsret=1,alertret;
     char buf[100];
     while (fsret){
          fsret=popup_file_select("Load Rule File:", rulefile, "l;ls;lm");
          if(fsret==0) return 0;
          if(!exists(rulefile)){
               sprintf(buf, "Can't find %s", rulefile);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }

     return(1);
}

char seedstring[80]="";
char maxstringlengthstring[80]="";
/*   (dialog proc)           (x)    (y)    (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG numrecurse_dialog[] =
{
   {d_box_proc,               100,  100,   500,  270,   255,   0,       0,   0,      0,   0,   NULL},
   {d_text_proc,              110,  110,   0,    0,     255,   0,       0,   0,      0,   0,   rulefile},

   {d_text_proc,              400,  110,   0,    0,     255,   0,       0,   0,      0,   0,   "max production length:"},
   {d_edit_proc,              400,  125,   50,   16,    255,   8,       0 ,  0,     3,   0,   maxstringlengthstring},
   {d_text_proc,              460,  125,   0,    0,     255,   0,       0,   0,      0,   0,   "Megabytes"},

   {d_text_proc,              400,  150,   0,    0,     255,   0,       0,   0,      0,   0,   "Seed:"},
   {d_edit_proc,              450,  150,   60,   16,    255,   8,       0 ,  0,     10,   0,   seedstring},
   {d_check_proc,             400,  165,   116,   10,    255,   0,       0, D_SELECTED, 0, 0,   "Random Seed"},

   {d_text_proc,              110,  130,   0,    0,     255,   0,       0,   0,      0,   0,   "recursion depth:"},
   {d_edit_proc,              250,  130,   30,   16,    255,   8,       0 ,  0,      2,   0,   numrecursestring},


   {d_text_proc,              110,  150,   0,    0,     255,   0,       0,   0,      0,   0,   "basic angle:"},
   {d_edit_proc,              250,  150,   60,   16,    255,   8,       0 ,  0,      6,   0,   deltaanglestring},

   {d_text_proc,              110,  170,   0,    0,     255,   0,       0,   0,      0,   0,   "axiom:" },
   {d_textbox_proc,           110,  190,   480,  30,    255,   0,       0,   0,      0,   0,   NULL},

   {d_text_proc,              110,  230,   0,    0,     255,   0,       0,   0,      0,   0,   numrulesstring},
   {d_text_proc,              500,  230,   0,    0,     255, MUTATEDBG,       0,   D_HIDDEN,      0,   0,   "Mutated"},
   {d_textbox_proc,           110,  250,   480,  80,    255,   0,       0,   0,      0,   0,   NULL},


   {d_button_proc,            220,  350,   80,   16,    255,   0,       13,  D_EXIT, 0,   0,    "Continue" },


   {d_button_proc,            340,  350,   50,   16,    255,   0,       27,  D_EXIT, 0,   0,    "Stop" },


   { NULL,                    0,    0,     0,    0,     0,     0,       0,   0,      0,   0,    NULL }
};
#define RANDOMIZECHECK 7
#define AXIOMBOX 13
#define MUTATEDTEXT 15
#define RULESBOX 16
#define NUMRECURSECANCEL 18
/*   (dialog proc)           (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG rulesinfo_dialog[] =
{
   {d_box_proc,               80,  150,   500,  300, 255,   0,       0,   0,      0,   0,   NULL},
   {d_text_proc,              90,  160,   0,    0,   255,   0,       0,   0,      0,   0,   rulefile},

   {d_text_proc,              90,  180,   0,    0,   255,   0,       0,   0,      0,   0,   "recursion depth:"},
   {d_text_proc,              230, 180,   30,   16,  255,   0,       0 ,  0,      2,   0,   numrecursestring},

   {d_text_proc,              90,  200,   0,    0,   255,   0,       0,   0,      0,   0,   "basic angle:"},
   {d_text_proc,              230, 200,   50,   16,  255,   0,       0 ,  0,      5,   0,   deltaanglestring},

   {d_text_proc,              90,  220,   0,    0,   255,   0,       0,   0,      0,   0,   "axiom:"},
   {d_textbox_proc,           90,  240,   480,  30,  255,   0,       0,   0,      0,   0,   NULL},

   {d_text_proc,              90,  280,   0,    0,   255,   0,       0,   0,      0,   0,   numrulesstring},
   {d_text_proc,              500, 230,   0,    0,   255,   2,       0,   D_HIDDEN,      0,   0,   "Mutated"},
   {d_textbox_proc,           90,  300,   480,  80,  255,   0,       0,   0,      0,   0,   NULL},

   { d_button_proc,           230, 400,   30,   16,  255,   0,       13,  D_EXIT, 0,   0,    "OK" },


   { NULL,                    0,   0,     0,    0,   0,     0,       0,   0,      0,   0,    NULL }
};
#define RULESINFOAXIOMBOX 7
#define RULESINFOMUTATEDTEXT 9
#define RULESINFORULESBOX 10


DIALOG maxstringsize_dialog[] =
{
   {d_box_proc,               260,  30,   300,  65,   255,   0,       0,   0,      0,   0,   NULL},
   {d_text_proc,              280,  40,   0,    0,     255,   0,       0,   0,      0,   0,   "Maximum Production String Length:"},
   {d_edit_proc,              280,  55,   25,   16,    255,   8,       0 ,  0,      2,   0,   maxstringlengthstring},
   {d_text_proc,              320,  55,   0,    0,     255,   0,       0,   0,      0,   0,   "Megabytes"},

   {d_button_proc,            280,  75,   30,   16,    255,   0,       13,  D_EXIT, 0,   0,    "OK" },
   {d_button_proc,            320,  75,   50,   16,    255,   0,       27,  D_EXIT, 0,   0,    "Cancel" },


   { NULL,                    0,    0,     0,    0,     0,     0,       0,   0,      0,   0,    NULL }
};

#define MAXSTRINGSIZECANCEL 5
int do_maxstringsizedialog(){
    int dret;
    long tmsl;
    sprintf(maxstringlengthstring,"%ld",(maxstringlength/(1024*1024)));
    dret=popup_dialog(maxstringsize_dialog,2);

    if(dret==MAXSTRINGSIZECANCEL || dret==-1){
              return D_O_K;
    }


    tmsl=atoi(maxstringlengthstring);
    if(tmsl>=1){
            maxstringlength=1024*1024*(long)tmsl;
    }
    return D_O_K;

}


int getrules( char * rulefile){

   int maxlevel;

   formatline(rulefile);
   if(*rulefile =='\0')
                return -1;

   initrules();
   rulefilefp=fopen(rulefile,"r");
   if(rulefilefp==NULL){

          alert("File not found",NULL,NULL,"OK",NULL,13,0);
          return -1;
   }

   maxlevel=readrulefile(rulefilefp);
   if(maxlevel<0){

          allegroexiterror("Memory Allocation Error");

   }
   originalmutated=0;
   unsavedrulechanges=0;
   sprintf(numrecursestring,"%d",maxlevel);
   sprintf(deltaanglestring,"%3.2f",deltaangledeg);
   sprintf(numrulesstring,"transformation rules (%d):",numrules);
   fclose(rulefilefp);
   strcpy(rulefilename,get_filename(rulefile));
   changefileext(rulefile,productionfilename,"out");
   changefileext(rulefile,savemfname,"mid");
   changefileext(rulefile,mutatefilename,"lm");
   changefileext(get_filename(rulefile),productionname,"");
   changefileext(rulefile,inifile,"ini");

   return 0;
}


char * makerulesstring(){
     int i;
     int stringlength=0;

     for (i=0;i<numrules;i++)
          stringlength+=(strlen(rules[i])+2);
     if(rulesstring!=NULL)
         free(rulesstring);
     rulesstring=(char *)malloc(sizeof(char)*stringlength+1);

     if(rulesstring!=NULL){
         *rulesstring='\0';
         for (i=0;i<numrules;i++){
           strcat(rulesstring,rules[i]);
           strcat(rulesstring,"\n");
         }
     }

     return rulesstring;
}
int do_numrecursedialog(int recurse){

   int dret;
   long tmsl;
   if(recurse<0){
       numrecurse_dialog[RULESBOX].dp=makerulesstring();
       numrecurse_dialog[AXIOMBOX].dp=axiom;
       sprintf(maxstringlengthstring,"%ld",(maxstringlength/(1024*1024)));
       sprintf(seedstring,"%u",rstart);
       if(randomize_p){
              numrecurse_dialog[RANDOMIZECHECK].flags |= D_SELECTED;

       }
       else numrecurse_dialog[RANDOMIZECHECK].flags &= ~D_SELECTED;
       originalmutated ? (numrecurse_dialog[MUTATEDTEXT].flags &= ~D_HIDDEN):(numrecurse_dialog[MUTATEDTEXT].flags |= D_HIDDEN);
       centre_dialog(numrecurse_dialog);
       dret=popup_dialog(numrecurse_dialog,-1);

       if(dret==NUMRECURSECANCEL || dret==-1){
              return -1;
       }
       recurse=atoi(numrecursestring);

       deltaangledeg=atof(deltaanglestring);
       rstart=(unsigned)atoi(seedstring);
       if(numrecurse_dialog[RANDOMIZECHECK].flags & D_SELECTED){
           randomize_p=1;
       }
       else {
            randomize_p=0;
            lastseed=rstart;
       }
       tmsl=atoi(maxstringlengthstring);
       if(tmsl>=1){
            maxstringlength=1024*1024*(long)tmsl;
       }

   }

   return recurse;
}
char productionlengthstring[24]="";
int saveproduction_proc(int msg, DIALOG *d, int c);
/*   (dialog proc)           (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG viewprod_dialog[] =
{
   {d_box_proc,               0,  0,   480,  300,   255,   4,       0,   0,      0,   0,   NULL},
   {d_text_proc,              200,2,   0,    0,     255,   4,       0,   0,      0,   0,  productionname},
   {d_textbox_proc,           0,  15,  480,  255,   255,   0,       0,   D_SELECTED,      0,   0,   NULL},

   {rulesinfo_proc,           5,  280, 100,   16,    255,   0,       'r',  D_EXIT,  0,   0,    "&Rules info" },
   {saveproduction_proc,      120,280, 130,   16,    255,   0,       's',  D_EXIT,  0,   0,    "&Save Production" },
   {d_button_proc,            5,  2,   10,    10,    255,   0,       13,  D_EXIT,  0,   0,    "X" },

   {d_text_proc,              300,280,   0,    0,     255,   4,       0,   0,      0,   0,  productionlengthstring},
   { NULL,              0,    0,   0,    0,    0,    0,       0,    0,      0,   0,    NULL }
};
#define PRODUCTIONTEXT 2

char *emptyproduction="(empty)";
int do_viewproduction(){
        long prodlen=strlen(production);
        production[prodlen]='\n';
        if(prodlen>0)
          viewprod_dialog[PRODUCTIONTEXT].dp=production;
        else
          viewprod_dialog[PRODUCTIONTEXT].dp=emptyproduction;
        sprintf(productionlengthstring,"Length: %ld",prodlen);
        centre_dialog(viewprod_dialog);
        popup_dialog(viewprod_dialog,1);
        production[prodlen]='\0';
        return D_O_K;
}


int rulesinfo_proc(int msg, DIALOG *d, int c){
      int ret=d_button_proc(msg,d,c);
      if(ret==D_CLOSE){
        rulesinfo_dialog[RULESINFOAXIOMBOX].dp=axiom;
        rulesinfo_dialog[RULESINFORULESBOX].dp=makerulesstring();
        originalmutated ? (rulesinfo_dialog[RULESINFOMUTATEDTEXT].flags &= ~D_HIDDEN):(rulesinfo_dialog[MUTATEDTEXT].flags |= D_HIDDEN);
        centre_dialog(rulesinfo_dialog);
        popup_dialog(rulesinfo_dialog,-1);
        return D_O_K;
      }
      return ret;
}
void redrawbuttons(){
     int i;
     show_mouse(NULL);
     for (i=PROCLOADBUT;i<=PROCQUITBUT;i++){
          d_icon_proc(MSG_DRAW,&(dialog1[i]),0);
     }
     show_mouse(screen);
}

int makeaborted;
int makefailed;
int loadnewrules(){

   int alertret=0;
   int obj;
   if(unsavedrulechanges){
          alertret=alert3("Unsaved rule changes","Do you want to save?","","Save","Don't save","Cancel",13,0,0);
          if(alertret==1)
                         saverulesas();
          else if(alertret==3){
                         makeaborted=1;
                         return D_O_K;
          }
   }

   makeaborted=0;
   makefailed=0;
   if(do_openrulefiledialog()==0){
                makeaborted=1;
                return D_O_K;
   }
   production_menu[PRODMAKE].flags |= D_DISABLED;
   production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
   production_menu[PRODINTERP].flags |= D_DISABLED;
   dialog1[PROCMAKEBUT].flags |= D_DISABLED;
   dialog1[PROCINTERPBUT].flags |= D_DISABLED;
   dialog1[PROCREMAPBUT].flags |= D_DISABLED;

   if(getrules(rulefile)==-1){
                makeaborted=1;
                return D_O_K;
   }
   dialog1[DIALOG1RULES].bg=UNCHANGEDBG;
   edit_menu[EDITEDIT].flags &= ~D_DISABLED;
   dialog1[PROCEDITBUT].flags &= ~D_DISABLED;
   topmenu[TOPMUTATE].flags &= ~D_DISABLED;
   mutate_menu[MUTATEMUTATE].flags &= ~D_DISABLED;
   mutate_menu[MUTATEREMAKE].flags &= ~D_DISABLED;
   dialog1[PROCMUTATEBUT].flags &= ~D_DISABLED;
   dialog1[PROCMUTANDBUT].flags &= ~D_DISABLED;
   mutate_menu[MUTATESAVE].flags |= D_DISABLED;

   production_menu[PRODMAKE].flags &= ~D_DISABLED;
   production_menu[PRODREMAKE].flags &= ~D_DISABLED;
   production_menu[PRODSAVERULES].flags &= ~D_DISABLED;
   dialog1[PROCMAKEBUT].flags &= ~D_DISABLED;
   dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;
   dialog1[PROCSAVERULESBUT].flags &= ~D_DISABLED;

   dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
   return D_O_K;
}
int do_makeproduction(){
   int recurse=-1;
   int makeret=0;
   makeaborted=0;
   makefailed=0;

   recurse=do_numrecursedialog(recurse);
   set_mouse_sprite(waitmouseb);

   makeret=makeproduction(recurse);

   if(makeret<0){
           set_mouse_sprite(NULL);
           showprocessstatus("");
           alert("production failed",productionmessage,NULL,"OK",NULL,13,0);
           makefailed=1;
   }
   else if(makeret==1 || recurse<0) {
           set_mouse_sprite(NULL);
           showprocessstatus("");
           alert("production aborted",NULL,NULL,"OK",NULL,13,0);
           makeaborted=1;
           production_menu[PRODINTERP].flags &= ~D_DISABLED;
           dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;
           production_menu[PRODMAKE].flags &= ~D_DISABLED;
           dialog1[PROCMAKEBUT].flags &= ~D_DISABLED;

   }
   else {
       production_menu[PRODINTERP].flags &= ~D_DISABLED;
       dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

   }
   set_mouse_sprite(NULL);
   showprocessstatus("");
   redrawbuttons();

   return D_O_K;
}
int do_remakeproduction(){
   int recurse=-1;
   int makeret=0;
   makeaborted=0;
   makefailed=0;

   recurse=do_numrecursedialog(recurse);

   show_mouse(screen);
   set_mouse_sprite(waitmouseb);

   makeret=makeproduction(recurse);

   if(makeret<0){
           set_mouse_sprite(NULL);
           showprocessstatus("");
           alert("production failed",productionmessage,NULL,"OK",NULL,13,0);
           makefailed=1;
   }
   else if(makeret==1 || recurse<0) {
           set_mouse_sprite(NULL);
           showprocessstatus("");
           alert("production aborted",NULL,NULL,"OK",NULL,13,0);
           production_menu[PRODREMAKE].flags &= ~D_DISABLED;
           production_menu[PRODSAVERULES].flags &= ~D_DISABLED;       
           production_menu[PRODINTERP].flags &= ~D_DISABLED;
           dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;
           dialog1[PROCSAVERULESBUT].flags &= ~D_DISABLED;
           dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

           makeaborted=1;
   }
   else {
       production_menu[PRODREMAKE].flags &= ~D_DISABLED;
       production_menu[PRODSAVERULES].flags &= ~D_DISABLED;
       production_menu[PRODINTERP].flags &= ~D_DISABLED;

       dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;
       dialog1[PROCSAVERULESBUT].flags &= ~D_DISABLED;
       dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

   }
   set_mouse_sprite(NULL);
   showprocessstatus("");
   redrawbuttons();

   return D_O_K;
}
FILE *readprod_fp;
int do_productionfiledialog(){
     int fsret=1,alertret;
     char buf[100];
     while (fsret){
          fsret=popup_file_select("Get Production File:", productionfilename, "out");
          if(fsret==0) return 0;
          if(!exists(productionfilename)){
               sprintf(buf, "Can't find %s", productionfilename);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }

     return(1);
}


int do_getproduction(){
   long plength=0L;
   char *ptr;

   long maxlen=maxstringlength-10L;
   int c;

   if(production==NULL){

      production=(char *)malloc(maxstringlength);
      if(production==NULL){
                    sprintf(productionmessage,"Memory Allocation Error");
                    alert(productionmessage,NULL,NULL,"OK",NULL,13,0);
                    return D_O_K;

      }
      
   }
   ptr=production;
   if(do_productionfiledialog()==0){

       return D_O_K;
   }
   else{
       readprod_fp=fopen(productionfilename,"r");
       if(readprod_fp==NULL){
              return D_O_K;
       }
       while( (c=fgetc(readprod_fp))!=EOF){
              *ptr=c;
               ptr++;
               plength++;
               if(plength>maxlen){
                     alert("Out of string space",NULL,NULL,"OK",NULL,13,0);
                     return D_O_K;
               }
       }
       fclose(readprod_fp);
       *ptr='\0';

   }
   changefileext(productionfilename,savemfname,"mid");
   changefileext(get_filename(productionfilename),productionname,"");

   production_menu[PRODINTERP].flags &= ~D_DISABLED;
   dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;


   return D_O_K;
}


int do_makeandinterpret(){
    int mret;
    int loadrulesret;
    loadrulesret=loadnewrules();
    if (makeaborted !=0)
        return D_O_K;
    mret=do_makeproduction();
    if (mret!=D_O_K) return mret;
    if(makeaborted==0 && makefailed==0){

          do_interpret();

    }
    return D_O_K;


}
int do_remakeandinterpret(){
    int mret=do_remakeproduction();
    if (mret!=D_O_K) return mret;
    if(makeaborted==0 && makefailed==0){

          do_interpret();

    }
    return D_O_K;


}
DIALOG aritherrorhelp_dialog[] =
{
   {d_box_proc,               180,  240,   360,   160,   255,   0,       0,   0,      0,   0,   NULL},
   {d_textbox_proc,           200,  242,   330,   130,   255,   0,       0,   0,       0,   0,  NULL},

   { d_button_proc,           200,  380,   30,   16,   255,  0,       13,  D_EXIT,  0,   0,    "OK" },
   { NULL,              0,    0,   0,    0,    0,    0,       0,    0,      0,   0,    NULL }
};
#define ARITHTEXTBOX 1

int do_aritherrorhelp(){

         aritherrorhelp_dialog[ARITHTEXTBOX].dp=curstatestring;

         popup_dialog(aritherrorhelp_dialog,-1);

         return 0;
}
#include <float.h>
int do_interpret(){

   int interpretret=0;

   int alertret;

   deltaanglerad = DEG2RAD(deltaangledeg);
   maxx=0;maxy=0;maxz=0;minx=0;miny=0;minz=0;
   fmaxx=0;fmaxy=0;fmaxz=0;fminx=0;fminy=0;fminz=0;
   umaxx=0;umaxy=0;umaxz=0;uminx=0;uminy=0;uminz=0;
   lmaxx=0;lmaxy=0;lmaxz=0;lminx=0;lminy=0;lminz=0;

   maxlength=10;
   minlength=10;
   maxdrawlength=10;
   mindrawlength=10;

   maxthickness=thick;
   minthickness=thick;
   numobjects=0;

   production_menu[PRODPLAY].flags |= D_DISABLED;
   production_menu[PRODSAVE].flags |= D_DISABLED;
   production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
   dialog1[PROCPLAYBUT].flags |= D_DISABLED;
   dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
   dialog1[PROCREMAPBUT].flags |= D_DISABLED;
   redrawbuttons();

   if(randomize_p)
         rstart = makeseed();
   srand(rstart);
   set_mouse_sprite(waitmouseu);
   showprocessstatus("Finding Interpret Limits");

   interpretret=interpret(0);

   set_mouse_sprite(NULL);
   showprocessstatus("");
   if( interpretret <= INTERPRETARITHERROR){
        alertret=alert3("Arithmetic error while interpreting.","Have to quit.",NULL,"OK","Rats!","Help",13,0,'h');
        if(alertret==3)
                       do_aritherrorhelp();
        if(interpretret==INTERPRETARITHERROR){
        /* with signal set in interpret(), we should never get in here*/
#ifdef EXITONARITHERROR

           allegro_exit();
           print_curstate();
           exit(0);
#endif
        }
        _clear87();/*???*/
        return D_O_K;
   }
   else if(interpretret==INTERPRETFILEERROR){
        production_menu[PRODINTERP].flags |= D_DISABLED;
        production_menu[PRODREMAKE].flags |= D_DISABLED;
        dialog1[PROCINTERPBUT].flags |= D_DISABLED;
        dialog1[PROCREMAKEBUT].flags |= D_DISABLED;
        alert("Production file error","","... Quitting","OK",NULL,13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETABORT){
        alert("Interpret aborted","(too soon to have anything to play)",NULL,"OK",NULL,13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETSTACKOVERFLOW){
        alert("Interpret failed","Stack full!","","OK","What the hell?",13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETSTACKUNDERFLOW){
        alert("Interpret failed","Pop from empty stack","","OK","What the hell?",13,0);
        return D_O_K;
   }

   if( numobjects == 0){
        alert("No objects. Done.",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }

   production_menu[PRODINTERPREMAP].flags &= ~D_DISABLED;
   dialog1[PROCREMAPBUT].flags &= ~D_DISABLED;
   redrawbuttons();
   return do_interpretremap();
}


int do_interpretremap(){
   int i;
   int obj;

   int playonabort;
   int interpretret;
   int alertret;
   int connectret;

   connectret=do_mconnect_dialog(0);
   if(connectret==-1||connectret==CONNECTCANCEL)
         return D_O_K;

   if(getdrawinglimits()<0){
        alert("Object has 0 size",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }
   production_menu[PRODPLAY].flags |=  D_DISABLED;
   production_menu[PRODSAVE].flags |=  D_DISABLED;
   dialog1[PROCPLAYBUT].flags |= D_DISABLED;
   dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
   redrawbuttons();

   for(i=0;i<MAXTRACKS;i++){
                  free_midi_note_list( tracklist[i] );
                  tracklist[i]=NULL;
   }
   if(draw_p){
     show_mouse(NULL);

     dialog_message(&dialog1[DRAWBOX],MSG_DRAW,0,&obj);
     dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
     show_mouse(NULL);
     rectfill(screen,drawleftx-4,drawbottomy+4,drawrightx+4,drawtopy-4,19);
     rectfill(screen,drawleftx-2,drawbottomy+2,drawrightx+2,drawtopy-2,DRAWBG);

     show_mouse(screen);
   }
   deltaanglerad = DEG2RAD(deltaangledeg);
   srand(rstart);
   set_mouse_sprite(waitmouset);
   showprocessstatus("Interpreting");

   interpretret=interpret(1);

   set_mouse_sprite(NULL);
   showprocessstatus("");
   if(interpretret <= INTERPRETARITHERROR){

      alertret=alert3("Arithmetic error while interpreting.","Have to quit.",NULL,"OK","Rats!","Help",13,0,'h');
      if(alertret==3)
                       do_aritherrorhelp();
      if(interpretret==INTERPRETARITHERROR){
      /* with signal set in interpret(), we should never get in here*/
#ifdef EXITONARITHERROR
         allegro_exit();
         print_curstate();
         exit(0);
#endif
      }
      _clear87();
      return D_O_K;

   }
   else if(interpretret==INTERPRETFILEERROR){

        alert("Production file error","","... Quitting","OK",NULL,13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETABORT){
        playonabort=2;
        if(autoplay){
            playonabort=alert("Interpret aborted","Play anyway?","","Yes","No",'y','n');
        }
        production_menu[PRODPLAY].flags &= ~D_DISABLED;
        production_menu[PRODSAVE].flags &= ~D_DISABLED;
        production_menu[PRODINTERP].flags &= ~D_DISABLED;
        production_menu[PRODREMAKE].flags &= ~D_DISABLED;

        dialog1[PROCPLAYBUT].flags &= ~D_DISABLED;
        dialog1[PROCSAVEMIDIBUT].flags &= ~D_DISABLED;
        dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;
        dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;

        strcpy(playrulefilename,rulefilename);
        redrawbuttons();

        if(playonabort==2) return D_O_K;
   }
   production_menu[PRODPLAY].flags &= ~D_DISABLED;
   production_menu[PRODSAVE].flags &= ~D_DISABLED;
   production_menu[PRODINTERPREMAP].flags &= ~D_DISABLED;
   production_menu[PRODINTERP].flags &= ~D_DISABLED;
   production_menu[PRODREMAKE].flags &= ~D_DISABLED;

   dialog1[PROCPLAYBUT].flags &= ~D_DISABLED;
   dialog1[PROCSAVEMIDIBUT].flags &= ~D_DISABLED;
   dialog1[PROCREMAPBUT].flags &= ~D_DISABLED;
   dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;
   dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;


   strcpy(playrulefilename,rulefilename);
   if( maxcumtime == 0){
        alert("Total time of piece is 0. Done.",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }
   redrawbuttons();
   if(autoplay)
       return (do_testplay());
   return D_O_K;
}

int do_testplay(){
#ifdef NOTALWAYSSOUND
   char message1[80];
   char message2[80];
#endif
   do_stopmidifile();
   timertempo(tempo);
#ifdef NOTALWAYSSOUND
   if(!soundoff){
      if (install_sound(soundcard, midicard, "") != 0) {
   
         sprintf(message1,"Error initializing sound system for LMUSe");, allegro_error);
         sprintf(message2,"%s", allegro_error);
         alert(message1,message2,NULL,"OK",NULL,13,0);
      }
      else
         load_midi_patches();
   }
#endif

   popup_dialog(play_dialog,-1);

#ifdef NOTALWAYSSOUND
   if(!soundoff) remove_sound();
#endif

   return D_O_K;
}

DATAFILE * Data1;

void setup_processbuttons();
int readinifile();
int quiet=FALSE;


int main(int argc,char *argv[]){

   char *datafilepath=NULL;
   int numargs=argc-1;
   char argvbuf[80];
   char message1[80],message2[80];
   char *aptr;
   int recurse;
   int ret;
   int i,j,n;
   int useinifile=0;
   strcpy(scalenamestring,scalenames[1]);
   strcpy(scalefnnamestring,scalefnnames[0]);
   pitchvariable=statevariablearray[X_VAR];
   durationvariable=statevariablearray[DRAWLENGTH_VAR];
   velocityvariable=statevariablearray[FX_VAR];

   for(i=0;i<MAXMAPS;i++){
        maps[i].pitch=&statevariablearray[X_VAR];
        maps[i].duration=&statevariablearray[DRAWLENGTH_VAR];
        maps[i].volume=&statevariablearray[FX_VAR];
        maps[i].pspread=pspread;
        maps[i].dspread=dspread;
        maps[i].vspread=vspread;
        maps[i].scale=(scales[1]);
        strcpy(maps[i].scalename,scalenames[1]);
        maps[i].scalefn=scalefunctions[0];
        maps[i].dmultiplier=dmultiplier;
        maps[i].tstack=transposestack_p;
        maps[i].fstacks=factstacks_p;
        maps[i].transpose=0;
        for(j=0;j<NUMLCONNECT;j++){
            *mapbuf[i][j]='\0';
        }
   }

   for(n = 1; n<=numargs;n++) {
        strcpy(argvbuf,argv[n]);
        strupr(argvbuf);
        aptr=argvbuf;
        if (*aptr == '-'){
             aptr++;
             if(*aptr=='S'){
                aptr++;
                maxstringlength = 1024*atoi(aptr);
             }
             /**/
             else if(*aptr=='D'){
                aptr++;
                soundcard = atoi(aptr);
             }
             else if(*aptr=='M'){
                aptr++;
                midicard = atoi(aptr);
             }
             else if(*aptr=='W'){
                aptr++;
                writeparameters_p = atoi(aptr);
                if(writeparameters_p){

                    options_menu[WRITEPARAMETERSTOGGLE].flags |= D_SELECTED;
                }
                else{

                    options_menu[WRITEPARAMETERSTOGGLE].flags &= ~D_SELECTED;
                }
             }
             else if(*aptr=='I'){
                aptr++;
                useinifile=1;
                if(*aptr)
                   strcpy(inifile,aptr);
             }
             else if(*aptr=='Q'){
                aptr++;
                quiet=TRUE;
                soundcard=DIGI_NONE;
                midicard=MIDI_NONE;

             }
        }
   
   }
   if(useinifile)
                  readinifile();
   readconfigfile();
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   LOCK_VARIABLE(int_t1);
   LOCK_FUNCTION(t_int1);

   randomize();
   rstart = makeseed();
   lastseed=rstart;
   initrules();

   Mf_error=allegroexiterror;

   vw = XY;

   recurse = -1;

   if(set_gfx_mode(GFX_AUTODETECT, DEF_SCREENWIDTH, DEF_SCREENHEIGHT, 0, 0)!=0){
         printf("Error initializing graphics for LMUSe\n%s\n",allegro_error);
         exit(1);

   }
   datafilepath = getenv("LMUSDATA");
   if (datafilepath == NULL) datafilepath = "lmus.dat";
   Data1=load_datafile(datafilepath);
   if(Data1 !=NULL){
            set_palette(Data1[PAL1].dat);

            rectfill(screen, 0, 0, DEF_SCREENWIDTH-1,DEF_SCREENHEIGHT-1, EMPTYBG);
            maxcolor=255;
            waitmouseb=Data1[WAITMOUSEB].dat;
            waitmousep=Data1[WAITMOUSEP].dat;
            waitmouset=Data1[WAITMOUSET].dat;
            waitmouseu=Data1[WAITMOUSEU].dat;
            pointup=Data1[POINTUP].dat;
            lmtitle=Data1[LMTITLE].dat;
            font=Data1[THEFONT].dat;
            setup_processbuttons();
   }
   else {

      allegro_exit();
      printf("\nLMUSe couldn't load the data file LMUS.DAT.\n");
      printf("Check that LMUS.DAT exists, and that you are either\n");
      printf("running LMUSe from the same directory that LMUS.DAT is in,\n");
      printf("or that the environmental variable LMUSDATA is set to\n");
      printf("the location of LMUS.DAT. \ne.g.\n\tSET LMUSDATA=C:\\LMUSE\\LMUS.DAT\n");

      exit(1);
   }


   /* install a MIDI sound driver */
   if(!soundoff){
      if (install_sound(soundcard, midicard, argv[0]) != 0) {
         soundcard=DIGI_NONE;
         midicard=MIDI_NONE;

         //allegro_exit();
         sprintf(message1,"Error initializing sound system for LMUSe");
         sprintf(message2,"%s", allegro_error);
         soundoff=1;

         //exit(1);
      }
#ifdef NOTALWAYSSOUND
      else
          remove_sound();
#else
      if(!soundoff)
          load_midi_patches();
#endif
   }
   if (midicard==MIDI_NONE){
        options_menu[SOUNDTOGGLE].flags &= ~D_SELECTED;
        soundoff=1;
   }
   else{
        options_menu[SOUNDTOGGLE].flags |= D_SELECTED;
        soundoff=0;
   }
   options_menu[DRAWTOGGLE].flags |= D_SELECTED;
   options_menu[AUTOPLAYTOGGLE].flags |= D_SELECTED;
   if(writeparameters_p)
      options_menu[WRITEPARAMETERSTOGGLE].flags |= D_SELECTED;
   else
      options_menu[WRITEPARAMETERSTOGGLE].flags &= ~D_SELECTED;
   set_mouse_speed(1, 1);


   sprintf(introinfo1,"version %s, %s",PROGRAMVERSION,VERSIONDATE);
   intro_dialog[INTROLOGOBMP].dp=lmtitle;
   centre_dialog(intro_dialog);
   position_mouse(intro_dialog[INTROOKBUTTON].x+intro_dialog[INTROOKBUTTON].w/2,intro_dialog[INTROOKBUTTON].y+intro_dialog[INTROOKBUTTON].h/2);
   ret=do_dialog(intro_dialog,-1);

   ret=do_dialog(dialog1,-1);

   for(i=0;i<MAXTRACKS;i++)
           free_midi_note_list( tracklist[i] );
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   exit(0);
}

int soundtoggle(){

   char message1[80];
   char message2[80];
   if (options_menu[SOUNDTOGGLE].flags & D_SELECTED){
       options_menu[SOUNDTOGGLE].flags &= ~D_SELECTED;
#ifndef NOTALWAYSSOUND
       remove_sound();
#endif
       soundoff=1;
   }
   else{
       options_menu[SOUNDTOGGLE].flags |= D_SELECTED;
       midicard=MIDI_AUTODETECT;
       soundcard=DIGI_AUTODETECT;

       if (install_sound(soundcard, midicard, NULL) != 0) {
    
          sprintf(message1,"Error initializing sound.");
          sprintf(message2,"%s",allegro_error);
          alert(message1,message2,NULL,"OK",NULL,13,0);
          options_menu[SOUNDTOGGLE].flags &= ~D_SELECTED;
#ifndef NOTALWAYSSOUND
          remove_sound();
#endif
          soundoff=1;
          return D_O_K;
       }
#ifdef NOTALWAYSSOUND
       remove_sound();
#else
       load_midi_patches();
#endif
       soundoff=0;
   }
   return D_O_K;
}

int drawtoggle(){
   if (options_menu[DRAWTOGGLE].flags & D_SELECTED){
       options_menu[DRAWTOGGLE].flags &= ~D_SELECTED;
       draw_p=0;
   }
   else{
       options_menu[DRAWTOGGLE].flags |= D_SELECTED;
       draw_p=1;
   }
   return D_O_K;
}
int autoplaytoggle(){
   if (options_menu[AUTOPLAYTOGGLE].flags & D_SELECTED){
       options_menu[AUTOPLAYTOGGLE].flags &= ~D_SELECTED;
       autoplay=0;
   }
   else{
       options_menu[AUTOPLAYTOGGLE].flags |= D_SELECTED;
       autoplay=1;
   }
   return D_O_K;
}
int writeparameterstoggle(){
   if (options_menu[WRITEPARAMETERSTOGGLE].flags & D_SELECTED){
       options_menu[WRITEPARAMETERSTOGGLE].flags &= ~D_SELECTED;
       writeparameters_p=0;
   }
   else{
       options_menu[WRITEPARAMETERSTOGGLE].flags |= D_SELECTED;
       writeparameters_p=1;
   }
   return D_O_K;
}

int quitting=0;
int quitter()
{
   int ret;
   quitting=1;
   if(unsavedrulechanges || unsavedmapchanges){
       ret=alert3("Really want to quit?",NULL,"(Changes not saved)", "Yes, quit","Save, then quit","Cancel",'y','s',27);
       if (ret==1){
           return D_CLOSE;
       }
       else if(ret==2){
            if(unsavedrulechanges)
                 saverulesas();
            if(unsavedmapchanges)
                 saveinifile();
            if(quitting)
               return D_CLOSE;
       }

   }
   else {
       ret=alert("Really want to quit?", NULL,NULL, "Yes", "Cancel", 'y', 27);
       if (ret==1)
          return D_CLOSE;
   }
   quitting=0;
   return D_O_K;
}




char * changefileext(char * origfilename,char * newfilename, char * newext){

        char * extptr;
        if(*origfilename&& origfilename !=NULL){
           strcpy (newfilename,origfilename);
           extptr=get_extension(newfilename);
           *extptr='\0'; /*chop off the extension*/
           strcat(newfilename,newext);
           return (newfilename);
        }
        else return (NULL);
}

int writeparameters2miditext(){
        char textbuf1[612];
        char textbuf2[612];
        long sz;

        sprintf (textbuf1,"LMUSe v%s: %s %s: ",PROGRAMVERSION,get_filename(rulefile), originalmutated?"(mutated)":"");

        sprintf(textbuf2,"recursions=%s, angle=%3.2f, Map file: %s ",numrecursestring,deltaangledeg,get_filename(inifile));

        strcat(textbuf1,textbuf2);

        sz=strlen(textbuf1);
        mf_write_meta_event(0L, text_event, textbuf1, sz);

        return 0;
}
int writetracklist (int whichtrack)
{

        MIDINOTELIST * L,* next_node,* first_node;
        MIDICHANEVENT m;
        int n,tracknumber;
        unsigned char stat;
        unsigned char channel;
	unsigned char data1[2]/*,data2[2]*/;
	long t,cum_time,holdt=0;
	unsigned char lastprog=-1;

	if(whichtrack==0){
                if(writeparameters_p)
                    writeparameters2miditext();
		mf_write_tempo((long)mtempo);
		return(1);
	}

        whichtrack=whichtrack-1;
        n=0;
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
             if(trackflags[tracknumber]&ACTIVE){
                  if(n==whichtrack){
                        whichtrack=tracknumber;
                        break;
                  }
                  else n++;
             }

        }
        channel=trackchannel[whichtrack];

        L=tracklist[whichtrack];
        first_node=L;
        next_node=L->next;
        n=0;
        cum_time=0L;
        holdt=0L;
	while( L!=NULL){

               m=L->m;
               t=m.t;
               stat=m.status&0xF0;

               data1[0]=m.data1;
               data1[1]=m.data2;
               if(stat==PRG_CHG){ /*we made lots of extra prg_chg events*/
                     if(lastprog!=data1[0]){
                         mf_write_midi_event(t+holdt,stat,channel,data1 ,1L);
                         lastprog=data1[0];
                         holdt=0L;
                     }
                     else holdt+=t;
               }
               else if(stat==NOTEON||stat==NOTEOFF){
                  mf_write_midi_event(t+holdt, stat, channel, data1, 2L);
                  holdt=0L;
               }
               else holdt+=t; /*some event we are not saving */

               L=L->next;
               n++;
	}
	return n;
}/*end writetracklist()*/
int do_savefiledialog(char * message,char * filenamebuf, char * ext){
/* returns 0 for cancel, returns 1 for continue saving process*/
     int fsret=1,alertret;
     char buf[100];

     while (fsret){
          fsret=popup_file_select(message, filenamebuf, ext);
          if(fsret==0) return 0;
          if(exists(filenamebuf)){
               sprintf(buf, "%s already exists, overwrite?", filenamebuf);
               alertret=alert3(buf, NULL, NULL, "Yes", "No","Cancel", 'y','n', 27) ;
               if(alertret==1) break;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }
     return(1);
}
int saveproduction(){
        int dret=do_savefiledialog("Save production as:",productionfilename,"out");
        FILE *prod_fp;
        if(dret>0){
              if((prod_fp = fopen(productionfilename,"w")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   fputs(production,prod_fp);
                   fclose(prod_fp);
              }
        }
        return D_O_K;
}

int saveproduction_proc(int msg, DIALOG *d, int c){
    int sret;
    int ret=d_button_proc(msg, d, c);
    if(ret==D_CLOSE){
           sret=saveproduction();
           return D_O_K;
    }
    return(ret);
}
int savemidi_proc(int msg, DIALOG *d, int c){
        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           ret=savemidi();
        }
        return(ret);
}

int savemidi(){

        int tracknumber;
        int dret;
        int numtracks=0;
        long holdt1=int_t1;

        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
               if(trackflags[tracknumber]&ACTIVE)
                      numtracks++;
               all_notes_off(trackchannel[tracknumber]);
        }
        dret=do_savefiledialog("Save as MIDI file as:", savemfname,"mid");
        if(dret>0){
              if((savemf_fp = fopen(savemfname,"wb")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   Mf_putc = myputc;
                   Mf_writetrack=writetracklist;

                   mfwrite(1,numtracks+1,division,savemf_fp);
                   fclose(savemf_fp);
              }

        }
        int_t1=holdt1;

        return(D_O_K);
}

int do_dosshell(){
   char message1[80];
   char message2[80];
   BITMAP * holdscreen;

   holdscreen=create_bitmap(SCREEN_W,SCREEN_H);
   if(holdscreen!=NULL){
          show_mouse(NULL);
          clear(holdscreen);
          blit(screen,holdscreen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
          show_mouse(screen);
   }
   allegro_exit();

   system("command");
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   set_gfx_mode(GFX_AUTODETECT, DEF_SCREENWIDTH, DEF_SCREENHEIGHT, 0, 0);

   if(Data1 !=NULL){
      set_palette(Data1[PAL1].dat);
   }
   else
      set_palette(desktop_palette);

   if(holdscreen!=NULL){
       blit(holdscreen,screen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
       destroy_bitmap(holdscreen);
   }
   else{
       clear(screen);

       rectfill(screen,0,0,SCREEN_W,SCREEN_H,BG1);
   }

   /* install a MIDI sound driver */
   if(options_menu[SOUNDTOGGLE].flags & D_SELECTED){
       if (install_sound(soundcard, midicard, NULL)) {
              sprintf(message1,"Error initializing sound.");
              sprintf(message2,"%s",allegro_error);
              alert(message1,message2,NULL,"OK",NULL,13,0);
              options_menu[SOUNDTOGGLE].flags &= ~D_SELECTED;
              remove_sound();
    
       }
       else{
#ifdef NOTALWAYSSOUND
              remove_sound();
#else
              load_midi_patches();
#endif
       }
   }
   set_mouse_speed(1, 1);
   return D_O_K;
}

int do_edit(char *filename){
   BITMAP * holdscreen;
   char commandbuf[200];
   char message1[80];
   char message2[80];
   if(!exists(editor)){

        geteditor();
        if(!exists(editor))
            return -1;
   }
   sprintf(commandbuf,"%s ",editor);
   if( *(get_filename(filename)) != '\0' ){
       strcat(commandbuf,filename);
   }

   holdscreen=create_bitmap(SCREEN_W,SCREEN_H);
   if(holdscreen!=NULL){
          show_mouse(NULL);
          clear(holdscreen);
          blit(screen,holdscreen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
          show_mouse(screen);
   }
   
   allegro_exit();

   system(commandbuf);

   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   set_gfx_mode(GFX_AUTODETECT, DEF_SCREENWIDTH, DEF_SCREENHEIGHT, 0, 0);

   if(Data1 !=NULL){
      set_palette(Data1[PAL1].dat);
   }
   else
      set_palette(desktop_palette);

   if(holdscreen!=NULL){
       blit(holdscreen,screen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
       destroy_bitmap(holdscreen);
   }
   else{
       clear(screen);

       rectfill(screen,0,0,SCREEN_W,SCREEN_H,BG1);
   }

   if(options_menu[SOUNDTOGGLE].flags & D_SELECTED){
       if (install_sound(soundcard, midicard, NULL)) {
              sprintf(message1,"Error initializing sound.");
              sprintf(message2,"%s",allegro_error);
              alert(message1,message2,NULL,"OK",NULL,13,0);
              options_menu[SOUNDTOGGLE].flags &= ~D_SELECTED;
              remove_sound();    
       }
       else{
#ifdef NOTALWAYSSOUND
              remove_sound();
#else
              load_midi_patches();
#endif
       }
   }
   set_mouse_speed(1, 1);

   return 0;
}
int editrulefile(){
     int ret,makeret;
     int obj;
     char buf1[120];

     if(do_edit(rulefile)==-1) return D_O_K;
     if(*(get_filename(rulefile))!='\0'){
         sprintf(buf1,"Reload %s",get_filename(rulefile));
         ret=alert3(NULL,NULL,NULL,buf1,"Cancel","New Rule File",13,0,'n');
     }
     else{
        ret=alert(NULL,NULL,NULL,"Load Rule File","Cancel",13,0);
        if (ret==1) ret=3;
     }
     if(ret==2) return D_O_K;

     production_menu[PRODPLAY].flags |= D_DISABLED;
     production_menu[PRODSAVE].flags |= D_DISABLED;
     production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
     production_menu[PRODINTERP].flags |= D_DISABLED;
     production_menu[PRODREMAKE].flags |= D_DISABLED;
     production_menu[PRODSAVERULES].flags |= D_DISABLED;

     dialog1[PROCPLAYBUT].flags |= D_DISABLED;
     dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
     dialog1[PROCREMAPBUT].flags |= D_DISABLED;
     dialog1[PROCINTERPBUT].flags |= D_DISABLED;
     dialog1[PROCREMAKEBUT].flags |= D_DISABLED;
     dialog1[PROCSAVERULESBUT].flags |= D_DISABLED;

     if(ret==1 && *rulefile!='\0' && rulefile!=NULL){
        if(getrules(rulefile)==-1){
                   return D_O_K;
        }
        dialog1[DIALOG1RULES].bg=UNCHANGEDBG;
        dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
        makeret=do_remakeandinterpret();
     }
     else makeret=do_makeandinterpret();
     return makeret;
}
int savetemprulefile();
char temprulesname[120]="LMUSEDIT.TMP";
int editrules(){
     int ret,saveret,makeret;
     int obj;
     int maxlevel;

     saveret=savetemprulefile();
     if(saveret==-1) return D_O_K;

     if(do_edit(temprulesname)==-1) return D_O_K;

     ret=alert(NULL,NULL,NULL,"Use Edited Rules","Discard Changes",13,0);
     if(ret==2) return D_O_K;

     production_menu[PRODPLAY].flags |= D_DISABLED;
     production_menu[PRODSAVE].flags |= D_DISABLED;
     production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
     production_menu[PRODINTERP].flags |= D_DISABLED;

     dialog1[PROCPLAYBUT].flags |= D_DISABLED;
     dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
     dialog1[PROCREMAPBUT].flags |= D_DISABLED;
     dialog1[PROCINTERPBUT].flags |= D_DISABLED;

     initrules();
     rulefilefp=fopen(temprulesname,"r");
     if(rulefilefp==NULL){
          alert("file error","","","OK",NULL,13,0);
          return D_O_K;
     }

     maxlevel=readrulefile(rulefilefp);
     unsavedrulechanges=1;
     sprintf(numrecursestring,"%d",maxlevel);
     sprintf(deltaanglestring,"%3.2f",deltaangledeg);
     sprintf(numrulesstring,"transformation rules (%d):",numrules);
     fclose(rulefilefp);

     dialog1[DIALOG1RULES].bg=CHANGEDBG;
     dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);

     makeret=do_remakeandinterpret();
     return makeret;
}



int geteditor(){
     int fsret=1,alertret;
     char buf[100];
     char editorbuf[120];
     strcpy(editorbuf,editor);

     while (fsret){
          fsret=popup_file_select("Use DOS editor:", editorbuf, "exe;com;bat");
          if(fsret==0) return 0;
          if(!exists(editorbuf)){
               sprintf(buf, "Can't find %s", editorbuf);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return D_O_K;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }
     strcpy (editor,editorbuf);
     writeconfigfile();
     return D_O_K;
}


#define MAXCFGLINE 255
int readinifile(){
    FILE *fp;
    MAP * m=&maps[cureditmap];

    int mnum;
    char *bptr,*rptr,*eqptr,*lptr;
    char buffer[MAXCFGLINE+1];
    SCALE * udefed_scale;

    fp=fopen(inifile,"rt");
    if(fp==NULL) return -1;

    while(fgets(buffer,MAXCFGLINE,fp)){

        bptr=buffer;
        while(isspace(*bptr)) bptr++;
        lptr=bptr;
        while(*lptr!='\0'){
           if(*lptr==commentchar||*lptr=='\n'){
              *lptr='\0';
              break;
           }
           lptr++;

        }
        if(*bptr== '@') break;/* "@" is lparser end mark*/
        if(*bptr!='\0'){
                        eqptr=strchr(bptr,'=');
                        if(eqptr!=NULL){
                             lptr=bptr;rptr=eqptr+1;
                             *eqptr='\0';
                             formatline(lptr);
                             while(isspace(*rptr)) rptr++;
                             if(!stricmp(lptr,"mapnumber")){
                                    mnum=atoi(rptr);
                                    if(mnum>=0&&mnum<MAXMAPS)
                                        m=&maps[mnum];
                                    else
                                        m=&maps[0];
                             }
                             if(!stricmp(lptr,"tempo")){
                                    tempo=atol(rptr);
                             }
                             else if(!stricmp(lptr,"transpose")){
                                    m->transpose=atoi(rptr);
                             }
                             else if(!stricmp(lptr,"pspread")){
                                    m->pspread=atof(rptr);
                                    if(m->pspread>PSPREADMAX) m->pspread=PSPREADMAX;
                                    if(m->pspread<-PSPREADMAX) m->pspread=-PSPREADMAX;

                             }
                             else if(!stricmp(lptr,"dspread")){
                                    m->dspread=atof(rptr);
                                    if(m->dspread>DSPREADMAX) m->dspread=DSPREADMAX;
                                    if(m->dspread<-DSPREADMAX) m->dspread=-DSPREADMAX;
                             }
                             else if(!stricmp(lptr,"vspread")){
                                    m->vspread=atof(rptr);
                                    if(m->vspread>VSPREADMAX) m->vspread=VSPREADMAX;
                                    if(m->vspread<-VSPREADMAX) m->vspread=-VSPREADMAX;

                             }
                             else if(!stricmp(lptr,"pitch")){
                                  formatline(rptr);
                                  if(!stricmp(rptr,"x"))
                                       m->pitch=&statevariablearray[X_VAR];
                                  else if(!stricmp(rptr,"y"))
                                       m->pitch=&statevariablearray[Y_VAR];
                                  else if(!stricmp(rptr,"z"))
                                       m->pitch=&statevariablearray[Z_VAR];

                                  else if(!stricmp(rptr,"forwardx")||!stricmp(rptr,"fx"))
                                       m->pitch=&statevariablearray[FX_VAR];
                                  else if(!stricmp(rptr,"forwardy")||!stricmp(rptr,"fy"))
                                       m->pitch=&statevariablearray[FY_VAR];
                                  else if(!stricmp(rptr,"forwardz")||!stricmp(rptr,"fz"))
                                       m->pitch=&statevariablearray[FZ_VAR];

                                  else if(!stricmp(rptr,"upx")||!stricmp(rptr,"ux"))
                                       m->pitch=&statevariablearray[UX_VAR];
                                  else if(!stricmp(rptr,"upy")||!stricmp(rptr,"uy"))
                                       m->pitch=&statevariablearray[UY_VAR];
                                  else if(!stricmp(rptr,"upz")||!stricmp(rptr,"uz"))
                                       m->pitch=&statevariablearray[UZ_VAR];
                                  else if(!stricmp(rptr,"leftx")||!stricmp(rptr,"lx"))
                                       m->pitch=&statevariablearray[LX_VAR];
                                  else if(!stricmp(rptr,"lefty")||!stricmp(rptr,"ly"))
                                       m->pitch=&statevariablearray[LY_VAR];
                                  else if(!stricmp(rptr,"leftz")||!stricmp(rptr,"lz"))
                                       m->pitch=&statevariablearray[LZ_VAR];

                                  else if(!stricmp(rptr,"length")||!stricmp(rptr,"statelength"))
                                       m->pitch=&statevariablearray[LENGTH_VAR];
                                  else if(!stricmp(rptr,"drawlength")||!stricmp(rptr,"dlength"))
                                       m->pitch=&statevariablearray[DRAWLENGTH_VAR];
                                  else if(!stricmp(rptr,"thickness")||!stricmp(rptr,"thick"))
                                       m->pitch=&statevariablearray[THICKNESS_VAR];
                             }
                             else if(!stricmp(lptr,"duration")){
                                  formatline(rptr);
                                  if(!stricmp(rptr,"x"))
                                       m->duration=&statevariablearray[X_VAR];
                                  else if(!stricmp(rptr,"y"))
                                       m->duration=&statevariablearray[Y_VAR];
                                  else if(!stricmp(rptr,"z"))
                                       m->duration=&statevariablearray[Z_VAR];

                                  else if(!stricmp(rptr,"forwardx")||!stricmp(rptr,"fx"))
                                       m->duration=&statevariablearray[FX_VAR];
                                  else if(!stricmp(rptr,"forwardy")||!stricmp(rptr,"fy"))
                                       m->duration=&statevariablearray[FY_VAR];
                                  else if(!stricmp(rptr,"forwardz")||!stricmp(rptr,"fz"))
                                       m->duration=&statevariablearray[FZ_VAR];

                                  else if(!stricmp(rptr,"upx")||!stricmp(rptr,"ux"))
                                       m->duration=&statevariablearray[UX_VAR];
                                  else if(!stricmp(rptr,"upy")||!stricmp(rptr,"uy"))
                                       m->duration=&statevariablearray[UY_VAR];
                                  else if(!stricmp(rptr,"upz")||!stricmp(rptr,"uz"))
                                       m->duration=&statevariablearray[UZ_VAR];
                                  else if(!stricmp(rptr,"leftx")||!stricmp(rptr,"lx"))
                                       m->duration=&statevariablearray[LX_VAR];
                                  else if(!stricmp(rptr,"lefty")||!stricmp(rptr,"ly"))
                                       m->duration=&statevariablearray[LY_VAR];
                                  else if(!stricmp(rptr,"leftz")||!stricmp(rptr,"lz"))
                                       m->duration=&statevariablearray[LZ_VAR];

                                  else if(!stricmp(rptr,"length"))
                                       m->duration=&statevariablearray[LENGTH_VAR];
                                  else if(!stricmp(rptr,"drawlength")||!stricmp(rptr,"dlength"))
                                       m->duration=&statevariablearray[DRAWLENGTH_VAR];
                                  else if(!stricmp(rptr,"thickness")||!stricmp(rptr,"thick"))
                                       m->duration=&statevariablearray[THICKNESS_VAR];
                             }
                             else if( !stricmp(lptr,"velocity") || !stricmp(lptr,"volume")){
                                  formatline(rptr);
                                  if(!stricmp(rptr,"x"))
                                       m->volume=&statevariablearray[X_VAR];
                                  else if(!stricmp(rptr,"y"))
                                       m->volume=&statevariablearray[Y_VAR];
                                  else if(!stricmp(rptr,"z"))
                                       m->volume=&statevariablearray[Z_VAR];

                                  else if(!stricmp(rptr,"forwardx")||!stricmp(rptr,"fx"))
                                       m->volume=&statevariablearray[FX_VAR];
                                  else if(!stricmp(rptr,"forwardy")||!stricmp(rptr,"fy"))
                                       m->volume=&statevariablearray[FY_VAR];
                                  else if(!stricmp(rptr,"forwardz")||!stricmp(rptr,"fz"))
                                       m->volume=&statevariablearray[FZ_VAR];

                                  else if(!stricmp(rptr,"upx")||!stricmp(rptr,"ux"))
                                       m->volume=&statevariablearray[UX_VAR];
                                  else if(!stricmp(rptr,"upy")||!stricmp(rptr,"uy"))
                                       m->volume=&statevariablearray[UY_VAR];
                                  else if(!stricmp(rptr,"upz")||!stricmp(rptr,"uz"))
                                       m->volume=&statevariablearray[UZ_VAR];
                                  else if(!stricmp(rptr,"leftx")||!stricmp(rptr,"lx"))
                                       m->volume=&statevariablearray[LX_VAR];
                                  else if(!stricmp(rptr,"lefty")||!stricmp(rptr,"ly"))
                                       m->volume=&statevariablearray[LY_VAR];
                                  else if(!stricmp(rptr,"leftz")||!stricmp(rptr,"lz"))
                                       m->volume=&statevariablearray[LZ_VAR];

                                  else if(!stricmp(rptr,"length"))
                                       m->volume=&statevariablearray[LENGTH_VAR];
                                  else if(!stricmp(rptr,"drawlength")||!stricmp(rptr,"dlength"))
                                       m->volume=&statevariablearray[DRAWLENGTH_VAR];
                                  else if(!stricmp(rptr,"thickness")||!stricmp(rptr,"thick"))
                                       m->volume=&statevariablearray[THICKNESS_VAR];

                             }
                             else if( !stricmp(lptr,"scale") ){
                                  if(isdigit(*rptr)){
                                       udefed_scale=string2scale(rptr);
                                       if(udefed_scale!=NULL){
                                          scale2scalestring(udefed_scale);
                                          m->scale=*udefed_scale;
                                          strcpy(m->scalename,scalenames[7]);
                                          strcpy(scalenamestring,scalenames[7]);

                                       }
                                  }
                                  else{
                                       formatline(rptr);
                                       if(!stricmp(rptr,"twelvetone")){
                                          m->scale=scales[0];
                                          strcpy(m->scalename,scalenames[0]);
                                          strcpy(scalenamestring,scalenames[0]);
                                       }
                                       else if(!stricmp(rptr,"major")){
                                          m->scale=scales[1];
                                          strcpy(m->scalename,scalenames[1]);
                                          strcpy(scalenamestring,scalenames[1]);
                                       }
                                       else if(!stricmp(rptr,"penta1")){
                                          m->scale=scales[2];
                                          strcpy(m->scalename,scalenames[2]);
                                          strcpy(scalenamestring,scalenames[2]);
                                       }
                                       else if(!stricmp(rptr,"minor")){
                                          m->scale=scales[3];
                                          strcpy(m->scalename,scalenames[3]);                                          
                                          strcpy(scalenamestring,scalenames[3]);
                                       }
                                       else if(!stricmp(rptr,"blue1")){
                                          m->scale=scales[4];
                                          strcpy(m->scalename,scalenames[4]);
                                          strcpy(scalenamestring,scalenames[4]);
                                       }
                                       else if(!stricmp(rptr,"whole")){
                                          m->scale=scales[5];
                                          strcpy(m->scalename,scalenames[5]);
                                          strcpy(scalenamestring,scalenames[5]);
                                       }
                                       else if(!stricmp(rptr,"diminished")){
                                          m->scale=scales[6];
                                          strcpy(m->scalename,scalenames[6]);                                          
                                          strcpy(scalenamestring,scalenames[6]);
                                       }

                                  }
                             }
                             else if(!stricmp(lptr,"scalefn")){
                                       formatline(rptr);
                                       if(!stricmp(rptr,"constant")){
                                          m->scalefn=scalefunctions[CONSTANTSCALE];
                                          strcpy(scalefnnamestring,scalefnnames[CONSTANTSCALE]);
                                       }
                                       else if(!stricmp(rptr,"slideto")){
                                          m->scalefn=scalefunctions[SLIDETOSCALE];
                                          strcpy(scalefnnamestring,scalefnnames[SLIDETOSCALE]);

                                       }
                                       else if(!stricmp(rptr,"steps")){
                                          m->scalefn=scalefunctions[SCALESTEPS];
                                          strcpy(scalefnnamestring,scalefnnames[SCALESTEPS]);

                                       }
                                       else if(!stricmp(rptr,"ignore")){
                                          m->scalefn=scalefunctions[IGNORESCALE];
                                          strcpy(scalefnnamestring,scalefnnames[IGNORESCALE]);

                                       }

                             }
                             else if(!stricmp(lptr,"dmultiplier")){
                                  m->dmultiplier=4.0*fabs(atof(rptr));
                                  if(m->dmultiplier>4.0*DMULTMAX) m->dmultiplier=4.0*DMULTMAX;
                                  if(m->dmultiplier<0) m->dmultiplier=0;

                             }
                             else if(!stricmp(lptr,"tstack") ||!stricmp(lptr,"transposestack")){
                                       formatline(rptr);
                                       if(!stricmp(rptr,"1")||!stricmp(rptr,"yes")||!stricmp(rptr,"y")||!stricmp(rptr,"on")){
                                          transposestack_p=1;
                                          m->tstack=1;
                                       }
                                       else {
                                          transposestack_p=0;
                                          m->tstack=0;
                                       }
                             }
                             else if(!stricmp(lptr,"fstacks") ||!stricmp(lptr,"factorstacks")){
                                       formatline(rptr);
                                       if(!stricmp(rptr,"1")||!stricmp(rptr,"yes")||!stricmp(rptr,"y")||!stricmp(rptr,"on")){
                                          factstacks_p=1;
                                          m->fstacks=1;
                                       }
                                       else{
                                          factstacks_p=0;
                                          m->fstacks=0;
                                       }
                             }
                             else if(!stricmp(lptr,"seed") ||!stricmp(lptr,"randomseed")){
                                       rstart=(unsigned)atoi(rptr);
                                       lastseed=rstart;
                             }
                             else if( !stricmp(lptr,"writeparameters") ){
                                       formatline(rptr);
                                       if(!stricmp(rptr,"0")||!stricmp(rptr,"no")||!stricmp(rptr,"n")||!stricmp(rptr,"off")){
                                          writeparameters_p=0;

                                          options_menu[WRITEPARAMETERSTOGGLE].flags &= ~D_SELECTED;
                                       }
                                       else {
                                          writeparameters_p=1;

                                          options_menu[WRITEPARAMETERSTOGGLE].flags |= D_SELECTED;
                                       }
                             }/*writeparameters*/
                        }/*if anything after '='*/
        }/*if this is a noncomment line*/

    }

    fclose(fp);
    return 0;
}

int loadini_proc(int msg,DIALOG *d, int c __attribute__ ((unused))){
    int ret;

    ret= getinibutton_proc(msg,d,255);

    return ret;
}
int getinibutton_proc(int msg,DIALOG *d, int c){
        int obj;
        int i;
        MAP *m=&maps[cureditmap];
        DIALOG *cd=connect_dialog;
        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           if(c!=255){
               connect_dialog[CONNECTDONE].flags|=D_DISABLED;
               connect_dialog[CONNECTCANCEL].flags|=D_DISABLED;
               connect_dialog[CONNECTHELP].flags|=D_DISABLED;
               dialog_message(&(connect_dialog[CONNECTDONE]), MSG_DRAW, 0, &obj);
               dialog_message(&(connect_dialog[CONNECTCANCEL]), MSG_DRAW, 0, &obj);
               dialog_message(&(connect_dialog[CONNECTHELP]), MSG_DRAW, 0, &obj);
           }
           ret=getinifile();

           for(i=0;i<NUMSTATEVARS;i++){
               if(m->pitch->v==statevariablearray[i].v)
                          connect_dialog[LCONNECT1+PITCH].d1=i;
               if(m->duration->v==statevariablearray[i].v)
                          connect_dialog[LCONNECT1+DURATION].d1=i;
               if(m->volume->v==statevariablearray[i].v)
                          connect_dialog[LCONNECT1+VOLUME].d1=i;

           }
           connect_dialog[DMULTSLIDER].d2=(int)(m->dmultiplier/4.0*100);
           sprintf(connect_dialog[DMULTTEXT].dp,"%1.2f",m->dmultiplier/4.0);

           connect_dialog[PSPREADSLIDER].d2=(int)((m->pspread+PSPREADMAX)/(2*PSPREADMAX)*70);
           sprintf(connect_dialog[PSPREADTEXT].dp,"%1.2f",m->pspread);

           connect_dialog[DSPREADSLIDER].d2=(int)((m->dspread+DSPREADMAX)/(2*DSPREADMAX)*70);
           sprintf(connect_dialog[DSPREADTEXT].dp,"%1.2f",m->dspread);

           connect_dialog[VSPREADSLIDER].d2=(int)((m->vspread+VSPREADMAX)/(2*VSPREADMAX)*70);
           sprintf(connect_dialog[VSPREADTEXT].dp,"%1.2f",m->vspread);
           sprintf(deltaanglestring,"%3.2f",deltaangledeg);
           strcpy(scalenamestring,m->scalename);
           for (i=0;i<3;i++){
             if(m->scalefn==scalefunctions[i])
               strcpy(scalefnnamestring,scalefnnames[i]);
           }

           if(c!=255){
               connect_dialog[CONNECTDONE].flags&=~D_DISABLED;
               connect_dialog[CONNECTCANCEL].flags&=~D_DISABLED;
               connect_dialog[CONNECTHELP].flags&=~D_DISABLED;
               dialog_message(cd, MSG_DRAW, 0, &obj);

           }
           return ret;
        }
        return(ret);
}

int getinifile(){
     int fsret=1,alertret;
     char ininamebuf[256];
     char buf[100];
     strcpy(ininamebuf,inifile);
     while (fsret){
          fsret=popup_file_select("Load INI File:", ininamebuf, "ini;map");
          if(fsret==0) return D_O_K;
          if(!exists(ininamebuf)){
               sprintf(buf, "Can't find %s", ininamebuf);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return D_O_K;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else {
             fsret=0;
             strcpy(inifile,ininamebuf);
          }
     }

     readinifile();

     return D_O_K;


}

#include "time.h"
int writeinifile(int mapnumber){
        FILE *fp;
        time_t now;
        int i;
        int writeall=0;
        MAP *m;
        char buf[120];
        if(mapnumber<0){
            mapnumber=0;
            writeall=1;
        }

        m=&maps[mapnumber];
        fp=fopen(inifile,"wt");
        if(fp==NULL) return -1;


        time(&now);
        fprintf(fp,"# LMUSe v%s map file %s\n# %s", PROGRAMVERSION,get_filename(inifile),asctime(localtime(&now)));
        fprintf(fp,"# Current rulefile: %s %s\n",*rulefile?get_filename(rulefile):"(none)", originalmutated?": (mutated)":"");

        fprintf(fp,"# Everything to the right of '#' on a line is ignored.\n");
        fprintf(fp,"# Each map line is of the form 'parameter=value'.\n");
        fprintf(fp,"# Including any of these parameter fields is optional.\n");
        fprintf(fp,"# Letter cases in map files are ignored.\n");


        fprintf(fp,"\n# tempo in beats per minute\n");
        fprintf(fp,"tempo=%ld\n",tempo);

        fprintf(fp,"\n# transposestack is a special stack for transposing the generated\n");
        fprintf(fp,"# pitches. (L-system symbols T(x) ... T ).\n");
        fprintf(fp,"# transposestack=1 enables this stack.\n");
        fprintf(fp, "transposestack=%d\n",m->tstack?1:0);

        fprintf(fp,"\n# factorstacks are special stacks for holding duration and volume\n");
        fprintf(fp,"# multipliers. (L-system symbols D(x) ... D , and V(x) ... V ).\n");
        fprintf(fp,"# factorstacks=1 enables these stacks.\n");
        fprintf(fp, "factorstacks=%d\n",m->fstacks?1:0);

        fprintf(fp, "\n# randomseed is an (unsigned) integer\n");
        fprintf(fp, "# To actually use this seed you need to\n");
        fprintf(fp, "# uncheck 'Random Seed' in the dialog presented\n");
        fprintf(fp, "# when doing a 'Make' or 'Remake'\n");
        fprintf(fp, "randomseed=%u\n",rstart);

        fprintf(fp, "\n# writeparameters is a flag (=0 or 1) to disable/enable\n");
        fprintf(fp, "# writing text information into saved midi files. Default=1\n");
        fprintf(fp, "writeparameters=%d\n",writeparameters_p?1:0);

        if(writeall){

           fprintf(fp, "\n# mapnumber tells which map (0 thru 9) the following\n");
           fprintf(fp, "# (up to the next mapnumber statement) are supposed to go\n");
           fprintf(fp, "# into when the file is loaded. mapnumber statements are\n");
           fprintf(fp, "# necessary to include several maps in a single map file\n");
           fprintf(fp, "mapnumber=%d\n",mapnumber);

        }

        fprintf(fp,"\n# pitch, duration, and volume of notes are each determined by\n");
        fprintf(fp,"# any one of the following L-system variables:\n");
        fprintf(fp,"# x          - the x coordinate of the turtle's position\n");
        fprintf(fp,"# y          - the y coordinate of the turtle's position\n");
        fprintf(fp,"# z          - the z coordinate of the turtle's position\n");
        fprintf(fp,"# forwardx   - (or 'fx') the x component of the turtle's forward direction\n");
        fprintf(fp,"# forwardy   - (or 'fy') the y component of the turtle's forward direction\n");
        fprintf(fp,"# forwardz   - (or 'fz') the z component of the turtle's forward direction\n");
        fprintf(fp,"# leftx      - (or 'lx') the x component of the turtle's 'left' orientation\n");
        fprintf(fp,"# lefty      - (or 'ly') the y component of the turtle's 'left' orientation\n");
        fprintf(fp,"# leftz      - (or 'lz') the z component of the turtle's 'left' orientation\n");
        fprintf(fp,"# upx        - the x component of the turtle's 'up' orientation\n");
        fprintf(fp,"# upy        - the y component of the turtle's 'up' orientation\n");
        fprintf(fp,"# upz        - the z component of the turtle's 'up' orientation\n");
        fprintf(fp,"# length     - (or 'statelength') the state length of the L-system\n");
        fprintf(fp,"# drawlength - the 'draw length' (affected by temporary length modifiers)\n");
        fprintf(fp,"# thickness  - the Lparser line thickness\n");


        for(i=0;i<3;i++){
           strcpy(buf,mapbuf[mapnumber][i]);
           formatline(buf);

           fprintf(fp,"%s\n",buf);
        }
        fprintf(fp,"\n# pspread, dspread, and vspread are magnifiers for the influence\n");
        fprintf(fp,"# of the pitch, duration and volume parameters on the notes generated.\n");
        fprintf(fp,"# Recommended to stay in interval -4.0 to 4.0\n");
        fprintf(fp,"pspread=%f\ndspread=%f\nvspread=%f\n",m->pspread,m->dspread,m->vspread);

        fprintf(fp,"\n# 'scale=scalename' tells LMUSe what scale to use.\n");
        fprintf(fp,"# The predefined scale choices are 'Major', 'minor', 'Blue1', 'Penta1',\n");
        fprintf(fp,"# 'diminished', 'Twelvetone', or 'whole'.\n");
        fprintf(fp,"# Alternatively, you can give a list of number halfsteps from\n");
        fprintf(fp,"# starting with the number '1'. For example, a major scale\n");
        fprintf(fp,"# could be given by: scale=1,3,5,6,8,10,12\n");

        if(!(stricmp(m->scalename,scalenames[numpredefinedscales]))){
             scale2scalestring( &(m->scale));
             sprintf(buf,"scale=%s",scalestring);
        }
        else{
             sprintf(buf,"scale=%s",m->scalename);
             formatline(buf);
        }
        fprintf(fp,"%s\n",buf);

        fprintf(fp,"\n# scalefn is the algorithm used to get the pitches to conform to the\n");
        fprintf(fp,"# desired musical scale. (see LMUSe.txt)\n");
        fprintf(fp,"# Choices are: slideto, steps, constant, ignore\n");
        for (i=0;i<3;i++){
           if(m->scalefn==scalefunctions[i])
               strcpy(scalefnnamestring,scalefnnames[i]);
        }
        sprintf(buf,"scalefn=%s",scalefnnamestring);
        formatline(buf);
        fprintf(fp,"%s\n",buf);

        fprintf(fp,"\n# transpose amount\n");
        fprintf(fp,"transpose=%d\n",m->transpose);

        fprintf(fp,"\n# duration multiplier\n");
        fprintf(fp,"dmultiplier=%f\n",m->dmultiplier/4.0);


        if(writeall){
          for(mapnumber=1;mapnumber<MAXMAPS;mapnumber++){
             m=&maps[mapnumber];
          
             fprintf(fp, "\nmapnumber=%d\n",mapnumber);


             for(i=0;i<3;i++){
                strcpy(buf,mapbuf[mapnumber][i]);
                formatline(buf);
                if(*buf)
                    fprintf(fp,"%s\n",buf);
             }
             fprintf(fp,"pspread=%f\ndspread=%f\nvspread=%f\n",m->pspread,m->dspread,m->vspread);
             if(!(stricmp(m->scalename,scalenames[numpredefinedscales]))){

                  scale2scalestring( &(m->scale));
                  sprintf(buf,"scale=%s",scalestring);
             }
             else{
                  sprintf(buf,"scale=%s",m->scalename);
                  formatline(buf);
             }
             fprintf(fp,"%s\n",buf);
     
             for (i=0;i<3;i++){
                if(m->scalefn==scalefunctions[i])
                    strcpy(scalefnnamestring,scalefnnames[i]);
             }
             sprintf(buf,"scalefn=%s",scalefnnamestring);
             formatline(buf);
             fprintf(fp,"%s\n",buf);

             fprintf(fp,"transpose=%d\n",m->transpose);

             fprintf(fp,"dmultiplier=%f\n",m->dmultiplier/4.0);
          }
        }
        fclose(fp);
        unsavedmapchanges=0;
        return 0;
}
int saveini_proc(int msg,DIALOG *d, int c){
    int butret=d_button_proc(msg,d,c);
    if(butret==D_CLOSE){
         saveinifile();
         return D_O_K;
    }
    return butret;
}
int writeallmaps=1;
int saveonemap_proc(int msg,DIALOG *d, int c){
    int butret=d_button_proc(msg,d,c);
    if(butret==D_CLOSE){
         writeallmaps=0;
         saveinifile();
         writeallmaps=1;
         return D_O_K;
    }
    return butret;
}

int saveinifile(){

        char saveininame[256];
        int mapnumber=writeallmaps?-1:cureditmap;
        int dret;

        strcpy(saveininame,inifile);
        dret=do_savefiledialog("Save map as:",saveininame,"ini;map");

        if(dret>0){
              strcpy(inifile,saveininame);
              do_mconnect_dialog(cureditmap);
              if(writeinifile(mapnumber)==-1)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);

        }
        else if(quitting) quitting=0;
        return D_O_K;
}


char configfile[256]="lmuse.cfg";
int readconfigfile(){
    FILE *fp;
    char *configfilepath=NULL;
    configfilepath = getenv("LMUSCFG");
    if (configfilepath == NULL)
         configfilepath = configfile;

    fp=fopen(configfilepath,"r");
    if(fp==NULL) return -1;
    fgets(editor,119,fp);
    fclose(fp);
    return 0;
}

int writeconfigfile(){
    FILE *fp;
    fp=fopen(configfile,"w");
    if(fp==NULL) return -1;
    fputs(editor,fp);
    fclose(fp);
    return 0;

}

#define FSH 164
#define FSW 308
int popup_file_select(char *message, char *path, char *ext){
          int ret;
          BITMAP *b=create_bitmap(FSW,FSH);
          int xc = (SCREEN_W - FSW) / 2;
          int yc = (SCREEN_H - FSH) / 2;
          if(b!=NULL){
              clear(b);
              show_mouse(NULL);
              blit(screen,b,xc,yc,0,0,FSW-1,FSH-1);
              show_mouse(screen);
          }
          ret=file_select(message,path,ext);
          if(b!=NULL){
              show_mouse(NULL);
              blit(b,screen,0,0,xc,yc,FSW-1,FSH-1);
              show_mouse(screen);
              destroy_bitmap(b);
          }
          return ret;
}

#define MUTATESUCCESS 1
#define MUTATEFAILED -1
#define NOMUTATION 0
#define MAXMUTATEATTEMPTS 100
int mutaterules(){
        int mutateret,obj;
        int numattempts=0;
        while( (mutateret=L_mutate())==NOMUTATION && numattempts<MAXMUTATEATTEMPTS){
              numattempts++;
        }
        if(mutateret!=MUTATEFAILED)
            mutate_menu[MUTATESAVE].flags &= ~D_DISABLED;
        if(mutateret>0){
             originalmutated=1;
             unsavedrulechanges=1;
             dialog1[DIALOG1RULES].bg=MUTATEDBG;
             dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
        }
        return D_O_K;
}

int mutateandremake(){
        mutaterules();
        return do_remakeandinterpret();
}

FILE * mutatedfp;

int savemutation(){
        int i;
        time_t now;
        int dret=do_savefiledialog("Save mutated rules as:",mutatefilename,"l;ls;lm");

        if(dret>0){
              if((mutatedfp = fopen(mutatefilename,"w")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   time(&now);
                   fprintf(mutatedfp,"# LMUSe Mutation %s\n# %s", get_filename(mutatefilename),asctime(localtime(&now)));
                   fprintf(mutatedfp,"# Current rulefile: %s\n",*rulefile?get_filename(rulefile):"(none)");

                   fprintf(mutatedfp,"%s\n",numrecursestring);
                   fprintf(mutatedfp,"%f\n",deltaangledeg);
                   fprintf(mutatedfp,"%f\n",thick);
                   fprintf(mutatedfp,"%s\n",axiom);

                   for (i = 0; i < MAXRULES; i++) {
                       if (rules[i] == NULL)
                       break;
                       fprintf(mutatedfp,"%s\n",rules[i]);
                   }
                   fprintf(mutatedfp,"%c",'@');
                   fclose(mutatedfp);
                   unsavedrulechanges=0;
              }

        }
        return D_O_K;
}

int saverulesas(){
        FILE *fp;
        char saverulesname[256];
        int i,obj;
        int dret;
        time_t now;

        strcpy(saverulesname,rulefile);
        dret=do_savefiledialog("Save rules as:",saverulesname,"l;ls;lm");

        if(dret>0){
              if((fp = fopen(saverulesname,"w")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   time(&now);
                   fprintf(fp,"# %s\n",get_filename(saverulesname));
                   fprintf(fp,"# %s", asctime(localtime(&now)));

                   fprintf(fp,"%s\t# recursion level\n",numrecursestring);
                   fprintf(fp,"%3.2f\t# angle\n",deltaangledeg);
                   fprintf(fp,"%3.2f\t# thickness\n",thick);
                   fprintf(fp,"# axiom:\n%s\n",axiom);

                   for (i = 0; i < MAXRULES; i++) {
                       if (rules[i] == NULL)
                       break;
                       fprintf(fp,"%s\n",rules[i]);
                   }
                   fprintf(fp,"%c  # end",'@');
                   fclose(fp);

                   strcpy(rulefile,saverulesname);
                   strcpy(rulefilename,get_filename(rulefile));
                   changefileext(rulefile,productionfilename,"out");
                   changefileext(rulefile,savemfname,"mid");
                   changefileext(rulefile,mutatefilename,"lm");
                   changefileext(get_filename(rulefile),productionname,"");
                   dialog1[DIALOG1RULES].bg=UNCHANGEDBG;
                   dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);

                   unsavedrulechanges=0;
              }
   
        }
        else if (quitting) quitting=0;
        return D_O_K;
}


int savetemprulefile(){
        FILE *fp;
        time_t now;
        int i;

        if((fp = fopen(temprulesname,"w")) == 0L){
                  alert("Unable to open temporary file for writing.",NULL,NULL,"OK",NULL,13,0);
                  return -1;
        }
        else{
             time(&now);
             fprintf(fp,"# LMUSe temporary file. Transformation rules currently in LMUSe's memory\n# %s", asctime(localtime(&now)));
             fprintf(fp,"# Current rulefile: %s\n",*rulefile?get_filename(rulefile):"(none)");

             fprintf(fp,"%s\t# number of recursions\n",numrecursestring);
             fprintf(fp,"%3.2f\t# angle\n",deltaangledeg);
             fprintf(fp,"%3.2f\t# thickness\n",thick);
             fprintf(fp,"# axiom:\n%s\n",axiom);
             fprintf(fp,"# Transformation rules:\n");
             for (i = 0; i < MAXRULES; i++) {
                       if (rules[i] == NULL)
                       break;
                       fprintf(fp,"%s\n",rules[i]);
             }
             fprintf(fp,"%c\t# end",'@');
             fclose(fp);
        }
        return 0;
}

FILE *playmidifile_fp;
char playmidifilename[256];
MIDI * midifilemidi=NULL;
int do_getmidifiledialog(){
     int fsret=1,alertret;
     char buf[100];
     while (fsret){
          fsret=popup_file_select("MIDI File to play:", playmidifilename, "mid");
          if(fsret==0) return 0;
          if(!exists(playmidifilename)){
               sprintf(buf, "Can't find %s", playmidifilename);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }

     return(1);
}

int do_playmidifile(){

#ifdef NOTALWAYSSOUND
   char message1[80];
   char message2[80];
   if(!soundoff){
      if (install_sound(soundcard, midicard, NULL) != 0) {
   
         sprintf(message1,"Error initializing sound system for LMUSe\n%s\n", allegro_error);
         sprintf(message2,"LMUSe can be run without sound using the command line parameters:\n\t-m0 -d0\n");
         alert(message1,message2,NULL,"OK",NULL,13,0);
         return D_O_K;
      }
      else
         load_midi_patches();
   }
#endif
   if(soundoff) {
        alert("Sound is turned off",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }

   if(do_getmidifiledialog()==0){

       return D_O_K;
   }
   midifilemidi=load_midi(playmidifilename);
   if(midifilemidi!=NULL){
      play_midi(midifilemidi,0);
      production_menu[PRODSTOPPLAY].flags&=~D_DISABLED;
   }
   return D_O_K;
}
int do_stopmidifile(){
   if(midifilemidi){
      stop_midi(NULL,0);
      production_menu[PRODSTOPPLAY].flags|=D_DISABLED;
   }
#ifdef NOTALWAYSSOUND
   if(!soundoff) remove_sound();
#endif
   destroy_midi(midifilemidi);
   midifilemidi=NULL;
   return D_O_K;
}


void setup_processbuttons(){


      dialog1[PROCEDITBUT].dp=Data1[EDITBUT].dat;
      dialog1[PROCEDITBUT].dp2=Data1[EDITSEL].dat;
      dialog1[PROCEDITBUT].dp3=Data1[EDITDIS].dat;
      dialog1[PROCEDITRULESBUT].dp=Data1[RULEEDITBUT].dat;
      dialog1[PROCEDITRULESBUT].dp2=Data1[RULEEDITSEL].dat;
      dialog1[PROCEDITRULESBUT].dp3=Data1[RULEEDITDIS].dat;

      dialog1[PROCLOADBUT].dp=Data1[LOADBUT].dat;
      dialog1[PROCLOADBUT].dp2=Data1[LOADSEL].dat;
      dialog1[PROCLOADBUT].dp3=Data1[LOADDIS].dat;
      
      dialog1[PROCMAKEBUT].dp=Data1[MAKEBUT].dat;
      dialog1[PROCMAKEBUT].dp2=Data1[MAKESEL].dat;
      dialog1[PROCMAKEBUT].dp3=Data1[MAKEDIS].dat;
      dialog1[PROCMAKEANDBUT].dp=Data1[MAKEANDBUT].dat;
      dialog1[PROCMAKEANDBUT].dp2=Data1[MAKEANDSEL].dat;
      dialog1[PROCMAKEANDBUT].dp3=Data1[MAKEANDDIS].dat;
      dialog1[PROCMUTATEBUT].dp=Data1[MUTATEBUT].dat;
      dialog1[PROCMUTATEBUT].dp2=Data1[MUTATESEL].dat;
      dialog1[PROCMUTATEBUT].dp3=Data1[MUTATEDIS].dat;
      dialog1[PROCMUTANDBUT].dp=Data1[MUTANDBUT].dat;
      dialog1[PROCMUTANDBUT].dp2=Data1[MUTANDSEL].dat;
      dialog1[PROCMUTANDBUT].dp3=Data1[MUTANDDIS].dat;
      dialog1[PROCINTERPBUT].dp=Data1[INTERPBUT].dat;
      dialog1[PROCINTERPBUT].dp2=Data1[INTERPSEL].dat;
      dialog1[PROCINTERPBUT].dp3=Data1[INTERPDIS].dat;
      dialog1[PROCPLAYBUT].dp=Data1[PLAYBUT].dat;
      dialog1[PROCPLAYBUT].dp2=Data1[PLAYSEL].dat;
      dialog1[PROCPLAYBUT].dp3=Data1[PLAYDIS].dat;
      dialog1[PROCQUITBUT].dp=Data1[QUITBUT].dat;
      dialog1[PROCQUITBUT].dp2=Data1[QUITSEL].dat;
      dialog1[PROCQUITBUT].dp3=Data1[QUITDIS].dat;
      dialog1[PROCREMAKEBUT].dp=Data1[REMAKEBUT].dat;
      dialog1[PROCREMAKEBUT].dp2=Data1[REMAKESEL].dat;
      dialog1[PROCREMAKEBUT].dp3=Data1[REMAKEDIS].dat;
      dialog1[PROCREMAPBUT].dp=Data1[REMAPBUT].dat;
      dialog1[PROCREMAPBUT].dp2=Data1[REMAPSEL].dat;
      dialog1[PROCREMAPBUT].dp3=Data1[REMAPDIS].dat;
      dialog1[PROCSAVEMIDIBUT].dp=Data1[SAVEMIDIBUT].dat;
      dialog1[PROCSAVEMIDIBUT].dp2=Data1[SAVEMIDISEL].dat;
      dialog1[PROCSAVEMIDIBUT].dp3=Data1[SAVEMIDIDIS].dat;
      dialog1[PROCSAVERULESBUT].dp=Data1[SAVERULESBUT].dat;
      dialog1[PROCSAVERULESBUT].dp2=Data1[SAVERULESSEL].dat;
      dialog1[PROCSAVERULESBUT].dp3=Data1[SAVERULESDIS].dat;

}



