/* SOX COPYRIGHT *************************************************** */
/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */
/* END OF SOX COPYRIGHT ******************************************** */

/* portions copied from sox */
/* modified by David Lai Jan 6 1993, lai%fastfood@daver.bungi.com */

/* BEGIN DAVID LAI COPYRIGHT ********************************************* */
/*
(C) Copyright David Lai 1993, 1994.  All rights reserved.

The source code is copyright by David Lai, however it is freely
distributable and released for unrestricted use.  Users may copy or modify 
this source code without charge, provided all copyright
notices remain intact in all the source code.  Portions of the source code
copyright by their respective copyright holders and are covered
under different agreements, however the source code used has
specifically been marked distributable royalty-free.

You can do whatever you want with it, even charge money for it, if
you find a sucker willing to pay for it.  This is not shareware, the program
is not crippled in any way, do not send money.  You can e-mail comments
to the electronic mail address below, or fax to the fax number below.

If you add a feature thats useful, or do a new port, you can send
the context diffs to the e-mail address below.  I may include it in
subsequent releases.  Your code must specifically be marked
freely distributable, I will not include code marked otherwise.

THE SOURCE CODE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.

The source code is provided with no support and without any obligation on
the part of David Lai to assist in its use, correction,
modification or enhancement.

DAVID LAI SHALL HAVE NO LIABILITY WITH RESPECT TO THE
INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS SOFTWARE
OR ANY PART THEREOF.

In no event will David Lai be liable for any lost revenue
or profits or other special, indirect and consequential damages, even if
David Lai has been advised of the possibility of such damages.

David Lai
1370 McKendrie St
San Jose, CA 95126
fax: 408-241-4615

lai%fastfood@daver.bungi.com

*/
/* END   DAVID LAI COPYRIGHT ********************************************* */

#include "misc.h"
#include "modcomp.h"

static char readerr[] = "Premature EOF while reading file.";
static char writerr[] = "Error writing file.  You are probably out of disk space.";

#define fail(x) err_exit(x,NULL)

/* Read short, little-endian: little end first. VAX/386 style. */
uint16
#ifdef  __STDC__
rlshort(FILE * ft)
#else
rlshort(ft) FILE * ft;
#endif
{
	unsigned char uc, uc2;
	uc  = getc(ft);
	uc2 = getc(ft);
	if (ferror(ft)) fail(readerr);
	return (uc2 << 8) | uc;
}

/* Read short, bigendian: big first. 68000/SPARC style. */
uint16
#ifdef  __STDC__
rbshort(FILE * ft)
#else
rbshort(ft) FILE * ft;
#endif
{
	unsigned char uc, uc2;
	uc2 = getc(ft);
	uc  = getc(ft);
	if (ferror(ft)) fail(readerr);
	return (uc2 << 8) | uc;
}

/* Write short, little-endian: little end first. VAX/386 style. */
void
#ifdef	__STDC__
wlshort(FILE * ft, uint16 us)
#else
wlshort(ft, us)
FILE * ft;
uint16 us;
#endif
{
	putc(us, ft);
	putc(us >> 8, ft);
	if (ferror(ft))
		fail(writerr);
}

/* Write short, big-endian: big end first. 68000/SPARC style. */
void
#ifdef	__STDC__
wbshort(FILE * ft, uint16 us)
#else
wbshort(ft, us)
FILE * ft;
uint16 us;
#endif
{
	putc(us >> 8, ft);
	putc(us, ft);
	if (ferror(ft))
		fail(writerr);
}

/* Read long, little-endian: little end first. VAX/386 style. */
uint32
#ifdef  __STDC__
rllong(FILE * ft)
#else
rllong(ft) FILE * ft;
#endif
{
	unsigned char uc, uc2, uc3, uc4;
/*	if (feof(ft))
		fail(readerr);		/* No worky! */
	uc  = getc(ft);
	uc2 = getc(ft);
	uc3 = getc(ft);
	uc4 = getc(ft);
	if (ferror(ft)) fail(readerr);
	return ((long)uc4 << 24) | ((long)uc3 << 16) | ((long)uc2 << 8) | (long)uc;
}

/* Read long, bigendian: big first. 68000/SPARC style. */
uint32
#ifdef  __STDC__
rblong(FILE * ft)
#else
rblong(ft) FILE * ft;
#endif
{
	unsigned char uc, uc2, uc3, uc4;
/*	if (feof(ft))
		fail(readerr);		/* No worky! */
	uc  = getc(ft);
	uc2 = getc(ft);
	uc3 = getc(ft);
	uc4 = getc(ft);
	if (ferror(ft)) fail(readerr);
	return ((long)uc << 24) | ((long)uc2 << 16) | ((long)uc3 << 8) | (long)uc4;
}

/* Write long, little-endian: little end first. VAX/386 style. */
void
#ifdef  __STDC__
wllong(FILE * ft, uint32 ul)
#else
wllong(ft, ul) FILE * ft; uint32 ul;
#endif
{
int datum;

	datum = (int)((ul) & 0xff);
	putc(datum, ft);
	datum = (int)((ul >> 8) & 0xff);
	putc(datum, ft);
	datum = (int)((ul >> 16) & 0xff);
	putc(datum, ft);
	datum = (int)((ul >> 24) & 0xff);
	putc(datum, ft);
	if (ferror(ft))
		fail(writerr);
}

/* Write long, big-endian: big end first. 68000/SPARC style. */
void
#ifdef  __STDC__
wblong(FILE * ft, uint32 ul)
#else
wblong(ft, ul) FILE * ft; uint32 ul;
#endif
{
int datum;

	datum = (int)((ul >> 24) & 0xff);
	putc(datum, ft);
	datum = (int)((ul >> 16) & 0xff);
	putc(datum, ft);
	datum = (int)((ul >> 8) & 0xff);
	putc(datum, ft);
	datum = (int)((ul) & 0xff);
	putc(datum, ft);
	if (ferror(ft))
		fail(writerr);
}

void
#ifdef  __STDC__
wezstr(FILE * ft, char *str)
#else
wezstr(ft, str) FILE * ft; char *str;
#endif
{ /* write a null terminated string, pad until even number of bytes written */
int len;
len = strlen(str)+1; /* include null byte */
	if ((int)fwrite(str, 1, len, ft)!= len)
		fail(writerr);
	if (len % 2) putc(0,ft);
}

#ifdef __MSDOS__
/* need a fwrite and fread that can handle > 64K */
uint32 FWRITE(const void * buffer, size_t size, uint32 count, FILE *stream)
 {
 uint32 i;
 unsigned j;
 unsigned incr = (unsigned)(65520 / size);
 i = 0;
 while(count - i > 0)
  {
  j= fwrite(buffer, size, (((count - i)) > incr? incr: (unsigned)(count - i)), stream);
  if (j!= ((count - i)>incr?incr:(unsigned)(count-i)))
	fail(writerr);
  i+=j;
  buffer = ((char *) buffer) + j*size;
  }
 return i;
 }

uint32 FREAD(void * buffer, size_t size, uint32 count, FILE *stream)
 {
 uint32 i;
 unsigned j;
 unsigned incr = (unsigned)(65520 / size);
 i = 0;
 while(count - i > 0)
  {
  j= fread(buffer, size, (((count - i)) > incr? incr:(unsigned)(count - i)), stream);
  if (j!= ((count - i)>incr?incr:(unsigned)(count-i)))
	fail(readerr);
  i+=j;
  buffer = ((char *) buffer) + j*size;
  }
 return i;
 }

#endif

static char rcs_id[]="$Id: misc.c,v 1.1 1994/03/19 09:21:31 dlai Exp $";

#if 0
$Log: misc.c,v $
 * Revision 1.1  1994/03/19  09:21:31  dlai
 * Initial revision
 *

#endif
