
{ Menus unit.  Menudefs.inc defines menu structure as a constant and MUST be
 in the current directory. Note that the unit will need to be re-compiled
 when used with a new source file.

                               Rowan McKenzie 28/3/89}

Unit menus;

Interface

Uses rm, graph, mousfunc;

  {$i menudefs.inc}

Var
  menustorage    : Array[1..noheadings]
                     Of Record
                          entry          : Array[1..maxverticalbars]
                                             Of Pointer;
                        End;

Procedure draw_menu_box(menuheading, menupos : Integer;
                        invert         : Boolean);

  { draws one menu box corresponding to entry menupos under menuheading}

Procedure remove_menu_box(menuheading, menupos : Integer);

  { removes specified menu box, and restores previos image}

Procedure draw_menu_headers;

  { draws row of menu heading boxes at top of screen}

Procedure draw_menu_column(menuheading : Integer);

  { draws column of menu boxes for given heading at top of screen}

Procedure remove_menu_column(menuheading : Integer);

  { removes column of menu boxes for given heading, and restores image}

Function menu_selection(direction, column : Byte) : Integer;


Implementation


  Procedure draw_menu_box(menuheading, menupos : Integer;
                          invert         : Boolean);

    { draws one menu box corresponding to entry menupos under menuheading}

  Var i, x, y, boxwidth, boxheight : Integer;

  Begin                           {draw_menu_box}
    settextstyle(menufont, horizdir, menufontsize);
    settextjustify(lefttext, toptext);
    boxwidth := (getmaxx-menuxoffset*2) Div noheadings;
    boxheight := Round(textheight(' ')*1.5);
    x := menuxoffset+(menuheading-1)*boxwidth;
    y := (menupos-1)*boxheight;
    If (menupos > 1) And Not invert Then {menu headers are never removed}
                                         {now save image under box to be drawn}
      getimage(x, y, x+boxwidth, y+boxheight-1,
               menustorage[menuheading].entry[menupos]^);
    If invert Then
      selectfillstyle(solidfill, menucolor)
    Else
      selectfillstyle(solidfill, menubcolor);
    bar(x, y, menuxoffset+(menuheading)*boxwidth, menupos*boxheight-1);
    If invert Then
      selectcolor(menubcolor)
    Else
      selectcolor(menucolor);
    line(x, menupos*boxheight-1,
         menuxoffset+(menuheading)*boxwidth, menupos*boxheight-1);
    line(x, y, x, menupos*boxheight-1);
    line(menuxoffset+(menuheading)*boxwidth, y,
         menuxoffset+(menuheading)*boxwidth, menupos*boxheight-1);
    If (getmaxcolor > 1) And
       Not menustructure[menuheading].entry[menupos].visible
    Then
      selectcolor(menuinvisiblecolor);
    outtextxy(x, y, ' '+menustructure[menuheading].entry[menupos].title);
    selectcolor(menubcolor);
    If Not menustructure[menuheading].entry[menupos].visible
    Then
      For i := 2 To Pred(boxwidth) Div 2 Do
        line(x+i*2, y+2, x+i*2, y+boxheight-2);
  End;                            {draw_menu_box}


  Procedure remove_menu_box(menuheading, menupos : Integer);

    { removes specified menu box, and restores previos image}

  Var x, y, boxwidth, boxheight : Integer;

  Begin                           {remove_menu_box}
    settextstyle(menufont, horizdir, menufontsize);
    boxwidth := (getmaxx-menuxoffset*2) Div noheadings;
    boxheight := Round(textheight(' ')*1.5);
    x := menuxoffset+(menuheading-1)*boxwidth;
    y := (menupos-1)*boxheight;
    putimage(x, y, menustorage[menuheading].entry[menupos]^, normalput);
  End;                            {remove_menu_box}


  Procedure draw_menu_headers;

    { draws row of menu heading boxes at top of screen}

  Var i          : Integer;

  Begin                           {draw_menu_headers}
    For i := 1 To noheadings Do
      If menustructure[i].entry[1].selection <> inactive Then
        draw_menu_box(i, 1, False);
  End;                            {draw_menu_headers}


  Procedure draw_menu_column(menuheading : Integer);

    { draws column of menu boxes for given heading at top of screen}

  Var i          : Integer;

  Begin                           {draw_menu_column}
    For i := 2 To maxverticalbars Do
      If menustructure[menuheading].entry[i].selection <> inactive Then
        draw_menu_box(menuheading, i, False);
  End;                            {draw_menu_column}



  Procedure remove_menu_column(menuheading : Integer);

    { removes column of menu boxes for given heading, and restores image}

  Var i          : Integer;

  Begin                           {remove_menu_column}
    draw_menu_box(menuheading, 1, False);
    For i := 2 To maxverticalbars Do
      If menustructure[menuheading].entry[i].selection <> inactive Then
        remove_menu_box(menuheading, i);
  End;                            {remove_menu_column}



  Function menu_selection(direction, column : Byte) : Integer;

{ determines which (if any) menu bar was selected in either horizontal (header)
 mode or vertical (sub menu) mode}

  Var boxwidth, boxheight, selection : Integer;

  Begin                           {menu_selection}
    settextstyle(menufont, horizdir, menufontsize);
    boxwidth := (getmaxx-menuxoffset*2) Div noheadings;
    boxheight := Round(textheight(' ')*1.5);
    Case direction Of
      vertdir :
        Begin
          If (mousex >= menuxoffset+(column-1)*boxwidth) And
          (mousex <= menuxoffset+column*boxwidth) And
          (mousey < menustructure[column].nentries*boxheight) And
          (mousey > boxheight) Then
            selection := mousey Div boxheight+1
          Else
            selection := -1;
          If (selection > -1) And
             Not menustructure[column].entry[selection].visible Then
            selection := -1;
        End;
      horizdir :
        Begin
          If (mousex > menuxoffset) And
          (mousex < menuxoffset
                    +noheadings*((getmaxx-menuxoffset*2) Div noheadings)-1) And
          (mousey <= boxheight) And
          (mousey >= 0) Then
            selection := (mousex-menuxoffset) Div boxwidth+1
          Else
            selection := -1;
          If (selection > -1) And
            Not menustructure[selection].entry[1].visible Then
            selection := -1;
        End;
    End;                          {case}
    menu_selection := selection;
  End;                            {menu_selection}

End.
