#include <time.h>
#include <sys/timeb.h>

extern volatile int done; /* Flag indicating that Ctrl-C was pressed */
extern volatile int buffer_full; /* Flag indicating that a record buffer is ready */
extern int windfunc;      /* Flag set to selected window function */
extern int gain;          /* Amount of db/octave gain */
extern int deriv;         /* Flag for doing differencing for 6db/octave gain */
extern int palette;       /* Number of the current palette */
extern int diff_mode;     /* Flag for using diff-mode for palette */
extern int stereo;        /* Flag indicating stereo or mono mode */
extern int stereo_diff;   /* Flag indicating L/R (0) or (L-R)/(L+R) (1) mode */
extern int logamp;        /* Flag indicating linear/log amplitude scale */
extern float amp_scale;   /* Scale factor used in linear amplitude mode */
extern float log_scale;   /* Scale factor used in logarithmic amplitude mode */
extern int log_base;      /* Base level used in logarithmic amplitude mode */
extern int freeze;        /* Flag indicating frozen display */
extern int df,tf;         /* Counters used for frequency tick marks */
extern int repcount;      /* Pixels displayed per frequency bin */

extern long SampleRate;   /* A/D sampling rate */
extern long displayed;    /* Count of number of displayed results */
extern double starttime;  /* Time at which sampling began */
extern long basetime;     /* Time value when the program began */
extern struct timeb tb;   /* Structure for grabbing the current time */
extern int accel_factor;  /* Number of FFTs performed per sampled buffer */
extern int buffer_offset; /* Offset in buffer to start processing data */
extern int buffer_step;   /* Samples to step forward after each FFT */
extern int fftlen;        /* Number of points for FFT */
extern short *fftdata;    /* Array for FFT data */
extern short *wind;       /* Array storing windowing function */
extern short *olddata;    /* Array for storing old display data for diff mode */
extern short *fftdata2;   /* Buffer for stereo mode */
extern short *olddata2;   /* Buffer for stereo mode */
extern void *buffer;      /* Buffer for gathering data */
extern void *offsetbuffer; /* Pointer to half point in buffer */

extern char ini_file[];   /* Filename used for INI information */
extern char *window_name[];  /* Descriptive names of the window functions */
extern char *palette_name[]; /* Descriptive names of the palettes */

/* Soundcard function pointers */
extern void (*reset_soundcard)(void);
extern void (*halt_soundcard)(void);
extern void (*cleanup_soundcard)(void);
extern void (*recordblock)(void *);
extern void (*set_mixer)(int,int);

extern char *audio_device;  /* Name of the audio device */
extern char *mixer_device;  /* Name of the mixer device */
extern char *output_device; /* Name of the output device */

extern int Soundcard;     /* Flag indicating which soundcard is active */
extern int mixers;        /* Flag indicating the presence of mixers */
extern int sample_size;   /* Flag indicating the bits per sample (8 or 16) */
extern int sb_irq;        /* Setting for Soundblaster IRQ */
extern int sb_dma;        /* Setting for Soundblaster DMA */
extern int sb_addr;       /* Setting for the Soundblaster port address */
extern int mic_level;     /* Current mic mixer level */
extern int ext_level;     /* Current ext mixer level */
extern int int_level;     /* Current int mixer level */

extern int _font_width;   /* Width of the font in pixels */
extern int _font_height;  /* Height of the font in pixels */
extern int _font_color;   /* Current font color */
extern int _draw_colors;  /* Number of colors available */
