/* SuperVGA information block */

typedef struct {
    char    VESASignature[4];       /* 'VESA' 4 byte signature          */
    short   VESAVersion;            /* VBE version number               */
    char    far *OEMStringPtr;      /* Pointer to OEM string            */
    long    Capabilities;           /* Capabilities of video card       */
    short   far *VideoModePtr;      /* Pointer to supported modes       */
    short   TotalMemory;            /* Number of 64kb memory blocks     */
    char    reserved[236];          /* Pad to 256 byte block size       */
    } SVGAInfoBlock;

/* SuperVGA mode information block */

typedef struct {
    short   ModeAttributes;         /* Mode attributes                  */
    char    WinAAttributes;         /* Window A attributes              */
    char    WinBAttributes;         /* Window B attributes              */
    short   WinGranularity;         /* Window granularity in k          */
    short   WinSize;                /* Window size in k                 */
    short   WinASegment;            /* Window A segment                 */
    short   WinBSegment;            /* Window B segment                 */
    void    far *WinFuncPtr;        /* Pointer to window function       */
    short   BytesPerScanLine;       /* Bytes per scanline               */
    short   XResolution;            /* Horizontal resolution            */
    short   YResolution;            /* Vertical resolution              */
    char    XCharSize;              /* Character cell width             */
    char    YCharSize;              /* Character cell height            */
    char    NumberOfPlanes;         /* Number of memory planes          */
    char    BitsPerPixel;           /* Bits per pixel                   */
    char    NumberOfBanks;          /* Number of CGA style banks        */
    char    MemoryModel;            /* Memory model type                */
    char    BankSize;               /* Size of CGA style banks          */
    char    NumberOfImagePages;     /* Number of images pages           */
    char    res1;                   /* Reserved                         */
    char    RedMaskSize;            /* Size of direct color red mask    */
    char    RedFieldPosition;       /* Bit posn of lsb of red mask      */
    char    GreenMaskSize;          /* Size of direct color green mask  */
    char    GreenFieldPosition;     /* Bit posn of lsb of green mask    */
    char    BlueMaskSize;           /* Size of direct color blue mask   */
    char    BlueFieldPosition;      /* Bit posn of lsb of blue mask     */
    char    RsvdMaskSize;           /* Size of direct color res mask    */
    char    RsvdFieldPosition;      /* Bit posn of lsb of res mask      */
    char    DirectColorModeInfo;    /* Direct color mode attributes     */
    char    res2[216];              /* Pad to 256 byte block size       */
    } ModeInfoBlock;

extern SVGAInfoBlock _svgaInfo;
extern ModeInfoBlock _modeInfo;

typedef short bool;
typedef unsigned char uchar;
typedef unsigned long ulong;

void clear800x600x8(void);
typedef unsigned char DacPalette256[256][3];
void setvgapalette256(unsigned char far *PalBuf);
void setBank(int bank);
void putPixel(int x,int y,int color);
int getPixel(int x,int y);
void line(int x1,int y1,int x2,int y2,int color);
void box(int x1,int y1,int x2,int y2,int color);
void writeText(int x,int y,int color,char far *str);
/****************************************************************************
 *
 * Function:     getModeInfo
 * Parameters:   mode    - Mode number to get info for
 *               modeInfo - Pointer to a structure in which to place the info
 * Returns:      1 if successful, 0 on failure
 *
 * Description:  Get the information about the specific mode, and places it
 *               in the structure pointed to by modeInfo
 *
 ****************************************************************************/
int getModeInfo(int mode, ModeInfoBlock far *modeInfo);
int initSuperVGA(void);
int getSVGAInfo(SVGAInfoBlock far *svgaInfo);
int setSuperVGAMode(int mode);
void setDisplayStart(int x,int y);
bool checkVESAPageFlip(void);
void SaveState(void);
void RestoreState(void);
void ShiftScreen(void);
