/*-------------------------------------------------------------------------
	22 Feb 2000

-------------------------------------------------------------------------*/

#include "file.h"
#include "parse.h"
#include "grid.h"
extern "C"
{
#include "memory.h"
}
#include "labels.h"
#include<share.h>
#include <stdlib.h>

//-----------------------------------------------------------------------
void File::NotValidFile()
{

  static char *pchar[20] = {"File Error",
	" Matrix cannot recognise this as a ",
	" valid spreadsheet file. Either the ",
	" file has become corrupted, or it was ",
	" not created by Matrix v2.0"
	};

	a->CursorOn();
	a->ShowDialogBox(&pchar[0], 4, 1, 4, 0);

}

//-----------------------------------------------------------------------
void OpenHelp(int rw)
{
  Disk *aa = new Disk;
  static char *ochar[20] =
	 {"File Open",
	  " Opens an existing file or creates a new named filed.",
	  " ",
	  " . You can use the Files and Directories boxes to select the ",
	  "   path name for the file. Or you can type the path name in the ",
	  "   File Name box.",
	  " ",
	  " . If the file doesn't exist, a new empty file is created with ",
	  "   the specified path name.",
	  " "
	  };
	  ochar[3][1] =4;
	  ochar[7][1] =4;




  static char *schar[20] =
	  {"File Save As",
		" Saves and names the file you are working on.",
		" ",
		" . Use this to name a new unnamed file, or to rename an existing ",
		"   file. Use the File Save Command to save an existing file ",
		"   without renaming it.",
		" ",
		" . Enter the path name in the File Name box. Or you can use ",
		"   the Directories and Existing Files boxes to help you select a ",
		"   different filename, or drive.",
		" ",
		" . If there's already an existing file with the same name, then ",
		"   Matrix asks you if you're sure you want to replace it with this ",
		"   file.",
		" "
		};
		schar[3][1] =4;
		schar[7][1] =4;
		schar[11][1] =4;

		  aa->CursorOn();
		  if(!rw)             //if rw =0 its open
			  aa->ShowDialogBox(&ochar[0], 8, 1, 8, 0);  //open help message
		  else
			  aa->ShowDialogBox(&schar[0], 13, 1, 13, 0);  //save help message

	delete aa;
}
//-----------------------------------------------------------------------




//-----------------------------------------------------------------------
//Get a char from either the buffer or refill the buffer from the file
//if there are more chars in the file to read in, then get the
//first char from the newly refilled buffer.
//Entry:
//  clear m_eof & m_buflen if you are reading for file for first time,
//  else leave alone.
//Exit:
// when m_pastchar becomes 1 then you've read past the end of the file.
//  When the end of the file is reached m_eof will be set.


int File::GetChar(int handle)
{
	int t, ch, actualbytes;

	m_pastchar =0; //assume not last char yet
top:
	if(m_buflen)  //if buf not empty get 1st char and shift remaining
	{				  //chars left to take its place

		ch = m_buffer[0];
		if(m_buflen > 1)
		{
			for(t = 0; t < m_buflen; t++){  //shift left the rest
				m_buffer[t] = m_buffer[t+1];
			}
		}

		m_buflen--;

		return ch;

	}
	else   //buffer enpty, try to refill from file
	{
		if(m_eof)   //file finished
		{
			m_pastchar =1; //flag to call to indicate that past char was reached
			return 0; //end of file reached
		}

		a->ReadFile(handle, maxlen, m_buffer, &actualbytes);
		if(!actualbytes)  //if nothing read in
		{
			m_eof =1;  //set flg: no more in file
			m_pastchar =1;
			return 0;
		}

		m_buflen = actualbytes;
		goto top;  //get char from buffer
	}


}
//---------------------------------------------------------------------
//return some characters to the beginning of buffer, pushing the ones
//already in the buffer right.
//Entry:
// string = the adr of the chars to add
// num = the number of chars to add
int File::AddBuf(char *string, int num)
{
	int t;


	if(!num)
		return 0;
	if((num + m_buflen) >84)
	num = num;
	//if there are already chars in the buffer, shift them right to make
	//rome for the ones we are going to add to the beginning.

	if(m_buflen)
	{
		for(t = m_buflen-1; t>=0; t--){
			m_buffer[t+num] = m_buffer[t];
		}

	}

	for(t =0; t<num; t++){
	  m_buffer[t] = string[t];
	}

	m_buflen += num;

	m_pastchar =0;  //not past end of file yet
	return m_buflen;
}
//----------------------------------------------------------------------
//Read in a string from a file
//Exit:
//	ax = r len of the null terminated string, but without the '\n'
int File::GetFileLine(int handle, char *buf, int maxl, int time)
{
	int t, chr;

	t =0;
	if(!time)
	{
		m_eof=0;
		m_buflen =0;
	}
	maxlen = maxl;
//  else leave alone.
	for(;;)
	{
		chr = this->GetChar(handle);
		if(chr == 10 || chr ==0) break;
		if(chr == 13) continue;
		buf[t] = chr;
		t++;
		if(t == maxlen) break;
	}

	buf[t] =0;
	return t;
}
//----------------------------------------------------------------------
//The user clicked on a file name. It was checked and found to be valid
//load it into memory
//Exit:
//	ax =0 if file was loaded
// ax != 0 if error or file missing
int File::LoadFile(char *name)
{

	char cell_name[10];
	char linebuf1[162], linebuf2[162], *p;
	char emailbuf[130];
	char spcstr[86];
	unsigned int tt, x,y, c, r, result;
	unsigned int count;
	int oldcline, chr;
	int len, spcs, nxttab, cline, lenbuf1, actualbytes, t, i, j, handle, ch;
	int time, prevch, pretied, start, times;
	int maxlen;
	unsigned int x2600;
	Cell *jj;

	maxlen =128;

	result =-1;   //flag: file not loaded yet
	times =0;
	start =0;
	pretied =0;
	strcpy(spcstr, "                                        ");
	strcat(spcstr, "                                        ");
	//Buggy(a, i);
	i = a->OpenFile(name, 0, &handle, 0);
	if(i) return i;  //error encountered    perhaps file not found
	//code to read in the file goes here
	//--------
	cline =0;     //haven't started loading lines yet
	m_eof =0;
	m_buflen =0;
	lenbuf1 =0;
	//a->InitMem();     //wipe lines memory
	linebuf1[0] =0;   //empty str

	ch =0;
top:
	prevch = ch;
	//ch =this->GetChar(a, handle);
	//-----
	time =0;
	//Read the spreadsheet identification message
	//any file without this wont be accepted when load in again
	strcpy(linebuf2, "Matrix spreadsheet v2.0");

	len = GetFileLine(handle, linebuf1, maxlen, time);
	if(!len) goto h;
	time++; //flag: don't reset file to beginning next time
	i = a->CompareStrings(linebuf2, linebuf1, 0,1);
	if(!i)
	{
h:		NotValidFile();
		g->NewSheet(); //delete all cells in the sheet
		goto ex;
	}




	len = GetFileLine(handle, linebuf1, maxlen, time);
	if(len <2) goto h;
	x2600 = atoi(linebuf1);
	if( x2600 <1 || x2600 >20800) goto h;

	//read the 26 colwidths  as a string
	len = GetFileLine(handle, linebuf1, maxlen, time);
	if(len != 26) goto h;

	strcpy(linebuf2, name); //preserve editortitle when newing sheet
									//incase its an alias for name
	g->NewSheet(); 			//delete all cells in the sheet
	strcpy(name, linebuf2);     //get back title

	for(t=0; t< 26; t++)
	{
		g->colwidths[t] = linebuf1[t] - 'A';
	}
	//read 4 char string representing the 2 alt rows
	len = GetFileLine(handle, linebuf1, maxlen, time);
	if(len != 4) goto h;
	gbc[7] = linebuf1[0] - 'A';
	gfc[7] = linebuf1[1] - 'A';
	gbc[8] = linebuf1[2] - 'A';
	gfc[8] = linebuf1[3] - 'A';
	g->SetAltRows();

	//read the count number of cells
	len = GetFileLine(handle, linebuf1, maxlen, time);
	count = atoi(linebuf1);

	if(!count) goto ex1;   //all cell's are empty

	if(count <1 || count > 800*26) goto h;


	for(t = 0; t< count; t++)
	{
		tt =0;
		//read in cell name '=' and formula
		len = GetFileLine(handle, linebuf1, maxlen, time);
		if(len <3) goto h;
		cell_name[0] = linebuf1[0];
ag:
		tt++;
		chr = linebuf1[tt];
		if((chr != '=') && (tt ==4)) goto h;   //file corrupt
		if(chr != '=')
		{
			if(!((chr >= '0') && (chr <= '9'))) goto h;
			cell_name[tt] = chr;
			goto ag;
		}

		cell_name[tt] =0;
		//formula begins at &linebuf1[tt+1]

		c = cell_name[0] - 'A'+1;
		if(c <1 || c>26) goto h;
		r = atoi(&cell_name[1]);
		if(r <1 ) goto h;
		if(r >y100) continue;   //cell row exceeds max row, igore it
		//because the file was originally created on a computer with
		//more expanded memory than this one.
		if(t < y2600)   //if the running count is within the capacity of
							 //this sheet area evaluate and store cell
			par->eval_exp(&linebuf1[tt+1], c, r);

	}



	//Read in the cells properties for all the cells, blank or othwise
	//upto and including the last nonblank row.
	//First check the 'Properties' string to make sure we are reading
	//in sync.
	len = GetFileLine(handle, linebuf1, maxlen, time);
	if(len != 10) goto h;
	strcpy(linebuf2, "Properties");
	i = a->CompareStrings(linebuf2, linebuf1, 0,1);
	if(!i)  goto h;   //file corrupted

	//Read in the entire sheet's cells colour properties.
	//upto an including the last nonblabk row.
	i = x2600 /26;  //= r # of lines to read in
	for(y = 0; y<i; y++)
	{

		len = GetFileLine(handle, linebuf1, maxlen, time);
		if(len != 26*3) break;
		//If we are reading in a file written by a computer
		//with more expanded memory than this computer
		//make sure we don't store lines past the max that this computer's
		//expanded memory can take.

		if(y <y100)
		{
			for(x =0; x<26; x++)
			{
				g->scrnsheet = sheet[y*26+x];
				g->scrnsheet->mem[0] = linebuf1[x*3] - 1;
				g->scrnsheet->mem[1] = linebuf1[x*3+1] - 1;
				g->scrnsheet->mem[2] = linebuf1[x*3+2] - 1;
				//store in far memory the cell's display property
				sheet(y*26+x, g->scrnsheet);
			}
		}
	}



ex1:
	result =0; //file loaded
	strcpy(editortitle, name);
ex:
	//Find the first visable column
	t =-1;
	for(;;)
	{
		t++;
		if(g->colwidths[t]) break;
	}
	g->homex =g->letters[t] -'A';
	g->scrncol =0;
	g->homey =0;
	block.validsw =0;
	g->DrawBorder(g->homex, g->homey);
	g->ReDrawSheet(1);
	g->DispCell(1);
	par->AutoCalc();
	g->ReDrawSheet(1);
	g->DispCell(1);
	//-----
	a->CloseFile(handle);


	return result;   //0 = file was loaded, !=0 means not loaded
}

//------------------------------------------------------------------------
//This function is called when the user presses <return> on the input line
// of the open dialog box
// See if the user typed in a path name or a full file name
// 1} if it is a full file name  see if there is a path to do to
//    then check to see if the file name really exists in among the list
//    if files in that path.
//    If so retur 0 and the filename in filenamebuf
//    if there is a full name, but it does not exist display the
//    appropriate diagog error message and return 1
// 2) if there is a path but no file name attempt to set the path
//    if unsuccessful display error message and return 1
//Exit:
//  if ax =0 successful name entered.
//  if ax = 1 caller need not redisplay the org list of files and dirs
//     again, just goto into the input function again
//  if ax = 2 caller must have original files and dirs redisplayed
//  and focus set in inpit field and input function called
int File::EvalPathOrName(char *filenamebuf)
{

	int i, handle, ii, j, specflg;
	int flags, t, found, inputlen;

	char specstr[128], ch1, ch2;
	char errbuf[128];
	char orgpath[128];
	char orgmask[128];
	char drive[128], dir[128], file[128], ext[128];
	char *pchar[6];
	char *p;

	Disk b;     //temp object for dialog box
	Disk c;
	pchar[0] = "Error";

	//set up error string in advance in case there was an error
	inputlen = strlen(inputbuf);

	pchar[1] = "Matrix was unable to find the path";
	errbuf[0] = 39;         //'
	if( inputlen < 50)
	{
		strcpy(&errbuf[1], inputbuf);
		errbuf[inputlen+1] = 39;
		errbuf[inputlen+2] = 0;
	}
	else
	{
		strcpy(&errbuf[1], "...");
		strncpy(&errbuf[4], inputbuf, 50);
		strcpy(&errbuf[54], "...");
		errbuf[57] = 39;
		errbuf[58] =0;
	}
	pchar[2] = &errbuf[0];
	pchar[3] = "";


	//make a backup copy of the current path
	strcpy(orgpath, m_path);
	strcpy(orgmask, m_filemask);
	//split the input string into the components of drive, dir, filename & ext

	flags = fnsplit(inputbuf, drive, dir, file, ext);

	if(!(flags & DRIVE))
	{                       //no drive letter specified, use default drive

		strcpy(drive, m_path);
	}
	else
	{     //see if drive letter is with range
		found =0;              //not found yet
		drive[0] = drive[0] & 95;     //make sure it uppercase  65-90

		for(t =0; t< a->m_numdevs; t++){
			if(a->m_devslist[t] == drive[0]) {found =1; break;}
		}
		if(!found)
		{
a1:    	b.ShowDialogBox(&pchar[0], 3, 1,3,0);
			return 1;          //error: caller must go back to input
									 //but not redisp the org files & dirs
		}
	} //end else

	//we have got a valid drive or we are using the default one
	specstr[0] =0;         //clr specstr
	if((flags & FILENAME) ==FILENAME)
		strcpy(specstr, file);
	if((flags & EXTENSION) ==EXTENSION)
		strcat(specstr, ext);
	//if specstr is empty it means there were no file and no extension
	//os use the org mask
	specflg =0;            //assume we are treating specstr as a filename
	if(!specstr[0])
	{  //since specstr is empty we must use the default mask and treat
		strcpy(specstr, orgmask);  //specstr as a mask
		specflg =1;                //therefore we set its flg



		goto z2; //skip over (the test to determine what specstr is filename
					//or mask, because we have just made it a mask, because it was
					//empty.)
	}

	//we know that specstr is not empty but we still don't know if it is
	//a file name or a mask. scan for a '*'. if found then specstr is a mask
	//else its a filename
	p = strchr(specstr, '*');
	if(p) specflg =1;    //treat specstr as a spec string for dirs
	else
	{
		specflg =0;     // assume specstr is a file name
		if(!(flags & FILENAME))
		{                  //no file name so copy  org mask and treat
			strcpy(specstr, orgmask); //specstr as a file spec
				specflg = 1;
		}

	}

z2:
	//if specstr is really a spec string and not a file name copy
	//it into m_filemask
	if(specflg)
		strcpy(m_filemask, specstr);


	//if there is a directory add it to the drive string
	if((flags & DIRECTORY))
	{
		i = strlen(drive);
		ch1 = drive[i-1];      //is the last of drive char '\'?
		ch2 = dir[0];          //is the first char or dir '\'?
		if(ch1 == 92 && ch2 == 92 ) dir[i-1] =0; //2 '\' del one of them
		strcat(drive, dir);
	}
	else
	{  //since there is no directory we must see if the new drive is
		//the same as the default one. If so we use the current default
		//directory path
		if(drive[0] == m_path[0])
		{
			strcpy(drive, m_path);
			if(drive[0] != 65) goto m1;
		}


	//the new drive is different from the old one and the user
	//specified no directory so we must set the drive first
	//then get the current path of the new drive

		i = drive[0];
		if( i == 'A')
		{

top:  	j = a->IsDriveReady(0);  //check if drive a is readable
			if(j==2)
			{
				pchar[1] = "Drive A: needs a formatted disk.";
				pchar[2] = "Insert the formatted disk in the drive first,";
				pchar[3] = "then click on the OK button.";
				pchar[4] = "Or insert a new disk, shell out to DOS,";
				pchar[5] = "then format it";
				ii= c.ShowDialogBox(&pchar[0], 5, 3, 5,0);
				if(ii ==27)
				{
					//restore original path
					strcpy(m_path, orgpath);
					strcpy(m_filemask, orgmask);

					return 1;
				}
				goto top;

			}
		}
		asm{
				push si
				push di
				mov dx, i
				sub dl, 65
				mov dh, 0
				mov ax, 0e00h     //"Change drive"
				int 21h
				pop di
				pop si
			}


			_getcurrentpath();
			strcpy(m_path, currentpath);
			goto z4;  //the path is already set


	} //end else


	strcpy(m_path, drive);
	//make sure there an '\' at the end of the path, if not append it
m1:
	i = strlen(m_path);
	if(m_path[i-1] !=  92)    // '\'
	{
		m_path[i] = 92;
		m_path[i+1] =0;
	}

	i = _set_path(m_path);
	if(!i)                  //error
	{
		//an error occurred while attempting to set the users path
		//set the original path, display the appropriate error message
		//and exit with ax =1, which means caller need not redisp the
		//orginal list, just reenter the input function
		strcpy(m_path, orgpath);
		i = _set_path(m_path);       //reset the original path
		strcpy(m_filemask, orgmask);
		goto a1;                    //disp error msg and exit
	}

z4:

	if(!(strlen(specstr))) strcpy(specstr, "*.*");

	if((specflg ==0) && ((flags & FILENAME) >0 ))
	{
		//attempt to open the file as a test to see if it really exists
		//i = a->OpenFile(specstr, 0, &handle, 0);
		p = strrchr(inputbuf, 92);    //find last occurrance of "\"
		if(p) strcpy(specstr, p+1);   //only copy the name part
		else strcpy(specstr, inputbuf);  //no "/" so copy the full name
		i = a->OpenFile(specstr, 0, &handle, 0);

		a->CloseFile(handle);
		if(i)
		{
			if(!m_rw)  //loading
			{
				pchar[1] = "Matrix was unable to find the file";
				b.ShowDialogBox(&pchar[0], 3, 1,3,0);
				return 1;          //error: caller must go back to input

			}


			//we havenot found a file of the same name as the user entered
			//we are saving so we are ok
			strcpy(filenamebuf, specstr);
			return 0;
		}

		//we have successfully opened and closed the uers file: it exists
		//but if we are saving we must warn the user
		if(!m_rw) //loading
		{
			strcpy(filenamebuf, specstr);
			return 0;      //report no error
		}
		//we are save, file exists, ask user if ok to replace
		pchar[1] = "Replace existing file?";
		pchar[0] = "Matrix";
		i = b.ShowDialogBox(&pchar[0], 3, 3,3,0);

		if( i == 13)  //replace existing file
		{
			strcpy(filenamebuf, specstr);
			return 0;      //report no error

		}
		return 1;  //dont replace existing file


	}

	//specstr was a mask. copy it to m_filemask and inform the caller to
	//display the dirs and files for the new path and mask
	if(strlen(specstr))
	{
		strcpy(m_filemask, specstr);

	}

	return 2;         //report: caller must reload files and dirs

}
//------------------------------------------------------------------------

//------------------------------------------------------------------------
//This function doesn't do any inputing of the input line.
//it just displays the contents of the input line in any one
//of 4 different cursor styles
//If the length of the lines is greater then 31
//then the last 31 chars of the line are shown
//the cursor, if it is to be visable is shown to the right of the last
//character.
//Entry:
// cursorstyle = 0 small cursor off, and black unselected
//               1 small cursor on, and black unselected
//               2 small cursor off, and black selected
//               3 small cursor on, and black selected

void File::ShowInputLine(char *buf, int cursorstyle)
{
	int x1, y1, len, stpos, displen;
	int color[2], selectstyle;
	char dotbuf[2];

	color[1] = BLACK*16+LIGHTGRAY;    //black selected
	color[0] = LIGHTGRAY*16+BLACK;    //black unselected

	selectstyle = 0;                  //assume black unselected
	if(cursorstyle == 2 || cursorstyle == 3) selectstyle =1;


	len = strlen(buf);
	if(!len)
	{
		if(!m_rw)
			strcpy(buf, filemask);       //filemask is global
		else
			buf[0] =0;

		len = strlen(buf);
	}

	stpos =0;
	if(len> 31) stpos = len-31;       //the c pos of the first char to disp

	displen = len - stpos;  //the r len of the text to disp

	x1 = 15; y1 =1;
	if(len)
		a->WriteLine(&buf[stpos], x1+14, y1+2, 32, color[0], 1);
	else
		a->WriteLine(".", x1+14, y1+2, 32, color[0], 1);

	if(len)
		a->WriteLine(&buf[stpos], x1+14, y1+2, displen, color[selectstyle], 1);

	//since we didn't write to the last char position on the line
	//it may contain rubbish from a line length of 32 or greater
	//so show the last char as a normal dot. The cursor will
	//be positioned on this dot if the len was 32 or greater
	dotbuf[0] = '.';
	a->WriteLine(dotbuf, x1+14+31, y1+2, 1, color[0], 1);

	//turn the small cursor on or off (depending on cursorstyle)
	gotoxy(1+x1+14+displen, 1+y1+2);
	if(cursorstyle == 1 || cursorstyle == 3) a->CursorOn();
	else a->CursorOff();

}
//------------------------------------------------------------------------
//Called from OpenJunior
//This function turns on or off the black select in the files listbox
//and turns on and positions the small cursor on the current item
//it the files listbox
//Entry:
// if cursorstyle =0 turn black select off
//                >0 turn black select on

void File::FocusFilesList(int cursorstyle)
{
	int c, x, y, width;

	width = (m_f.m_x2 - m_f.m_x1) -1;

	c = 0;
	if(cursorstyle) c =1;

	x = m_MousePos[1].x1+2;
	y = m_MousePos[1].y1+1;
	if(m_f.m_numitems) y += m_f.m_currentitem -m_f.m_topitem;


	gotoxy(x, y);
	m_f.CursorOn();
	if(m_numfiles)
	{
		_fetch_stored_entry(tempbuf, m_f.m_currentitem +m_numdirs);
		strcpy(&filebuf[1], &tempbuf[9]);
		filebuf[0] =32;
		m_f.WriteLine(filebuf, x-2, y-1, width, m_colour[c]);
	}
}
//------------------------------------------------------------------------
//allow the user to enter a new line width
//Entry:
//  chr2 = the first char to enter into the inputline
//Exit:
// ax =13  <return>
//     27  <esc>
//      9  <tab>
//     30  <up>
//     31  <down>
//     257  <click>
//     258  <double click>
int File::InputLineWidth()
{
	int i, n, icursorpos;
	static char keys[5] = {13, 27, 9, 30, 31};

	strcpy(m_linewidthbuf, "   ");

	icursorpos = 0;
	i = a->Input(&m_MousePos[0], 14, m_linewidthbuf, m_MousePos[4].x1+1, m_MousePos[4].y1,
								3, 3, &icursorpos, m_colour[0], 1+2+4+256, 0);

	a->CursorOn();    //keep the cursor on
	if(i >=0 && i <= 4)   //a # corrosponding to the Input exit key
	{
		i = keys[i];

	}
	if(i== 27) goto ex;
	if(i==13 || i== 9 || i== 30 || i == 31 || i==257)
	{//attempt to accept the users new line width
		n = atoi(m_linewidthbuf);
		if(n < 10 || n> 78) n = m_linewidth;
		m_linewidth =n;
	}

ex:
	this->FocusLineWidth(0);
	return i;
}
//------------------------------------------------------------------------
//This function turns on or off the black select in the dirs listbox
//and turns on and positions the small cursor on the current item
//it the dirs listbox
//Entry:
// if cursorstyle =0 turn black select off
//                >0 turn black select on
void File::FocusDirsList(int cursorstyle)
{
	int x, y, t, c, width;

	width = (m_d.m_x2 - m_d.m_x1) -1;

	c =0;
	if(cursorstyle) c =1;

	x = m_MousePos[2].x1+2;
	y = m_MousePos[2].y1+1;

	y += m_d.m_currentitem -m_d.m_topitem;
	gotoxy(x, y);
	m_d.CursorOn();

	if(m_d.m_currentitem < m_numdirs)   //caller wants a dir, not a dev
	{
		_fetch_stored_entry(tempbuf, m_d.m_currentitem);
		strcpy(&filebuf[1], &tempbuf[9]);
		filebuf[0] =32;
	}
	//return "[-A-] to the list box
	//and store and display on the input line something like
	//"D:*.*"
	else
	{
		strcpy(filebuf, " [-A-]");
		t = m_d.m_currentitem- m_numdirs;
		filebuf[3] = (m_d.m_devslist[t] &95); //convert drive
																//letter to upper case
	}


	m_d.WriteLine(filebuf, x-2, y-1, width, m_colour[c]);

}
//------------------------------------------------------------------------
void File::FocusWordWrap()
{
	int x, y;

	x = m_MousePos[3].x1;
	y = m_MousePos[3].y1;
	gotoxy(x+2, y+1);
	//m_f.CursorOn();

}
//------------------------------------------------------------------------
//Entry:
// cursorstyle =0 turn linewidth black select off
//             =1 turn linewidth black select on
void File::FocusLineWidth(int cursorstyle)
{
	int x, y;
	char numbuf[10];

	x = m_MousePos[4].x1;
	y = m_MousePos[4].y1;
	gotoxy(x+2, y+1);
	sprintf(numbuf, "%d  ", m_linewidth);
	m_f.WriteLine(numbuf, x+1, y, 3, m_colour[cursorstyle]);

}
//-----------------------------------------------------------------------
//Show the button cursor at the button pressed, unpressed
//and show the small cursor as well, at the the button pos
//Entry:
//  button = 0 to 2
//  pressed = 0 or 1
void File::FocusButton(int button, int pressed)
{
	int x, y;

	a->m_buttonscursorpos = button;
	a->m_buttonpressed = pressed;
	a->ShowButtons();

	x = m_MousePos[5+button].x1;
	y = m_MousePos[5+button].y1;
	if(!button) x++;
	gotoxy(x+3, y+1);


}
//------------------------------------------------------------------------
//This function is only included for debugging purposes.
//The structure TMouse m_mouse is defined in screen.h
//and included as a member var in keyboard.h
//the it is instanciated when var a is created
void File::ShowMouseCoordinates()
{
		  int i;
		  char linebuf1[40];
	i = a->WhichFieldIsMouseIn(&this->m_MousePos[0], &mouse, 13);
	//i = -1 if mouse is not in a valid field
	sprintf(linebuf1, "   %5d   %5d  %5d ", mouse.x, mouse.y, i);
	gotoxy(1,1);
	a->WriteLine(linebuf1, 0,0, GREEN*16+ BLACK);
}
//------------------------------------------------------------------------
//Constructor for class File
File::File()
{
	m_colour[0] = LIGHTGRAY*16+BLACK;    //black select off
	m_colour[1] = BLACK*16+LIGHTGRAY;    //black select on

	//input field coordinates
	m_MousePos[0].x1 = 29;
	m_MousePos[0].y1 = 3;
	m_MousePos[0].x2 = 60;
	m_MousePos[0].y2 = 3;
	m_MousePos[0].available =1;
	//file listbox coordinates
	m_MousePos[1].x1 = 18;
	m_MousePos[1].y1 = 7;
	m_MousePos[1].x2 = 37;
	m_MousePos[1].y2 = 18;
	m_MousePos[1].available =0;    //not available
	//dir listbox coordinates
	m_MousePos[2].x1 = 41;
	m_MousePos[2].y1 = 7;
	m_MousePos[2].x2 = 60;
	m_MousePos[2].y2 = 14;
	m_MousePos[2].available =1;
	//word wrap coordinates
	m_MousePos[3].x1 = 41;
	m_MousePos[3].y1 = 16;
	m_MousePos[3].x2 = 53;
	m_MousePos[3].y2 = 16;
	m_MousePos[3].available =1;
	//line width coordinates
	m_MousePos[4].x1 = 53;
	m_MousePos[4].y1 = 19;
	m_MousePos[4].x2 = 57;
	m_MousePos[4].y2 = 19;
	m_MousePos[4].available =1;
	//ok button coordinates
	m_MousePos[5].x1 = 19;
	m_MousePos[5].y1 = 21;
	m_MousePos[5].x2 = 26;
	m_MousePos[5].y2 = 21;
	m_MousePos[5].available =1;
	//cancel button coordinates
	m_MousePos[6].x1 = 33;
	m_MousePos[6].y1 = 21;
	m_MousePos[6].x2 = 42;
	m_MousePos[6].y2 = 21;
	m_MousePos[6].available =1;
	//help button coordinates
	m_MousePos[7].x1 = 51;
	m_MousePos[7].y1 = 21;
	m_MousePos[7].x2 = 58;
	m_MousePos[7].y2 = 21;
	m_MousePos[7].available =1;
	//up arrow in file list box coordinates
	m_MousePos[8].x1 = 38;
	m_MousePos[8].y1 = 7;
	m_MousePos[8].x2 = 38;
	m_MousePos[8].y2 = 7;
	m_MousePos[8].available =0;     //not available
	//down arrow in file listbox coordinates
	m_MousePos[9].x1 = 38;
	m_MousePos[9].y1 = 18;
	m_MousePos[9].x2 = 38;
	m_MousePos[9].y2 = 18;
	m_MousePos[9].available =0;     //not available

	//scrollbar in file listbox coordinates
	m_MousePos[10].x1 = 38;
	m_MousePos[10].y1 = 8;
	m_MousePos[10].x2 = 38;
	m_MousePos[10].y2 = 17;
	m_MousePos[10].available =0;    //not available

	//up arrow in dir listbox coordinates
	m_MousePos[11].x1 = 61;
	m_MousePos[11].y1 = 7;
	m_MousePos[11].x2 = 61;
	m_MousePos[11].y2 = 7;
	m_MousePos[11].available =0;      //not available

	//down arrow in dir listbox coordinates
	m_MousePos[12].x1 = 61;
	m_MousePos[12].y1 = 14;
	m_MousePos[12].x2 = 61;
	m_MousePos[12].y2 = 14;
	m_MousePos[12].available =0;       //not available
	//scroll bar in dir listbox coordinates
	m_MousePos[13].x1 = 61;
	m_MousePos[13].y1 = 8;
	m_MousePos[13].x2 = 61;
	m_MousePos[13].y2 = 13;
	m_MousePos[13].available =0;      //not available

	//scroll down line in file list box   (on the bottom of the frame)
	m_MousePos[14].x1 = 17;
	m_MousePos[14].y1 = 19;
	m_MousePos[14].x2 = 38;
	m_MousePos[14].y2 = 19;
	m_MousePos[14].available =0;      //not available

	//scroll up line in file list box (on the top of the frame)
	m_MousePos[15].x1 = 17;
	m_MousePos[15].y1 = 6;
	m_MousePos[15].x2 = 38;
	m_MousePos[15].y2 = 6;
	m_MousePos[15].available =0;      //not available

	//scroll down line in dir list box   (on the bottom of the frame)
	m_MousePos[16].x1 = 40;
	m_MousePos[16].y1 = 15;
	m_MousePos[16].x2 = 61;
	m_MousePos[16].y2 = 15;
	m_MousePos[16].available =0;      //not available

	//scroll up line in dir list box (on the top of the frame)
	m_MousePos[17].x1 = 40;
	m_MousePos[17].y1 = 6;
	m_MousePos[17].x2 = 61;
	m_MousePos[17].y2 = 6;
	m_MousePos[17].available =0;      //not available

	//m_wordwrap = 1;                 //word wrap on
	m_linewidth = maxlen;
	strcpy(m_filemask, "*.mtx");         //filemask is a global var

	//setup coordinates for the file listbox
	m_f.m_x1       = m_MousePos[1].x1 -1;
	m_f.m_y1       = m_MousePos[1].y1 -1;
	m_f.m_x2       = m_MousePos[1].x2 +1;
	m_f.m_y2       = m_MousePos[1].y2 +1;
	m_f.m_numitems = 0;   //this needs to be changed
	m_f.m_currentitem =0; //this will be changed during scrolling in the
																 //class WinCtrls listbox
	m_f.m_topitem  =  0;  //and this as well

	//------------------------------
	//setup coordinates for the dir listbox
	m_d.m_x1       = m_MousePos[2].x1 -1;
	m_d.m_y1       = m_MousePos[2].y1 -1;
	m_d.m_x2       = m_MousePos[2].x2 +1;
	m_d.m_y2       = m_MousePos[2].y2 +1;
	m_d.m_numitems = 0;   //this needs to be changed
	m_d.m_currentitem =0; //this will be changed during scrolling in the
																 //class WinCtrls listbox
	m_d.m_topitem  =  0;  //and this as well


}
//------------------------------------------------------------------------
// This function opens the "open" box.
void File::OpenOpenBox()
{
	char linebuf1[81];
	char msgbuf[80];
	int x1, y1, x2, y2, t, i, stpos, lenbuf, lenmsg;
	int box1x1, box1y1, box2x1, box2y1;

	x1 = 15; x2 = 63;
	y1 = 1; y2 = 22;
	a->OpenShadowBox(x1, y1, x2, y2, LIGHTGRAY*16+BLACK, 0);

  strcpy(linebuf1, "                                                 ");
  strcpy(msgbuf, "Open");
  if(m_rw)
	 strcpy(msgbuf, "Save As");

  lenbuf = strlen(linebuf1);
  lenmsg = strlen(msgbuf);
  stpos = 1+(lenbuf /2) - (lenmsg/2);  //pos to enter title text into
													//linebuf1
  for(t = 0; t<lenmsg; t++){
			linebuf1[stpos+t] = msgbuf[t];
  }

  a->WriteLine(linebuf1, x1, y1, -1, WHITE*16+BLACK);
  a->WriteLine("File name: [                                ]",
			x1+2, y1+2, -1, LIGHTGRAY*16+BLACK);

  if(!m_rw)
	  a->WriteLine("Files:                 Directories:",
							x1+3, y1+4, -1, LIGHTGRAY*16+BLACK);

	else
		a->WriteLine("Existing Files:        Directories:",
							 x1+3, y1+4, -1, LIGHTGRAY*16+BLACK);


 box1x1 = x1+2;        box1y1 =y1+5;
 box2x1 = box1x1+21+2; box2y1 =box1y1;
 a->DrawBox(box1x1, box1y1, box1x1+21, box1y1+13, LIGHTGRAY*16+BLACK, 1);
 a->DrawBox(box2x1, box2y1, box2x1+21, box2y1+13-4, LIGHTGRAY*16+BLACK, 1);
 //a->WriteLine("[ ] Word Wrap", box2x1+1, box2y1+10, -1, LIGHTGRAY*16+BLACK);
//a->WriteLine("Line Width: [   ]", box2x1+1, box2y1+13, -1, LIGHTGRAY*16+BLACK);

 a->m_buttonsposx1[0] = box1x1+2;
 a->m_buttonsposy1[0] = box1y1+15;
 a->m_buttonsposx1[1] = box1x1+2+14;
 a->m_buttonsposy1[1] = box1y1+15;
 a->m_buttonsposx1[2] = box1x1+2+32;
 a->m_buttonsposy1[2] = box1y1+15;
 a->m_buttonsnum = 3;
 a->m_buttonscursorpos = 0;
 a->m_buttonpressed =0;
/*
  if(m_wordwrap)
  {
	  linebuf1[0] = 'x';
	  a->WriteLine(linebuf1, box2x1+2, box2y1+13-3, 1, LIGHTGRAY*16+BLACK);
  }
  sprintf(linebuf1, "%2d", m_linewidth);
  a->WriteLine(linebuf1, box2x1+2+12, box2y1+13, -1, LIGHTGRAY*16+BLACK);
 */
	a->SetTextOnButtons(3, 1+2+4);
	a->ShowButtons();

}
//-------------------------------------------------------------------------
