{$R-,S-,I-,D-,T-,F+,V-,B+,N-,L+ }
{$M 1024,0,0 }
program EmulATT;
uses dos;

var
    regs      : registers;      {registers for INTR function}
CONST
   Version = '1.00c'; {Beta Test Release}
   VERDATE = '02 February 1988';

begin {EMATTSET}
  Writeln ('EMATTSET: Version ',version,',  ',verdate);
  Writeln ('AT&T Graphics card Emulator for the DEC VAXmate computer');
  writeln ('       Copyright 1988 University of Saskatchewan');
  writeln;
  writeln ('         Written by Kevin Lowey');
  writeln ('         Department of Computing Services');
  writeln ('         Room 56 Physics Building');
  writeln ('         University of Saskatchewan');
  writeln ('         Saskatoon, Saskatchewan Canada S7N 0W0');
  writeln;
  writeln ('         LOWEY@SASK.BITNET');
  writeln ('         ...!ihnp4!sask!lowey.uucp');
  writeln ('         (306) 966-4826 SASK-TEL');
  writeln;

  { Check to see if already installed }
  regs.ax := $FF00;
  intr($10,regs);
  if NOT (regs.ax = $FF42) then begin {Signature found}
    writeln ('The program EMULATT is not currently installed');
    writeln ('Run EMULATT to make your VAXmate computer emulate');
    writeln ('the AT&T 6300 640x400x2 graphics mode along with the');
    writeln ('DEC VAXmate 640x400x2 graphics mode.');
    writeln ('Program aborting . . .');
    halt(1);
  end
  else begin {install}
    if paramstr(1) = '+' then begin
      regs.ax := $FF01;
      intr($10,regs);
      if regs.ax = $FFFF then begin
        writeln ('The AT&T emulator will now report to calling programs');
        writeln ('that it is using an AT&T graphics card, and NOT the');
        writeln ('VAXmate graphics card.  This is not the default setting.');
      end
      else begin
        writeln ('An error occured.  The AT&T graphics emulator will');
        writeln ('continue to report the current settings');
      end;
    end
    else if paramstr(1) = '-' then begin
      regs.ax := $FF02;
      intr($10,regs);
      if regs.ax = $FFFF then begin
        writeln ('The AT&T emulator will now report to calling programs');
        writeln ('that it is using the VAXmate graphics card, and NOT the');
        writeln ('AT&T graphics card.  This is the default setting.');
      end
      else begin
        writeln ('An error occured.  The AT&T graphics emulator will');
        writeln ('continue to report the current settings');
      end;
    end
    else begin {Unrecognised Parameter}
      writeln ('USAGE:  EMATTSET {+,-}');
      writeln (
        '  "EMATTSET +" makes EMULATT report that it is using an AT&T');
      writeln (
        '               graphics card for compatibility with AT&T software.');
      writeln;
      writeln (
        '  "EMATTSET -" makes EMULATT report that it is using a VAXmate');
      writeln (
        '               graphics card for compatibility with DEC software.');
      writeln;
      regs.ax := $FF03;
      intr($10,regs);
      if regs.AX = $FF40 then
        writeln ('EMULATT is currently set to "+"')
      else
        writeln ('EMULATT is currently set to "-"');
    end; {usage}
  end; {install}
end. {att2vaxMATE}