procedure SHADOWS (var Shades: nodearray);
{ Flag the shades array with any nodes that are in a shadow. }

var Node:                      word;          { node # }
    Surf:                      word;          { surface # }
    Xfotran, Yfotran, Zfotran: real;          { transformed focal pt. }
    { surface minimum & average (Ztran) }
    XYmax:                     real;          { max coordinate }
    Txeye, Tyeye, Tzeye:       real;          { temps for eye coords }
    Tgxmin, Tgxmax, Tgymin, Tgymax: integer;  { temps for plot limits }
    Tmagnify:                  real;          { temp for magnification }
    Result:                    boolean;       { result of normalize setup }
{$ifndef BIGMEM}
    Surfmin, Surfmax: surfaces;
      { surface minimum & maximum (Ztran) }
{$endif}

begin
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
with ptrd^ do with ptre^ do with ptrf^ do
with ptrk^ do with ptrn^ do
begin
{$endif}

  menumsg ('Computing shadows...');
{ Preserve the old status before changing to shadowing values }
  Txeye := Xeye;
  Tyeye := Yeye;
  Tzeye := Zeye;
  Tgxmin := Gxmin;
  Tgxmax := Gxmax;
  Tgymin := Gymin;
  Tgymax := Gymax;
  Tmagnify := Magnify;

{ New values to transform all nodes/surfaces as if they were being seen
  by the primary light source. NOTE: This only works with a single light
  source!
}
  Xeye := Xlite[1];
  Yeye := Ylite[1];
  Zeye := Zlite[1];
  Gxmin := 0;         { shorten search time by using a coarser grid }
  Gxmax := 100;
  Gymin := 0;
  Gymax := 100;
  Magnify := 1.0;

{ Transform from 3-D to 2-D coordinates }
  setorigin;
  for Node := 1 to Nnodes do
    perspect (Xworld[Node], Yworld[Node], Zworld[Node],
                 Xtran[Node],  Ytran[Node],  Ztran[Node]);

{ Set plotting limits and normalize transformed coords to shadow-test coords }
  perspect (Xfocal, Yfocal, Zfocal, Xfotran, Yfotran, Zfotran);
  Result := setnormal (Xfotran, Yfotran, XYmax);

{ Normalize all the nodes }
  for Node := 1 to Nnodes do begin
    normalize (Xtran[Node], Ytran[Node], Xfotran, Yfotran, XYmax);
    { Initialize the Shades to zero }
    Shades[Node] := 0.0;
  end;
  minmax (Surfmin, Surfmax, Nsurf);
  shelsurf (Surfmin, Surfmax, Nsurf);

  for Node := 1 to Nnodes do begin
    { Check every surface closer to the light source to see if it blocks
    the light from this node. }
    Surf := Nsurf;
    while (Surf > 0) do begin
      if (Surfmax[Surf] <= Ztran[Node]) then
        { Gone past this node; flag that none of the remaining surfaces can
        possibly be in front of it. }
        Surf := 0
      else if (Surfmin[Surf] > Ztran[Node]) then begin
        { Only check surfaces that are completely in front of the node
        (avoids surfaces that contain the node being considered in front
        of the node) }
        if (cheksurf (round(Xtran[Node]),round(Ytran[Node]),Surf)) then begin
          Shades[Node] := -1.0;
          { Flag to stop the loop }
          Surf := 0;
        end;
      end; { if Surfmax }
      Surf := Surf - 1;
    end; { while }
  end; { for Node }

{ Done; now put things back the way we found them }
  Xeye := Txeye;
  Yeye := Tyeye;
  Zeye := Tzeye;
  Gxmin := Tgxmin;
  Gxmax := Tgxmax;
  Gymin := Tgymin;
  Gymax := Tgymax;
  Magnify := Tmagnify;
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure SHADOWS }
