procedure SURFACE;

{ Make a surface model drawing of the object }
var Node:                      word;          { node # }
    Surf:                      word;          { surface # }
    Node1:                     word;          { 1st node of surface }
    Shade:                     real;          { shade of surface }
    Count:                     integer;       { # vertices in shadow }
    Vert:                      integer;       { vertex # }
    User_abort:                boolean;       { did the user abort? }
    ch:                        char;
{$ifndef BIGMEM}
    Shades: nodearray;
      { shade at each node }
    Surfmin, Surfmax: surfaces;
      { surface minimum & maximum (Ztran) }
{$endif}
label ABORTTEXT,                              { text-mode abort }
      ABORTGRPH;                              { graphics-mode abort }

begin
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
with ptrd^ do with ptre^ do with ptrf^ do
with ptrh^ do with ptri^ do with ptrj^ do
with ptrk^ do with ptrn^ do
begin
{$endif}
  perf_start;
  User_abort := TRUE;
  if (checkey) then goto ABORTTEXT;
{$ifndef NOSHADOW}
  if (Shadowing) then
    shadows (Shades)
  else
{$else}
  if (Shadowing) then
    writeln ('Error: Shadows not implemented in this version')
  else
{$endif}
    for Node := 1 to Nnodes do
      Shades[Node] := 0.0;

  if (Viewchanged) or (Shadowing) then begin
    menumsg ('Transforming to 2-D...');
    if (checkey) then goto ABORTTEXT;
{ Transform from 3-D to 2-D coordinates }
    setorigin;
    for Node := 1 to Nnodes do
      perspect (Xworld[Node], Yworld[Node], Zworld[Node],
                Xtran[Node],  Ytran[Node],  Ztran[Node]);

    if (checkey) then goto ABORTTEXT;
{ Set plotting limits and normalize transformed coords to screen coords }
    perspect (Xfocal, Yfocal, Zfocal, Xfotran, Yfotran, Zfotran);
    if (not setnormal (Xfotran, Yfotran, XYmax)) then begin
      menumsg ('Warning: Focal point outside data limits.');
      writeln;
      write   ('  Press any key ...');
      ch := readkey;
    { Erase the previous message }
      menumsg ('');
      writeln;
      write ('                          ');
    end;

    if (checkey) then goto ABORTTEXT;
{ Normalize all the nodes }
    for Node := 1 to Nnodes do
      normalize (Xtran[Node], Ytran[Node], Xfotran, Yfotran, XYmax);

    if (checkey) then goto ABORTTEXT;
    menumsg ('Sorting surfaces...');
    minmax (Surfmin, Surfmax, Nsurf);
    shelsurf (Surfmin, Surfmax, Nsurf);
    Viewchanged := FALSE;
  end; { if Viewchanged }

  setshade;                            { Setup for shading calculations }

{$ifdef USE_IFF}
  menumsg ('Plotting...');
{$endif}

  setgmode (Nmatl);
  for Surf := 1 to Nsurf do begin
    Count := 0;
    if (Shadowing) then begin
      { Count the number of vertices that are in a shadow }
      for Vert := 1 to Nvert[Surf] do
        if (Shades[konnec (Surf, Vert)] < 0.0) then
          Count := Count + 1;
    end;
{ In a shadow if any vertex of the surface is in shadow }
    if (Count < 1) then begin
      { Not in shadow }
      Node1 := konnec (Surf, 1);
      if (Nsides = 2) then begin
        { do the secondary surface first, if desired }
        Shade := shading (Surf, 2);
        if (Shade >= 0.0) then
          fillsurf (Surf, Matl[Surf], Shade);
      end;
      Shade := shading (Surf, 1);
      if (Shade >= 0.0) then
        fillsurf (Surf, Matl[Surf], Shade);
    end else
      { In a shadow - show at ambient light intensity }
      fillsurf (Surf, Matl[Surf], Ambient[Matl[Surf]]);
    { Show border of surface, if requested }
    if (ShowAllBorders > 0) then
      border (Surf, Matl[Surf]);
    if (grafstat) then goto ABORTGRPH;
  end; { for Surf }
  drawaxes (Xfotran, Yfotran, XYmax);

  perf_stop (4);

{$ifdef USE_IFF}
  menumsg ('Saving IFF...');
  saveiff (Filemask + '.IFF', VGApal);
{$else}
  { Wait for user keypress to continue }
  continue;
{$endif}
  User_abort := FALSE;

  ABORTGRPH:
  exgraphic;
  ABORTTEXT:
  if (User_abort) then
    perf_stop (0);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; {procedure SURFACE }
