procedure OPENFILE (Filename: text80; var Infile: text);
{ Open a file with error checking. Prompt for new one if file not found }

var Flnm: string[80];
    Fileread: boolean;

begin
  Flnm := Filename;
  Fileread := FALSE;
  while (NOT Fileread) do begin
    assign (Infile, Flnm);
    {$I-}
    reset (Infile);
    {$I+}
    if (ioresult <> 0) then begin
      writeln ('Error: file ',Flnm,' does not exist.');
      write ('Enter new file name (or <enter> to exit): ');
      readln (Flnm);
      if (Flnm = '') then
        halt;
    end else
      Fileread := TRUE;
  end;
end;   { procedure Openfile }

procedure READFILE (Filename: text80);
{ procedure will read the input data from the file passed }

var
  Version: integer;       { used for multiple version input flag(only 3 now) }
  j: integer;             { counter for looping and reading into arrays}
  RInfile: text;          { file to read}
  Realvar: vartype;       { temporary array for storage of line input }
  Num: integer;           { number of inputted values on the line }
  Comment: text80;        { comment at end of line }
  Line_num: integer;      { line number in input file }
  Nvread: integer;        { #vertices read so far in this surface }
  Vert: integer;          { vertex # }
  Cmmd: integer;          { script command number }
  Mat: integer;           { material # }
  Node: integer;          { node # }
  Surf: integer;          { surface # }
  Nvert: integer;         { # vertices in surface }
  Flpurpose: string[127]; { title for plot }
  RNnodes: integer;       { READFILE temp for Nnodes }
  RNsurf: integer;        { READFILE temp for Nsurf }
  RMaxvert: integer;      { READFILE temp for Maxvert }
  RNmatl: integer;        { READFILE temp for Nmatl }
  RNscript: integer;      { READFILE temp for Nscript }
  RNsides: integer;       { READFILE temp for Nsides }
  Oldnmatl: integer;      { previous Nmatl }
  Oldnnodes: integer;     { previous Nnodes }
  Mat1, Mat2: integer;    { range of matl numbers in this file }

begin {procedure READFILE}
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
begin
{$endif}

  openfile (Filename, RInfile);

  writeln ('Reading data from file ',Filename);

  readln (RInfile, Flpurpose);
  Line_num := 2;
  Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 1) then begin
    writeln ('Bad input: Reading version number.');
    close (RInfile);
    close (Infile);
    halt;
  end;
  Version := round(Realvar[1]);
  if (Version = 1) then begin
    Line_num := Line_num + 1;
    Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 4) then begin
      writeln ('Bad input: Reading #nodes, #surfaces, Maxvert and #materials',
          ' (line ',Line_num,')');
      close (RInfile);
      close (Infile);
      halt;
    end;
    RNnodes := round(Realvar[1]);
    RNsurf := round(Realvar[2]);
    RMaxvert := round(Realvar[3]);
    RNmatl := round(Realvar[4]);
    RNscript := 0;
    RNsides := 1;
  end else if (Version = 2) then begin
    Line_num := Line_num + 1;
    Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 6) then begin
      writeln ('Bad input: Reading #matl, #nodes, #surf, #script, Maxvert,',
          ' #sides (line ',Line_num,')');
      close (RInfile);
      close (Infile);
      halt;
    end;
    RNmatl := round(Realvar[1]);
    RNnodes := round(Realvar[2]);
    RNsurf := round(Realvar[3]);
    RNscript := round(Realvar[4]);
    RMaxvert := round(Realvar[5]);
    RNsides := round(Realvar[6]);
  end else if (Version = 3) or (Version = 4) then begin
    Line_num := Line_num + 1;
    Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 5) then begin
      writeln ('Bad input: Reading #matl, #nodes, #surf, Maxvert,',
          ' #sides (line ',Line_num,')');
      close (RInfile);
      close (Infile);
      halt;
    end;
    RNmatl := round(Realvar[1]);
    RNnodes := round(Realvar[2]);
    RNsurf := round(Realvar[3]);
    RMaxvert := round(Realvar[4]);
    RNsides := round(Realvar[5]);
  end else begin
    writeln('Wrong data input version number specified');
    close (RInfile);
    close (Infile);
    halt;
  end;

  if (RMaxvert > Maxvert) then begin
    writeln ('Error in file ',Filename,': Maxvert (',RMaxvert,
         ') exceeds previous Maxvert (',Maxvert,')');
    close (RInfile);
    close (Infile);
    halt;
  end;

  Oldnmatl := Nmatl;
  if (Matl_reuse) then begin
    { Re-use material numbers across data files }
    if (RNmatl > Nmatl) then
      Nmatl := RNmatl;
    Mat1 := 1;
    Mat2 := RNmatl;
  end else begin
    { Generate unique material numbers for each data file }
    Mat1 := Nmatl + 1;
    Mat2 := Nmatl + RNmatl;
    Nmatl := Mat2;
  end;
    
    if (RNnodes+Nnodes<=MAXNODES) and (RNsurf+Nsurf<=Realmaxsurf) and
       (Nmatl<=MAXMATL) and (Maxvert*(RNsurf+Nsurf)<=MAXCONNECT) and
       (RNsides<=2) and (RNnodes>0) and (RNsurf>0) and (RNmatl>0) then begin

      for Mat := Mat1 to Mat2 do begin
        Line_num := Line_num + 1;
        Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
        if (Version <= 2) then begin
          if (Num <> 3) then begin
            writeln ('Bad input: Reading data for material #',Mat,' (line ',
                Line_num,')');
            close (RInfile);
            close (Infile);
            halt;
          end;
          R1[Mat] := Realvar[1];
          R2[Mat] := Realvar[2];
          R3[Mat] := 0.0;
          Color[Mat] := round(Realvar[3]);
          Ambient[Mat] := 0.1;
        end else if (Version = 3) then begin
          if (Num <> 4) then begin
            writeln ('Bad input: Reading data for material #',Mat,' (line ',
                Line_num,')');
            close (RInfile);
            close (Infile);
            halt;
          end;
          R1[Mat] := Realvar[1];
          R2[Mat] := Realvar[2];
          R3[Mat] := Realvar[3];
          Color[Mat] := round(Realvar[4]);
          Ambient[Mat] := 0.1;
        end else begin
          if (Num <> 5) then begin
            writeln ('Bad input: Reading data for material #',Mat,' (line ',
                Line_num,')');
            close (RInfile);
            close (Infile);
            halt;
          end;
          R1[Mat] := Realvar[1];
          R2[Mat] := Realvar[2];
          R3[Mat] := Realvar[3];
          Color[Mat] := round(Realvar[4]);
          Ambient[Mat] := Realvar[5];
        end; { if Version }
      end;  {for Mat}

      Oldnnodes := Nnodes;
      for Node := Nnodes+1 to RNnodes+Nnodes do begin
        Line_num := Line_num + 1;
        Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
        if (Num <> 3) then begin
          writeln ('Bad input: Reading data for node #',Node,' (line ',
              Line_num,')');
          close (RInfile);
          close (Infile);
          halt;
        end;
        World[Node][1] := Realvar[1];
        World[Node][2] := Realvar[2];
        World[Node][3] := Realvar[3];
      end; {for Node}
      Nnodes := Nnodes + RNnodes;

      for Surf := Nsurf+1 to RNsurf+Nsurf do begin
        Line_num := Line_num + 1;
        Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
        if (Num < 5) then begin
          writeln ('Bad input: Reading data for surface #',Surf,' (line ',
              Line_num,')');
          if (Num > 2) then
            writeln ('Must have at least 3 nodes on a surface!');
          close (RInfile);
          close (Infile);
          halt;
        end;
        Nvert := round(Realvar[1]);
{ Offset the material number to match the material data that was read in }
        Matl[Surf] := round(Realvar[2]) + Mat1 - 1;
        if (Nvert<3) or (Nvert>Maxvert) or (Nvert<Num-2)
            then begin
          writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
          if (Nvert < 3) then
            writeln ('Must have at least 3 nodes per surface')
          else if (Nvert > Maxvert) then
            writeln ('#vertices exceeds Maxvert')
          else
            writeln ('#vertices specified does not match #arguments');
          close (RInfile);
          close (Infile);
          halt;
        end; { if Nvert... }
        Nvread := Num - 2;
        for Vert := 1 to Nvread do
{ Offset the node number to match the node data that was read in }
          Connect[(Surf-1)*Maxvert+Vert] := round(Realvar[Vert+2]) + Oldnnodes;
        while (Nvread < Nvert) do begin
          Line_num := Line_num + 1;
          Num := inreal (RInfile, Realvar, Comment, Line_num, FALSE);
          if (Num < 1) or (Nvread + Num > Nvert) then begin
            writeln ('Error in surface ',Surf,'(line ',Line_num,'): ');
            if (Num = 0) then
              writeln ('No data read.')
            else if (Nvread + Num > Nvert) then
              writeln ('Too many vertices read.');
            close (RInfile);
            close (Infile);
            halt;
          end; { if Num... }
          Vert := Nvread + 1;
          for j := 1 to Num do begin
            Connect[(Surf-1)*Maxvert+Vert] := round(Realvar[j]) + Oldnnodes;
            Vert := Vert + 1;
          end;
          Nvread := Nvread + Num;
        end; { while }
        if (Nvert < Maxvert) then
          Connect[(Surf-1)*Maxvert+Nvert+1] := 0;
      end; { for Surf }
      Nsurf := Nsurf + RNsurf;
    end else begin
      writeln ('Error in read file ',Filename);
      if (RNnodes+Nnodes>MAXNODES) or (RNnodes<1) then
        writeln('Nnodes (',RNnodes,') must be between 1 and ',MAXNODES-Nnodes);
      if (RNsurf+Nsurf>Realmaxsurf) or (RNsurf<1) then
        writeln('Nsurf (',RNsurf,') must be between 1 and ',Realmaxsurf-Nsurf);
      if (Nmatl>MAXMATL) or (RNmatl<1) then
        writeln('Nmatl (',RNmatl,') must be between 1 and ',MAXMATL);
      if Maxvert*(RNsurf+Nsurf)>MAXCONNECT then begin
        writeln('Number of surfaces or max number of vertices too large!');
        writeln('Maxvert (',Maxvert,') * Nsurf (',RNsurf,
            ') must be smaller than ',MAXCONNECT-Maxvert*Nsurf);
      end;
      if (RNsides<1) or (RNsides>2) then
        writeln('Nsides (',RNsides,') must be either 1 or 2');
      close (RInfile);
      close (Infile);
      halt;
    end; { if RNnodes... }

    close (RInfile);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure READFILE }
