{ This file is no longer used in SURFMODL, only for file conversion. }
procedure READINI (Datafile: text80);
{ Read the INItialization file }

var Num: integer;           { #parameters read on line }
    Realvar: vartype;       { temp array for storage of line input }
    Infile: text;           { file to read }
    Comment: text80;        { comment at end of line }
    Version: integer;       { version # of the INI file }
    Line_num: integer;      { line # in input file }
    Cmmd: integer;          { selection # }
    Filebad: boolean;       { flag bad file }
    Mat: integer;           { material # }
    Lite: integer;          { light source # }
    Sys_type_set: boolean;  { was the system type set in this INI file? }
    Sys: integer;           { index to legal system number array }
    Command: cmmdtype;      { symbolic command type }
    Parm: parmtype;         { symbolic parameter }
    Dir: dirstr;            { directory name of file }
    Name: namestr;          { name of file }
    Ext: extstr;            { extension of file }
    ch: char;

begin
{$ifndef INICVT}
  ClrScr;
  writeln ('Reading .INI file . . .');
{$endif}
  Sys_type_set := FALSE;
  { Correctly name the INI file }
  fsplit (Datafile, Dir, Name, Ext);
  { Save the Data file mask for other data file uses }
  Filemask := Dir + Name;

  Inifile := Filemask + '.INI';

  Filebad := FALSE;
{ See if it exists }
  assign (Infile, Inifile);
  {$I-}
  reset (Infile);
  {$I+}
  if (ioresult = 0) then begin
    { File exists; read it and set global parameters }
    Line_num := 0;
    Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num, FALSE);
    if (Num <> 1) then begin
      writeln ('Bad INIfile: Reading version number.');
      Filebad := TRUE;
    end else
      Version := round (Realvar[1]);

    if (Version >= 1) and (Version <= 4) and (not Filebad) then begin
      Cmmd := 0;
      while (Cmmd <> 99) and (not Filebad) do begin
        Num := inreal (Infile, Realvar, Comment, Command, Parm, Line_num,
            FALSE);
        if (Num < 1) then begin
          writeln ('Bad INIfile');
          Filebad := TRUE;
        end;
        if (Filebad) then
          Cmmd := 99
        else
          Cmmd := round (Realvar[1]);

        case Cmmd of
          1:
            begin
            (* KVC 09/05/91 Obsolete!
            if (Num <> 2) then begin
              writeln ('INIfile: System number input bad');
              Filebad := TRUE;
            end else begin
              grSys := trunc(Realvar[2]);
              if (version = 4) then begin
                grmode := round (100.0 * (realvar[2] - grsys));
              end
              else
                grmode := 0; {guaranteed for all modes}
              if version <= 3 then
                grsys := oldsys[grsys];
              if (Version >= 3) then
                Sys_type_set := TRUE;
            end; { if Num }
            *)
            end;
          2:
            if (Num <> 4) then begin
              writeln ('INIfile: Eye coordinates bad');
              Filebad := TRUE;
            end else begin
              Xeye := Realvar[2];
              Yeye := Realvar[3];
              Zeye := Realvar[4];
            end;
          3:
            if (Num <> 4) then begin
              writeln ('INIfile: Focal point coordinates bad');
              Filebad := TRUE;
            end else begin
              Xfocal := Realvar[2];
              Yfocal := Realvar[3];
              Zfocal := Realvar[4];
            end;
          4:
            if (Num <> 2) then begin
              writeln ('INIfile: Bad magnification factor');
              Filebad := TRUE;
            end else
              Magnify := Realvar[2];
          5:
            if (Num <> 2) or (Realvar[2]<0.0) or (Realvar[2]>3.0) then begin
              writeln ('INIfile: Bad view type');
              Filebad := TRUE;
            end else
              Viewtype := round(Realvar[2]);
          6:; { Autoresolve removed }
          7:
            if (Version = 1) then begin
              if (Num <> 6) or (Realvar[2]<1.0)or(Realvar[2]>MAXMATL) then begin
                writeln ('Warning: Bad matl data in INIfile.');
                write ('Press any key to continue...');
                ch := readkey;
              end else begin
                Mat := round (Realvar[2]);
                if (Mat > Nmatl) then
                  Nmatl := Mat;
                R1[Mat] := Realvar[3];
                R2[Mat] := Realvar[4];
                R3[Mat] := Realvar[5];
                Color[Mat] := round (Realvar[6]);
                Ambient[Mat] := 0.1;
                color_to_RGB (Color[Mat], Redmax[Mat], Grnmax[Mat], 
                              Blumax[Mat]);
              end;
            end else begin
              if (Num <> 7) or (Realvar[2]<1.0)or(Realvar[2]>MAXMATL) then begin
                writeln ('Warning: Bad matl data in INIfile.');
                write ('Press any key to continue...');
                ch := readkey;
              end else begin
                Mat := round (Realvar[2]);
                if (Mat > Nmatl) then
                  Nmatl := Mat;
                R1[Mat] := Realvar[3];
                R2[Mat] := Realvar[4];
                R3[Mat] := Realvar[5];
                Color[Mat] := round (Realvar[6]);
                Ambient[Mat] := Realvar[7];
                color_to_RGB (Color[Mat], Redmax[Mat], Grnmax[Mat], 
                              Blumax[Mat]);
              end;
            end; { if Version }
          8:
            if (Num <> 6) or (Realvar[2] < 1.0) or (Realvar[2] > MAXLITE)
                or (Realvar[2] > Nlite+1) then begin
              writeln ('INIfile: Bad Light Source Data');
              Filebad := TRUE;
            end else begin
              Lite := round (Realvar[2]);
              if (Lite > Nlite) then
                Nlite := Lite;
              Xlite[Lite] := Realvar[3];
              Ylite[Lite] := Realvar[4];
              Zlite[Lite] := Realvar[5];
              Intensity[Lite] := Realvar[6];
            end;
          9:
            if (Num <> 2) or (Version <> 1) then begin
              writeln ('INIfile: Bad ambient light');
              Filebad := TRUE;
            end else
              for Mat := 1 to Nmatl do
                Ambient[Mat] := Realvar[2];
          10:
            if (Num <> 2) then begin
              writeln ('INIfile: Bad Epsilon');
              Filebad := TRUE;
            end else
              if (Realvar[2] > 0.0) then begin
                Epsilon := Realvar[2];
                Interpolate := TRUE;
              end else
                Interpolate := FALSE;
          11:
            if (Num <> 2) or (Realvar[2]<0.0) or (Realvar[2]>1.0) then begin
              writeln ('INIfile: Bad Shadowing');
              Filebad := TRUE;
            end else
              if (Realvar[2] = 0.0) then
                Shadowing := FALSE
              else
                Shadowing := TRUE;
          12: begin
             (* KVC 09/17/91 Obsolete!
             if (Num <> 2) or (Realvar[2] < 0) then begin
               writeln ('INIfile: Bad number of graphics characters');
               Filebad := TRUE;
             end else
               Ngraphchar := round (Realvar[2]);
             *)
            end;
          13:
             if (Num <> 6) or (Realvar[2]<0) or (Realvar[2]>2) or
                (Realvar[6]<0) or (Realvar[6]>32) then begin
               writeln ('INIfile: Bad axis codes');
               Filebad := TRUE;
             end else begin
               Showaxes := round(Realvar[2]);
               Xaxislen := Realvar[3];
               Yaxislen := Realvar[4];
               Zaxislen := Realvar[5];
               Axiscolor := round(Realvar[6]);
             end;
          14:
             if (Num <> 2) then begin
               writeln ('INIfile: Bad window number');
               Filebad := TRUE;
             end else
               Nwindow := round(Realvar[2]);
          15:
            begin
            (* KVC 09/14/91 Obsolete!
             if (Num <> 3) or (Realvar[2] < 1) or (Realvar[3] < 0) or
                 (Realvar[3] > 1) then begin
               writeln ('INIfile: Bad system color data');
               Filebad := TRUE;
             end else begin
               Ncolors := round(Realvar[2]);
               if (Realvar[3] = 0) then
                 Mono := FALSE
               else
                 Mono := TRUE;
             end;
            *)
            end;
          16:
            if (Num <> 2) then begin
              writeln ('INIfile: Bad Randshade');
              Filebad := TRUE;
            end else begin
              if (Realvar[2] > 0.0) then begin
                Randshade := Realvar[2];
                Dorandom := TRUE;
              end else
                Dorandom := FALSE;
            end;
          17:
            if (Num <> 5)or(Realvar[2] < 1.0)or(Realvar[2] > MAXMATL) then begin
              writeln ('INIfile: Bad RGB data');
              Filebad := TRUE;
            end else begin
              Mat := round(Realvar[2]);
              if (Mat > Nmatl) then
                Nmatl := Mat;
              Redmax[Mat] := round(Realvar[3]);
              Grnmax[Mat] := round(Realvar[4]);
              Blumax[Mat] := round(Realvar[5]);
              if Redmax[Mat] < 1 then
                Redmax[Mat] := 1;
              if Redmax[Mat] > 256 then
                Redmax[Mat] := 256;
              if Grnmax[Mat] < 1 then
                Grnmax[Mat] := 1;
              if Grnmax[Mat] > 256 then
                Grnmax[Mat] := 256;
              if Blumax[Mat] < 1 then
                Blumax[Mat] := 1;
              if Blumax[Mat] > 256 then
                Blumax[Mat] := 256;
              end;
          18:
             if (Num <> 2) then begin
               writeln ('INIfile: Bad ShowAllBorders code');
               Filebad := TRUE;
             end else
               ShowAllBorders := round(Realvar[2]);
          99:
          else
            writeln ('Warning: INIfile has unknown code (',Cmmd,')');
        end; { case Cmmd }
      end; { while }
    end else begin
      writeln ('INIfile: Bad version number');
      Filebad := TRUE;
    end; { if Version }

    close (Infile);
    if (Filebad) then begin
      writeln ('Error found in line ',Line_num,' of ',Inifile);
{$ifdef INICVT}
      Ini_ok := FALSE;
{$else}
      write ('Press any key to continue...');
      ch := readkey;
{$endif}
    end;

  end else begin
{$ifdef INICVT}
    writeln ('File ', Inifile, ' does not exist.');
    Ini_ok := FALSE;
{$else}
    writeln ('No INItialization file.');
    writeln ('Using last values.');
{$endif}
  end; { if ioresult }

  (* KVC 09/05/91 Obsolete!
  if not sys_type_set then
    grsys := 0; {detect graphics}

  if driveron then begin
    closedriver;
  end;
  setsys;
  *)

end; { procedure READINI }
