	.MODEL	SMALL, C
	.CODE
	PUBLIC cx_i486cacheoff

CR0_CD_DIS	EQU	40000000h	; Disable cache with CR0
CR0_NW_DIS	EQU	20000000h	; Disable writethru with CR0
					; Actually, the NW bit is hardwired
					; to 0 at all times on the Cyrix,
					; but we set and clear it anyway...

;
;	void cx_i486cacheoff(void)
;
;	This routine disables and flushes the i486 internal cache.
;

cx_i486cacheoff	PROC

	.386P				; let fly with 32 bit instructions

; Shouldn't need these with MASM v5.1 as it does this for you.
;	push	ebp
;	mov	ebp, esp

	mov	eax, cr0		; cr0 -> eax
	or	eax, CR0_CD_DIS		; Turn "off" CD bit
	or	eax, CR0_NW_DIS		; Turn "off" NW bit
	mov	cr0, eax		; eax -> cr0
	db	0fh			; INVD instruction:
	db	08h			; Flush i486 cache
	db	0fh			; WBINVD instruction:
	db	09h			; Flush i486 cache with write back
	jmp	cx_postinvd2		; Jmp to next to force queue flush
cx_postinvd2:

; Same as above, i.e. MASM v5.1 should do this.
;	pop	ebp

	ret

cx_i486cacheoff	ENDP
		END

