#ifndef __TINY__
#error Use TINY memory model--Don't forget to turn off debug info
#endif

#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include <string.h>
#include <bios.h>
#include <sys\stat.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>

//#define BETA

#define VER "v2.1"
#define RIGHT 0x01
#define LEFT 0x02
#define TRUE 1
#define FALSE 0
#define NUMTAIL 20

void touch(char[]);
void main(void);
char *upit(char[]);
void writeout(void);
void help(void);
void printlog(void);
void add2log(void);
void getlog(char *);
void tail(void);
void exitlog(void);

char filename[255], bday[4], bmon[4], ampm[3], comment = FALSE, set = FALSE,
 log = FALSE, needhelp = FALSE, cnt, found, showtail = FALSE, logexit = FALSE;
struct ffblk ffblk;
struct time curtime;
struct date curdate;
struct tm *old, *new;
time_t thetime;
int sec, min, numday, hour, bdate, bhour, bmin, bsec, byear;
struct COUNTRY cinfo;
long int totalboots = 0;

void main(void)
{
    strcpy(ampm, "am");
    strcpy(filename, searchpath(_argv[0]));
    country(0, &cinfo);
    for (cnt = 1; cnt + 1 <= _argc; cnt++) {
	found = FALSE;
	if (strcmp("SET", upit(_argv[cnt])) == 0)
	    set = found = TRUE;
	if (strcmp("LOG", upit(_argv[cnt])) == 0)
	    log = found = TRUE;
	if (strcmp("TAIL", upit(_argv[cnt])) == 0)
	    showtail = found = TRUE;
	if (strcmp("COMMENT", upit(_argv[cnt])) == 0) {
	    /* non zero is true, and this marks where the comment starts */
	    comment = found = cnt + 1;
	    /* don't need to go any farther, the rest is comment */
	    cnt = _argc;
	    /* if "comment" is the only thing ignore it */
	    _argc--;
	}
	if (strcmp("EXIT", upit(_argv[cnt])) == 0)
	    logexit = found = TRUE;
	if (!found) {
	    needhelp = TRUE;
	    break;
	}
    }
    if (needhelp) {
	help();
	exit(1);
    }
    if (logexit) {
	exitlog();
	exit(0);
    }
    if (set)
	touch(filename);
    if (log) {
	if (set)
	    add2log();
	if (!set && !showtail)
	    printlog();
	if (!set && showtail) {
	    printf("Error:  Cannot combine \"log\" and \"tail\" without \"set\"\n");
	    exit(1);
	}
    }
    if (set)
	puts("...");
    if (showtail) {
	if (set)
	    printf("\n");
	tail();
    }
    if (_argc == 1 || (comment && !set && !log && !showtail))
	writeout();
    fcloseall();
}				/* main */

void touch(char name[])
{
    FILE *file;
    char tmp;

    int modifiers;

    modifiers = bioskey(2);
    if (!(modifiers & RIGHT || modifiers & LEFT)) {
	printf("Updating launch time");
	file = fopen(name, "r+");
	fseek(file, SEEK_SET, 0);
	fread(&tmp, 1, 1, file);
	rewind(file);
	fwrite(&tmp, 1, 1, file);

    } else {
	printf("Aborting update of %s\n", _argv[0]);
	exit(1);
    }
}				/* touch */

char *
 upit(char str[])
{
    int i;

    for (i = 0; i < strlen(str); i++) {
	str[i] = toupper(str[i]);
    }
    return str;
}


void writeout(void)
{
    time_t tmp_t;
    struct tm *tmp_tm;
    int tmpint;

    new = malloc(sizeof(struct tm));
    old = malloc(sizeof(struct tm));
    findfirst(filename, &ffblk, FA_DIREC);
    (*old).tm_sec = 2 * (ffblk.ff_ftime & 31);
    (*old).tm_min = (ffblk.ff_ftime & 2016) >> 5;
    (*old).tm_hour = (ffblk.ff_ftime & 63488) >> 11;
    (*old).tm_mday = (ffblk.ff_fdate & 31);
    (*old).tm_mon = ((ffblk.ff_fdate & 480) >> 5) - 1;
    (*old).tm_year = ((ffblk.ff_fdate & 65024) >> 9) + 80;

    tmpint = (*old).tm_hour;
    tmp_t = mktime(old);
    tmp_tm = localtime(&tmp_t);
    memcpy(old, tmp_tm, sizeof(struct tm));
    (*old).tm_hour = tmpint;

    thetime = time(NULL);
    new = localtime(&thetime);

    sec = (*new).tm_sec - (*old).tm_sec;
    min = (*new).tm_min - (*old).tm_min;
    if (sec < 0) {
	sec += 60;
	min--;
    }
    hour = (*new).tm_hour - (*old).tm_hour;
    if (min < 0) {
	min += 60;
	hour--;
    }
    numday = (*new).tm_yday - (*old).tm_yday + (365 * ((*new).tm_year - (*old).tm_year));
    if (hour < 0) {
	hour += 24;
	numday--;
    }
    sscanf(ctime(&tmp_t), "%3s %3s %d %d:%d:%d %d", bday, bmon, &bdate, &bhour, &bmin, &bsec, &byear);
    bhour = tmpint;
    if (bhour >= 12 && cinfo.co_time == 0) {
	bhour -= 12;
	ampm[0] = 'p';
    } //
	else
	//ampm[0] = '\0';

    if (bhour == 0)
	bhour = 12;
    if (numday < 0)
	fprintf(stderr, "Error:  System clock has been changed since bootup\n\n");
    else if (numday != 0)
	switch (cinfo.co_date) {
	case 0:
	    printf("System launched at %2.2d%c%2.2d%c%2.2d%s on %s, %s %d, %d\nUp for %d day(s), %2.2d%c%2.2d%c%2.2d\n", bhour, cinfo.co_tmsep[0], bmin, cinfo.co_tmsep[0], bsec, ampm, bday, bmon, bdate, byear, numday, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 1:
	    printf("System launched at %2.2d%c%2.2d%c%2.2d on %s, %d %s, %d\nUp for %d day(s), %2.2d%c%2.2d%c%2.2d\n", bhour, cinfo.co_tmsep[0], bmin, cinfo.co_tmsep[0], bsec, bday, bdate, bmon, byear, numday, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 2:
	    printf("System launched at %2.2d%c%2.2d%c%2.2d on %s, %d %s, %d\nUp for %d day(s), %2.2d%c%2.2d%c%2.2d\n", bhour, cinfo.co_tmsep[0], bmin, cinfo.co_tmsep[0], bsec, bday, byear, bmon, bdate, numday, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
    } else
	switch (cinfo.co_date) {
	case 0:
	    printf("System launched at %2.2d%c%2.2d%c%2.2d%s on %s, %s %d, %d\nUp for %2.2d%c%2.2d%c%2.2d\n", bhour, cinfo.co_tmsep[0], bmin, cinfo.co_tmsep[0], bsec, ampm, bday, bmon, bdate, byear, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 1:
	    printf("System launched at %2.2d%c%2.2d%c%2.2d on %s, %d %s, %d\nUp for %2.2d%c%2.2d%c%2.2d\n", bhour, cinfo.co_tmsep[0], bmin, cinfo.co_tmsep[0], bsec, bday, bdate, bmon, byear, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 2:
	    printf("System launched at %2.2d%c%2.2d%c%2.2d on %s, %d %s, %d\nUp for %2.2d%c%2.2d%c%2.2d\n", bhour, cinfo.co_tmsep[0], bmin, cinfo.co_tmsep[0], bsec, bday, byear, bmon, bdate, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	}
}

void help(void)
{
#ifdef BETA
    printf("\nUptime %s BETA\t\t\t\t\t    By Eric S. Peters\n", VER);
#else
    printf("\nUptime %s\t\t\t\t\t\t    By Eric S. Peters\n", VER);
#endif
    printf("Compiled at %s, on %s\n\n", __TIME__, __DATE__);
    puts("Uptime will tell you how long your computer has been running since the last");
    puts("time it was launched.  Executed with no parameters, it returns the time elapsed");
    puts("since bootup.\n");
    puts("SET\t: Will set the launchtime.  This needs to be in the AUTOEXEC.BAT file.");
    puts("\t: If either shift key is held, the \"set\" is aborted.");
    puts("LOG\t: Will print the log, or add to the log if called with \"set\".");
    puts("\t: The log file will be in the same directory as uptime.");
    puts("TAIL\t: Will print the last 20 entries in the log, and can only be combined");
    puts("\t: with \"log\" if \"set\" is called as well.");
    puts("COMMENT\t: Will print the rest of the command line into the log");
    puts("\t: and will be ignored if not called with \"set\" and \"log\".");
    puts("EXIT\t: Will add exit time, and total time to the log.");
#ifdef BETA
    puts("\nThis is a BETA copy of uptime.  Please don't distribute.\n");
#else
    puts("\nUptime can be copied and distributed freely.\n");
#endif
    puts("I used to think that it would be pretty hard to find a bug in a small program");
    puts("like this, but I was wrong.  I can be reached at peters@cs.colostate.edu.\n");
}

void printlog()
{
    char logname[255], line[81], ans, tail[NUMTAIL][81],exitinlog=FALSE;
    FILE *log;
    int cnt = 0, num2prn = 0;

    getlog(logname);
    log = fopen(logname, "r");
    if (log != NULL) {
	while (fgets(line, 81, log) != NULL) {
	    printf("%s", line);
        if(strncmp(line,"Launched",8)!=0)exitinlog=TRUE;
	    totalboots++;
	    if (++cnt % 24 == 0 && eof(log) != 0) {
		printf("(T)ail, (Q)uit, or anything else\r");
		ans = toupper(getch());
		while (kbhit())
		    getch();
		switch (ans) {
		case 'Q':
		case 27:
		    exit(0);
		    break;
		case 'T':
		    cnt = 0;
		    fseek(log, 0, SEEK_SET);
		    totalboots = 0;
		    while (fgets(tail[cnt % NUMTAIL], 81, log) != NULL){
              if(strncmp(tail[cnt%NUMTAIL],"Launched",8)!=0)exitinlog=TRUE;
			  totalboots++;
              cnt++;
            }
		    num2prn = (--cnt);
		    if (num2prn > 20)
			clrscr();
		    if (num2prn > NUMTAIL)
			num2prn = NUMTAIL;
            if(exitinlog)
              puts("\nLast few Launches\n");
            else
		      printf("\nLast %d of %ld Launch(es):\n\n", num2prn, totalboots);
		    for (ans = 1; ans <= num2prn; ans++)
			printf("%s", tail[cnt++ % num2prn]);
		    fclose(log);
		    exit(0);
		}
	    }
	}
    if(exitinlog)
      printf("\nDelete the log? ");
    else
	  printf("\nDelete %ld entries in the log? ", totalboots);
	ans = toupper(getch());
	if (ans != 'Y')
	    ans = 'N';
	printf("%c", ans);
	if (ans == 'Y')
	    unlink(logname);
	fclose(log);
    } else
	puts("No log to print");

}

void getlog(char newname[])
{
    char *letter;

    strcpy(newname, filename);
    letter = strrchr(newname, '.');
    strcpy(letter, ".LOG");

}

void add2log()
{
    char logname[255], day[4], month[4], cnt;
    int date, hour, min, sec, year;
    FILE *log;

    printf(" and adding entry to log");
    getlog(logname);
    log = fopen(logname, "at");
    time(&thetime);
    sscanf(ctime(&thetime), "%s %s %d %d:%d:%d %d", day, month, &date, &hour, &min, &sec, &year);
    switch (cinfo.co_date) {
    case 0:
	fprintf(log, "Launched at: %s %s %.2d %2.2d%c%2.2d%c%2.2d %d", day, month, date, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec, year);
	break;
    case 1:
    case 2:
	fprintf(log, "Launched at: %s %.2d %s %2.2d%c%2.2d%c%2.2d %d", day, date, month, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec, year);
	break;
    }
    if (comment) {
	fprintf(log, "::");
	for (cnt = comment; cnt <= _argc; cnt++)
	    fprintf(log, " %s", _argv[cnt]);
    }
    fprintf(log, "\n");
    fclose(log);
}

void exitlog(void)
{
    char logname[255], day[4], month[4];
    int date, hour, min, sec, year, tmpint;
    //int bdate, bhour, bmin, bsec, byear;

    FILE *log;
    time_t tmp_t;
    struct tm *tmp_tm;

    printf("Uptime Exiting...");
    getlog(logname);
    log = fopen(logname, "at");
    time(&thetime);
    sscanf(ctime(&thetime), "%s %s %d %d:%d:%d %d", day, month, &date, &hour, &min, &sec, &year);
    switch (cinfo.co_date) {
    case 0:
	fprintf(log, "Exited at: %s %s %.2d %2.2d%c%2.2d%c%2.2d %d\n", day, month, date, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec, year);
	break;
    case 1:
    case 2:
	fprintf(log, "Exited at: %s %.2d %s %2.2d%c%2.2d%c%2.2d %d\n", day, date, month, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec, year);
	break;
    }

    /* Alot of redundant code, but hey, I didn't want to put _too_ much work
       into it <grin>.  Besides, the executable is compressed. */

    new = malloc(sizeof(struct tm));
    old = malloc(sizeof(struct tm));
    findfirst(filename, &ffblk, FA_DIREC);
    (*old).tm_sec = 2 * (ffblk.ff_ftime & 31);
    (*old).tm_min = (ffblk.ff_ftime & 2016) >> 5;
    (*old).tm_hour = (ffblk.ff_ftime & 63488) >> 11;
    (*old).tm_mday = (ffblk.ff_fdate & 31);
    (*old).tm_mon = ((ffblk.ff_fdate & 480) >> 5) - 1;
    (*old).tm_year = ((ffblk.ff_fdate & 65024) >> 9) + 80;

    tmpint = (*old).tm_hour;
    tmp_t = mktime(old);
    tmp_tm = localtime(&tmp_t);
    memcpy(old, tmp_tm, sizeof(struct tm));
    (*old).tm_hour = tmpint;

    thetime = time(NULL);
    new = localtime(&thetime);

    sec = (*new).tm_sec - (*old).tm_sec;
    min = (*new).tm_min - (*old).tm_min;
    if (sec < 0) {
	sec += 60;
	min--;
    }
    hour = (*new).tm_hour - (*old).tm_hour;
    if (min < 0) {
	min += 60;
	hour--;
    }
    numday = (*new).tm_yday - (*old).tm_yday + (365 * ((*new).tm_year - (*old).tm_year));
    if (hour < 0) {
	hour += 24;
	numday--;
    }
    sscanf(ctime(&tmp_t), "%3s %3s %d %d:%d:%d %d", bday, bmon, &bdate, &bhour, &bmin, &bsec, &byear);
    bhour = tmpint;
    if (bhour >= 12 && cinfo.co_time == 0) {
	bhour -= 12;
	ampm[0] = 'p';
    } //
	else
	//ampm[0] = '\0';

    if (bhour == 0)
	bhour = 12;
    if (numday < 0) {
	fprintf(stderr, "Error:  System clock has been changed since bootup\n\n");
	exit(1);
    } else if (numday != 0)
	switch (cinfo.co_date) {
	case 0:
	    fprintf(log, "Up for %d day(s), %2.2d%c%2.2d%c%2.2d\n", numday, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 1:
	    fprintf(log, "Up for %d day(s), %2.2d%c%2.2d%c%2.2d\n", numday, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 2:
	    fprintf(log, "Up for %d day(s), %2.2d%c%2.2d%c%2.2d\n", numday, hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
    } else
	switch (cinfo.co_date) {
	case 0:
	    fprintf(log, "Up for %2.2d%c%2.2d%c%2.2d\n", hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 1:
	    fprintf(log, "Up for %2.2d%c%2.2d%c%2.2d\n", hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	case 2:
	    fprintf(log, "Up for %2.2d%c%2.2d%c%2.2d\n", hour, cinfo.co_tmsep[0], min, cinfo.co_tmsep[0], sec);
	    break;
	}



    fprintf(log, "\n");
    fclose(log);
}

void tail()
{
   char            logname[255], ans, tail[NUMTAIL][81],exitinlog=FALSE;
   FILE           *log;
   int             cnt = 0, num2prn=0;

   getlog(logname);
   log = fopen(logname, "r");
   if (log != NULL) {
      cnt = 0;
      fseek(log, 0, SEEK_SET);
      while (fgets(tail[cnt % NUMTAIL], 81, log) != NULL){
        if(strncmp(tail[cnt%NUMTAIL],"Launched",8)!=0)exitinlog=TRUE;
        totalboots++;
        cnt++;
      }
      num2prn=(--cnt);
      if (num2prn>NUMTAIL)
        num2prn=NUMTAIL;
      if(exitinlog)
        puts("\nLast few Launches\n");
      else
        printf("\nLast %d of %ld Launch(es):\n\n", num2prn,totalboots);
      for (ans = 1; ans <= num2prn; ans++)
         printf("%s", tail[cnt++ % num2prn]);
      fclose(log);
      exit(0);
   } else
      puts("No log to print");
}


