/*
**	file:		what.h
**
**	purpose:	This file contains macro definitions used
**			to incorporate "what" strings into a
**			program.  A what string is defined as any
**			sequence of printable characters following
**			the occurrance of the pattern '@(#)' up to
**			the first ", >, \n, \, or \0 character. All
**			"what" strings created by these macros are
**			null '\0' terminated.
**
**			Typically, "what" strings may contain version,
**			usage, copyright, or other miscellaneous
**			information.
**
**			They may be displayed using the utility "what".
**
**			This utility comes direct to you without commercial
**			interruption from Unix (tm) and Unix-derived
**			operating systems.  (Unix is a registered
**			trademark of AT&T.
**
**
**	usage:		WHATVER(p,v,r)
**
**			This macro expands to a "what" string containing
**			the program's name, version and revision.
**
**				p = The program name (quoted)
**				v = version  (may be #defined)
**				r = revision  (may be #defined)
**
**			Example:
**
**				#define VER 1
**				#define REV 0
**				WHATVER("DEMO", VER, REV)
**
**			    expands to:
**
**				@(#)DEMO, Version 1.0\0
**
**
**	usage:		WHATWHEN
**
**			This macro expands to a "what" string containing
**			the date and time of the file's compilation.
**
**			Example:
**
**				WHATWHEN
**
**			    expands to:
**
**				@(#)fubar.c: Compiled on Jun 10 1988 at 22:17:20\0
**
**
**	usage:		WHATDATE
**
**			This macro expands to a "what" string containing
**			the day, date, and time of the contained source
**			file's last modification.
**
**			Example:
**
**				WHATDATE
**
**			    expands to:
**
**				@(#)fubar.c: Last modified on Fri Jun 10 22:17:00 1988\0
**
**
**	usage:		WHAT(s)
**
**			This macro expands to a "what" string containing
**			the caller supplied string s.
**
**				s = quoted string
**
**			Example:
**
**				WHAT("if u cn rd ths u cn gt a gd jb!")
**
**			    expands to:
**
**				@(#)if u cn rd ths u cn gt a gd jb!\0
*/

/*	magic bullet	*/

#define	WHATKEY	"@(#)"

/*
**	_N(n) is needed so we can include #define'd numbers
**	as arguments to WHATVER.
*/

#define	_N(n)	#n

#define	WHATVER(p,v,r)	WHATKEY p ", Version " _N(v) "." _N(r)
#define	WHATWHEN	WHATKEY __FILE__ ": Compiled on " __DATE__ " at " __TIME__
#define	WHATDATE	WHATKEY __FILE__ ": Last modified on " __TIMESTAMP__
#define	WHAT(s)		WHATKEY s

