{
   IRQR -- Report status of IRQs in the H248 computer, PC/AT or compatibles.
   Copyright 1988 by Lawrence R. Steeger

   Based upon IRQS by Joseph Katz (Copyright 1988 by Joseph Katz), which
   was published in Katz's "C Notes" in SEXTANT No. 34 - Late Spring 1988.

   (Turbo Pascal Version 4)

}

const	NUMPORTS = 2;
		NUMIRQS = 15;

type	irqport = record
			number : word;
			name : string[4];
		end;

var		status,
		bit,
		p8259 : word;

const	ports : array [1..NUMPORTS] of irqport =
				((number : $21; name : '0x21'),
				 (number : $A1; name : '0xA1'));

		free : string[5] = '>FREE';
		used : string[5] = ' used';

		ibm : array[0..NUMIRQS] of string[15] =
				('Timer          ',
			 	 'Keyboard       ',
			 	 '2nd 8259       ',
			 	 'COM2           ',
			 	 'COM1           ',
			 	 'LPT2           ',
			 	 'Floppy Disk    ',
			 	 'LPT1           ',
			 	 'Clock          ',
			 	 'Redirected IRQ2',
			 	 '(reserved)     ',
			 	 '(reserved)     ',
			 	 '(reserved)     ',
			 	 'Coprocessor    ',
			 	 'Hard Disk      ',
			 	 '(reserved)     ');

		oem : array[0..NUMIRQS] of string[15] =
				('               ',
			 	 '               ',
			 	 'Autofax Imager ',
			 	 '               ',
			 	 '               ',
			 	 'MS Bus Mouse   ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ',
			 	 '               ');

function fStr(v, d : integer) : string;

{ Create a blank-filled, right-justified numeric string }

var	s : string;

begin
	Str(v:d, s);
	fStr := s;
end;

function Portname(p8259, bit : word) : string;

{ return port name or blanks }

begin
	if (bit = 0)
	then portname := ports[(p8259+1)].name
	else portname := '    ';
end;

function State(status, bit : byte) : string;

{ return '>FREE' or ' used' }

begin
	if ((status shr bit) and 1) <> 0
	then state := free
	else state := used;
end;

begin
	Writeln('IRQR --'#9'Report Status of 8259 Hardware Interrupt Channels');
	Writeln(#9'Copyright 1988 by Lawrence R. Steeger'#13#10);
	Writeln(#9'8259  IRQ  Status   IBM Assignments  OEM Assignments');
	Writeln(#9'----  ---  ------   ---------------  ---------------');

	{ display status of 8259 IRQs }

	for p8259 := 0 to (NUMPORTS - 1)
	do begin

		{ get 8259 status port information }

		status := Port[ports[(p8259+1)].number];

		for bit := 0 to 7
		do Writeln(#9 + Portname(p8259, bit) + '  '
					  + fStr((bit + (p8259 * 8)), 3) + '   '
					  + State(status, bit) + '   '
					  + ibm[(bit + (p8259 * 8))] + '  '
					  + oem[(bit + (p8259 * 8))]);

		if ((p8259 + 1) < NUMPORTS) then Writeln;
	end;

	Halt(0);
end.

{ end of IRQR.C }

