;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
;
; RESTAMP algorythm not entirely tested
;
; Buffers.asm
;
; Function: Handle disk buffers
;   Handles swapping out least used buffer
;   Handles allocating buffer space in the expanded memory area
;   Handles low-level disk calls
;
	;MASM MODE
	.386p

include  errors.asi 
include  segs.asi 
include  os.asi 
include  fs.ase 
include  floppy.asi 
include  fs.asi 
include  page.asi 
include  sys.mac 
include  pageall.asi 
include  prints.ase 
include  pageall.ase 
include  boot.ase 

	PUBLIC	GetSectors,ReadSector,WriteBuffer,DirtyBuffer,FlushBuffers
	PUBLIC	StampAsLatest
	PUBLIC	bufferInit,bufferstart

RETRIES = 3
BUF_PAGES_TO_ALLOC = 16

seg386data	SEGMENT	
badbuf	db	"Bad Buffer Alloc",0
bufferstart dd	0
numbuffers dd	BUFFERCOUNT
stamp	dw	0				; Usage stamp value
seg386data	ENDS	

seg386	SEGMENT	
;
; Initialize a buffer
;
Init	PROC	
	mov	[edi + BUFFER.BUFLAGS],0		; Mark it empty and clean
	bts	DWORD PTR [edi + BUFFER.BUFLAGS],BF_EMPTY ;
	ret
Init	ENDP	
;
; Init all buffers
;
BufferInit	PROC	
	ALLOCEXT				; External allocation
	call	PageAlloc			; Get a page
	jc	short badbufmsg			; Err if none
	cmp	eax,PG_STARTOFEXTMEM		; Err if not start of EXT mem
	jnz	short badbufmsg   			;
	ZA	eax
	mov	[bufferstart],eax		; Fill in buffer start
	mov	ecx,BUF_PAGES_TO_ALLOC-1	; Remainter of pages to alloc
alloc64K:		
	ALLOCEXT
	call	PageAlloc			; Alloc one
	loop	alloc64K                        ; Loop until all
	mov	edx,offset cgroup:init			; Buffer init routine
	call	BufferRunThrough 		; Run through all buffers
	ret
badbufmsg:
	MESSAGE badbuf
	jmp	$
BufferInit	ENDP	
;
; Return number of sectors
;
GetSectors	PROC	
	os	DK_GETSECTORS			; Call the disk routine
	ret
GetSectors	ENDP	
;
; Run through all buffers applying a function
;
BufferRunThrough	PROC	
	mov	edi,[bufferstart]		; First buffer
	mov	ecx,[numbuffers]		; Numbre of buffers
br_lp:
	push	edx				; Save function
	call	edx				; Call function
	pop	edx				;
	jc	br_done				; Get out if function Carry
	add	edi,BUFFEROFFSET		; Next buffer
	loop 	br_lp				; Do next
	clc					; Finished all buffers
br_done:
	ret
BufferRunThrough	ENDP	
;
; Flush a buffer
;
Flush	PROC	
	bt	DWORD PTR [edi + BUFFER.BUFLAGS],BF_DIRTY	; See if dirty
	jnc	noflush				; Quit if clean
	movzx	ebx,[edi + BUFFER.BUDRIVE]	; Get drive & sector & buffer
	mov	edx,[edi + BUFFER.BUSECTOR]	;
	lea	esi,[edi + BUFFER.DATA]		;
	call	Write				; Write the buffer out
	jc	noflush				; Get out on error
	btr	DWORD PTR [edi + BUFFER.BUFLAGS],BF_DIRTY	; Clean buffer
	clc					; No error
noflush:
	ret
Flush	ENDP	
;
; Flush all buffers
;
FlushBuffers	PROC	
	push	esi				; Save all regs
	push	ebx				;
	push	ecx				;
	push	edx				;
	mov	edx,offset cgroup:Flush		; Flush routine
	call	BufferRunThrough		; Do runthrough
	pop	edx				; Restore regs
	pop	ecx				;
	pop	ebx				;
	pop	esi				;
	ret
FlushBuffers	ENDP	
;
; Invalidate a buffer
;
Invalidate	PROC	
	cmp	[edi + BUFFER.BUDRIVE],al		; See if for this drive
	jnz	short inv_done			; Quit if not
	btr	DWORD PTR [edi + BUFFER.BUFLAGS],BF_DIRTY	; Else clean it
	bts	DWORD PTR [edi + BUFFER.BUFLAGS],BF_EMPTY	; Empty it
inv_done:
	clc					; No error
	ret
Invalidate	ENDP	
;
; Invalidate all buffers for a given drive
;
InvalidateBuffers	PROC	
	jnc	short noerror			; Get out if not error
	push	eax				; Save error
	pushfd					; Save err flag
	cmp	al,DERR_CHANGED			; See if changed
	jz	short goterr			; Yeah, go invalidate buffers
       	cmp	al,DERR_TIMEOUT			; See if missing
	jnz	short noinvalidate		; No, no invalidate
goterr:
	push	edi
	push	edx
	push	ecx
	mov	eax,ebx				; EAX = drive
	mov	edx,offset cgroup:Invalidate		; Invalidate function
	call	BufferRunThrough		; Run through buffers
	pop	ecx
	pop	edx
	pop	edi
noinvalidate:
	popfd					; Restore err flag
	pop	eax				; And error
noerror:
	ret
InvalidateBuffers	ENDP	
;
; Set a buffer stamp back to halfway mark
; Buffer stamps start at 0, progress to 65535, then start back at 32767
;
Restamp	PROC	
	btr	[edi + BUFFER.BUSTAMP],15		; Set us back
	clc					; No errors
	ret
Restamp	ENDP	
;
; Restamp all buffers
;
RestampBuffers	PROC	
	mov	edx,offset cgroup:Restamp		; Restamp function
	call	BufferRunThrough		; Run through all buffers
	ret
RestampBuffers	ENDP	
;
; Stamp a buffer with current time stap
;
StampBuffer	PROC	
	mov	ax,[stamp]			; Get stamp
	mov	[edi + BUFFER.BUSTAMP],ax		; Load buffer with stamp
	inc	[stamp]				; Next stamp
	jnz	short noRestamp			; Get out if no overflow
	push	edi				;
	push	edx				; 
	call	RestampBuffers			; Restamp all buffers
	pop	edx
	pop	edi				;
norestamp:
	ret
StampBuffer	ENDP	
;
; See if a buffer is free or lowest stamp
;
IsFree	PROC	
	bt	DWORD PTR [edi + BUFFER.BUFLAGS],BF_EMPTY	; See if empty
	jc	short gotfree			; Automatically free if empty
	movzx	eax,[edi + BUFFER.BUSTAMP]	; Else get stamp
	cmp	eax,ebx				; See if is lowest stamp yet
	jnc	short notfree		 	; No, get out
	mov	ebx,eax				; Yes, make it lowest
	cmc
gotfree:
	mov	esi,edi				; ESI = found buffer
notfree:
	ret	
IsFree	ENDP	
;
; Find a free buffer
;
FindFree	PROC	
	mov	edx,offset cgroup:IsFree		; Free function
	sub	ebx,ebx				; EBX = way high
	dec	ebx				;
	call	BufferRunThrough		; Get us a buffer
	mov	edi,esi				; in EDI
ifdef DEBUG
	push	eax				; Debugging, print buffer
	mov	eax,esi
	call	printdword
	call	printspace
	pop	eax
endif
	call	Flush				; MAke sure it is flushed
	jc	short writerr			; Get out if error
	btr	DWORD PTR [edi + BUFFER.BUFLAGS],BF_EMPTY	; Not empty
	call	stampBuffer			; Stamped
	clc
	ret
writerr:	
	ret
FindFree	ENDP	
;
; See if this buffer matches the requested sector
;
Match	PROC	
ifdef DEBUG
	push	eax				; Debugging, print a star
	push	edx
	mov	dl,'*'
	os	VF_CHAR
	pop	edx
	pop	eax
endif
	bt	DWORD PTR [edi + BUFFER.BUFLAGS],BF_EMPTY	; See if empty
	jc	short nomatch			; Can't match empty buffer
	cmp	bl,[edi + BUFFER.BUDRIVE]		; See if drive matches
	jnz	short nomatch			; No, get out
	cmp	eax,[edi + BUFFER.BUSECTOR]	; See if sector matches
	jnz	short nomatch			; No, get out
ifdef DEBUG
	push	eax      			; Debugging, just put output
	call	printbyte
	call	printspace
	pop	eax
endif
	stc					; Mark we found a match
	ret
nomatch:
	clc					; No match
	ret
Match	ENDP	
;
; See if any buffers match the requested sector
;
FindMatch	PROC	
	mov	eax,edx				; eax = sector
	mov	edx,offset cgroup:Match		; Match function
	call	BufferRunThrough		; Run through all buffers
	ret
FindMAtch	ENDP	
;
; Read a sector
;
Read	PROC	
	cmp	ebx,NUMDRIVES
	jnc	short rdtoohigh
	push	ecx				; Save old ecx
	sub	ecx,ecx				;
	mov	cl,RETRIES			; MAX number of tries
rdlp:
	xchg	[esp],ecx			;
	os	DK_READ				; Read sector
	xchg	[esp],ecx			;
	jnc	short rdone			; Get out if no errors
	call	ClearNumSats			; Clear sat table if disk changed
	call	InvalidateBuffers		; Invalidate buffers if disk changed
	loop	rdlp				; Try again on error
rdone:
	pop	ecx				; Restore ecx
	ret
rdtoohigh:
	mov	al,ERR_INVALIDRIVE
	stc
	ret
Read	ENDP	

;
; Write a sector
;
Write	PROC	
ifdef DEBUG
	push	eax				; Debugging, display a %
	push	edx
	mov	dl,'%'
	os	VF_CHAR
	pop	edx
	pop	eax
endif
	cmp	ebx,NUMDRIVES
	jnc	short rdtoohigh
	push	ecx				; Save old ecx
	sub	ecx,ecx				;
	mov	cl,RETRIES			; Max number of tries
wrlp:
	xchg	[esp],ecx			; WRITE function gets old CX
	os	DK_WRITE			; Go write
	xchg	[esp],ecx			;
	jnc	short wdone                     ; Get out, noerr
	call	ClearNumSats			; Clear sat table if disk change
	call	InvalidateBuffers		; Invalidate buffers if disk change
	loop	wrlp				
wdone:
	pop	ecx
	ret
Write	ENDP	
;
; Mark a buffer as dirty
;
DirtyBuffer	PROC	
	push	esi				; Save esi
	sub	esi,DATAOFFSET			; Point to control info
	bts	DWORD PTR [esi + BUFFER.BUFLAGS],BF_DIRTY ; Mark buffer dirty
	clc					; In case multiple marks
	pop	esi				;           	
	ret
DirtyBuffer	ENDP	
;
; Get a write buffer
;                                                             	
WriteBuffer	PROC	
	push	edi				; Save regs
	push	edx				;
	push	ecx				;
	push	ebx				;
	call	FindMatch			; See if already there
	jnc	short getfree			; Not there, get free buffer
	call	Flush				; Flush it
	jc	short wb_err			; Err if flush failed
	jmp	short gotbuffer			; Else we have it
getfree:
	call	FindFree			; Else Get a free buffer
gotbuffer:
	pop	ebx				;
	pop	ecx				;
	pop	edx				;
	jc	short wb_err			; Get out if flush failed
	btr	DWORD PTR [edi + BUFFER.BUFLAGS],BF_DIRTY	; Never dirty
	mov	[edi + BUFFER.BUSECTOR],edx	; Save sector number
	mov	[edi + BUFFER.BUDRIVE],bl		; Save drive number
	lea	esi,[edi + BUFFER.DATA]		; Get buffer address
	pop	edi				;
	ret
wb_err:
	pop	edi
	ret
WriteBuffer	ENDP	
;
; Get a sector off disk and return buffer
;
ReadSector	PROC	
	push	edi				; Save regs
	push	edx				;
	push	ecx				;
	push	ebx				;
	call	FindMatch			; See if sector in buffer
	jc	short rs_found			; Yeah, go restamp it
	call	FindFree			; Else get a free buffer
	pop	ebx				;
	pop	ecx				;
	pop	edx				; Get out if flush failed
	jc	short rs_err				;
	mov	[edi + BUFFER.BUSECTOR],edx	; Save sector
	mov	[edi + BUFFER.BUDRIVE],bl		; Save drive
	lea	esi,[edi + BUFFER.DATA]		; Get buffer
	pop	edi				;
	call	Read				; Read a sector into it
	ret
rs_found:
	pop	ebx				; Restore regs
	pop	ecx				;
	pop	edx				;
	call	StampBuffer			; Restamp the buffer
	lea	esi,[edi + BUFFER.DATA]		; Return buffer address
	pop	edi
	clc
	ret
rs_err:
	pop	edi
	ret
ReadSector	ENDP	
StampAsLatest	PROC	
	push	edi
	sub	edi,DATAOFFSET
	call	StampBuffer
	pop	edi
	ret
StampAsLatest	ENDP	
seg386	ENDS	
END

	
