;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include	lib.asi

   	PUBLIC	_OSFloppyReset, _OSFloppyFormat, _OSFloppyRead
	PUBLIC	_OSFloppyWrite, _OSFloppyVerify, _OSFloppyGetSectors
_TEXT	SEGMENT	
;
;* void OSFloppyReset(void);
;
_OSFloppyReset	PROC	
	OS	DK_RESET
	ret
_OSFloppyReset	ENDP	
;
;* int OSFloppyFormat(int drive, unsigned char *buffer);
;
noerr:
	sub	eax,eax
	LEAVE
	ret
_OSFloppyFormat	PROC	
	ARG	DRIVE : DWORD, BUFFER : DWORD
	ENTER	0,0
	push	esi
	push	ebx
	mov	ebx,[DRIVE]
	mov	esi,[BUFFER]
	OS	DK_FORMAT
	pop	esi
	pop	ebx
	jnc	short noerr
	LEAVE
	ret
_OSFloppyFormat	ENDP	
;
;* int OSFloppyRead(int drive,int sector, unsigned char *buffer);
;
_OSFloppyRead	PROC	
	ARG	DRIVE : DWORD, SECTOR: DWORD, BUFFER : DWORD
	ENTER	0,0
	push	esi
	push	ebx
	mov	ebx,[DRIVE]
	mov	esi,[BUFFER]
	mov	edx,[SECTOR]
	OS	DK_READ
	pop	ebx
	pop	esi
	jnc	short noerr
	LEAVE
	ret
_OSFloppyRead	ENDP	
;
;* int OSFloppyWrite(int drive, int sector, unsigned char *buffer);
;
_OSFloppyWrite	PROC	
	ARG	DRIVE : DWORD, SECTOR: DWORD, BUFFER : DWORD
	ENTER	0,0
	push	esi
	push	ebx
	mov	ebx,[DRIVE]
	mov	esi,[BUFFER]
	mov	edx,[SECTOR]
	OS	DK_WRITE
	pop	ebx
	pop	esi
	jnc	short noerr
	LEAVE
	ret
_OSFloppyWrite	ENDP	
;
;* int OSFloppyVerify(int drive, int sector);
;
_OSFloppyVerify	PROC	
	ARG	DRIVE : DWORD, SECTOR: DWORD
	ENTER	0,0
	push	esi
	push	ebx
	mov	ebx,[DRIVE]
	mov	edx,[SECTOR]
	OS	DK_WRITE
	pop	ebx
	pop	esi
	jnc	noerr
	LEAVE
	ret
_OSFloppyVerify	ENDP	
;
;* int OSFloppyGetSectors(int drive);
;

_OSFloppyGetSectors	PROC	
	ARG	DRIVE :DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[DRIVE]
	OS	DK_GETSECTORS
	pop	ebx
	LEAVE
	ret
_OSFloppyGetSectors	ENDP	
_TEXT	ENDS	
END