	page	66,132
;-----------------------------------------------------------------------------;
;  This routine emulates DOS 2.x/3.x switchchar processing
;-----------------------------------------------------------------------------;
	.model	small
	.code

	org	5ch

dos_vect dd	?			; old DOS vector number
switch	db	?			; switch character
isr	label	byte


	public	begin
	org	100h
begin:	jmp	initialize

;-----------------------------------------------------------------------------;
;  DOS service request interceptor
;-----------------------------------------------------------------------------;
dos_isr proc	far
	cmp	ah,37h			; abandon interest in all but switch
	je	@f
	jmp	cs:[dos_vect]
@@:
	cmp	al,0
	je	@f
	mov	switch,dl
@@:
	mov	dl,switch
	iret

isrlen	equ	$-dos_isr

dos_isr endp


;-----------------------------------------------------------------------------;
;	    Terminate and stay resident initialization			      ;
;-----------------------------------------------------------------------------;

initialize proc near

	mov	switch,'/'		; initialize switch character

	mov	di,offset isr		; relocate isr routine
	mov	si,offset dos_isr
	mov	cx,isrlen
    rep movsb

	mov	es,ds:2ch		; free unused environment space
	mov	ah,49h
	int	21h

	mov	ax,3521h		; get DOS interrupt vector
	int	21h
	mov	word ptr cs:dos_vect + 2,es
	mov	word ptr cs:dos_vect,bx

	push	ds			; hook us into the interrupt chain
	mov	ax,2521h
	mov	dx,cs
	mov	ds,dx
	mov	dx,offset isr
	int	21h
	pop	ds

	mov	ax,offset isr + isrlen	; compute resident size
	add	ax,15
	mov	cl,4
	shr	ax,cl
	mov	dx,ax
	mov	ah,31h			; terminate but stay resident
	mov	al,0
	int	21h
initialize endp

	end	begin
