;	name...
;		swapkey
;
;	function...
;
;	Swap the escape and tilde keys using the "keyboard intercept"
;	ROM BIOS feature: INT 15 with AH=4fH.
;
;	This interrupt feature is implemented on recent AT class machines, 
;	including at least these:
;		AT (models 319/339 only), convertable, and PS/2
;		clones with the Award BIOS
;
;	on entrance to this interrupt,
;		AH = 4fH
;		AL = scan code
;		carry flag is set
;
;	on return from the interrupt,
;		AL = scan code (possibly changed)
;		carry flag cleared if scan code is to be ignored
;
;	An AT with a BIOS module dated 01/04/84 does not have the "keyboard intercept"
;	feature.  For that machine, use the companion program SWPKEYAT.
;
;	Documentation courtesy of: Thom Hogan, "The Programmer's PC Sourcebook"
;
;	Author: James R. Van Zandt (jrv@mitre-bedford.arpa)
;
VECTORS		SEGMENT	AT 0H
	ORG	15H*4
INT_VECTOR	LABEL	DWORD
VECTORS		ENDS


CODE_SEG	SEGMENT
	ASSUME	CS:CODE_SEG
	ORG	100H
BEGIN:	JMP	INIT_VECTORS		;Initialize vectors and attach to DOS
ROM_INT	DD


INTERCEPT_INT	PROC	NEAR
	ASSUME	DS:NOTHING
	CMP	AH,4FH
	JZ	SWP_1

CONTINUE:
	JMP	ROM_INT			; jump to former routine

SWP_1:
	CMP	AL,001H			; ESC scan code?
	JNZ	SWP_2

	MOV	AL,029H			; substitute tilde scan code
	JMP	CONTINUE

SWP_2:
	CMP	AL,029H			; tilde scan code?
	JNZ	CONTINUE

	MOV	AL,001H			; substitute ESC key scan code
	JMP	CONTINUE


INTERCEPT_INT ENDP


;-----------------------------------------------------------------;
;This procedure initializes the interrupt vectors.		  ;
;-----------------------------------------------------------------;
INIT_VECTORS	PROC	NEAR
	ASSUME	DS:VECTORS
	PUSH	DS			;Save old Data Segment
	MOV	AX,VECTORS		;Set up the data segment for vectors
	MOV	DS,AX
	CLI				;Don't allow interrupts

	MOV	AX,word ptr INT_VECTOR	;Save addresses of BIOS routines
	MOV	word ptr ROM_INT,AX
	MOV	AX,word ptr INT_VECTOR[2]
	MOV	word ptr ROM_INT[2],AX
					;Set up new KEYBOARD_INT vector
	MOV	word ptr INT_VECTOR,OFFSET INTERCEPT_INT
	MOV	word ptr INT_VECTOR[2],CS
	STI				;Allow interrupts again

	MOV	DX,OFFSET INIT_VECTORS	;End of resident portions
	INT	27H			;Terminate but stay resident
INIT_VECTORS	ENDP

CODE_SEG	ENDS

	END	BEGIN
