/*
 *	Simple mail user interface for KA9Q IP/TCP package.
 */
#include <stdio.h>
#include <alloc.h>
#include <ctype.h>
#include <string.h>
#if	defined(__TURBOC__)
#include <conio.h>
#endif
#include "bm.h"

/* commands valid in bm.rc */

struct token  rccmds[] = {
  "smtp", SMTP,
  "host", HOST,
  "user", USER,
  "edit", EDIT,
  "fullname", NAME,
  "reply", REPLY,
  "maxlet", MAXLET,
  "mbox", MBOX,
  "record", RECORD,
  "folder", FOLDER,
  "mqueue", MQUEUE,
  "via", VIA,
  "askvia", ASKVIA,
  "autoedit", AUTOEDIT,
  "tmp", TMPDIR,
  "alias", ALIAS,
  "zone", ZONE,
  "pager", PAGER,
  "asksubject", ASKSUBJECT,
  "askmsgtype", ASKMSGTYPE,
  "delempty", DELEMPTY,
  "gate", GATE,
  "organ", ORGAN,
  "askrecord", ASKRECORD,
  NULLCHAR, 0
};

FILE	     *mfile = NULLFILE;
char	     *hostname = NULLCHAR;	/* name of this host from rc file */
char	     *username = NULLCHAR;	/* name of this user from rc file */
char	     *fullname = NULLCHAR;	/* fullname of this user from rc file */
char	     *replyto = NULLCHAR;	/* address for reply-to header */
char	     *maildir = NULLCHAR;	/* defined mail directory */
char	     *mqueue = NULLCHAR;/* defined mqueue outbound directory */
char	     *savebox = NULLCHAR;	/* name of the mbox text file */
char	     *record = NULLCHAR;/* record  outbound mail in this file */
char	     *folder = NULLCHAR;/* directory for saveing read mail */
char	     *editor = NULLCHAR;/* user's favorite text editor */
char	     *tmpdir = NULLCHAR;/* tmp directory */
char	     *aliases = NULLCHAR;	/* defined alias directory */
char	     *tzone = NULLCHAR; /* time zone */
char	     *pager = NULLCHAR; /* pager */
char	     *gate = NULLCHAR;	/* gate to send default mail to */
char	     *via = NULLCHAR;  /* via to send default mail to */
char	     *organ = NULLCHAR; /* organization name */
char	      notename[9];	/* name of current notefile */
char	      unotename[9];	/* name of user notefile */
char	      notefile[LINELEN];/* full pathname of mail text file */
char	     *mfilename = notefile;	/* pointer to current mbox or mail
					 * file -f */
char	     *emname = NULLCHAR;
int	      current;		/* the current message number */
int	      nmsgs;		/* the number of messages in the notefile */
int	      newmsgs;		/* Number of new unread message */
int	      change;		/* indicates that the mail file has been
				 * changed in this session */
int	      fflag = 0;	/* true if current notefile is not an mbox */
int	      qflag = 0;	/* true if bm is used just to queue files */
int	      sflag = 0;	/* true if bm should ask for subject */
int	      tflag = 0;	/* true if bm should ask for msgtype */
int	      vflag = 0;	/* true if bm should ask for via route */
int	      eflag = 0;	/* true if autoedit */
int	      rflag = 0;	/* true if recording forced off */
int	      lflag = 0;	/* if true list to instead of from address */
int	      dflag = 0;	/* if true delete empty notefile */
int	      aflag = 0;	/* if true don't add sender addr to work file */
int	      novia = 0;	/* if true don't use via */
int	      recflag = 0;	/* true if bm should ask for record msg */
unsigned      maxlet = NLET + 1;/* max number of messages in mailbox */
int	      tty = 0;		/* tells if stdin is a tty */
struct let   *mbox;		/* pointer to the array of messages */


char	      usage[] = "Usage: bm [-a] [-c file] [-f file] [-e file] [-q] [-r] "
"[-v] [-u user]\r\nor:    bm [-a] [-c file] "
"[-q] [-r] [-v] [-s subject] users\r\n";
char	      options1[] = "\r\nOPTIONS\r\n";
char	      options2[] = " -c file      Use file instead of \\bm.rc\r\n";
char	      options3[] = " -f file      Use file instead of \\email\\user\r\n";
char	      options4[] = " -h or -?     Print this help msg\r\n";
char	      options5[] = " -q           Queue mode\r\n";
char	      options6[] = " -s subject   Set Subject field\r\n";
char	      options7[] = " -e file      Send file as the message body\r\n";
char	      options8[] = " -u user      Read user's mail\r\n";
char	      options10[] = " -r           Recording off\r\n";
char	      options11[] = " -a           Don't add sender address to work file\r\n";
char	      options12[] = " -v           Do not use via\r\n\n";

char	      badmsg[] = "Invalid message number %d\r\n";
char	      nomail[] = "No messages\r\n";
char	      noaccess[] = "Unable to access %s\n";
char	      nofile[] = "No file specified\r\n";
char	      badcommand[] = "Invalid command. ? for help\r\n";
char	      newmail[] = "New mail has arrived\r\n";
char	      nopattern[] = "No pattern specified\r\n";

char	      mailemail[] = "\\email";  /* Incoming mail */
char	      mailqdir[] = "\\email\\mqueue";   /* Outgoing mail email */
char	      alias[] = "\\net\\alias"; /* alias file */
char	      tempdir[] = "\\tmp";      /* tmp directory */
char	      deadmsg[] = "dead.msg";   /* dead.msg file */

/* version control information */
char	      version[] = "Bdale's Mailer (MSDOS)";

main( argc, argv )
int	      argc;
char	     *argv[];
{
  extern int	optind;
  extern char  *optarg;
  char	       *subjectline = NULLCHAR;
  long		tmp;
  int		c;
  int		ret;
  int		cfg = 0;
  char	       *cfgfile = NULLCHAR;
  char	       *ttybuf;
  char	       *p, *q;
  int		d;

  ( void ) fclose( stdaux );
  ( void ) fclose( stdprn );

  directvideo = 1;

  if ( isatty( fileno( stdin ) ) )
  {
    /* announce ourselves */
/*		screen_clear(); */
    printf( "%s\r\n\n", version );
    tty = 1;
  }

  while ( ( c = getopt( argc, argv, "c:u:e:f:s:arqv?h" ) ) != -1 )
  {
    switch ( c )
    {
      case 'c':
	cfg = 1;
	cfgfile = optarg;
	break;
      case 'f':
	fflag++;
	mfilename = optarg;
	cleanup_fname( mfilename );
	break;
      case 'e':
	emname = optarg;
	break;
      case 'r':
	rflag++;
	break;
      case 'a':
	aflag++;
	break;
      case 'v':
	novia++;
	break;
      case 'q':
	qflag++;
	break;
      case 's':
	subjectline = optarg;
	break;
      case 'u':
	strncpy( notename, optarg, 8 );
	notename[8] = '\0';
	cleanup_notename( notename );
	break;
      case '?':
      case 'h':
	printf( usage );
	printf( options1 );
	printf( options11 );
	printf( options2 );
	printf( options3 );
	printf( options7 );
	printf( options4 );
	printf( options5 );
	printf( options10 );
	printf( options6 );
	printf( options8 );
	printf( options12 );
	exit( 1 );
    }
  }

  if ( !cfg )
    loadconfig( NULLCHAR );
  else
    loadconfig( cfgfile );

  current = 1;
  nmsgs = 0;

  /* check for important directories */

  p = maildir;
  q = maildir;
  if ( p[0] != '\0' )
  {
    p += strlen( p ) - 1;
    q += strlen( q ) - 2;
  }
  if ( strcmp( maildir, "/" ) != 0 && strcmp( maildir, "\\" ) != 0 )
  {
    if ( *maildir != '\0' && *p == ':' )
      strcat( maildir, "\\" );
    if ( *maildir != '\0' && *p == '/' || *p == '\\' && *q != ':' )
    {
      d = strlen( maildir );
      maildir[d - 1] = '\0';
    }
  }

  if ( access( maildir, 0 ) )
  {
    fprintf( stderr, noaccess, maildir );
    exit( 1 );
  }

  p = maildir;
  if ( p[0] != '\0' )
    p += strlen( p ) - 1;
  if ( *p == '\\' || *p == '/' )
  {
    d = strlen( maildir );
    maildir[d - 1] = '\0';
  }

  p = mqueue;
  q = mqueue;
  if ( p[0] != '\0' )
  {
    p += strlen( p ) - 1;
    q += strlen( q ) - 2;
  }
  if ( strcmp( mqueue, "/" ) != 0 && strcmp( mqueue, "\\" ) != 0 )
  {
    if ( *mqueue != '\0' && *p == ':' )
      strcat( mqueue, "\\" );
    if ( *mqueue != '\0' && *p == '/' || *p == '\\' && *q != ':' )
    {
      d = strlen( mqueue );
      mqueue[d - 1] = '\0';
    }
  }

  if ( access( mqueue, 0 ) )
  {
    fprintf( stderr, noaccess, mqueue );
    exit( 1 );
  }

  p = mqueue;
  if ( p[0] != '\0' )
    p += strlen( p ) - 1;
  if ( *p == '\\' || *p == '/' )
  {
    d = strlen( mqueue );
    mqueue[d - 1] = '\0';
  }

  p = tmpdir;
  q = tmpdir;
  if ( p[0] != '\0' )
  {
    p += strlen( p ) - 1;
    q += strlen( q ) - 2;
  }
  if ( strcmp( tmpdir, "/" ) != 0 && strcmp( tmpdir, "\\" ) != 0 )
  {
    if ( *tmpdir != '\0' && *p == ':' )
      strcat( tmpdir, "\\" );
    if ( *tmpdir != '\0' && *p == '/' || *p == '\\' && *q != ':' )
    {
      d = strlen( tmpdir );
      tmpdir[d - 1] = '\0';
    }
  }

  if ( access( tmpdir, 0 ) )
  {
    fprintf( stderr, noaccess, tmpdir );
    exit( 1 );
  }

  p = tmpdir;
  if ( p[0] != '\0' )
    p += strlen( p ) - 1;
  if ( *p == '\\' || *p == '/' )
  {
    d = strlen( tmpdir );
    tmpdir[d - 1] = '\0';
  }

  strncpy( unotename, username, 8 );	/* get username for signature file */
  unotename[8] = '\0';
  cleanup_notename( unotename );

  if ( *notename == '\0' )
  {
    strncpy( notename, username, 8 );
    notename[8] = '\0';
    cleanup_notename( notename );
  }

  /* set any signal handlers to catch break */
  setsignals(  );

  if ( optind < argc )
  {
    dosmtpsend( NULLFILE, &argv[optind], argc - optind, subjectline, 0,
		NULLCHAR, NULLCHAR, 0, 0, NULLCHAR );
    ( void ) exit( 0 );
  }

  tmp = ( long ) maxlet *( long ) sizeof( struct let );
  /*
   * Since we are in the dos small model make sure that we don't overflow a
   * unsigned short on the number bytes need for malloc. If not checked
   * malloc will succeed and we will be trashing ourself in no time.
   */
  if ( ( tmp & 0xffff0000 ) ||
       ( mbox = ( struct let * ) malloc( ( unsigned short ) tmp ) ) == ( struct let * ) NULL )
  {
    fprintf( stderr,
	     "Cannot allocate memory table for %d messages\n",
	     maxlet - 1 );
    ( void ) exit( 1 );
  }
  sprintf( notefile, "%s\\%s.txt", maildir, notename );
  cleanup_fname( notefile );
  if ( !fflag && lockit(  ) )
    exit( 1 );
  ret = initnotes(  );
  if ( !fflag )
    rmlock( maildir, notename );
  if ( ret != 0 )
    exit( 1 );
  listnotes( 0, 0, NULLCHAR, 0, 2 );

  getcommand(  );
  return 0;
}

loadconfig( cfile )
char	     *cfile;
{
  FILE	       *rcfp;		/* handle for the configuration file */
  char		rcline[LINELEN];/* buffer for config file reading */
  register char *h, *s, *p, *q;
  int		line = 0;
  char	       *getenv(	 );
  char		runcom[LINELEN];
  char		xtempdir[LINELEN];
  char	       *rcl;

  if ( cfile == NULL )
  {
    /* check for BMRC in the ENV */
    if ( ( h = getenv( "BMRC" ) ) != NULLCHAR )
      strcpy( runcom, h );
    else
      strcpy( runcom, RUNCOM );
  }
  else
    strcpy( runcom, cfile );
  Rip( runcom );

  cleanup_fname( runcom );
  if ( ( rcfp = fopen( runcom, "r" ) ) == NULLFILE )
  {				/* open config file */
    fprintf( stderr, "Cannot open '%s', check your installation\n", runcom );
    ( void ) exit( 1 );
  }

  while ( !feof( rcfp ) )
  {
    if ( fgets( rcline, LINELEN, rcfp ) == NULLCHAR )
      break;
    line++;
    rip( rcline );
    if ( *rcline == '\0' || *rcline == ';' || *rcline == '#' )
      continue;
    /* find the argument to the command */

    s = rcline;
    /* skip the white space */
    while ( *s == ' ' || *s == '\t' )
      s++;
    p = s;
    /* skip the command */
    while ( *p && *p != ' ' && *p != '\t' )
      p++;
    /* skip the white space */
    while ( *p == ' ' || *p == '\t' )
      p++;
    if ( *s == '\0' )
      continue;

    switch ( rc_line_type( s ) )
    {
      case HOST:
	hostname = savestr( p );
	Rip( hostname );
	break;
      case USER:
	username = savestr( p );
	Rip( username );
	break;
      case REPLY:
	replyto = savestr( p );
	break;
      case EDIT:
	editor = savestr( p );
	break;
      case AUTOEDIT:
	eflag++;
	break;
      case SMTP:
	maildir = savestr( p );
	Rip( maildir );
	cleanup_fname( maildir );
	break;
      case NAME:
	fullname = savestr( p );
	break;
      case MAXLET:
	maxlet = atoi( p ) + 1;
	break;
      case MBOX:
	savebox = savestr( p );
	Rip( savebox );
	break;
      case RECORD:
	record = savestr( p );
	Rip( record );
	cleanup_fname( record );
	break;
      case DELEMPTY:
	dflag++;
	break;
      case FOLDER:
	folder = savestr( p );
	Rip( folder );
	cleanup_fname( folder );
	break;
      case MQUEUE:
	mqueue = savestr( p );
	Rip( mqueue );
	cleanup_fname( mqueue );
	break;
      case TMPDIR:
	tmpdir = savestr( p );
	Rip( tmpdir );
	break;
      case ALIAS:
	aliases = savestr( p );
	Rip( aliases );
	cleanup_fname( aliases );
	break;
      case ZONE:
	tzone = savestr( p );
	Rip( tzone );
	break;
      case PAGER:
	pager = savestr( p );
	break;
      case ASKSUBJECT:
	sflag++;
	break;
      case ASKMSGTYPE:
	tflag++;
	break;
      case GATE:
	gate = savestr( p );
	Rip( gate );
	break;
      case VIA:
	via = savestr( p );
	Rip( via );
	break;
      case ASKVIA:
	vflag++;
	break;
      case ORGAN:
	organ = savestr( p );
	break;
      case ASKRECORD:
	recflag++;
	break;
      default:
	rcl = savestr( rcline );
	fprintf( stderr,
		 "%s: line %d invalid command: '%s'\n",
		 runcom, line, rcl );
	exit( 1 );
    }
  }
  ( void ) fclose( rcfp );
  if ( maildir == NULLCHAR || *maildir == '\0' )
    maildir = mailemail;
  if ( mqueue == NULLCHAR || *mqueue == '\0' )
    mqueue = mailqdir;
  if ( tmpdir == NULLCHAR || *tmpdir == '\0' )
  {
    if ( ( q = getenv( "TMP" ) ) != NULLCHAR )
      strcpy( xtempdir, q );
    else
      strcpy( xtempdir, tempdir );
    tmpdir = savestr( xtempdir );
    Rip( tmpdir );
  }
  cleanup_fname( tmpdir );
  if ( aliases == NULLCHAR || *aliases == '\0' )
  {
    aliases = alias;
  }
  if ( savebox == NULLCHAR || *savebox == '\0' )
  {
    savebox = "mbox";
  }
  if ( hostname == NULLCHAR || *hostname == '\0' )
  {
    fprintf( stderr, "%s: hostname not set\n", runcom );
    exit( 1 );
  }
  if ( username == NULLCHAR || *username == '\0' )
  {
    fprintf( stderr, "%s: username not set\n", runcom );
    exit( 1 );
  }
  pgp_ini();
}

/* return the line_type from a line of the configuration file */
rc_line_type( s )
register char *s;
{
  register struct token *tp;

  for ( tp = rccmds; tp->str != NULLCHAR; tp++ )
  {
    if ( strncmp( tp->str, s, strlen( tp->str ) ) == 0 )
      return tp->type;
  }
  return ( NONE );
}

/* replace terminating end of line marker(s) with null */
rip( s )
register char *s;
{
  for ( ; *s; s++ )
    if ( *s == '\r' || *s == '\n' )
    {
      *s = '\0';
      break;
    }
}

/* replace first space with null */
Rip( s )
register char *s;
{
  for ( ; *s; s++ )
    if ( *s == ' ' || *s == '\t' )
    {
      *s = '\0';
      break;
    }
}

/* copy a string return a pointer to it */
char	     *
savestr( s )
char	     *s;
{
  register char *p;
  int		c;

  c = strlen( s );
  while ( s[c - 1] == ' ' || s[c - 1] == '\t' )
  {
    s[c - 1] = '\0';
    c = strlen( s );
  }
  p = malloc( strlen( s ) + 1 );
  if ( p == NULLCHAR )
    fprintf( stderr, "Out of memory\n" );
  else
    strcpy( p, s );
  return p;
}

dohelp(	 )
{
/*	screen_clear(); */
  printf( "HELP:  Mail Commands\r\n\n" );
  printf( "PRINTING MESSAGES AND HEADERS           "
	  "OTHER COMMANDS\r\n" );
  printf( " <Return>         Next msg              "
	  " ! command     Run shell command\r\n" );
  printf( " #                Where # is msg number "
	  " $             Sync the notefile\r\n" );
  printf( " .                Print current msg     "
	  " %%[f] <list>   Print reply address\r\n" );
  printf( " h or H <list>    Print headers         "
	  " / pattern     Search for pattern\r\n" );
  printf( "                                        "
	  " =             Print msg number\r\n" );
  printf( "DISPOSING OF MESSAGES                   "
	  " ?             Print this help msg\r\n" );
  printf( " b <list> users   Bounce msg (remail)   "
	  " a [name]      Edit or print alias\r\n" );
  printf( " d or u <list>    Delete or undelete    "
	  " A <list>      Alias msg\r\n" );
  printf( " f <list> users   Forward msg to users  "
	  " k job-id      Kill unsent msgs\r\n" );
  printf( " F <list> users   Forward msg; no tab   "
	  " l             List unsent msgs\r\n" );
  printf( " p <list>         Print msg on printer  "
	  " m users       Mail to users\r\n" );
  printf( " r[f] <list>      Reply to a msg        "
	  " M users file  Mail file to users\r\n" );
  printf( " R[f] <list>      Reply including msg   "
	  " n [file]      Change notefile\r\n" );
  printf( " s <list> [file]  Save msg in mbox      "
	  " q             Quit; save changes\r\n" );
  printf( " w <list> file    Append msg to file    "
	  " x             Exit\r\n\n" );
}

bmexit( x )
int	      x;
{
  if ( !fflag && lockit(  ) )
    exit( 1 );
  ( void ) closenotes(	);
  if ( !fflag )
    rmlock( maildir, notename );
  exit( x );
}

/* this is the main command processing loop */
getcommand(  )
{
  FILE	       *tfile, *tmpfile(  );
  char		command[LINELEN];	/* command line */
  char	       *args[MAXARGS];
  int		nargs;
  char	       *p;
  char	       *cp;
  register int	msgnum;
  register int	i;
  int		ret;

  printf( "\r\nType ? for help.\r\n" );

  /* command parsing loop */
  while ( 1 )
  {
    printf( "\"%s\"> ", notename );

    gets( command );

    p = command;
    while ( *p == ' ' || *p == '\t' )
      p++;

    if ( *p == '!' )
    {
      system( &p[1] );
      continue;
    }
    if ( *p )
    {
      cp = p;
      while ( *cp && *cp != ' ' && *cp != '\t' )
	cp++;
      nargs = parse( cp, args, MAXARGS );
    }

    switch ( *p )
    {
      case 'm':                 /* send msg */
	if ( nargs == 0 )
	{
	  printf( "To: " );
	  gets( command );
	  nargs = parse( command, args, MAXARGS );
	}
	dosmtpsend( NULLFILE, args, nargs, NULLCHAR, 0, NULLCHAR, NULLCHAR,
		    0, 0, NULLCHAR );
	break;

      case 'M':
	if ( nargs == 0 )
	{
	  printf( "To: " );
	  gets( command );
	  nargs = parse( command, args, MAXARGS );
	}
	dosmtpsend( NULLFILE, args, nargs, NULLCHAR, 0, NULLCHAR, NULLCHAR,
		    1, 0, NULLCHAR );
	break;

      case 's':                 /* save current msg to file */
	do_msg( nargs, args, 0, 0, 0, 1, 0 );
	break;

      case 'w':                 /* write current msg to file */
	do_msg( nargs, args, 0, 0, 1, 0, 0 );
	break;

      case 'x':                 /* abort */
	( void ) fclose( mfile );
	( void ) exit( 0 );
	/* NOTREACHED */
	break;

      case 'p':                 /* print message */
	do_msg( nargs, args, 0, 0, 0, 0, 1 );
	break;

      case 'r':                 /* reply */
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	{
	  if ( nargs == 0 )
	    msgnum = current;
	  else
	    msgnum = atoi( args[0] );
	  switch ( p[1] )
	  {
	    case 'f':
	      if ( msgnum >= 1 && msgnum <= nmsgs )
		Reply( msgnum, 0, 1, 0, 0 );
	      else
		printf( badmsg, msgnum );
	      break;
	    default:
	      if ( msgnum >= 1 && msgnum <= nmsgs )
		Reply( msgnum, 0, 0, 0, 0 );
	      else
		printf( badmsg, msgnum );
	      break;
	  }
	}
	break;

      case 'R':
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	{
	  if ( nargs == 0 )
	    msgnum = current;
	  else
	    msgnum = atoi( args[0] );
	  switch ( p[1] )
	  {
	    case 'f':
	    case 'F':
	      if ( msgnum >= 1 && msgnum <= nmsgs )
		Reply( msgnum, 1, 1, 0, 0 );
	      else
		printf( badmsg, msgnum );
	      break;
	    default:
	      if ( msgnum >= 1 && msgnum <= nmsgs )
		Reply( msgnum, 1, 0, 0, 0 );
	      else
		printf( badmsg, msgnum );
	      break;
	  }
	}
	break;

      case '%':
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	{
	  if ( nargs == 0 )
	    msgnum = current;
	  else
	    msgnum = atoi( args[0] );
	  switch ( p[1] )
	  {
	    case 'f':
	    case 'F':
	      if ( msgnum >= 1 && msgnum <= nmsgs )
		Reply( msgnum, 0, 1, 1, 0 );
	      else
		printf( badmsg, msgnum );
	      break;
	    default:
	      if ( msgnum >= 1 && msgnum <= nmsgs )
		Reply( msgnum, 0, 0, 1, 0 );
	      else
		printf( badmsg, msgnum );
	      break;
	  }
	}
	break;

      case 'f':
	if ( mfile == NULLFILE )
	{
	  printf( nomail );
	  break;
	}
	if ( nargs == 0 )
	  msgnum = current;
	else
	  msgnum = atoi( args[0] );
	if ( msgnum < 1 || msgnum > nmsgs )
	{
	  printf( badmsg, msgnum );
	  break;
	}
	if ( ( tfile = tmpfile(	 ) ) == NULLFILE )
	  printf( "Cannot open tmp file\r\n" );
	else
	{
	  msgtofile( msgnum, tfile, 0, 1 );
	  fseek( tfile, 0L, 0 );
	  printf( "To: " );
	  gets( command );
	  nargs = parse( command, args, MAXARGS );
	  dosmtpsend( tfile, args, nargs, NULLCHAR, 0, NULLCHAR, NULLCHAR,
		      0, 0, NULLCHAR );
	  ( void ) fclose( tfile );
	}
	break;

      case 'F':
	if ( mfile == NULLFILE )
	{
	  printf( nomail );
	  break;
	}
	if ( nargs == 0 )
	  msgnum = current;
	else
	  msgnum = atoi( args[0] );
	if ( msgnum < 1 || msgnum > nmsgs )
	{
	  printf( badmsg, msgnum );
	  break;
	}
	if ( ( tfile = tmpfile(	 ) ) == NULLFILE )
	  printf( "Cannot open tmp file\r\n" );
	else
	{
	  msgtofile( msgnum, tfile, 0, 0 );
	  fseek( tfile, 0L, 0 );
	  printf( "To: " );
	  gets( command );
	  nargs = parse( command, args, MAXARGS );
	  dosmtpsend( tfile, args, nargs, NULLCHAR, 0, NULLCHAR, NULLCHAR,
		      0, 0, NULLCHAR );
	  ( void ) fclose( tfile );
	}
	break;

      case 'b':                 /* bounce a message */
	if ( mfile == NULLFILE )
	{
	  printf( nomail );
	  break;
	}
	if ( nargs == 0 )
	  msgnum = current;
	else
	  msgnum = atoi( args[0] );
	if ( msgnum < 1 || msgnum > nmsgs )
	{
	  printf( badmsg, msgnum );
	  break;
	}
	if ( ( tfile = tmpfile(	 ) ) == NULLFILE )
	  printf( "Cannot open tmp file\r\n" );
	else
	{
	  msgtofile( msgnum, tfile, 0, 0 );
	  fseek( tfile, 0L, 0 );
	  printf( "To: " );
	  gets( command );
	  nargs = parse( command, args, MAXARGS );
	  bouncemsg( tfile, args, nargs );
	  ( void ) fclose( tfile );
	}
	break;

      case 'u':
	do_msg( nargs, args, 0, 1, 0, 0, 0 );
	break;

      case 'l':                 /* display unsent messages */
	listqueue(  );
	break;

      case 'k':
	if ( nargs == 0 )
	  printf( "No Job_ID specified\r\n" );
	else
	  for ( i = 0; i < nargs; i++ )
	    killjob( args[i] );
	break;

      case 'a':
	in_alias( nargs, args, NULLCHAR );
	break;

      case 'A':
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	{
	  if ( nargs == 0 )
	    msgnum = current;
	  else
	    msgnum = atoi( args[0] );
	  if ( msgnum >= 1 && msgnum <= nmsgs )
	    alias_msg( msgnum );
	  else
	    printf( badmsg, msgnum );
	}
	break;

      case 'n':                 /* display or change notefile */
	mboxnames( nargs, args, 0 );
	break;

      case 'q':                 /* quit */
	if ( isnewmail(	 ) )
	{
	  printf( newmail );
	  reinit( 3, 0 );
	}
	else
	  bmexit( 0 );
	/* NOTREACHED */
	break;

      case '$':
	if ( isnewmail(	 ) )
	{
	  printf( newmail );
	  reinit( 3, 0 );
	}
	else
	  reinit( 2, 0 );
	break;

      case '/':
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	{
	  if ( nargs == 0 )
	  {
	    printf( nopattern );
	    break;
	  }
	  else if ( lflag )
	    listnotes( 1, nargs, args, 0, 0 );
	  else
	    listnotes( 0, nargs, args, 0, 0 );
	}
	break;

      case 'd':                 /* delete a message */
	do_msg( nargs, args, 1, 0, 0, 0, 0 );
	break;

      case 'h':                 /* list message headers in notefile */

	if ( mfile == NULLFILE )
	  printf( nomail );
	else if ( lflag )
	  if ( nargs == 0 )
	    listnotes( 1, 0, NULLCHAR, 0, 2 );
	  else
	  {
	    msgnum = atoi( args[0] );
	    if ( msgnum >= 1 && msgnum <= nmsgs )
	      listnotes( 1, 0, NULLCHAR, msgnum, 2 );
	    else
	      printf( badmsg, msgnum );
	  }
	else if ( nargs == 0 )
	  listnotes( 0, 0, NULLCHAR, 0, 2 );
	else
	{
	  msgnum = atoi( args[0] );
	  if ( msgnum >= 1 && msgnum <= nmsgs )
	    listnotes( 0, 0, NULLCHAR, msgnum, 2 );
	  else
	    printf( badmsg, msgnum );
	}
	break;

      case 'H':                 /* list message headers in notefile */

	if ( mfile == NULLFILE )
	  printf( nomail );
	else if ( nargs == 0 )
	  listnotes( 1, 0, NULLCHAR, 0, 2 );
	else
	{
	  msgnum = atoi( args[0] );
	  if ( msgnum >= 1 && msgnum <= nmsgs )
	    listnotes( 1, 0, NULLCHAR, msgnum, 2 );
	  else
	    printf( badmsg, msgnum );
	}
	break;

      case '\0':                /* a blank line prints next message */
	printnext(  );
	break;

      case '?':                 /* help */
	dohelp(	 );
	break;

      case '.':
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	  displaymsg( current );
	break;

      case '=':
	if ( mfile == NULLFILE )
	  printf( nomail );
	else
	  printf( "Message #%d %s\r\n", current,
		  mbox[current].status & DELETE ? "[Deleted]" : "" );
	break;

      default:
	if ( !isdigit( *p ) )
	  printf( badcommand );
	else
	{
	  if ( mfile == NULLFILE )
	    printf( nomail );
	  else
	  {
	    msgnum = atoi( p );
	    if ( msgnum <= 0 || msgnum > nmsgs )
	      printf( badmsg, msgnum );
	    else
	    {
	      current = msgnum;
	      displaymsg( current );
	    }
	  }
	}
	break;
    }
  }
}

do_msg( argc, argv, del, undel, writemsg, savemsg, printmsg )
int	      argc;
char	     *argv[];
int	      del;
int	      undel;
int	      writemsg;
int	      savemsg;
int	      printmsg;
{
  register int	msgnum;
  register int	nmsgnum;
  register char *p;
  register char *q;
  register char *cp;
  register int	n;
  register int	i;
  char		tstring[LINELEN];
  register char *writefile;
  FILE	       *tfile;
  register int	wflag = 0;
  register char *savefile;
  char		buf[LINELEN];
  char		cmd[LINELEN];
  char		lpfile[LINELEN];
  register int	j;

  register char *s;
  register int	c;

  if ( mfile == NULLFILE )
  {
    printf( nomail );
    return;
  }
  if ( argc == 0 )
  {
    if ( printmsg )
    {
      if ( ( tfile = fopen( "PRN", "a" ) ) == NULLFILE )
      {
	perror( "PRN" );
	return;
      }
      msgtofile( current, tfile, 0, 0 );
      fprintf( tfile, "" );
      ( void ) fclose( tfile );
      wflag = 1;
    }
    if ( savemsg )
    {
      cleanup_fname( savebox );
      if ( ( tfile = fopen( savebox, "a" ) ) == NULLFILE )
      {
	perror( savebox );
	return;
      }
      msgtofile( current, tfile, 0, 0 );
      ( void ) fclose( tfile );
      printf( "%s appended\r\n", savebox );
    }
    if ( writemsg )
      printf( nofile );
    if ( del )
      delmsg( current );
    if ( undel )
      mbox[current].status &= ~DELETE;
  }
  else
  {
    if ( savemsg )
    {
      if ( isdigit( *argv[argc - 1] ) ||
	   *argv[argc - 1] == '*' || *argv[argc - 1] == '$' )
	savefile = savebox;
      else
      {
	savefile = argv[argc - 1];
	--argc;
	if ( strpbrk( savefile, "/\\" ) == NULLCHAR && folder != NULLCHAR )
	{

	  s = folder;
	  if ( s[0] != '\0' )
	    s += strlen( s ) - 1;
	  if ( *s == '\\' || *s == '/' )
	  {
	    c = strlen( folder );
	    folder[c - 1] = '\0';
	  }
	  sprintf( buf, "%s/%s", folder, savefile );
	  savefile = buf;
	}
      }
      cleanup_fname( savefile );
      if ( argc == 0 )
      {
	if ( ( tfile = fopen( savefile, "a" ) ) == NULLFILE )
	{
	  perror( savefile );
	  return;
	}
	msgtofile( current, tfile, 0, 0 );
	( void ) fclose( tfile );
	wflag = 1;
      }
    }
    if ( writemsg )
    {
      if ( isdigit( *argv[argc - 1] ) ||
	   *argv[argc - 1] == '*' || *argv[argc - 1] == '$' )
      {
	printf( nofile );
	return;
      }
      else
      {
	writefile = argv[argc - 1];
	--argc;
      }
      cleanup_fname( writefile );
      if ( argc == 0 )
      {
	if ( ( tfile = fopen( writefile, "a" ) ) == NULLFILE )
	{
	  perror( writefile );
	  return;
	}
	msgtofile( current, tfile, 1, 0 );
	( void ) fclose( tfile );
	wflag = 1;
      }
    }
    for ( j = 0; j < argc; j++ )
    {
      i = strlen( argv[j] );
      *tstring = '\0';
      while ( i )
      {
	strcat( tstring, "*" );
	i--;
      }
      if ( strcmp( argv[j], tstring ) == 0 )
      {
	if ( printmsg )
	  if ( ( tfile = fopen( "PRN", "a" ) ) == NULLFILE )
	  {
	    perror( "PRN" );
	    return;
	  }
	if ( savemsg )
	  if ( ( tfile = fopen( savefile, "a" ) ) == NULLFILE )
	  {
	    perror( savefile );
	    return;
	  }
	if ( writemsg )
	  if ( ( tfile = fopen( writefile, "a" ) ) == NULLFILE )
	  {
	    perror( writefile );
	    return;
	  }
	msgnum = 1;
	while ( msgnum != nmsgs + 1 )
	{
	  if ( del )
	    delmsg( msgnum );
	  if ( undel )
	    mbox[msgnum].status &= ~DELETE;
	  if ( writemsg )
	    msgtofile( msgnum, tfile, 1, 0 );
	  if ( savemsg || printmsg )
	  {
	    msgtofile( msgnum, tfile, 0, 0 );
	    if ( printmsg )
	      fprintf( tfile, "" );
	  }
	  msgnum++;
	}
	if ( writemsg || savemsg || printmsg )
	{
	  wflag = 1;
	  ( void ) fclose( tfile );
	}
      }
      else
      {
	if ( strchr( argv[j], '-' ) != NULLCHAR )
	{
	  p = argv[j];
	  cp = strchr( p, '-' );
	  *cp = '\0';
	  n = strlen( p );
	  q = &p[n + 1];
	  while ( *q == '-' )
	    q++;
	  *tstring = '\0';
	  while ( n )
	  {
	    strcat( tstring, "$" );
	    n--;
	  }
	  if ( strcmp( p, tstring ) == 0 )
	    msgnum = nmsgs;
	  else
	    msgnum = atoi( p );
	  i = strlen( q );
	  *tstring = '\0';
	  while ( i )
	  {
	    strcat( tstring, "$" );
	    i--;
	  }
	  if ( strcmp( q, tstring ) == 0 )
	    nmsgnum = nmsgs;
	  else
	    nmsgnum = atoi( q );
	  if ( msgnum < 1 || msgnum > nmsgs )
	    printf( badmsg, msgnum );
	  else if ( nmsgnum < 1 || nmsgnum > nmsgs )
	    printf( badmsg, nmsgnum );
	  if ( msgnum <= nmsgnum && msgnum >= 1 &&
	       msgnum <= nmsgs && nmsgnum >= 1 && nmsgnum <= nmsgs )
	  {
	    if ( printmsg )
	      if ( ( tfile = fopen( "PRN", "a" ) ) == NULLFILE )
	      {
		perror( "PRN" );
		return;
	      }
	    if ( savemsg )
	      if ( ( tfile = fopen( savefile, "a" ) ) == NULLFILE )
	      {
		perror( savefile );
		return;
	      }
	    if ( writemsg )
	      if ( ( tfile = fopen( writefile, "a" ) ) == NULLFILE )
	      {
		perror( writefile );
		return;
	      }
	    while ( msgnum != nmsgnum + 1 )
	    {
	      if ( del )
		delmsg( msgnum );
	      if ( undel )
		mbox[msgnum].status &= ~DELETE;
	      if ( writemsg )
		msgtofile( msgnum, tfile, 1, 0 );
	      if ( savemsg || printmsg )
	      {
		msgtofile( msgnum, tfile, 0, 0 );
		if ( printmsg )
		  fprintf( tfile, "" );
	      }
	      msgnum++;
	    }
	    if ( writemsg || savemsg || printmsg )
	    {
	      ( void ) fclose( tfile );
	      wflag = 1;
	    }
	  }
	  else
	  {
	    if ( msgnum > nmsgnum && msgnum >= 1 &&
		 msgnum <= nmsgs && nmsgnum >= 1 && nmsgnum <= nmsgs )
	    {
	      if ( printmsg )
		if ( ( tfile = fopen( "PRN", "a" ) ) == NULLFILE )
		{
		  perror( "PRN" );
		  return;
		}
	      if ( savemsg )
		if ( ( tfile = fopen( savefile, "a" ) ) == NULLFILE )
		{
		  perror( savefile );
		  return;
		}
	      if ( writemsg )
		if ( ( tfile = fopen( writefile, "a" ) ) == NULLFILE )
		{
		  perror( writefile );
		  return;
		}
	      while ( msgnum != nmsgnum - 1 )
	      {
		if ( del )
		  delmsg( msgnum );
		if ( undel )
		  mbox[msgnum].status &= ~DELETE;
		if ( writemsg )
		  msgtofile( msgnum, tfile, 1, 0 );
		if ( savemsg || printmsg )
		{
		  msgtofile( msgnum, tfile, 0, 0 );
		  if ( printmsg )
		    fprintf( tfile, "" );
		}
		msgnum--;
	      }
	      if ( writemsg || savemsg || printmsg )
	      {
		( void ) fclose( tfile );
		wflag = 1;
	      }
	    }
	  }
	}
	else
	{
	  i = strlen( argv[j] );
	  *tstring = '\0';
	  while ( i )
	  {
	    strcat( tstring, "$" );
	    i--;
	  }
	  if ( strcmp( argv[j], tstring ) == 0 )
	    msgnum = nmsgs;
	  else
	    msgnum = atoi( argv[j] );
	  if ( msgnum >= 1 && msgnum <= nmsgs )
	  {
	    if ( del )
	      delmsg( msgnum );
	    if ( undel )
	      mbox[msgnum].status &= ~DELETE;
	    if ( writemsg )
	    {
	      if ( ( tfile = fopen( writefile, "a" ) ) == NULLFILE )
	      {
		perror( writefile );
		return;
	      }
	      msgtofile( msgnum, tfile, 1, 0 );
	      ( void ) fclose( tfile );
	      wflag = 1;
	    }
	    if ( savemsg )
	    {
	      if ( ( tfile = fopen( savefile, "a" ) ) == NULLFILE )
	      {
		perror( savefile );
		return;
	      }
	      msgtofile( msgnum, tfile, 0, 0 );
	      ( void ) fclose( tfile );
	      wflag = 1;
	    }
	    if ( printmsg )
	    {
	      if ( ( tfile = fopen( "PRN", "a" ) ) == NULLFILE )
	      {
		perror( "PRN" );
		return;
	      }
	      msgtofile( msgnum, tfile, 0, 0 );
	      fprintf( tfile, "" );
	      ( void ) fclose( tfile );
	      wflag = 1;
	    }
	  }
	  else
	    printf( badmsg, msgnum );
	}
      }
    }
    if ( writemsg && wflag )
      printf( "%s appended\r\n", writefile );
    if ( savemsg && wflag )
      printf( "%s appended\r\n", savefile );
  }
}

in_alias( argc, argv, user )
int	      argc;
char	     *argv[];
char	     *user;
{
  FILE	       *fa;
  char	       *name;
  char		al[LINELEN];
  register char *a, *p, *q;
  int		found;
  char		Name[LINELEN];
  char		als[LINELEN];
  char		tstring[LINELEN];

  if ( argc == 0 )
  {
    if ( editor == NULLCHAR || *editor == '\0' )
    {
      printf( "No editor defined\r\n" );
      return 0;
    }
    sprintf( tstring, "%s %s", editor, aliases );
    system( tstring );
    return 0;
  }
  found = 0;
  if ( ( fa = fopen( aliases, "r" ) ) == NULLFILE )
  {
    if ( user != NULLCHAR )
      return 0;
    else
    {
      printf( "Cannot open %s\r\n", aliases );
      return 0;
    }
  }
  if ( user != NULLCHAR )
    name = user;
  else
    name = argv[0];
  while ( fgets( al, LINELEN, fa ) != NULLCHAR )
  {
    p = al;
    if ( *p == '#' || *p == '\0' || *p == '\n' )
      continue;
    rip( p );
    if ( found && *p != ' ' && *p != '\t' )
      break;
    if ( !found )
    {
      q = Name;
      while ( *p && *p != ' ' && *p != '\t' && *p != ',' )
	*q++ = *p++;
      *q = '\0';
    }
    if ( strcmp( name, Name ) == 0 )
    {
      while ( *p != '\0' )
      {
	while ( *p == ' ' || *p == '\t' || *p == ',' )
	  p++;
	if ( *p == '#' )
	  break;
	a = als;
	while ( *p && *p != ' ' && *p != '\t' && *p != ',' )
	  *a++ = *p++;
	*a = '\0';
	if ( *als != '\0' )
	{
	  found = 1;
	  if ( user == NULLCHAR )
	  {
	    printf( "Alias: %s", als );
	    if ( strchr( als, '@' ) == NULLCHAR )
	      printf( "@%s", hostname );
	    printf( "\r\n" );
	  }
	}
      }
    }
  }
  ( void ) fclose( fa );
  if ( user != NULLCHAR && found )
    return 1;
  else if ( user != NULLCHAR && !found )
    return 0;
  else if ( !found )
    printf( "No alias found\r\n" );
  return 0;
}

reinit( nlines, sv )
int	      nlines;
int	      sv;
{
  int		ret;

  if ( !fflag && lockit(  ) )
    return;
  ret = closenotes(  );
  if ( !fflag )
    rmlock( maildir, notename );
  if ( ret != 0 )
  {
    if ( sv )
      savetpfile(  );
    exit( 1 );
  }
  if ( !fflag && lockit(  ) )
  {
    if ( sv )
      savetpfile(  );
    exit( 1 );
  }
  ret = initnotes(  );
  if ( !fflag )
    rmlock( maildir, notename );
  if ( ret != 0 )
  {
    if ( sv )
      savetpfile(  );
    exit( 1 );
  }
  if ( lflag )
    listnotes( 1, 0, NULLCHAR, 0, nlines );
  else
    listnotes( 0, 0, NULLCHAR, 0, nlines );
}
