#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <sys/stat.h>
#ifndef UNIX
#include <dos.h>
#endif
#include "bm.h"

struct addr  *addrecip(	 );
char	     *ptime(  );
extern char   version[];
long	      sequence;
char	      dateline[LINELEN], inreplytoline[LINELEN];
char	      replytoline[XLINELEN], smtp_subjectline[XLINELEN];
char	      fullnameline[XLINELEN], organline[XLINELEN];
FILE	     *hfile;
char	      norcp[] = "No recipients\r\n";
char	      nosend[] = "Send aborted\n";
char	      bim[] = "\n  ===== Begin of included message =====\n\n";
char	      eim[] = "  ===== End of included message =====\n\n";
FILE	     *tpfile;
char	      tpf[LINELEN];

/* save and delete msg tmp file */
savetpfile(  )
{
  char		dmsg[XLINELEN];
  FILE	       *deadfl;
  int		c;

  strcpy( dmsg, deadmsg );
  if ( ( deadfl = fopen( dmsg, "w" ) ) == NULLFILE )
    perror( dmsg );
  else
  {
    fseek( tpfile, 0L, 0 );
    while ( ( c = getc( tpfile ) ) != EOF )
      if ( putc( c, deadfl ) == EOF )
	break;
    if ( ferror( deadfl ) )
    {
      perror( dmsg );
      ( void ) fclose( deadfl );
      ( void ) unlink( dmsg );
    }
    else
    {
      ( void ) fclose( deadfl );
      printf( "Message saved in %s\r\n", dmsg );
    }
  }
  ( void ) fclose( tpfile );
  ( void ) unlink( tpf );
}

printtolist( tolist, ack )
struct addr  *tolist;
int	      ack;
{
  register struct addr *tp;
  char		tstring[XXLINELEN];
  int		n;

  strcpy( tstring, "To: " );
  for ( tp = tolist; tp != NULLADDR; tp = tp->next )
  {
    strcat( tstring, tp->user );
    if ( tp->host != NULLCHAR || *tp->host != '\0' )
    {
      strcat( tstring, "@" );
      strcat( tstring, tp->host );
    }
    n = strlen( tstring );
    if ( tp->next )
    {
      if ( n > 50 )
      {
	if ( tty )
	{
	  fputs( tstring, stdout );
	  fputs( ",\r\n    ", stdout );
	}
	*tstring = '\0';
      }
      else
	strcat( tstring, ", " );
    }
  }
  if ( ack )
  {
    if ( tty )
    {
      fputs( tstring, stdout );
      fputs( " (Y/n) ? ", stdout );
    }
  }
  else if ( tty )
  {
    fputs( tstring, stdout );
    fputs( "\r\n", stdout );
  }
}

/* send a message */
dosmtpsend( mfp, toargs, nargs, subject, incl, msgno, msgid, sendfile,
	    reply, date )
FILE	     *mfp;
char	     *toargs[];
int	      nargs;
char	     *subject;
int	      incl;
int	      msgno;
char	     *msgid;
int	      sendfile;
int	      reply;
char	     *date;
{
  char	       *tmpnam(	 );
  FILE	       *fpin, *fsign, *fsigna, *fts;
  char		smtp_subject[LINELEN];
  char	       *p;
  char	       *tfl = "bmXXXXXX";       /* temp file name */
  struct addr  *tolist;
  time_t	t;
  int		mnargs;
  char	       *margs[MAXARGS], *targs[MAXARGS];
  char	       *cp, *q;
  register int	i, c, msgnum;
  char		bmcmd[2];
  struct stat	mstat;
  int		T_nargs;
  char		cmd[LINELEN], tline[LINELEN];
  char		cm[LINELEN], rm[LINELEN], line[LINELEN], tyn[LINELEN];
  char		tstring[LINELEN], filetosend[LINELEN];
  char		sign_str[XLINELEN], sign_all[XLINELEN];
  int		tnargs, rmg, quotes, today_quote;
  int		txt = 0;
  long		beg_q_poz, end_q_poz;

  if ( nargs == 0 )
  {
    printf( norcp );
    return 0;
  }
  fpin = mfp;
  if( fpin == NULLFILE && emname != NULLCHAR )
    fpin = fopen( emname, "r" );
  if ( ( tolist = make_tolist( nargs, toargs ) ) == NULLADDR )
  {
    fprintf( stderr, nosend );
    return 0;
  }

  if ( ( sequence = get_msgid(	) ) == -1 )
  {
    fprintf( stderr, nosend );
    return 0;
  }

  time( &t );
  sprintf( tpf, "%s\\%s", tmpdir, tfl );
  mktemp( tpf );
  /* open textfile for write */
  if ( ( tpfile = fopen( tpf, "w+" ) ) == NULLFILE )
  {
    perror( tpf );
    del_addrlist( tolist );
    return 1;
  }

  if ( eflag && reply )
  {
    printtolist( tolist, 1 );
    if ( tty )
    {
      gets( tyn );
      q = tyn;
      while ( *q == ' ' || *q == '\t' )
	q++;
      if ( *q == 'n' || *q == 'N' )
      {
	printf( "To: " );
	gets( tline );
	tnargs = parse( tline, targs, MAXARGS );
	if ( tnargs == 0 )
	{
	  printf( norcp );
	  ( void ) fclose( tpfile );
	  ( void ) unlink( tpf );
	  return 0;
	}
	if ( ( tolist = make_tolist( tnargs, targs ) ) == NULLADDR )
	{
	  fprintf( stderr, nosend );
	  ( void ) fclose( tpfile );
	  ( void ) unlink( tpf );
	  return 0;
	}
	else
	  printtolist( tolist, 0 );
      }
    }
  }
  else
    printtolist( tolist, 0 );

  *fullnameline = '\0';
  if ( fullname != NULLCHAR && *fullname != '\0' )
    sprintf( fullnameline, " (%s)\n", fullname );
  else
    sprintf( fullnameline, "\n" );

  if ( !qflag )
    sprintf( dateline, "Date: %s", ptime( &t ) );

  if ( !qflag )
  {
    *replytoline = '\0';
    if ( replyto != NULLCHAR && *replyto != '\0' )
      sprintf( replytoline, "Reply-To: %s\n", replyto );

    *smtp_subjectline = '\0';
    if ( sflag && tty && ( subject == NULL || *subject == '\0' ) ||
	 mfp != NULLFILE || sendfile )
    {
      /* prompt and get Subject: */
      printf( "Subject: " );
      gets( smtp_subject );
      q = smtp_subject;
      while ( *q == ' ' || *q == '\t' )
	q++;
      if ( *q != '\0' )
	sprintf( smtp_subjectline, "Subject: %s\n", q );
    }
    if ( subject != NULL && *subject != '\0' )
    {
      strcpy( smtp_subject, subject );
      if ( tty )
	printf( "Subject: %s\r\n", smtp_subject );
      sprintf( smtp_subjectline, "Subject: %s\n", smtp_subject );
    }

    *inreplytoline = '\0';
    if ( reply && *date != '\0' )
      sprintf( inreplytoline, "In-Reply-To: Your message of %s\n", date );

    *organline = '\0';
    if ( organ != NULLCHAR && *organ != '\0' )
      sprintf( organline, "X-Organization: %s\n", organ );

    if ( mfp != NULLFILE )
      fprintf( tpfile, "  ===== Forwarded message follows =====\n\n" );
  }

  if ( !tty && fpin == NULLFILE )
    fpin = stdin;

  if ( fpin != NULLFILE )
  {
    while ( ( c = getc( fpin ) ) != EOF )
      if ( putc( c, tpfile ) == EOF )
	break;
    if ( ferror( tpfile ) )
    {
      perror( "tmp file" );
      ( void ) fclose( tpfile );
      ( void ) unlink( tpf );
      return 1;
    }
  }
  else
  {
    if ( incl )
    {
      if ( *msgid != '\0' )
	fprintf( tpfile, "In message %s you write:\n", msgid );
      else
	fprintf( tpfile, "You write:\n" );
      msgtofile( msgno, tpfile, 1, 1 );
    }
    if ( sendfile )
    {
      printf( "File: " );
      gets( filetosend );
      q = filetosend;
      while ( *q == ' ' || *q == '\t' )
	q++;
      cleanup_fname( q );
      if ( *q == '\0' )
      {
	printf( nofile );
	( void ) fclose( tpfile );
	( void ) unlink( tpf );
	return 0;
      }
      else if ( ( fts = fopen( q, "r" ) ) == NULLFILE )
      {
	printf( "No such file\r\n" );
	( void ) fclose( tpfile );
	( void ) unlink( tpf );
	return 0;
      }
      else
      {
	printf( "Reading file %s\r\n", q );
	while ( ( c = getc( fts ) ) != EOF )
	  if ( putc( c, tpfile ) == EOF )
	    break;
	if ( ferror( tpfile ) )
	{
	  perror( "tmp file" );
	  ( void ) fclose( fts );
	  ( void ) fclose( tpfile );
	  ( void ) unlink( tpf );
	  return 1;
	}
	( void ) fclose( fts );
      }
    }
    else
    {
      /* sending a message not from a file */
      /* copy text from console to the file */
      if ( !eflag )
      {
	printf( "\r\nType message text.  Enter a '.' "
		"or Ctrl-D in column one to end." );
	printf( "\r\nCommands: ~p - Print msg so far, "
		"~e - Invoke editor, ~? - Help\r\n\n" );
	for ( ;; )
	{
	  /* read line from console ie stdin */
	  if ( gets( tstring ) == NULLCHAR )
	  {
	    break;
	  }
	  rip( tstring );
	  if ( strcmp( tstring, "." ) == 0 || tstring[0] == '\004' )
	    break;
	  if ( *tstring == '~' )
	  {
	    switch ( tstring[1] )
	    {
	      case 'h':
	      case 'p':
	      case 'P':
		/* Print the message so far */
		if ( !qflag )
		  fputs( dateline, stdout );
		printf( "From: %s@%s", username, hostname );
		fputs( fullnameline, stdout );
		if ( !qflag )
		{
		  fputs( replytoline, stdout );
		  printtolist( tolist, 0 );
		  fputs( smtp_subjectline, stdout );
		  fputs( inreplytoline, stdout );
		  fputs( organline, stdout );
		  printf( "X-Mailer: %s\r\n", version );
		  fputs( "\n", stdout );
		}
		if ( tstring[1] != 'h' )
		{
		  fseek( tpfile, 0L, 0 );
		  while ( fgets( tstring, sizeof( tstring ), tpfile ) !=
			  NULLCHAR )
		    fputs( tstring, stdout );
		}
		break;
	      case 'e':
	      case 'v':
		/* Drop into editor */
		if ( editor == NULLCHAR || *editor == '\0' )
		{
		  printf( "No editor defined\r\n" );
		  break;
		}
		( void ) fclose( tpfile );
		sprintf( tstring, "%s %s", editor, tpf );
		/* call editor to enter message text */
		system( tstring );
		txt = 1;
		tpfile = fopen( tpf, "a+" );
		break;
	      case 'a':
		p = &tstring[2];
		mnargs = parse( p, margs, MAXARGS );
		in_alias( mnargs, margs, NULLCHAR );
		break;
	      case 'o':
		if ( !qflag )
		{
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  if ( *p != '\0' )
		  {
		    if ( ( strlen( p ) == 1 ) && *p == '~' )
		      *organline = '\0';
		    else if ( *p == '~' )
		      sprintf( organline, "X-Organization: %s\n", &p[1] );
		    else
		      sprintf( organline, "X-Organization: %s\n", p );
		  }
		  else
		    fputs( organline, stdout );
		}
		break;
	      case 'R':
		if ( !qflag )
		{
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  if ( *p != '\0' )
		  {
		    if ( ( strlen( p ) == 1 ) && *p == '~' )
		      *replytoline = '\0';
		    else if ( *p == '~' )
		      sprintf( replytoline, "Reply-To: %s\n", &p[1] );
		    else
		      sprintf( replytoline, "Reply-To: %s\n", p );
		  }
		  else
		    fputs( replytoline, stdout );
		}
		break;
	      case 's':
		if ( !qflag )
		{
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  if ( *p != '\0' )
		  {
		    if ( ( strlen( p ) == 1 ) && *p == '~' )
		      *smtp_subjectline = '\0';
		    else if ( *p == '~' )
		      sprintf( smtp_subjectline, "Subject: %s\n", &p[1] );
		    else
		      sprintf( smtp_subjectline, "Subject: %s\n", p );
		  }
		  else
		    fputs( smtp_subjectline, stdout );
		}
		break;
	      case 'T':
		p = &tstring[2];
		if ( *p != '\0' )
		{
		  T_nargs = parse( p, margs, MAXARGS );
		  if ( ( tolist = make_tolist( T_nargs, margs ) ) == NULLADDR )
		  {
		    fprintf( stderr, nosend );
		    if ( txt )
		      savetpfile(  );
		    else
		    {
		      ( void ) fclose( tpfile );
		      ( void ) unlink( tpf );
		    }
		    return 0;
		  }
		}
		printtolist( tolist, 0 );
		break;
	      case 'q':
		( void ) fclose( tpfile );
		( void ) unlink( tpf );
		printf( "Abort\r\n" );
		return 0;
	      case 'w':
		{
		  FILE	       *outfl;
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  cleanup_fname( p );
		  if ( *p == '\0' )
		    printf( nofile );
		  else
		  {
		    if ( stat( p, &mstat ) == 0 )
		    {
		      printf( "File exists\r\n" );
		      break;
		    }
		    if ( ( outfl = fopen( p, "w" ) ) == NULLFILE )
		    {
		      perror( p );
		      break;
		    }
		    fseek( tpfile, 0L, 0 );
		    while ( ( c = getc( tpfile ) ) != EOF )
		      if ( putc( c, outfl ) == EOF )
			break;
		    if ( ferror( outfl ) )
		    {
		      perror( p );
		      ( void ) fclose( outfl );
		      ( void ) unlink( p );
		      break;
		    }
		    ( void ) fclose( outfl );
		    printf( "New file %s\r\n", p );
		  }
		  break;
		}
	      case 'r':
		{
		  FILE	       *infl;
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  cleanup_fname( p );
		  if ( *p == '\0' )
		    printf( nofile );
		  else if ( ( infl = fopen( p, "r" ) ) == NULLFILE )
		    printf( "No such file\r\n" );
		  else
		  {
		    printf( "Reading file %s\r\n", p );
		    while ( ( c = getc( infl ) ) != EOF )
		      if ( putc( c, tpfile ) == EOF )
			break;
		    if ( ferror( tpfile ) )
		    {
		      perror( "tmp file" );
		      ( void ) fclose( infl );
		      ( void ) fclose( tpfile );
		      ( void ) unlink( tpf );
		      return 1;
		    }
		    ( void ) fclose( infl );
		    txt = 1;
		  }

		  break;
		}
	      case 'm':
		{
		  int		msg;
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  if ( *p == '\0' )
		    msg = current;
		  else
		    msg = atoi( p );
		  if ( mfile == NULLFILE || msg < 1 || msg > nmsgs )
		    printf( "No such message\r\n" );
		  else
		  {
		    printf( "Include header (y/N) ? " );
		    gets( cm );
		    q = cm;
		    while ( *q == ' ' || *q == '\t' )
		      q++;
		    printf( "Inserting message %d\r\n", msg );
		    fprintf( tpfile, bim );
		    if ( *q == 'y' || *q == 'Y' )
		      msgtofile( msg, tpfile, 0, 1 );
		    else
		      msgtofile( msg, tpfile, 1, 1 );
		    fprintf( tpfile, eim );
		    txt = 1;
		  }
		  break;
		}
	      case 'M':
		{
		  int		msg;
		  p = &tstring[2];
		  while ( *p == ' ' || *p == '\t' )
		    p++;
		  if ( *p == '\0' )
		    msg = current;
		  else
		    msg = atoi( p );
		  if ( mfile == NULLFILE || msg < 1 || msg > nmsgs )
		    printf( "No such message\r\n" );
		  else
		  {
		    printf( "Include header (y/N) ? " );
		    gets( cm );
		    q = cm;
		    while ( *q == ' ' || *q == '\t' )
		      q++;
		    printf( "Inserting message %d\r\n", msg );
		    fprintf( tpfile, bim );
		    if ( *q == 'y' || *q == 'Y' )
		      msgtofile( msg, tpfile, 0, 0 );
		    else
		      msgtofile( msg, tpfile, 1, 0 );
		    fprintf( tpfile, eim );
		    txt = 1;
		  }
		  break;
		}
	      case '!':
		p = &tstring[2];
		system( p );
		break;
	      case '<':
		p = &tstring[2];
		( void ) fclose( tpfile );
		sprintf( cmd, "%s >> %s", p, tpf );
		system( cmd );
		tpfile = fopen( tpf, "a+" );
		txt = 1;
		break;
	      case '~':
		fprintf( tpfile, "%s\n", &tstring[1] );
		txt = 1;
		break;
	      case ':':
		p = &tstring[2];
		while ( *p == ' ' || *p == '\t' )
		  p++;
		if ( *p == '!' )
		{
		  system( &p[1] );
		  break;
		}
		if ( *p )
		{
		  cp = p;
		  while ( *cp && *cp != ' ' && *cp != '\t' )
		    cp++;
		  mnargs = parse( cp, margs, MAXARGS );
		}
		switch ( *p )
		{
		  case 'a':
		    in_alias( mnargs, margs, NULLCHAR );
		    break;
		  case 'A':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else
		    {
		      if ( mnargs == 0 )
			msgnum = current;
		      else
			msgnum = atoi( margs[0] );
		      if ( msgnum >= 1 && msgnum <= nmsgs )
			alias_msg( msgnum );
		      else
			printf( badmsg, msgnum );
		    }
		    break;
		  case 'd':
		    do_msg( mnargs, margs, 1, 0, 0, 0, 0 );
		    break;
		  case 'h':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else if ( lflag )
		      if ( mnargs == 0 )
			listnotes( 1, 0, NULLCHAR, 0, 2 );
		      else
		      {
			msgnum = atoi( margs[0] );
			if ( msgnum >= 1 && msgnum <= nmsgs )
			  listnotes( 1, 0, NULLCHAR, msgnum, 2 );
			else
			  printf( badmsg, msgnum );
		      }
		    else if ( mnargs == 0 )
		      listnotes( 0, 0, NULLCHAR, 0, 2 );
		    else
		    {
		      msgnum = atoi( margs[0] );
		      if ( msgnum >= 1 && msgnum <= nmsgs )
			listnotes( 0, 0, NULLCHAR, msgnum, 2 );
		      else
			printf( badmsg, msgnum );
		    }
		    break;
		  case 'H':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else if ( mnargs == 0 )
		      listnotes( 1, 0, NULLCHAR, 0, 2 );
		    else
		    {
		      msgnum = atoi( margs[0] );
		      if ( msgnum >= 1 && msgnum <= nmsgs )
			listnotes( 1, 0, NULLCHAR, msgnum, 2 );
		      else
			printf( badmsg, msgnum );
		    }
		    break;
		  case 'k':
		    if ( mnargs == 0 )
		      printf( "No Job_ID specified\r\n" );
		    else
		      for ( i = 0; i < mnargs; i++ )
			killjob( margs[i] );
		    break;
		  case 'l':
		    listqueue(	);
		    break;
		  case 'n':
		    if ( txt )
		      mboxnames( mnargs, margs, 1 );
		    else
		      mboxnames( mnargs, margs, 0 );
		    break;
		  case '$':
		    if ( isnewmail(  ) )
		    {
		      printf( newmail );
		      if ( txt )
			reinit( 3, 1 );
		      else
			reinit( 3, 0 );
		    }
		    else if ( txt )
		      reinit( 2, 1 );
		    else
		      reinit( 2, 0 );
		    break;
		  case 'p':
		    do_msg( mnargs, margs, 0, 0, 0, 0, 1 );
		    break;
		  case 's':
		    do_msg( mnargs, margs, 0, 0, 0, 1, 0 );
		    break;
		  case 'u':
		    do_msg( mnargs, margs, 0, 1, 0, 0, 0 );
		    break;
		  case 'w':
		    do_msg( mnargs, margs, 0, 0, 1, 0, 0 );
		    break;
		  case '/':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else
		    {
		      if ( mnargs == 0 )
		      {
			printf( nopattern );
			break;
		      }
		      else if ( lflag )
			listnotes( 1, mnargs, margs, 0, 0 );
		      else
			listnotes( 0, mnargs, margs, 0, 0 );
		    }
		    break;
		  case '%':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else
		    {
		      if ( mnargs == 0 )
			msgnum = current;
		      else
			msgnum = atoi( margs[0] );
		      switch ( p[1] )
		      {
			case 'f':
			case 'F':
			  if ( msgnum >= 1 && msgnum <= nmsgs )
			    Reply( msgnum, 0, 1, 1, 0 );
			  else
			    printf( badmsg, msgnum );
			  break;
			default:
			  if ( msgnum >= 1 && msgnum <= nmsgs )
			    Reply( msgnum, 0, 0, 1, 0 );
			  else
			    printf( badmsg, msgnum );
			  break;

		      }
		    }
		    break;
		  case '.':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else
		      displaymsg( current );
		    break;
		  case '=':
		    if ( mfile == NULLFILE )
		      printf( nomail );
		    else
		      printf( "Message #%d %s\r\n", current,
			      mbox[current].status &
			      DELETE ? "[Deleted]" : "" );
		    break;
		  case '\0':
		    printnext(	);
		    break;
		  case '?':
		    dohelp(  );
		    break;
		  default:
		    if ( *p == 'b' || *p == 'f' || *p == 'F' ||
			 *p == 'm' || *p == 'M' || *p == 'q' ||
			 *p == 'r' || *p == 'R' || *p == 'x' )
		    {
		      strncpy( bmcmd, p, 1 );
		      bmcmd[1] = '\0';
		      printf( "Cannot run mail-command '%s' "
			      "while composing\r\n", bmcmd );
		    }
		    else if ( !isdigit( *p ) )
		      printf( badcommand );
		    else
		    {
		      if ( mfile == NULLFILE )
			printf( nomail );
		      else
		      {
			msgnum = atoi( p );
			if ( msgnum <= 0 || msgnum > nmsgs )
			  printf( badmsg, msgnum );
			else
			{
			  current = msgnum;
			  displaymsg( current );
			}
		      }
		    }
		    break;
		}
		break;
	      case '?':
		printf( "HELP:  Mail Compose Escapes\r\n\n" );
		printf( "EDITING HEADING FIELDS                 "
			"EDITING MESSAGE BODY\r\n" );
		printf( "                                       "
			" ~e or ~v         Invoke editor\r\n" );
		printf( " ~o [organ]     Set X-Organization\r\n" );
		printf( " ~R [reply]     Set Reply-To field     "
			"OTHER COMPOSE ESCAPES\r\n" );
		printf( " ~s [subject]   Set Subject field      "
			" ~! command       Run shell command\r\n" );
		printf( "                                       "
			" ~: mail-command  Run mail command\r\n" );
		printf( " ~T [users]     Set To field           "
			" ~?               Print this help msg\r\n" );
		printf( "                                       "
			" ~~               Begin line with tilde\r\n" );
		printf( "READING IN MESSAGES                    "
			" ~a [name]        Edit or print alias\r\n" );
		printf( " ~< command  Read output shell command "
			" ~h               Print header\r\n" );
		printf( " ~m <list>   Read msg                  "
			" ~p or ~P         Print msg so far\r\n" );
		printf( " ~M <list>   Read msg; no tab          "
			" ~q               Abort msg\r\n" );
		printf( " ~r file     Read file                 "
			" ~w file          Write msg to file\r\n\n" );
		break;
	      default:
		printf( "Unknown ~ escape. ~? for help\r\n" );
	    }
	    printf( "(continue)\r\n" );
	  }
	  else
	  {
	    fprintf( tpfile, "%s\n", tstring );
	    txt = 1;
	  }
	}
	printf( "EOF\r\n" );
      }
      else
      {
	if ( editor == NULLCHAR || *editor == '\0' )
	{
	  printf( "No editor defined\r\n" );
	  ( void ) fclose( tpfile );
	  ( void ) unlink( tpf );
	  return 0;
	}
	( void ) fclose( tpfile );
	sprintf( tstring, "%s %s", editor, tpf );
    start:system( tstring );
	printf( "Abort, Edit or Send message (a/e/S) ? " );
	gets( line );
	q = line;
	while ( *q == ' ' || *q == '\t' )
	  q++;
	if ( *q == 'a' || *q == 'A' )
	{
	  ( void ) fclose( tpfile );
	  ( void ) unlink( tpf );
	  return 0;
	}
	if ( *q == 'e' || *q == 'E' )
	  goto start;
	tpfile = fopen( tpf, "a+" );
      }
    }
  }
  if ( !qflag )
  {
    sprintf( sign_str, "%s/%s.sig", mqueue, unotename );
    cleanup_fname( sign_str );
    sprintf( sign_all, "%s/signatur.sig", mqueue );
    cleanup_fname( sign_all );
    if ( ( fsigna = fopen( sign_all, "rt" ) ) != NULLFILE )
    {
      if ( ( fsign = fopen( sign_str, "wt" ) ) != NULLFILE )
      {
	while ( fgets( sign_all, XLINELEN, fsigna ) != NULLCHAR )
	{
	  if ( strncmp( sign_all, "--begin--", 9 ) == 0 )
	    break;
	  fputs( sign_all, fsign );
	}
	fprintf( fsign, "-- \n" );
	beg_q_poz = ftell( fsigna );
	quotes = 0;
	while ( fgets( sign_all, XLINELEN, fsigna ) != NULLCHAR )
	{
	  if ( *sign_all == '\n' )
	    quotes++;
	  if ( strncmp( sign_all, "--end--", 7 ) == 0 )
	  {
	    quotes++;
	    break;
	  }
	}
	end_q_poz = ftell( fsigna );
#ifdef UNIX
	today_quote = ( unsigned ) time( NULL ) % quotes;
#else
	today_quote = *((unsigned far *) MK_FP( 0x40, 0x6c )) % quotes;
#endif
	fseek( fsigna, beg_q_poz, SEEK_SET );
	while ( today_quote )
	{
	  fgets( sign_all, XLINELEN, fsigna );
	  if ( *sign_all == '\n' )
	    today_quote--;
	}
	while ( fgets( sign_all, XLINELEN, fsigna ) != NULLCHAR )
	{
	  if ( *sign_all == '\n' ||
	       strncmp( sign_all, "--end--", 7 ) == 0 )
	    break;
	  fputs( sign_all, fsign );
	}
	fprintf( fsign, "--\n" );
	fseek( fsigna, end_q_poz, SEEK_SET );
	while ( fgets( sign_all, XLINELEN, fsigna ) != NULLCHAR )
	  fputs( sign_all, fsign );
	fclose( fsigna );
	fclose( fsign );
      }
    }
    if ( ( fsign = fopen( sign_str, "rt" ) ) != NULLFILE )
    {
      while ( ( c = getc( fsign ) ) != EOF )
	if ( putc( c, tpfile ) == EOF )
	  break;
      if ( ferror( tpfile ) )
      {
	perror( "tmp file" );
	( void ) fclose( fsign );
	( void ) fclose( tpfile );
	( void ) unlink( tpf );
	return 1;
      }
      ( void ) fclose( fsign );
    }
  }
  header( tolist );
  if ( ( queuejob( tpfile, tolist, 0 ) ) != 1 )
  {

    fputs( "\n", tpfile );
    if ( !sendfile && !rflag && record != NULLCHAR && *record != '\0' )
      if ( recflag && tty )
      {
	printf( "Record message (y/N) ? " );
	gets( rm );
	q = rm;
	while ( *q == ' ' || *q == '\t' )
	  q++;
	if ( *q == 'y' || *q == 'Y' )
	  recordmsg( tpfile );	/* save copy for sender */
      }
      else
	recordmsg( tpfile );	/* save copy for sender */
  }
  else if ( txt )
  {
    ( void ) fclose( hfile );
    del_addrlist( tolist );
    savetpfile(	 );
    return 0;
  }
  ( void ) fclose( hfile );
  del_addrlist( tolist );
  ( void ) fclose( tpfile );
  ( void ) unlink( tpf );
  return 0;
}

/* forward a message in its orginal form */
bouncemsg( mfp, toargs, nargs )
FILE	     *mfp;
char	     *toargs[];
int	      nargs;
{
  struct addr  *list;

  if ( nargs == 0 )
    printf( norcp );
  else if ( ( list = make_tolist( nargs, toargs ) ) == NULLADDR )
    fprintf( stderr, nosend );
  else
  {
    printtolist( list, 0 );
    queuejob( mfp, list, 1 );
    del_addrlist( list );
  }
}

/* Return Date/Time in Arpanet format in passed string */
/* Print out the time and date field as
 *		"DAY day MONTH year hh:mm:ss ZONE"
 */
char	     *
ptime( t )
long	     *t;
{
  register struct tm *ltm;
  struct tm    *localtime(  );
  static char	tz[4];
  static char	str[40];
  extern char  *getenv(	 );
  char	       *p;
  static char  *days[7] = {
  "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

  static char  *months[12] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

  /* Read the system time */
  ltm = localtime( t );

  if ( tzone != NULLCHAR && *tzone != '\0' )
    strncpy( tz, tzone, 3 );

  if ( *tz == '\0' )
    if ( ( p = getenv( "TZ" ) ) == NULLCHAR )
      strcpy( tz, "GMT" );
    else
      strncpy( tz, p, 3 );

  /* rfc 822 format */
  sprintf( str, "%s, %.2d %s %02d %02d:%02d:%02d %.3s\n",
	   days[ltm->tm_wday],
	   ltm->tm_mday,
	   months[ltm->tm_mon],
	   ltm->tm_year,
	   ltm->tm_hour,
	   ltm->tm_min,
	   ltm->tm_sec,
	   tz );
  return ( str );
}

/* save copy in the record file */
recordmsg( dfile )
FILE	     *dfile;
{
  FILE	       *fp;
  time_t	t;
  int		d;
  char		ml[LINELEN];
  register char *p;
  register char *cp;

  fseek( dfile, 0L, 0 );
  if ( ( fp = fopen( record, "a" ) ) == NULLFILE )
  {
    printf( "Unable to append to %s\r\n", record );
  }
  else
  {
    ( void ) time( &t );
    fprintf( fp, "From %s@%s %s", username, hostname, ctime( &t ) );
    rewind( hfile );
    while ( ( d = getc( hfile ) ) != EOF )
      if ( putc( d, fp ) == EOF )
	break;
    while ( fgets( ml, sizeof( ml ), dfile ) != NULLCHAR )
    {
      p = ml;
      if ( strncmp( p, "From ", 5 ) == 0 )
	fputs( ">", fp );
      fputs( p, fp );
    }
    if ( ferror( fp ) )
    {
      ( void ) fclose( fp );
      return 1;
    }
    ( void ) fclose( fp );
  }
  return 0;
}

/* make tmpfile with header */
header( tolist )
struct addr  *tolist;
{
  FILE	       *tmpfile(  );
  register struct addr *tp;
  char		qstring[XXLINELEN];
  int		n;

  if ( ( hfile = tmpfile(  ) ) == NULLFILE )
    perror( "tmp file" );
  else
  {
    if ( !qflag )
      fputs( dateline, hfile );
    if ( !aflag )
    {
      fprintf( hfile, "From: %s@%s", username, hostname );
      fputs( fullnameline, hfile );
    }
    if ( !qflag )
    {
      fputs( replytoline, hfile );
      strcpy( qstring, "To: " );
      for ( tp = tolist; tp != NULLADDR; tp = tp->next )
      {
	strcat( qstring, tp->user );
	if ( tp->host != NULLCHAR || *tp->host != '\0' )
	{
	  strcat( qstring, "@" );
	  strcat( qstring, tp->host );
	}
	n = strlen( qstring );
	if ( tp->next )
	{
	  if ( n > 50 )
	  {
	    fprintf( hfile, "%s,\n    ", qstring );
	    *qstring = '\0';
	  }
	  else
	    strcat( qstring, ", " );
	}
      }
      fprintf( hfile, "%s\n", qstring );
      fputs( smtp_subjectline, hfile );
      fputs( inreplytoline, hfile );
      fputs( organline, hfile );
      fputs( "\n", hfile );
    }
  }
}

/* place a mail job in the outbound queue */
int
queuejob( dfile, tolist, bounce )
FILE	     *dfile;
struct addr  *tolist;
int	      bounce;
{
  FILE	       *fp;
  char		tmpstring[XLINELEN];
  char		rm[LINELEN];
  char	       *q;
  register struct addr *tp, *sp;
  char		prefix[9];
  int		c, d;
  long		id;
  int		xmsgs;

  if ( !bounce )
    xmsgs = 0;
  else
    xmsgs = 1;
  for ( tp = tolist; tp != NULLADDR; tp = tp->next )
  {
    if ( tp->sent )
      continue;
    fseek( dfile, 0L, 0 );
    if ( !xmsgs )
      sprintf( prefix, "%ld", sequence );
    else
    {
      if ( ( id = get_msgid(  ) ) == -1 )
      {
	fprintf( stderr, nosend );
	return 1;
      }
      sprintf( prefix, "%ld", id );
    }
    ( void ) mlock( mqueue, prefix );
    sprintf( tmpstring, "%s/%s.txt", mqueue, prefix );
    cleanup_fname( tmpstring );
    if ( ( fp = fopen( tmpstring, "w" ) ) == NULLFILE )
    {
      fprintf( stderr, "Unable to open %s\n", tmpstring );
      ( void ) rmlock( mqueue, prefix );
      return 1;
    }
    if ( !bounce )
    {
      rewind( hfile );
      while ( ( d = getc( hfile ) ) != EOF )
	if ( putc( d, fp ) == EOF )
	  break;
    }
    while ( ( fgets( tmpstring, XLINELEN, dfile ) ) != NULLCHAR )
    {
      if ( send_pgp( tmpstring, dfile, fp, tp->user ) )
	break;
    }
    if ( ferror( fp ) )
    {
      ( void ) fclose( fp );
      ( void ) rmlock( mqueue, prefix );
      return 1;
    }
    ( void ) fclose( fp );
    sprintf( tmpstring, "%s/%s.wrk", mqueue, prefix );
    cleanup_fname( tmpstring );
    if ( ( fp = fopen( tmpstring, "w" ) ) == NULLFILE )
    {
      ( void ) rmlock( mqueue, prefix );
      return 1;
    }
    q = "n" ;
    if ( tty && !novia && via && vflag )
    {
      printf( "Send through via: %s (y/N) ? ", via );
      gets( rm );
      q = rm;
      while ( *q == ' ' || *q == '\t' )
	q++;
    }
    if ( !tty && !novia && vflag || *q == 'y' || *q == 'Y' )
      fprintf( fp, "%s\n", via );
    else
      fprintf( fp, "%s\n", tp->host );
    if ( !aflag )
      fprintf( fp, "%s@%s\n", username, hostname );
    else
      fprintf( fp, "\n" );
    fprintf( fp, "%s@%s\n", tp->user, tp->host );
    tp->sent++;
    /* find any other addresses to the same host */
    for ( sp = tp->next; sp != NULLADDR; sp = sp->next )
    {
      if ( sp->sent )
	continue;
      if ( strcmp( tp->host, sp->host ) == 0 )
      {
	fprintf( fp, "%s@%s\n", sp->user, sp->host );
	sp->sent++;
      }
    }
    ( void ) fclose( fp );
    ( void ) rmlock( mqueue, prefix );
    xmsgs = 1;
  }

  return 0;
}

#define SKIPWORD(X) while(*X && *X!=' ' && *X!='\t' && *X!='\n' && *X!=',') X++;
#define SKIPSPACE(X) while(*X ==' ' || *X =='\t' || *X =='\n' || *X ==',') X++;

/* check for an alias and expand alias into a address list */
struct addr  *
expandalias( head, user )
struct addr **head;
char	     *user;
{
  FILE	       *fp;
  register char *s, *p, *h;
  int		inalias;
  struct addr  *tp;
  char		buf[LINELEN];

  fp = fopen( aliases, "r" );

  /* no alias file found */
  if ( fp == NULLFILE )
    return addrecip( head, user, hostname );

  inalias = 0;
  while ( fgets( buf, LINELEN, fp ) != NULLCHAR )
  {
    p = buf;
    if ( *p == '#' || *p == '\0' || *p == '\n' )
      continue;
    rip( p );

    /* if not in an matching entry skip continuation lines */
    if ( !inalias && isspace( *p ) )
      continue;

    /* when processing an active alias check for a continuation */
    if ( inalias )
    {
      if ( !isspace( *p ) )
	break;			/* done */
    }
    else
    {
      s = p;
      SKIPWORD( p );
      *p++ = '\0';              /* end the alias name */
      if ( strcmp( s, user ) != 0 )
	continue;		/* no match go on */
    }

    /* process the recipients on the alias line */
    SKIPSPACE( p );
    while ( *p != '\0' && *p != '#' )
    {
      inalias = 1;
      s = p;
      SKIPWORD( p );
      if ( *p != '\0' )
	*p++ = '\0';
      /* find hostname */
      if ( ( h = strchr( s, '@' ) ) != NULLCHAR )
	*h++ = '\0';
      else
	h = hostname;
      tp = addrecip( head, s, h );
      SKIPSPACE( p );
    }
  }
  ( void ) fclose( fp );

  if ( inalias )		/* found and processed and alias. */
    return tp;

  /* no alias found treat as a local address */
  return addrecip( head, user, hostname );
}

/* convert arg list to a list of address structures */
struct addr  *
make_tolist( argc, argv )
int	      argc;
char	     *argv[];
{
  struct addr  *tolist, *tp;
  char	       *user, *host;
  int		i;

  tolist = NULLADDR;
  for ( i = 0; i < argc; i++ )
  {
    user = argv[i];
    if ( in_alias( 1, NULLCHAR, user ) || stricmp( user, username ) == 0 )
      tp = expandalias( &tolist, user );
    else
    {
      if ( ( host = strchr( user, '@' ) ) != NULLCHAR )
      {
	*host++ = '\0';
	/* if it matches our host name */
	if ( stricmp( host, hostname ) == 0 )
	  host = NULLCHAR;
      }
      else if ( gate != NULLCHAR && *gate != '\0' )
	host = gate;

      if ( host == NULLCHAR )	/* a local address */
	tp = expandalias( &tolist, user );
      else			/* a remote address */
	tp = addrecip( &tolist, user, host );
    }

    if ( tp == NULLADDR )
    {
      fprintf( stderr, "Out of memory\n" );
      del_addrlist( tolist );
      return NULLADDR;
    }
  }
  return tolist;
}

/* delete a list of mail addresses */
del_addrlist( list )
struct addr  *list;
{
  struct addr  *tp, *tp1;;
  for ( tp = list; tp != NULLADDR; tp = tp1 )
  {
    tp1 = tp->next;
    if ( tp->user != NULLCHAR );
    free( tp->user );
    if ( tp->host != NULLCHAR );
    free( tp->host );
    ( void ) free( ( char * ) tp );
  }
}

/* add an address to the from of the list pointed to by head
** return NULLADDR if out of memory.
*/
struct addr  *
addrecip( head, user, host )
struct addr **head;
char	     *user, *host;
{
  register struct addr *tp;

  tp = ( struct addr * ) calloc( 1, sizeof( struct addr ) );
  if ( tp == NULLADDR )
    return NULLADDR;

  tp->next = NULLADDR;

  /* allocate storage for the user's login */
  if ( ( tp->user = malloc( ( unsigned ) strlen( user ) + 1 ) ) == NULLCHAR )
  {
    ( void ) free( ( char * ) tp );
    return NULLADDR;
  }
  strcpy( tp->user, user );

  /* allocate storage for the host name */
  if ( host != NULLCHAR )
    if ( ( tp->host = malloc( ( unsigned ) strlen( host ) + 1 ) ) == NULLCHAR )
    {
      ( void ) free( tp->user );
      ( void ) free( ( char * ) tp );
      return NULLADDR;
    }
  strcpy( tp->host, host );

  /* add entry to front of existing list */
  if ( *head == NULLADDR )
    *head = tp;
  else
  {
    tp->next = *head;
    *head = tp;
  }
  return tp;

}
