/* tiffsubs.c
 *
 */

#include "aldtypes.h"
#include "imtypes.h"
#include "imag.h"
#include "imtiff.h"
#include "tiff.h"
#include "ImErr.h"

#if 0
#define IMPDEFS
#include "errdefs.h"
#endif /* 0 */

/* get the sizeof a TIFF data type
 */
RC GtTiffSizeof (n, p)
WORD n;		/* TIFFBYTE or ... */
WORD *p;	/* output */
{
	RC err = SUCCESS;

	switch (n) {
	case TIFFBYTE:
	case TIFFASCII:
		*p = 1;
		break;
	case TIFFSHORT:
		*p = 2;
		break;
	case TIFFLONG:
		*p = 4;
		break;
	case TIFFRATIONAL:
		*p = 8;
		break;
	case TIFFSIGNED:
		*p = 2;
		break;
	case TIFFFLOAT:		/* manufactured type -- not found in TIFF file */
		*p = sizeof(float);
		break;
	default:
		DBMSG(("GtTiffSizeof: n=%d\n", n));
		*p = 1;
		err = IM_BUG;
		break;
	}
	return err;
}
