        PAGE 60,132
        TITLE TESSPARK.ASM -- TesSeRact Demo program to park disk drive heads
;----------------------------------------------------------------------------
SUBTTL  TesSeRact Revision Level 1
;-----------------------------------------------------------------------------
;   TesSeRact(tm) -- A Library of Routines for Creating Ram-Resident (TSR)
;                    programs for the IBM PC and compatible Personal
;                    Computers.
;
;The software, documentation and source code are: 
; 
;       Copyright (C) 1986, 1987, 1988 Tesseract Development Team
;       All Rights Reserved 
; 
;       c/o Chip Rabinowitz
;       Innovative Data Concepts
;       2084 Woodlawn Avenue
;       Glenside, PA 19038
;       1-215-884-3373
;
;-----------------------------------------------------------------------------
;   This product supports the TesSeRact Standard for Ram-Resident Program 
;   Communication.  For information about TesSeRact, contact the TesSeRact 
;   Development Team at:
;       Compuserve:    70731,20
;       MCIMAIL:       315-5415
;   This MCIMAIL Account has been provided to the TesSeRact Development
;   Team by Borland International, Inc.  The TesSeRact Development Team
;   is in no way associated with Borland International, Inc.
;-----------------------------------------------------------------------------
;
; BASED on code originally provided by Jim Mischel
;
; ORIGINAL COPYRIGHT NOTICE:
;
;;;; AUTOPARK.ASM - program to automatically park the disk drive heads
;;;; at specified time intervals.
;;;;
;;;; Copyright (c) 1988, Jim Mischel
;;;;
;;;;
;;;; This program has been assembled using MASM 5.0.  Changes may be required for
;;;; use with earlier versions.
;;;;
;;;; To build:
;;;;    MASM AUTOPARK ;
;;;;    LINK AUTOPARK ;
;;;;    EXE2BIN AUTOPARK AUTOPARK.COM

;
; To assemble this TesSeRact version:
;
;       MASM TESSPARK;
;       LINK TESS_ASM+TESS_BP+TESSPARK+TESS_END,TESSPARK;
;       EXE2BIN TESSPARK.EXE TESSPARK.COM
;

.model small

.code

; wait_count is # of timer ticks to wait between the last disk access
; and parking the disk.  Each tick is approximately 1/18.2 seconds.
; 
; Maximum wait count is 65536 ticks (0), which is darn close to 1 hour.
;
wait_count      equ     1092            ;1 minute
;wait_count     equ     192             ;10 seconds (for testing)


speaker_beep    equ     1               ;sound TESSBEEP if set

tick_count      dw      ?

;
; This routine attempts to park the disk.
; Returns with carry set if park was unsuccessful.
;
; I'm not real clear on all the details here.  I disassembled this from a
; park program I've been using.  It will park the heads on all hard disks.
; It's using some undocumented (or not very well documented) features of the
; AT BIOS.  From looking at the code, I'd say it doesn't work on XT's, but
; when run, it seems to work fine.
;
parkit  proc    near
        mov     si,0080h
pk0:    mov     ah,08h
        mov     dx,si                   ;DX is drive ID
        int     13h                     ;get drive parameters
        add     dl,30h
        xor     dh,dh                   ;This is going to tell
        add     dx,4fh                  ;us whether we've got an AT
        mov     di,dx                   ;save drive count
        cmp     di,0080h
        jb      pkdone                  ;< 0080 means it's an XT
        inc     ch                      ;CH is tracks + 1
        jnb     pk1
        add     cl,40h                  ;CL is sectors
pk1:    mov     ax,0c01h                ;seek to cylinder
        mov     dx,si                   ;DX is drive ID
        int     13h                     ;this does the seek
        inc     si                      ;bump drive count
        cmp     si,di
        jbe     pk0                     ;loop until all drives are parked
pkdone:
if speaker_beep
EXTRN TESSBEEP:NEAR

        call    TESSBEEP
endif
        ret
parkit  endp

;
; TesSeRact Entry Points
;
;
PUBLIC  TSRUSERPROC, TSRTIMERPROC, TSRBACKCHECK, TSRMAIN, TSRBACKPROC
PUBLIC  TSRCLEANUP

;
; These are NULL procedures.  We don't service them in this program
;
;
TSRUSERPROC:
TSRMAIN:
        ret

MyParms dw      0                       ;saved location of INT 13 flag 
                                        ;  from TesSeRact data area

do_park db      0                       ;flag set when we want to park

TSRBACKCHECK proc near
        assume cs:_TEXT, ds:_TEXT

        mov     al,do_park              ;do we want to park the disk?
        xor     ah,ah                   ;if non-zero, yes!
        ret
TSRBACKCHECK endp

TSRBACKPROC proc near
        assume cs:_TEXT, ds:_TEXT

        call    near ptr parkit         ;attempt to park it
        mov     do_park,0
        mov     bx,[MyParms]
        mov     word ptr [tick_count],wait_count        ;restart wait
        mov     byte ptr [bx],0

        ret
TSRBACKPROC endp

TSRCLEANUP proc near
        assume cs:_TEXT, ds:_TEXT

        or      ax,ax
        jnz     clean_term

clean_init:
;
;  Please note that the data area returned by this function is also available
;    as the TESS_GLOBALS public symbol.
;
        mov     cx,ParkNum
        mov     bx,4h                   ;in data area
        mov     ax,5453h
        int     2fh

        add     bx,3h                   ;add in offset we want (Was13)

        mov     MyParms,bx              ;since we know segment is our's
                                        ;we don't need to worry about it!

clean_term:                             ;nothing needed to terminate!
clean_out:
        ret

TSRCLEANUP endp


TSRTIMERPROC proc near
        assume cs:_TEXT, ds:_TEXT

        mov     bx,[MyParms]
        cmp     byte ptr [bx],1
        jne     no_park
no_disk:
        mov     [do_park],0
        dec     word ptr [tick_count]
        jnz     no_park

        mov     [do_park],1
clear_it:
        mov     word ptr [tick_count],wait_count        ;restart wait
        mov     byte ptr [bx],0                         ;clear flag
no_park:
        ret

TSRTIMERPROC endp

;
; If AUTOPARK already installed, display error message and exit.
; If not installed, attempt to park the disks and install the resident
; portion.
;
EXTRN TSDOINIT:NEAR
EXTRN TSCHECKRESIDENT:near
EXTRN TSSETSTACK:near

ParkNum         dw 0                    ;our ID number
ParkName        db 'TESSPARK',0         ;our Identification string

public mystack
public topstack

mystack         db 512 dup(0)           ;stack to use

topstack        equ this byte

PUBLIC TESSINITSTART                    ;required entry point

TESSINITSTART:
        assume cs:_TEXT, ds:_TEXT

        mov     dx,offset signon
        mov     ah,09
        int     21h                     ;display the signon message

        mov     si,offset ParkName
        mov     di,offset ParkNum
        call    TSCHECKRESIDENT

        or      ax,ax
        jz      do_install

        mov     dx,offset already_installed     ;we must already be installed
        mov     ah,09
        int     21h                     ;display message
term_it:
        mov     ax,4c01h
        int     21h                     ;and exit with error code

do_install:
        mov     di,offset topstack
        dec     di
        dec     di
        mov     si,di
        call    TSSETSTACK

        call    near ptr parkit         ;attempt to park disk
        jmp     short inst1

inst1:
        mov     word ptr cs:[tick_count],wait_count     ;start wait
;
; display installed message and exit
;
        mov     dx,offset installed
        mov     ah,09
        int     21h

        mov     dx,offset TESSINITSTART
        mov     bx,1060h                ;no pop graphics, timer proc and
                                        ;    background procs only
        xor     ax,ax                   ;no hotkey!
        dec     ax                      ;no hotkey is -1

        call    TSDOINIT
        jmp     term_it                 ;we should never do this!

signon  db      13,10,'TESSPARK.COM Version 1.0, Copyright (c) '
        db      '1988, TesSeRact(tm) Development Team',13,10
        db      'All Rights Reserved',13,10,10
        db      'Based on Original Code provided by Jim Mischel:',13,10
        db      '   AUTOPARK 1.0  Copyright (c) 1988, Jim Mischel',13,10,'$'
installed       label   byte
        db      'TESSPARK installed',13,10,'$'
already_installed       label   byte
        db      'TESSPARK already installed',7,13,10,'$'

_TEXT ends

        END
