# include <dos.h>
# include <string.h>
# include <stdio.h>
# include <bios.h>
# include <stdlib.h>
# include <conio.h>
# include <mem.h>
# include <dir.h>
# include <stdarg.h>

# include "simpwin.h"
# include "swskdef.h"
# include "mouse23.h"
# include "fontedit.h"
# include "vgacolor.h"

# define MAIN_MENU_WIN         1
# define MAIN_MENU_MENU        0
# define DEMO_MENU_MENU        1
# define DEMO_MENU_WIN         2
# define TUT_MENU_WIN          3
# define TUT_MENU_MENU         2
# define SIMPLE_DEMO_WIN       4
# define SIMPLE_DEMO_MENU      3
# define FONT_DEMO_WIN         5
# define FONT_DEMO_MENU        4
# define VGA_DEMO_WIN          6
# define VGA_DEMO_MENU         5
# define FUNCTION_MENU_WIN     7
# define FUNCTION_MENU_MENU    6
# define EXEC_MENU_WIN         8
# define EXEC_MENU_MENU        7
# define SIMPLE_LIBS_WIN       9
# define SIMPLE_LIBS_MENU      8
# define FONT_LIBS_WIN        10
# define FONT_LIBS_MENU        9
# define VGA_LIBS_WIN         11
# define VGA_LIBS_MENU        10
# define MOUSE_LIBS_WIN       12
# define MOUSE_LIBS_MENU      11
# define FONT_EXEC_WIN        13
# define FONT_EXEC_MENU       12
# define VGA_EXEC_WIN         14
# define VGA_EXEC_MENU        13
# define QUIT_WIN             16
# define TEXT_WIN             9
# define TEXT_DEMO_WIN        15
# define ENTER_WIN            17
# define ERROR_WIN            18
# define DATA_OK_WIN          19
# define PRINT_WIN            20


int mou_switch = 0;
int display_switch = 1;
char disk[5] = "C";
unsigned char palette[16];
int video_adapter = 0;
char *edit_buff;
char *t_buff;
int buttons;

int main_menu(void);
int quit(void);
int demo_menu(void);
int tutor_menu(void);
int register_print(void);
int function_menu(void);
int simp_libs_menu(void);
int font_libs_menu(void);
int vga_libs_menu(void);
int mouse_libs_menu(void);
int execute_menu(void);
int font_exec_menu(void);
int vga_exec_menu(void);
int text_screen(int file_num);
int file_text(char *file_name,int file_num);
int file_screen(char *file_name);
int simp_demo_menu(void);
int demo_popup(void);
int shad_demo(void);
int boarder_demo(void);
int enter_demo(void);
int data_ok(void);
int scr_form(void);
int song_demo(void);
int font_demo_menu(void);
void dual_font_demo(void);
void large_font_demo(void);
void multi_font_demo(void);
int vga_demo_menu(void);
int color_demo(void);
int gray_demo(void);
int palette_64(void);
int mouse_demo(void);
void load_default_palette(int toggle);
void view_tut(int file_num,char *lable);


void main(void)
{
	int i,j,k;

	if(init_window(25,40,10,disk,1) != 0)
	{
		cprintf("Can't init swin libs!");
		exit(1);
	}
	if(mouinit() != 0)
	{
		cprintf("Can't init mouse23 libs!");
		uninit_window();
		exit(1);
	}
	load_default_palette(2);
	if((video_adapter = vga_get_adapter()) == 0)
	{
		cprintf("This program requiers a VGA/EGA vidoe card");
		uninit_window();
		mouuninit();
		exit(1);
	}
	if(video_adapter == 9)
	{
		if(init_vgaedit() != 0)
		{
			cprintf("Can't init vgacolr libs!");
			uninit_window();
			mouuninit();
			exit(1);
		}
	}
	if(init_multi_font("ibmstd.fnt","script.fnt",palette,0) != 0)
	{
		cprintf("Can't init fonted libs!");
		if(video_adapter == 9)
		{
			uninit_vgaedit();
		}
		uninit_window();
		mouuninit();
		exit(1);
	}
	if((edit_buff = (char *)malloc(22 * 80)) == NULL)
	{
		cprintf("Not enough memory!");
		uninit_multi_font();
		if(video_adapter == 9)
		{
			uninit_vgaedit();
		}
		uninit_window();
		mouuninit();
		exit(1);
	}
	else
	{
		if((t_buff = (char *)malloc(4000)) == NULL)
		{
			cprintf("Not enough memory!");
			uninit_multi_font();
			if(video_adapter == 9)
			{
				uninit_vgaedit();
			}
			uninit_window();
			mouuninit();
			free(edit_buff);
			exit(1);
		}
	}
	memset(edit_buff,0,(22 * 80));
	if(load_menu_text("fultut.men") != 0)
	{
		cprintf("Can't find file FULTUT.MEN !");
		uninit_multi_font();
		if(video_adapter == 9)
		{
			uninit_vgaedit();
		}
		uninit_window();
		mouuninit();
		free(edit_buff);
		free(t_buff);
		exit(1);
	}
	if(load_win_data("fultut.win") != 0)
	{
		cprintf("Can't find file FULTUT.WIN !");
		uninit_multi_font();
		if(video_adapter == 9)
		{
			uninit_vgaedit();
		}
		uninit_window();
		mouuninit();
		free(edit_buff);
		free(t_buff);
		exit(1);
	}
	system("cls");
	if((buttons = mouinstalled()) != 0)
	{
		simp_window(30,10,50,12,1,0,2,4,0,0,0,0,0);
		if(loadcurs("moucurs.fnt") == 0)
		{
			moucursortype(0x01);
			mouhide();
			mousetposition(1,1);
			mou_switch = 1;
			write_window(3,2,"Mouse Installed !");
		}
		else
		{
			mou_switch = 0;
			write_window(3,2,"No cursor file !");
			mouhide();
		}
		delay(1000);
	}
	else
	{
		simp_window(23,10,57,12,1,0,2,4,0,0,0,0,0);
		write_window(3,2,"NO mouse driver installed");
		mou_switch = 0;
		mouhide();
		delay(1000);
	}
	hide_cursor();
	k= 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			simp_window(40 - j,13 - i,40 + j,13 + i,1,0,6,1,0,0,0,0,0);
		}
		k = k + 3;
	}
	simp_window(1,1,80,25,1,0,6,1,0,0,0,0,0);
	k = 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			window(40 - j,13 - i,40 + j,13 + i);
			load_screen_form(1,"fultut.scr");
		}
		k = k + 3;
	}
	window(1,1,80,25);
	load_screen_form(1,"fultut.scr");
	write_window(35,25," HIT ANY KEY ");
	bioskey(0);
	draw_horizontal_line(196,196,196,2,79,25);
	save_screen(1);
	/*mou_switch = 0;*/
	while(main_menu())
	{
	}
	uninit_multi_font();
	if(video_adapter == 9)
	{
		uninit_vgaedit();
	}
	uninit_window();
	mouuninit();
	free(edit_buff);
	free(t_buff);
	show_cursor();
	system("cls");
}

int main_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[3][13] = {"Demo","Tutor","eXit"};


	if(display_switch)
	{
		load_screen(1);
		call_window(MAIN_MENU_WIN);
		call_menu(MAIN_MENU_MENU,3,2);
		save_screen(2);
	}
	else
	{
		load_screen(2);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"D");
	write_window(22,2,"T");
	write_window(41,2,"X");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if(mousey == 4)
			{
				if((mousex > 5) & (mousex < 12))
				{
					i = 0;
				}
				else if((mousex > 24) & (mousex < 31))
				{
					i = 1;
				}
				else if((mousex > 42) & (mousex < 49))
				{
					i = 2;
				}
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 2)
		{
			i = 2;
		}
		if(old_i != i)
		{
			mouhide();
			old_i = i;
			load_screen_buff();
			switch(i)
			{
				case 0 : simp_window(6,4,11,4,0,2,4,3,1,5,0,0,0); break;
				case 1 : simp_window(25,4,31,4,0,2,4,3,1,5,0,0,0); break;
				case 2 : simp_window(43,4,48,4,0,2,4,3,1,5,0,0,0); break;
			}
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 4; break;
				case CURSOR_RIGHT : i = i + 1; break;
				case CURSOR_LEFT : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_D : choice = 2; break;
				case ALT_T : choice = 3; break;
				case ALT_X : choice = 4; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if(mousey == 4)
			{
				if(((mousex > 5) & (mousex < 12)) |
					((mousex > 24) & (mousex < 31)) |
					((mousex > 42) & (mousex < 49)))
				{
					choice = 1;
				}
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	pick = 1;
	switch(choice)
	{
		case 2 : while(demo_menu()){} break;
		case 3 : while(tutor_menu()){} break;
		case 4 : pick = quit(); break;
	}
	return(pick);
}

int quit(void)
{

	call_window(QUIT_WIN);
	write_window(3,2,"Quit Y/N ?");
	show_cursor();
	if(get_choice(14,2,"N") == 1)
	{
		uncall_window(QUIT_WIN);
		hide_cursor();
		return(0);
	}
	uncall_window(QUIT_WIN);
	hide_cursor();
	return(1);
}


int demo_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[4][13] = {"Simple demo","Font demo","VGA demo","Mouse demo"};

	if(display_switch)
	{
		load_screen(2);
		call_window(DEMO_MENU_WIN);
		call_menu(DEMO_MENU_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"S");
	write_window(3,3,"F");
	write_window(3,4,"V");
	write_window(3,5,"M");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 6) & (mousex < 20))
			{
				i = mousey - 5;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(7,5 + i,19,5 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_S : choice = 2; break;
				case ALT_F : choice = 3; break;
				case ALT_V : choice = 4; break;
				case ALT_M : choice = 5; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 6) & (mousex < 19) & (mousey > 4) & (mousey < 9))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : while(simp_demo_menu()){} break;
		case 3 : while(font_demo_menu()){} break;
		case 4 : while(vga_demo_menu()){} break;
		case 5 : mouse_demo(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}


int tutor_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[8][19] = {"General","Legal","Functions","Executes","Support","Quarks","Defines","Register"};

	if(display_switch)
	{
		load_screen(2);
		call_window(TUT_MENU_WIN);
		call_menu(TUT_MENU_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"G");
	write_window(3,3,"L");
	write_window(3,4,"F");
	write_window(3,5,"E");
	write_window(3,6,"S");
	write_window(3,7,"Q");
	write_window(3,8,"D");
	write_window(3,9,"R");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 20) & (mousex < 32))
			{
				i = mousey - 5;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 7)
		{
			i = 7;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(21,5 + i,31,5 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 10; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_G : choice = 2; break;
				case ALT_L : choice = 3; break;
				case ALT_F : choice = 4; break;
				case ALT_E : choice = 5; break;
				case ALT_S : choice = 6; break;
				case ALT_Q : choice = 7; break;
				case ALT_D : choice = 8; break;
				case ALT_R : choice = 9; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 20) & (mousex < 32) & (mousey > 4) & (mousey < 13))
			{
				choice = 1;
			}
			else
			{
				choice = 10;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : file_screen("general.txt"); break;
		case 3 : file_screen("disclaim.txt"); break;
		case 4 : while(function_menu()){} break;
		case 5 : while(execute_menu()){} break;
		case 6 : file_text("fultut.men",25); break;
		case 7 : file_text("fultut.men",30); break;
		case 8 : file_screen("defines.txt"); break;
		case 9 : register_print(); break;
		case 10 : pick = 0; break;
	}
	display_switch = pick;
	return(pick);
}

int register_print(void)
{
	char data_string[6][30] = {"","","","","",""};
	int data_quant[6] = {0,0,0,0,0,0};
	int done = 0,i = 0,pick;
	int j;
	float price[6] = {0,0,0,0,0,0};
	float total_price = 0;
	int total_quant = 0;
	float sub_total_price = 0;
	float total_s_h = 0L;

	call_window(TEXT_WIN);
	load_text(27,"fultut.men");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	clear_window(0);
	load_text(28,"fultut.men");
	while(done == 0)
	{
		show_cursor();
		switch(i)
		{
			case 0 : pick = edit_string(data_string[0],
					"****************************",13,2,"TAP");
				 break;
			case 1 : pick = edit_string(data_string[1],
					"****************************",13,4,"TAP");
				 break;
			case 2 : pick = edit_string(data_string[2],
					"****************************",13,5,"TAP");
				 break;
			case 3 : pick = edit_string(data_string[3],
					"****************************",13,6,"TAP");
				 break;
			case 4 : pick = edit_string(data_string[4],
					"############",13,9,"TAP");
				 break;
			case 5 : pick = edit_string(data_string[5],
					"****************",20,10,"TAP");
				 break;
		}
		switch(pick)
		{
			case ESC : done = 1; break;
			case CURSOR_UP : i = i - 1; break;
			case CURSOR_DN : i = i + 1; break;
			case 0 : i = i + 1; break;
		}
		if(i == 6)
		{
			if((done = data_ok()) == 0)
			{
				i = 0;
			}
		}
	}
	clear_window(0);
	load_text(29,"fultut.men");
	done = 0;
	i = 0;
	while(done == 0)
	{
		show_cursor();
		get_int(&data_quant[i],2,34,i + 5);
		switch(i)
		{
			case 5 : price[5] = data_quant[5] * 100.00; break;
			default : price[i] = data_quant[i] * 25.00; break;
		}
		i++;
		if(i == 6)
		{
			total_quant = 0;
			total_price = 0;
                        sub_total_price = 0;
			for(j = 0;j < 6;j++)
			{
				write_window(51,5 + j,"%8.2f",price[j]);
				sub_total_price = price[j] + sub_total_price;
				total_quant = data_quant[j] + total_quant;
				total_s_h = total_quant * 3.00;
				if(total_s_h > 50.00)
				{
					total_s_h = 50.00;
				}
				total_price = sub_total_price + total_s_h;
			}
			write_window(34,12,"%-3d",total_quant);
			write_window(51,12,"%8.2f",sub_total_price);
			write_window(51,13,"%8.2f",total_s_h);
			write_window(50,15,"%9.2f",total_price);
			if((done = data_ok()) == 0)
			{
				i = 0;
			}
		}
	}
	hide_cursor();
	load_form(1,"fultut.prn");
	print_printf(13,18,"%s",data_string[0]);
	print_printf(13,20,"%s",data_string[1]);
	print_printf(13,21,"%s",data_string[2]);
	print_printf(13,22,"%s",data_string[3]);
	print_printf(13,25,"%s",data_string[4]);
	print_printf(21,27,"%s",data_string[5]);
	for(i = 0;i < 6;i++)
	{
		print_printf(36,36 + i,"%2d",data_quant[i]);
		print_printf(53,36 + i,"%8.2f",price[i]);
	}
	print_printf(36,43,"%-4d",total_quant);
	print_printf(53,43,"%8.2f",sub_total_price);
	print_printf(53,44,"%8.2f",total_s_h);
	print_printf(52,46,"%9.2f",total_price);
	call_window(PRINT_WIN);
	if(print_char(0x0c) != 0)
	{
		clear_window(0);
		write_window(4,2,"Printer error !");
		bioskey(0);
		uncall_window(PRINT_WIN);
		uncall_window(TEXT_WIN);
		return(0);
	}
	write_window(4,2,"Align Paper Now !");
	write_window(5,3,"HIT ANY KEY");
	bioskey(0);
	clear_window(0);
	write_window(8,2,"PRINTING!");
	if(print_buff() != 0)
	{
		clear_window(0);
		write_window(4,2,"Printer error !");
		bioskey(0);
	}
	uncall_window(PRINT_WIN);
	uncall_window(TEXT_WIN);
	display_switch = 0;
	return(0);
}

int function_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[4][13] = {"Simple libs","Font libs","VGA libs","Mouse libs"};

	if(display_switch)
	{
		load_screen(3);
		call_window(FUNCTION_MENU_WIN);
		call_menu(FUNCTION_MENU_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"S");
	write_window(3,3,"F");
	write_window(3,4,"V");
	write_window(3,5,"M");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 21) & (mousex < 35))
			{
				i = mousey - 6;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(22,6 + i,34,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_S : choice = 2; break;
				case ALT_F : choice = 3; break;
				case ALT_V : choice = 4; break;
				case ALT_M : choice = 5; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 21) & (mousex < 35) & (mousey > 5) & (mousey < 10))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : simp_libs_menu(); break;
		case 3 : font_libs_menu(); break;
		case 4 : vga_libs_menu(); break;
		case 5 : mouse_libs_menu(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}

int simp_libs_menu(void)
{
	int pick,choice,i,j,old_i = 100,old_j = 4;
	int mousex = 0,mousey = 0;
		char lable[3][21][25] = {"simp_window\(\)","popup_window\(\)","make_window\(\)","call_window\(\)",
		"uncall_window\(\)","unpopup_window\(\)","load_win_data\(\)","","",
		"make_menu\(\)","load_menu_text\(\)","call_menu\(\)","load_text\(\)","","",
		"get_choice\(\)","get_int_date\(\)","edit_string\(\)","get_string\(\)",
		"get_int\(\)","get_long\(\)","print_printf\(\)","print_putch\(\)",
		"print_horizontal_line\(\)","print_vertical_line\(\)","print_window\(\)",
		"clear_print_buff\(\)","print_buff\(\)","load_form\(\)","print_char\(\)","","",
		"draw_horizontal_line\(\)","draw_vertical_line\(\)","clear_window\(\)",
		"move_window\(\)","show_cursor\(\)","hide_cursor\(\)","move_cursor\(\)",
		"load_screen_form\(\)","write_window\(\)","read_text\(\)","set_tempo\(\)",
		"tone\(\)","cord\(\)","playsong\(\)","","","read_file\(\)",
		"write_file\(\)","file_to_file\(\)","copy_file\(\)","creat_file\(\)","read_directory\(\)",
		"","","save_screen\(\)","load_screen\(\)","save_screen_buff\(\)",
		"load_screen_buff\(\)","","init_window\(\)","uninit_window\(\)"};

	if(display_switch)
	{
		call_window(SIMPLE_LIBS_WIN);
		call_menu(SIMPLE_LIBS_MENU,5,3);
		write_window((80 - strlen("FUNCTION MENU ")) / 2,1," FUNGTION MENU ");
		write_window((80 - strlen(" ESC to exit ")) / 2,25," ESC to exit ");
		save_screen(5);
	}
	else
	{
		load_screen(5);
	}
	save_screen_buff();
	i = 0;
	j = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 3) & (mousex < 25))
			{
				i = mousey - 4;
				if((mousey > 2) & (mousey < 23))
				{
					j = 0;
				}
			}
			else if((mousex > 27) & (mousex < 56))
			{
				i = mousey - 4;
				if((mousey > 3) & (mousey < 23))
				{
					j = 1;
				}
			}
			else if((mousex > 58) & (mousex < 80))
			{
				i = mousey - 4;
				if((mousey > 3) & (mousey < 25))
				{
					j = 2;
				}
			}

		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 100; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_RIGHT : j = j + 1; break;
				case CURSOR_LEFT : j = j - 1; break;
			}
		}
		switch(j)
		{
			case 0 : switch(i)
				 {
					case 7 : i = 9; break;
					case 8 : i = 6; break;
					case 13 : i = 15; break;
					case 14 : i = 12; break;
				 }
				 if(i < 0)
				 {
					i = 0;
				 }
				 if(i > 20)
				 {
					i = 0;
					j = 1;
				 }
				 break;
			case 1 : switch(i)
				 {
					case 9 : i = 11; break;
					case 10 : i = 8; break;
				 }
				 if(i < 0)
				 {
					i = 20;
					j = 0;
				 }
				 else if(i > 20)
				 {
					i = 0;
					j = 2;
				 }
				 break;
			case 2 : switch(i)
				 {
					case 4 : i = 6; break;
					case 5 : i = 3; break;
					case 12 : i = 14; break;
					case 13 : i = 11; break;
				 }
				 if((old_i < i) & (i == 18))
				 {
					i = 19;
				 }
				 if((old_i > i) & (i == 18))
				 {
					i = 17;
				 }
				 if(i < 0)
				 {
					i = 20;
					j = 1;
				 }
				 else if(i > 20)
				 {
					i = 20;
				 }
				 break;
		}
		if(j < 0)
		{
			j = 0;
		}
		if(j > 2)
		{
			j = 2;
		}
		if((old_i != i) | (old_j != j))
		{
			mouhide();
			old_i = i;
			old_j = j;
			load_screen_buff();
			switch(j)
			{
				case 0 : simp_window(4,4 + i,4 + strlen(lable[j][i]) + 1,4 + i,0,2,4,3,1,5,0,0,0); break;
				case 1 : simp_window(28,4 + i,28 + strlen(lable[j][i]) + 1,4 + i,0,2,4,3,1,5,0,0,0); break;
				case 2 : simp_window(59,4 + i,59 + strlen(lable[j][i]) + 1,4 + i,0,2,4,3,1,5,0,0,0); break;
			}
			write_window(2,1,"%s",lable[j][i]);
			moushow();
		}
		if(moubuttonrelease(LEFTBUTTON))
		{
			if(((mousex > 3) & (mousex < strlen(lable[0][i]) + 5)) |
				((mousex > 27) & (mousex < strlen(lable[1][i]) + 31)) |
				((mousex > 58) & (mousex < strlen(lable[2][i]) + 62)))
			{
				choice = 1;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		switch(j)
		{
			case 0 : switch(i)
				 {
					case 0 : choice = 0; break;
					case 1 : choice = 1; break;
					case 2 : choice = 2; break;
					case 3 : choice = 3; break;
					case 4 : choice = 4; break;
					case 5 : choice = 5; break;
					case 6 : choice = 6; break;
					case 9 : choice = 7; break;
					case 10 : choice = 8; break;
					case 11 : choice = 9; break;
					case 12 : choice = 10; break;
					case 15 : choice = 11; break;
					case 16 : choice = 12; break;
					case 17 : choice = 13; break;
					case 18 : choice = 15; break;
					case 19 : choice = 16; break;
					case 20 : choice = 17; break;
				 }
				 break;
			case 1 : switch(i)
				 {
					case 0 : choice = 18; break;
					case 1 : choice = 19; break;
					case 2 : choice = 20; break;
					case 3 : choice = 21; break;
					case 4 : choice = 22; break;
					case 5 : choice = 23; break;
					case 6 : choice = 24; break;
					case 7 : choice = 25; break;
					case 8 : choice = 52; break;
					case 11 : choice = 26; break;
					case 12 : choice = 27; break;
					case 13 : choice = 28; break;
					case 14 : choice = 29; break;
					case 15 : choice = 30; break;
					case 16 : choice = 31; break;
					case 17 : choice = 32; break;
					case 18 : choice = 33; break;
					case 19 : choice = 34; break;
					case 20 : choice = 35; break;
				 }
				 break;
			case 2 : switch(i)
				 {
					case 0 : choice = 36; break;
					case 1 : choice = 37; break;
					case 2 : choice = 38; break;
					case 3 : choice = 39; break;
					case 6 : choice = 40; break;
					case 7 : choice = 41; break;
					case 8 : choice = 42; break;
					case 9 : choice = 43; break;
					case 10 : choice = 44; break;
					case 11 : choice = 45; break;
					case 14 : choice = 46; break;
					case 15 : choice = 47; break;
					case 16 : choice = 48; break;
					case 17 : choice = 49; break;
					case 19 : choice = 50; break;
					case 20 : choice = 51; break;
				 }
		}
		view_tut(choice,lable[j][i]);
		switch(choice)
		{
			case 13 : view_tut(14,lable[j][i]); break;
		}
	}
	pick = 1;
	if(choice == 100)
	{
		pick = 0;
	}
	display_switch = 0;
	return(pick);
}


int font_libs_menu(void)
{
	int pick,choice,i = 0,old_i = 12,mousex = 0,mousey = 0;
	char lable[15][29] = {"load_font\(\)","enable_dual_font\(\)","write_win_bank\(\)",
				"write_win_multi\(\)","load_emulate\(\)","write_win_large\(\)",
				"write_win_multi_large\(\)","set_palette\(\)","font_get_adapter\(\)",
				"toggle_blink\(\)","toggle_intensity\(\)","enable_reset\(\)",
				"init_multi_font\(\)","uninit_multi_font\(\)","load_multi_pal\(\)"};

	if(display_switch)
	{
		load_screen(4);
		call_window(FONT_LIBS_WIN);
		call_menu(FONT_LIBS_MENU,3,2);
		save_screen(5);
	}
	else
	{
		load_screen(5);
	}
	display_switch = 1;
	save_screen_buff();
	moushow();
	i = 0;
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 48))
			{
				i = mousey - 7;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 14)
		{
			i = 14;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,7 + i,47,7 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 12; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 48) & (mousey > 6) & (mousey < 22))
			{
				choice = 1;
			}
			else
			{
				choice = 12;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		file_text("fulfunc2.men",i);
	}
	else
	{
		if(choice == 12)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}


int vga_libs_menu(void)
{
	int pick,choice,i = 0,old_i = 12,mousex = 0,mousey = 0;
	char lable[14][29] = {"save_color_regs\(\)","load_color_regs\(\)","read_color_reg\(\)",
				"write_color_reg\(\)","save_palette\(\)","load_palette\(\)",
				"write_palette\(\)","read_palette\(\)","vag_get_adapter\(\)",
				"gray_color_reg\(\)","gray_color_regs\(\)","enable_reset\(\)",
				"init_vgaedit\(\)","uninit_vgaedit\(\)"};

	if(display_switch)
	{
		load_screen(4);
		call_window(VGA_LIBS_WIN);
		call_menu(VGA_LIBS_MENU,3,2);
		save_screen(5);
	}
	else
	{
		load_screen(5);
	}
	display_switch = 1;
	save_screen_buff();
	moushow();
	i = 0;
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 43))
			{
				i = mousey - 7;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 13)
		{
			i = 13;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,7 + i,42,7 + i,0,2,4,3,1,8,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 12; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 43) & (mousey > 6) & (mousey < 21))
			{
				choice = 1;
			}
			else
			{
				choice = 12;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		file_text("fulfunc2.men",i + 15);
	}
	else
	{
		if(choice == 12)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}

int mouse_libs_menu(void)
{
	int pick,choice,i = 0,old_i = 12,mousex = 0,mousey = 0;
	char lable[15][29] = {"mouinstalled\(\)","moureset\(\)","moubuttonpressed\(\)",
				"moushow\(\)","mouhide\(\)","moucursortype\(\)",
				"mousetposition\(\)","mousetmaxposition\(\)",
				"moubuttonrelease\(\)","loadcurs\(\)","mou_get_adapter\(\)",
				"mouinit\(\)","mouuninit\(\)","mouposition\(\)",
				"moupositionpix\(\)"};

	if(display_switch)
	{
		load_screen(4);
		call_window(MOUSE_LIBS_WIN);
		call_menu(MOUSE_LIBS_MENU,3,2);
		save_screen(5);
	}
	else
	{
		load_screen(5);
	}
	display_switch = 1;
	save_screen_buff();
	moushow();
	i = 0;
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 44))
			{
				i = mousey - 7;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 12; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 14)
		{
			i = 14;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,7 + i,43,7 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 44) & (mousey > 6) & (mousey < 22))
			{
				choice = 1;
			}
			else
			{
				choice = 12;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		file_text("fulfunc2.men",i + 29);
	}
	else
	{
		if(choice == 12)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}

int execute_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[2][13] = {"Font exec","VGA exec"};

	if(display_switch)
	{
		load_screen(3);
		call_window(EXEC_MENU_WIN);
		call_menu(EXEC_MENU_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"F");
	write_window(3,3,"V");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 21) & (mousex < 33))
			{
				i = mousey - 6;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 1)
		{
			i = 1;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(22,6 + i,32,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_F : choice = 2; break;
				case ALT_V : choice = 3; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 21) & (mousex < 33) & (mousey > 5) & (mousey < 8))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : font_exec_menu(); break;
		case 3 : vga_exec_menu(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}


int font_exec_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[5][29] = {"loadfont.exe","dualon.exe","setpal.exe","makefont.exe","resetpal.exe"};

	if(display_switch)
	{
		load_screen(4);
		call_window(FONT_EXEC_WIN);
		call_menu(FONT_EXEC_MENU,3,2);
		save_screen(5);
	}
	else
	{
		load_screen(5);
	}
	display_switch = 1;
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 37))
			{
				i = mousey - 7;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 4)
		{
			i = 4;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,7 + i,36,7 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 37) & (mousey > 6) & (mousey < 12))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		file_text("fulfunc2.men",i + 44);
	}
	else
	{
		if(choice == 9)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}


int vga_exec_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[5][29] = {"savedac.exe","loaddac.exe","savepal.exe","loadpal.exe",
			     "resetpal.exe"};

	if(display_switch)
	{
		load_screen(4);
		call_window(VGA_EXEC_WIN);
		call_menu(VGA_EXEC_MENU,3,2);
		save_screen(5);
	}
	else
	{
		load_screen(5);
	}
	display_switch = 1;
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 37))
			{
				i = mousey - 7;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 4)
		{
			i = 4;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,7 + i,36,7 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 37) & (mousey > 6) & (mousey < 12))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		file_text("fulfunc2.men",i + 49);
	}
	else
	{
		if(choice == 9)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}


int text_screen(int file_num)
{
	call_window(TEXT_DEMO_WIN);
	load_text(file_num,"fultut.men");
	write_window((61 - strlen(" HIT ANY KEY ")) / 2,18," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TEXT_DEMO_WIN);
	return(0);
}

int file_text(char *file_name,int file_num)
{
	call_window(TEXT_WIN);
	load_text(file_num,file_name);
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TEXT_WIN);
	return(0);
}

int file_screen(char *file_name)
{
	call_window(TEXT_WIN);
	write_window((80 - strlen(" PgUp/PgDn ESC ")) / 2,25," PgUp/PgDn ESC ");
	read_text(file_name,1);
	uncall_window(TEXT_WIN);
	return(0);
}

int simp_demo_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[6][13] = {"Capacity","Shadow","Boarder","Forms",
		"Music","Enteries"};

	if(display_switch)
	{
		load_screen(3);
		call_window(SIMPLE_DEMO_WIN);
		call_menu(SIMPLE_DEMO_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"C");
	write_window(3,3,"S");
	write_window(3,4,"B");
	write_window(3,5,"F");
	write_window(3,6,"M");
	write_window(3,7,"E");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 7) & (mousex < 18))
			{
				i = mousey - 6;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_C : choice = 2; break;
				case ALT_S : choice = 3; break;
				case ALT_B : choice = 4; break;
				case ALT_F : choice = 5; break;
				case ALT_M : choice = 6; break;
				case ALT_E : choice = 7; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 5)
		{
			i = 5;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(8,6 + i,17,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 7) & (mousex < 18) & (mousey > 5) & (mousey < 12))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : demo_popup(); break;
		case 3 : shad_demo(); break;
		case 4 : boarder_demo(); break;
		case 5 : scr_form(); break;
		case 6 : song_demo(); break;
		case 7 : enter_demo(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}

int demo_popup(void)
{
	long int free_space,block = 4056L,convert = 1L;
	struct dfree space;
	int i,x,y,fore,back,num_file,done = 0;
	unsigned int temp_num;
	int temp_disk;

	save_screen_buff();
	text_screen(14);
/*************************************************************************

	this code asks for a drive letter and selects that drive
	for the utilitie files checking to see if there is enough
	memory

*************************************************************************/

	call_window(TEXT_WIN);
	load_font("script.fnt",1);
	getdfree(disk[0] - 64,&space);
	free_space = (convert * space.df_avail * space.df_bsec * space.df_sclus);
	temp_num = (free_space / block) - 2;
	if(temp_num < 1)
	{
		call_window(ERROR_WIN);
		write_window(3,2,"Not enough disk space !");
		bioskey(0);
		unpopup_window(ERROR_WIN);
		return(1);
	}
	if(temp_num > 10000)
	{
		temp_num = 10000;
	}
/****************************************************************************/
	call_window(ENTER_WIN);
	write_window(3,2,"Enter number of popups:");
	num_file = temp_num;
	while(done == 0)
	{
		if(get_int(&num_file,5,27,2) == 1)
		{
			uncall_window(ENTER_WIN);
			return(0);
		}
		if(num_file < 0)
		{
			clear_window(0);
			write_window(3,2,"Can't do negitive windows !");
			bioskey(0);
			clear_window(0);
			write_window(3,2,"Enter number of popups:");
			num_file = temp_num;
		}
		else
		{
			if(num_file > temp_num)
			{
				clear_window(0);
				write_window(3,2,"To many popups !");
				bioskey(0);
				clear_window(0);
				write_window(3,2,"Enter number of popups:");
				num_file = temp_num;
			}
			else
			{
				done = 1;
			}
		}
	}
	uncall_window(ENTER_WIN);
	temp_disk = getdisk();
	setdisk(disk[0] - 65);
	copy_file("win.dat","win.temp");
	setdisk(temp_disk);
	load_default_palette(0);
	for(i = 1;i < num_file;i++)
	{
		x = (random(69) + 3);
		y = (random(20) + 2);
		fore = random(16);
		back = random(8);
		popup_window(i,x,y,x + 7,y + 2,1,2,fore,back,1,8,0,0,0);
		write_window(3,2,"%d",i);
	}
	popup_window(i,35,10,42,12,1,2,14,4,1,8,0,0,0);
	write_window(3,2,"%d",i);
	done = 0;
	while(done == 0)
	{
		for(i = 500;i < 1000;i++)
		{
			sound(i);
			delay(5);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
		}
		if(done == 1)
		{
			break;
		}
		for(i = 1000;i > 500;i--)
		{
			sound(i);
			delay(5);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
		}
	}
	nosound();
	for(i = num_file; i > 0;i--)
	{
		unpopup_window(i);
	}
	setdisk(disk[0] - 65);
	copy_file("win.tem","win.dat");
	remove("win.tem");
	setdisk(temp_disk);
	display_switch = 0;
	load_emulate(1);
	load_default_palette(1);
	return(0);
}


int shad_demo(void)
{
	int fore,back,i;

	text_screen(15);
	load_default_palette(0);
	load_font("ibmstd.fnt",1);
	for(i = 0;i < 3;i++)
	{
		popup_window(24,20,10,63,15,2,i,14,2,1,8,0,0,0);
		switch(i)
		{
			case 0 : write_window(3,3,"This is the 0 or NO_SHADOW style."); break;
			case 1 : write_window(3,3,"This is the 1 or WIDE_SHADOW style"); break;
			case 2 : write_window(3,3,"This is the 2 or NARROW_SHADOW style"); break;
		}
		write_window(15,6," HIT ANY KEY ");
		bioskey(0);
		unpopup_window(24);
	}
	for(i = 1;i < 5;i++)
	{
		popup_window(24,20,10,63,15,2,1,14,2,i,8,0,0,0);
		switch(i)
		{
			case 1 : write_window(3,3,"This is the 1 or LOWER LEFT location"); break;
			case 2 : write_window(3,3,"This is the 2 or UPPER_LEFT location"); break;
			case 3 : write_window(3,3,"This is the 3 or LOWER_RIGHT location"); break;
			case 4 : write_window(3,3,"This is the 4 or UPPER_RIGHT location"); break;
		}
		write_window(15,6," HIT ANY KEY ");
		bioskey(0);
		unpopup_window(24);
	}
	for(;;)
	{
		fore = random(16);
		back = random(8);
		popup_window(24,20,10,63,15,2,2,14,2,1,fore,back,0,0);
		write_window(15,6," HIT ANY KEY ");
		write_window(6,3,"These are the diffrent colors that");
		write_window(11,4,"you can use for shadows.");
		delay(700);
		if(bioskey(1))
		{
			bioskey(0);
			unpopup_window(24);
			break;
		}
	}
	load_default_palette(1);
	load_emulate(1);
	display_switch = 0;
	return(0);
}

int boarder_demo(void)
{
	int i,char_boarder;

	text_screen(16);
	load_default_palette(0);
	load_font("ibmstd.fnt",1);
	for(i = 0;i <5;i++)
	{
		popup_window(24,20,10,60,15,i,2,14,2,1,8,0,0,0);
		switch(i)
		{
			case 0 : write_window(3,3,"This is the 0 or NO_BOARDER style."); break;
			case 1 : write_window(3,3,"This is the 1 or SINGLE_BOARDER style"); break;
			case 2 : write_window(3,3,"This is the 2 or DOUBLE_BOARDER style"); break;
			case 3 : write_window(3,3,"This is the 3 or SIG_DUB_BOARDER style"); break;
			case 4 : write_window(3,3,"This is the 4 or DUB_SIG_BOARDER style"); break;
		}
		write_window(15,6," HIT ANY KEY ");
		bioskey(0);
	}
	for(;;)
	{
		char_boarder = random(255);
		if(char_boarder < 15)
		{
			char_boarder = char_boarder + 15;
		}
		popup_window(24,20,10,60,15,5,2,14,2,1,8,0,char_boarder,0);
		write_window(15,3," HIT ANY KEY ");
		delay(700);
		if(bioskey(1))
		{
			bioskey(0);
			unpopup_window(24);
			break;
		}
	}
	load_default_palette(1);
	load_emulate(1);
	display_switch = 0;
	return(0);
}

int enter_demo(void)
{
	int int_data = 0,date[3] = {4,1,94},j,i,done = 0,pick;
	long int long_data = 0;
	char enter_string[30] = "";

	text_screen(17);
	creat_file("edit.tem");
	read_file(edit_buff,"edit.tem",(22 * 80),0L);
	load_font("ibmstd.fnt",1);
	show_cursor();
	for(i = 0;i < 5;i++)
	{
		call_window(ENTER_WIN);
		switch(i)
		{
			case 0 : write_window(3,2,"Enter Int :");
				 get_int(&int_data,4,16,2);
				 clear_window(0);
				 write_window(3,2,"You entered %d",int_data);
				 break;
			case 1 : write_window(3,2,"Enter Long :");
				 get_long(&long_data,8,17,2);
				 clear_window(0);
				 write_window(3,2,"You entered %ld",long_data);
				 break;
			case 2 : write_window(3,2,"Enter String :");
				 get_string(enter_string,"          --        ","**********  ********",18,2,1,0);
				 clear_window(0);
				 write_window(3,2,"You entered %s",enter_string);
				 break;
			case 3 : write_window(3,2,"Enter date :");
				 get_int_date(date,16,2);
				 clear_window(0);
				 write_window(3,2,"You enterd %d %d %d",date[0],date[1],date[2]);
				 break;
			case 4 : write_window(3,2,"Chose Y/N ?");
				 if(get_choice(15,2,"Y"))
				 {
					clear_window(0);
					write_window(3,2,"You choose YES");
				 }
				 else
				 {
					clear_window(0);
					write_window(3,2,"You coose NO");
				 }
				 break;
		}
		write_window(15,3," HIT ANY KEY ");
		bioskey(0);
		clear_window(0);
	}
	uncall_window(ENTER_WIN);
	text_screen(18);
/*************************************************************************

	this code is a full screen editor with edit_string()

**************************************************************************/
	call_window(TEXT_WIN);
	for(i = 0;i < 22;i++)
	{
		write_window(3,3 + i,"%s",edit_buff + (80 * i));
	}
	i = 0;
	while(done == 0)
	{
		write_window(31,25," F1 Help F2 Quit ");
		pick = edit_string(edit_buff + (80 * i),
			"***************************************************************************",
			3,3 + i,"TP");
		switch(pick)
		{
			case 0 : i = i + 1; break;
			case ALT_I : for(j = 20;j > i;j--)
				     {
					memmove(edit_buff + (80 * (j + 1)),edit_buff + (80 * j),80);
				     }
				     memset(edit_buff + (80 * (i + 1)),0,80);
				     clear_window(0);
				     for(j = 0;j < 22;j++)
				     {
					write_window(3,3 + j,"%s",edit_buff + (80 * j));
				     }
				     i = i + 1; 
				     break;
			case ESC : clear_window(0);
				   return(0);
			case CURSOR_UP : i = i - 1; break;
			case CURSOR_DN : i = i + 1; break;
			case F2 : done = data_ok(); 
				  if(done == 0)
				  {
					read_file(edit_buff,"edit.tem",22 * 80,0L);
					clear_window(0);
					for(j = 0;j < 22;j++)
					{
						write_window(3,3 + j,"%s",edit_buff + (80 * j));
					}
				  }
				  break;
			case F1 : text_screen(1);
				  break;
			case ALT_D : for(j = i;j < 22;j++)
				     {
					memmove(edit_buff + (80 * j),edit_buff + (80 * (j + 1)),80);
				     }
				     memset(edit_buff + (80 * 21),0,80);
				     clear_window(0);
				     for(j = 0;j < 22;j++)
				     {
					write_window(3,3 + j,"%s",edit_buff + (80 * j));
				     }
				     break;
		}
		if(i > 21)
		{
			i = 21;
		}
		if(i < 0)
		{
			i = 0;
		}
	}

/**************************************************************************/

	write_file(edit_buff,"edit.tem",(22 * 80),0L);
	clear_window(0);
	call_window(ENTER_WIN);
	write_window(3,2,"Display Changes Y/N ?");
	if(get_choice(25,2,"Y"))
	{
		uncall_window(ENTER_WIN);
		for(i = 0;i < 22;i++)
		{
			write_window(3,3 + i,"%s",edit_buff + (80 * i));
		}
		write_window(31,25,"   HIT ANY KEY   ");
		bioskey(0);
	}
	else
	{
		uncall_window(ENTER_WIN);
	}
	hide_cursor();
	uncall_window(TEXT_WIN);
	display_switch = 0;
	load_emulate(1);
	return(0);
}

/**************************************************************************

	this modual is a typical select y/n

************************************************************************/

int data_ok(void)
{
	call_window(DATA_OK_WIN);
	write_window(3,2,"Data OK Y/N ?");
	if(get_choice(17,2,"Y"))
	{
		uncall_window(DATA_OK_WIN);
		return(1);
	}
	uncall_window(DATA_OK_WIN);
	return(0);
}

int scr_form(void)
{
	int i,data[10],j,y,total[10];
	char name[9][15] = {"Don","Ted","Sue","Mary","Bruce","Mike","Sam","Paul","John"};

	text_screen(19);
	for(j = 0;j < 10;j++)
	{
		total[j] = 0;
	}
/*********************************************************************

	this code draws a form on screen

*********************************************************************/
	call_window(TEXT_WIN);
	load_screen_form(0,"fultut.scr");
	write_window(33,25," HIT ANY KEY ");
	bioskey(0);
	y = 6;
	for(i = 0;i < 9;i++)
	{
		for(j = 0;j < 10;j++)
		{
			data[j] = random(100);
		}
		write_window(4,y,"%-s",name[i]);
		write_window(17,y,"%2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d",
			data[0],data[1],data[2],data[3],data[4],data[5],data[6],
			data[7],data[8],data[9]);
		for(j = 0;j < 10;j++)
		{
			total[j] = total[j] + data[j];
		}
		y = y + 2;
	}
	write_window(16,24,"%3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d",
		total[0],total[1],total[2],total[3],total[4],total[5],total[6],total[7],
		total[8],total[9]);
	bioskey(0);
	text_screen(20);
/*************************************************************************

	this code loads a print form and prints it

**************************************************************************/


	load_form(0,"fultut.prn");
	y = 6;
	for(i = 0;i < 10;i++)
	{
		total[i] = 0;
	}
	for(i = 0;i < 9;i++)
	{
		for(j = 0;j < 10;j++)
		{
			data[j] = random(100);
		}
		print_printf(4,y,"%s",name[i]);
		print_printf(17,y,"%2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d",
			data[0],data[1],data[2],data[3],data[4],data[5],data[6],
			data[7],data[8],data[9]);
		for(j = 0;j < 10;j++)
		{
			total[j] = total[j] + data[j];
		}
		y = y + 2;
	}
	print_printf(16,24,"%3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d",
		 total[0],total[1],total[2],total[3],total[4],total[5],total[6],
		 total[7],total[8],total[9]);
	call_window(PRINT_WIN);

	if(print_char(0x0c) != 0)
	{
		clear_window(0);
		write_window(4,2,"Printer error !");
		bioskey(0);
		uncall_window(PRINT_WIN);
		uncall_window(TEXT_WIN);
		return(0);
	}
	write_window(4,2,"Align Paper Now !");
	write_window(5,3,"HIT ANY KEY");
	bioskey(0);
	clear_window(0);
	write_window(8,2,"PRINTING!");
	if(print_buff() != 0)
	{
		clear_window(0);
		write_window(4,2,"Printer error !");
		bioskey(0);
	}
	uncall_window(PRINT_WIN);
	uncall_window(TEXT_WIN);
	display_switch = 0;
	return(0);
}

int song_demo(void)
{
	text_screen(21);
	call_window(TEXT_WIN);
	write_win_large(0,15,5,"Simptut song");
	write_win_large(0,15,14," with cords");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	while(playsong(0,"simptut.sng") == 0)
	{}
	clear_window(0);
	write_win_large(0,15,5,"Little song");
	write_win_large(0,15,14," with notes");
	while(playsong(0,"little.sng") == 0)
	{}
	display_switch = 0;
	uncall_window(TEXT_WIN);
	return(0);
}

int font_demo_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[3][13] = {"Dual demo","Large demo","Multi demo"};

	if(display_switch)
	{
		load_screen(3);
		call_window(FONT_DEMO_WIN);
		call_menu(FONT_DEMO_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"D");
	write_window(3,3,"L");
	write_window(3,4,"M");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 7) & (mousex < 20))
			{
				i = mousey - 6;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 2)
		{
			i = 2;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(8,6 + i,19,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_D : choice = 2; break;
				case ALT_L : choice = 3; break;
				case ALT_M : choice = 4; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 7) & (mousex < 20) & (mousey > 5) & (mousey < 9))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : dual_font_demo(); break;
		case 3 : large_font_demo(); break;
		case 4 : multi_font_demo(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}


void dual_font_demo(void)
{
	call_window(TEXT_WIN);
	hide_cursor();
	load_font("script.fnt",1);
	write_win_bank(0,3,4,"This is the low bank font called by write_win_bank\(\)");
	write_win_bank(1,3,5,"This is the high bank font called by write_win_bank\(\)");
	write_win_bank(0,3,7,"You can use this for ");
	write_win_bank(1,24,7,"Highlight");
	write_win_bank(0,34,7,"like this");
	write_win_bank(1,(80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TEXT_WIN);
	hide_cursor();
}

void large_font_demo(void)
{
	call_window(TEXT_WIN);
	load_font("script.fnt",1);
	load_emulate(1);
	hide_cursor();
	write_win_large(0,3,3,"Low Bank Font.");
	write_win_large(1,3,13,"High Bank font.");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TEXT_WIN);
	hide_cursor();
}


void multi_font_demo(void)
{
	call_window(TEXT_WIN);
	load_font("fdemo1.fnt",0);
	load_font("fdemo2.fnt",1);
	load_emulate(1);
	hide_cursor();
	write_win_multi(1,3,3,"This is font 1 from lower bank");
	write_win_multi(2,3,4,"This is font 2 from lower bank");
	write_win_multi(3,3,5,"This is font 3 from high bank");
	write_win_multi(4,3,6,"This is font 4 from high bank");
	write_win_multi_large(1,3,7,"FONT 1");
	write_win_multi_large(2,40,7,"FONT 2");
	write_win_multi_large(3,3,16,"FONT 3");
	write_win_multi_large(4,40,16,"FONT 4");
	write_win_multi(1,(80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	clear_window(0);
	load_font("fdemo.fnt",1);
	load_emulate(1);
	hide_cursor();
	write_win_multi(1,3,3,"Some stuff you can do");
	write_win_multi_large(3,29,5,"D");
	write_win_multi_large(3,25,13,"ACB");
	write_win_multi(3,40,5,"D");
	write_win_multi(3,39,6,"ACB");
	write_win_multi(1,(80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TEXT_WIN);
	load_font("ibmstd.fnt",0);
	load_font("script.fnt",1);
	load_emulate(1);
	hide_cursor();
}

int vga_demo_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[3][17] = {"Color demo","Gray demo","Palete demo"};

	if(display_switch)
	{
		load_screen(3);
		call_window(VGA_DEMO_WIN);
		call_menu(VGA_DEMO_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"C");
	write_window(3,3,"G");
	write_window(3,4,"P");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 7) & (mousex < 22))
			{
				i = mousey - 6;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 2)
		{
			i = 2;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(8,6 + i,21,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_C : choice = 2; break;
				case ALT_G : choice = 3; break;
				case ALT_P : choice = 4; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 7) & (mousex < 22) & (mousey > 5) & (mousey < 9))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : color_demo(); break;
		case 3 : gray_demo(); break;
		case 4 : palette_64(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}

int color_demo(void)
{
	int i,j,m;
	char color[3];
	char color_temp[3];
	int done = 0;

	if(video_adapter != 9)
	{
		call_window(ERROR_WIN);
		write_window(3,2,"Must use VGA adapter card for this demo!");
		bioskey(0);
		uncall_window(ERROR_WIN);
		return(1);
	}
	color[0] = 0x00;
	color[1] = 0x00;
	color[2] = 0x00;
	read_color_reg(color_temp,3);
	write_color_reg(color,3);
	text_screen(22);
	call_window(TEXT_WIN);
	write_window((80 - strlen(" HIT ANY KEY TO EXIT ")) / 2,25," HIT ANY KEY TO EXIT ");
	popup_window(24,25,5,55,15,1,2,3,7,1,5,0,0,0);
	clear_window(0xdb);
	window(1,1,80,25);
	textattr(0x70);
	i = 0;
	j = 0;
	m = 0;
	done = 0;
	for(i = 0;i < 64;i++)
	{
		color[0] = i;
		write_color_reg(color,3);
		write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
		if(bioskey(1))
		{
			done = 1;
			break;
		}
		delay(100);
	}
	if(done == 0)
	{
		i = 0;
		color[0] = i;
		for(j = 0;j < 64;j++)
		{
			color[1] = j;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		j = 0;
		color[1] = j;
		for(m = 0;m < 64;m++)
		{
			color[2] = m;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		m = 0;
		color[2] = m;
		for(i = 0;i < 64;i++)
		{
			color[0] = i;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		i = 63;
		for(m = 0;m < 64;m++)
		{
			color[2] = m;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		m = 0;
		color[2] = 0;
		for(j = 0;j < 64;j++)
		{
			color[1] = j;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		j = 0;
		color[1] = j;
		i = 0;
		color[0] = i;
		for(m = 0;m < 64;m++)
		{
			color[2] = m;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		m = 63;
		color[2] = m;
		for(i = 0;i < 64;i++)
		{
			color[0] = i;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		i = 0;
		color[0] = i;
		for(j = 0;j < 64;j++)
		{
			color[1] = j;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		j = 0;
		color[1] = j;
		m = 0;
		color[2] = m;
		for(j = 0;j < 64;j++)
		{
			color[1] = j;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		j = 63;
		for(m = 0;m < 64;m++)
		{
			color[2] = m;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		m = 0;
		color[2] = m;
		for(i = 0;i < 64;i++)
		{
			color[0] = i;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		i = 0;
		color[0] = i;
		j = 0;
		color[1] = j;
		for(m = 0;m < 64;m++)
		{
			color[2] = m;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		m = 63;
		for(i = 0;i < 64;i++)
		{
			color[0] = i;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	if(done == 0)
	{
		i = 63;
		for(j = 0;j < 64;j++)
		{
			color[1] = j;
			write_color_reg(color,3);
			write_window(25,17,"Color Blue = %2d Red = %2d Green = %2d",m,i,j);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
			delay(100);
		}
	}
	write_color_reg(color_temp,3);
	unpopup_window(24);
	uncall_window(TEXT_WIN);
	return(0);
}


int gray_demo(void)
{
	int i;
	char character[2];

	if(video_adapter != 9)
	{
		call_window(ERROR_WIN);
		write_window(3,2,"Must use VGA adapter card for this demo!");
		bioskey(0);
		uncall_window(ERROR_WIN);
		return(1);
	}

	text_screen(23);
	save_color_regs("temp.reg");
	call_window(TEXT_WIN);
	load_default_palette(0);
	load_font("ibmstd.fnt",1);
	popup_window(24,30,10,50,12,1,2,15,1,1,8,0,0,0);
	character[0] = 0xdb;
	character[1] = 0x00;
	for(i = 0;i < 16;i++)
	{
		textcolor(i);
		write_window(3 + i,2,"%s",character);
	}
	window(1,1,80,25);
	textattr(0x70);
	write_window(25,14,"This is the color palette.");
	write_window(25,15,"Hit any key to see grayscale.");
	bioskey(0);
	gray_color_regs();
	write_window((80 - strlen(" HIT ANY KET TO EXIT ")) / 2,25," HIT ANY KEY TO EXIT ");
	bioskey(0);
	unpopup_window(24);
	load_color_regs("temp.reg");
	remove("temp.reg");
	load_default_palette(1);
	load_emulate(1);
	uncall_window(TEXT_WIN);
	return(0);
}

int palette_64(void)
{
	char buff[20 * 64];
	char *temp_point;
	int i;

	text_screen(24);
	if(read_file(buff,"define.dat",20 * 64,0L) > 0)
	{
		return(1);
	}
	call_window(TEXT_WIN);
	write_window((80 - strlen(" ANY KEY TO TOGGLE COLOR  ESC TO EXIT ")) / 2,25," ANY KEY TO TOGGLE  ESC TO EXIT ");
	popup_window(8,20,5,60,15,1,2,3,1,1,5,0,0,0);
	clear_window(0xdb);
	window(1,1,80,25);
	textattr(0x70);
	temp_point = strtok(buff,"\r\n");
	for(i = 0;i < 64;i++)
	{
		write_palette(i,3);
		write_window(30,18,"Color define %s = %d",temp_point,i);
		if(bioskey(0) == 283)
		{
			break;
		}
		write_window(30,18,"                                                ");
		temp_point = strtok(NULL,"\r\n");
	}
	write_palette(3,3);
	uncall_window(TEXT_WIN);
	return(0);
}

int mouse_demo(void)
{
	int type = 1,done = 0;
	int moux,mouy,pix_x,pix_y;

	text_screen(31);
	load_font("script.fnt",1);
	load_emulate(1);
	call_window(TEXT_WIN);
	write_window((80 - strlen(" Hit Any Key to exit ")) / 2,25," HIT ANY KEY TO EXIT ");
	write_win_large(0,5,3,"Mouse v 2.3");
	write_win_large(1,5,11,"Mouse v 2.3");
	write_win_bank(0,55,9,"Mouse v 2.3");
	write_win_bank(1,55,16,"Mouse v 2.3");
	write_window(5,23,"Use LEFT and RIGHT button press to change cursor.");
	moureset();
	moushow();
	while(done == 0)
	{
		mouposition(&moux,&mouy);
		moupositionpix(&pix_x,&pix_y);
		if(buttons == 2)
		{
			if(moubuttonpressed(LEFTBUTTON))
			{
				write_window(40,20,"Left button pressed  ");
				type++;
				if(type > 8)
				{
					type = 8;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonpressed(RIGHTBUTTON))
			{
				write_window(40,20,"Right button pressed ");
				type--;
				if(type < 1)
				{
					type = 1;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonrelease(LEFTBUTTON))
			{
				write_window(40,20,"Left button released ");
			}
			if(moubuttonrelease(RIGHTBUTTON))
			{
				write_window(40,20,"Rigth button released");
			}
		}
		else
		{
			if(moubuttonpressed(LEFTBUTTON))
			{
				write_window(40,20,"Left button pressed   ");
				type++;
				if(type > 32)
				{
					type = 32;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonpressed(RIGHTBUTTON))
			{
				write_window(40,20,"Right button pressed  ");
				type--;
				if(type < 1)
				{
					type = 1;
				}
				moucursortype(type);
				mouposition(&moux,&mouy);
			}
			if(moubuttonrelease(LEFTBUTTON))
			{
				write_window(40,20,"Left button released  ");
			}
			if(moubuttonrelease(RIGHTBUTTON))
			{
				write_window(40,20,"Rigth button released ");
			}
			if(moubuttonpressed(MIDBUTTON))
			{
				write_window(40,20,"Middle button pressed ");
			}
			if(moubuttonrelease(MIDBUTTON))
			{
				write_window(40,20,"Middle button released");
			}
		}
		write_window(5,19,"Number of buttons = %1d",buttons);
		write_window(5,21,"Pix X = %3d Pix Y = %3d",pix_x,pix_y);
		write_window(5,22,"    X = %2d     Y = %2d",moux,mouy);
		if(bioskey(1))
		{
		    done = 1;
		}
		write_window(5,20,"Cursor type number %2d",type);
	}
	moucursortype(1);
	mouhide();
	uncall_window(TEXT_WIN);
	return(0);
}

void load_default_palette(int toggle)
{
	int i;

	for(i = 0;i < 16;i++)
	{
		switch(i)
		{
			case 0 : switch(toggle)
				 {
					case 0 : set_palette(i,C_BLACK); break;
					case 1 : set_palette(i,C_BLACK); break;
					case 2 : palette[i] = C_BLACK; break;
				 }
				 break;
			case 1 : switch(toggle)
				 {
					case 0 : set_palette(i,C_BLUE); break;
					case 1 : set_palette(i,C_BLUE); break;
					case 2 : palette[i] = C_BLUE; break;
				 }
				 break;
			case 2 : switch(toggle)
				 {
					case 0 : set_palette(i,C_GREEN); break;
					case 1 : set_palette(i,C_YELLOW); break;
					case 2 : palette[i] = C_YELLOW; break;
				 }
				 break;
			case 3 : switch(toggle)
				 {
					case 0 : set_palette(i,C_CYAN); break;
					case 1 : set_palette(i,C_CYAN); break;
					case 2 : palette[i] = C_CYAN; break;
				 }
				 break;
			case 4 : switch(toggle)
				 {
					case 0 : set_palette(i,C_RED); break;
					case 1 : set_palette(i,C_RED); break;
					case 2 : palette[i] = C_RED; break;
				 }
				 break;
			case 5 : switch(toggle)
				 {
					case 0 : set_palette(i,C_MAGENTA); break;
					case 1 : set_palette(i,C_DARK_GRAY_2); break;
					case 2 : palette[i] = C_DARK_GRAY_2; break;
				 }
				 break;
			case 6 : switch(toggle)
				 {
					case 0 : set_palette(i,C_BROWN); break;
					case 1 : set_palette(i,C_WHITE); break;
					case 2 : palette[i] = C_WHITE; break;
				 }
				 break;
			case 7 : switch(toggle)
				 {
					case 0 : set_palette(i,C_LIGHT_GRAY); break;
					case 1 : set_palette(i,C_LIGHT_GRAY); break;
					case 2 : palette[i] = C_LIGHT_GRAY; break;
				 }
				 break;
			case 8 : switch(toggle)
				 {
					case 0 : set_palette(i,C_DARK_GRAY_2); break;
					case 1 : set_palette(i,C_BLACK); break;
					case 2 : palette[i] = C_BLACK; break;
				 }
				 break;
			case 9 : switch(toggle)
				 {
					case 0 : set_palette(i,C_BLUE_3); break;
					case 1 : set_palette(i,C_BLUE); break;
					case 2 : palette[i] = C_BLUE; break;
				 }
				 break;
			case 10 : switch(toggle)
				 {
					case 0 : set_palette(i,C_GREEN_4); break;
					case 1 : set_palette(i,C_YELLOW); break;
					case 2 : palette[i] = C_YELLOW; break;
				 }
				 break;
			case 11 : switch(toggle)
				 {
					case 0 : set_palette(i,C_PALE_CYAN); break;
					case 1 : set_palette(i,C_CYAN); break;
					case 2 : palette[i] = C_CYAN; break;
				 }
				 break;
			case 12 : switch(toggle)
				 {
					case 0 : set_palette(i,C_LIGHT_RED); break;
					case 1 : set_palette(i,C_RED); break;
					case 2 : palette[i] = C_RED; break;
				 }
				 break;
			case 13 : switch(toggle)
				 {
					case 0 : set_palette(i,C_PALE_MAGENTA); break;
					case 1 : set_palette(i,C_DARK_GRAY_2); break;
					case 2 : palette[i] = C_DARK_GRAY_2; break;
				 }
				 break;
			case 14 : switch(toggle)
				 {
					case 0 : set_palette(i,C_YELLOW); break;
					case 1 : set_palette(i,C_WHITE); break;
					case 2 : palette[i] = C_WHITE; break;
				 }
				 break;
			case 15 : switch(toggle)
				 {
					case 0 : set_palette(i,C_WHITE); break;
					case 1 : set_palette(i,C_LIGHT_GRAY); break;
					case 2 : palette[i] = C_LIGHT_GRAY; break;
				 }
				 break;
		}
	}
}

void view_tut(int file_num,char *lable)
{
	call_window(TEXT_WIN);
	write_window((80 - strlen(lable) - 2) / 2,1," %s ",lable);
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	load_text(file_num,"fulfunc1.men");
	bioskey(0);
	uncall_window(TEXT_WIN);
}
