# include <dos.h>
# include <string.h>
# include <stdio.h>
# include <bios.h>
# include <stdlib.h>
# include <conio.h>
# include <mem.h>
# include <process.h>
# include <dir.h>

/***************************************************************************

      simple windows includes

***************************************************************************/

# include "simpwin.h"
# include "swskdef.h"
# include "mouse21.h"

/***************************************************************************

      window call defines

***************************************************************************/

# define MAIN_WIN 1
# define DEMO_WIN 2
# define TEXT_WIN 3
# define FONT_TEXT 4
# define FONT_WIN 5
# define QUIT_WIN 6
# define FUNG_WIN 7
# define DEMO_TEXT 8
# define ENTER_WIN 9
# define EDIT_WIN 10
# define OPT_WIN 19

/***************************************************************************

      menu call defines

***************************************************************************/

# define MAIN_MENU 0
# define DEMO_MENU 1
# define TEXT_MENU 2
# define FONT_TEXT_MENU 3
# define FONT_MENU 4
# define CAP_MENU 6
# define FUNG_MENU 5
# define SHADOW_MENU 7
# define BOARDER_MENU 8
# define ENTER_MENU 9
# define EDIT_MENU 10
# define SCREEN_MENU 11
# define FORM_MENU 12
# define SONG_MENU 13
# define OPT_MENU_1 14
# define OPT_MENU_2 15
# define OPT_MENU 16

/***************************************************************************

      fungtion prototypes

***************************************************************************/

int font_demo(void);
int main_menu(void);
int quit(void);
int demo_menu(void);
int tutor_menu(void);
int tut_menu(void);
int demo_popup(void);
int shad_demo(void);
int boarder_demo(void);
int enter_demo(void);
int data_ok(void);
int scr_form(void);
int song_demo(void);
void view_text(int file_num);
int reg_form(void);
void view_tut(int file_num,char *lable);
void reed_text(char *file_name);
int option_menu(void);
int o_menu(void);
void get_port(void);
int save_option(int save_switch);
int change_window(char lable[9][15]);
int boarder_select(void);
int shadow_select(void);
int color_select(void);
void write_data(int record);
void save_data(void);
int get_color(void);
int mou_menu(void);

typedef struct
{
	int port;
	int hk_color;
	char font[15];
	int data[8][8];
} O_DATA;


int mou_switch,port_number,win_num = 0,color_code,display_switch = 1;
O_DATA o_data;
char *edit_buff,font_string[255];
char *t_buff;

void main(void)
{
	int i,j,k;

/****************************************************************************

	load system file

****************************************************************************/


	init_window(2,1,1,"",1);
	read_file(&o_data,"simptut.sys",sizeof(O_DATA),0L);
	strcpy(font_string,"swloadft ");
	strcat(font_string,o_data.font);
	system(font_string);
	hide_cursor();
	system("cls");

/***************************************************************************

	check for enough memory

***************************************************************************/

	if(((edit_buff = (char *)malloc(22 * 80)) == NULL) |
		((t_buff = (char *)malloc(4000)) == NULL))
	{       popup_window(0,1,25,80,25,0,0,14,4,1,0,0,0,0);
		write_window(3,2,"Not enough memory!");
		exit(1);
	}
	memset(edit_buff,0,(22 * 80));

/****************************************************************************

	initialize simple windows anf mouse21

***************************************************************************/

	port_number = o_data.port;
	if(init_window(30,20,4,"",port_number) == 1)
	{
		simp_window(1,25,80,25,0,0,14,4,1,0,0,0,0);
		gotoxy(3,2);
		cprintf("Unable to install simple windows");
		exit(1);
	}
	if(mouinstalled() != 0)
	{
		loadcurs("cursor.fnt",0);
		mousetposition(1,1);
		mou_switch = 1;
		simp_window(30,10,50,12,1,0,14,4,0,0,0,0,0);
		write_window(3,2,"Mouse Installed !");
		delay(1000);
	}
	else
	{
		simp_window(23,10,57,12,1,0,14,4,0,0,0,0,0);
		write_window(3,2,"NO mouse driver installed");
		delay(1000);
	}

	if(load_menu_text("simptut.men") != 0)
	{
		uninit_window();
		free(edit_buff);
		exit(1);
	}
	load_win_data("simptut.win");
	save_data();

/***************************************************************************

	make title screen

****************************************************************************/
	hide_cursor();
	k= 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			simp_window(40 - j,13 - i,40 + j,13 + i,o_data.data[0][0],
				o_data.data[0][1],o_data.data[0][2],o_data.data[0][3],
				o_data.data[0][4],o_data.data[0][5],o_data.data[0][6],
				o_data.data[0][7],0);
		}
		k = k + 3;
	}
	simp_window(1,1,80,25,o_data.data[0][0],o_data.data[0][1],o_data.data[0][2],
		o_data.data[0][3],o_data.data[0][4],o_data.data[0][5],
		o_data.data[0][6],o_data.data[0][7],0);
	k = 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			window(40 - j,13 - i,40 + j,13 + i);
			load_screen_form(0,"simptut.scr");
		}
		k = k + 3;
	}
	window(1,1,80,25);
	load_screen_form(0,"simptut.scr");
	save_screen(1);
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	moucursortype(0xff);
	/*mou_switch = 0;*/
/****************************************************************************

	run program menu system

***************************************************************************/

	hide_cursor();
	while(main_menu())
	{
	}

/***************************************************************************

	uninitialize simple windows and exit

****************************************************************************/

	free(edit_buff);
	uninit_window();
	show_cursor();
	spawnlp(P_WAIT,"swloadft.exe","swloadft.exe","ibmstd.fnt",NULL);
	system("cls");
}

/**************************************************************************

	This is a typical menu fungtion. I will comment this one only
	to save on redundancy. All the other menuing moduals are similar.

**************************************************************************/

int font_demo(void)
{
	int i,pick,choice,old_i = 9,mousex = 0,mousey = 0;
	char lable[8][13] = {"Roman","Script","Antique","Brodway","saNserif",
		"Courrier","Medieval","Ibmstd"};

/**************************************************************************

	draw window and menu with hilght

**************************************************************************/

	load_screen(3);
	call_window(FONT_TEXT);
	call_menu(FONT_TEXT_MENU,3,2);
	write_window(16,10," HIT ANY KEY ");
	bioskey(0);
	call_window(FONT_WIN);
	write_window(5,1," FONTS ");
	call_menu(FONT_MENU,3,2);
	textcolor(o_data.hk_color);
	write_window(3,2,"R");
	write_window(3,3,"S");
	write_window(3,4,"A");
	write_window(3,5,"B");
	write_window(5,6,"N");
	write_window(3,7,"C");
	write_window(3,8,"M");
	write_window(3,9,"I");
	save_screen_buff();

/***************************************************************************

	This is the cursor and mouse control

***************************************************************************/

	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
	/******************************************************************

		This tells where is mouse

	******************************************************************/
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 30 ) & (mousex < 45 ))
			{
				i = mousey - 7;
			}
		}
	/******************************************************************

		This checks for key entery

	******************************************************************/
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 10; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
				case ALT_R : choice = 2; break;
				case ALT_S : choice = 3; break;
				case ALT_A : choice = 4; break;
				case ALT_B : choice = 5; break;
				case ALT_N : choice = 6; break;
				case ALT_C : choice = 7; break;
				case ALT_M : choice = 8; break;
				case ALT_I : choice = 9; break;
			}
		}
	/******************************************************************

		this is for cursor control

	******************************************************************/

		if(i < 0)
		{
			i = 0;
		}
		if(i > 7)
		{
			i = 7;
		}

	/******************************************************************

		this draws shadowed hilight

	********************************************************************/

		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(31,7 + i,44,7 + i,o_data.data[7][0],o_data.data[7][1],
				o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
				o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}

	/******************************************************************

		this checks mouse button

	******************************************************************/

		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex < 45) & (mousex > 30) & (mousey > 6) & (mousey < 15))
			{
				choice = 1;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}

	mouhide();
	load_screen_buff();

/************************************************************************

	this check to see if there is a selection

************************************************************************/

	if(choice == 1)
	{
		choice = i + 2;
	}
	pick = 1;
	switch(choice)
	{
		case 2 :
		case 3 :
		case 4 :
		case 5 :
		case 6 :
		case 7 :
		case 8 :
		case 9 : strcpy(o_data.font,lable[i]); break;
	}
	if(choice != 10)
	{
		strcat(o_data.font,".fnt");
		strcpy(font_string,"swloadft ");
		strcat(font_string,o_data.font);
		system(font_string);
	}
	load_screen_buff();
	uncall_window(FONT_WIN);
	uncall_window(FONT_TEXT);
	display_switch = 0;
	return(pick);
}

int main_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[4][13] = {"Demo","Text","Options","eXit"};

/***************************************************************************

	this code is used to get rid of window flash

**************************************************************************/

	if(display_switch)
	{
		load_screen(1);
		call_window(MAIN_WIN);
		call_menu(MAIN_MENU,3,2);
		save_screen(2);
	}
	else
	{
		load_screen(2);
	}

/**************************************************************************/

	display_switch = 1;
	textcolor(o_data.hk_color);
	write_window(3,2,"D");
	write_window(15,2,"T");
	write_window(28,2,"O");
	write_window(43,2,"X");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if(mousey == 4)
			{
				if((mousex > 5) & (mousex < 11))
				{
					i = 0;
				}
				else if((mousex > 17) & (mousex < 24))
				{
					i = 1;
				}
				else if((mousex > 30) & (mousex < 39))
				{
					i = 2;
				}
				else if((mousex > 44) & (mousex < 50))
				{
					i = 3;
				}
			}
		}
		if(old_i != i)
		{
			mouhide();
			old_i = i;
			load_screen_buff();
			switch(i)
			{
				case 0 : simp_window(6,4,11,4,o_data.data[7][0],
					 o_data.data[7][1],o_data.data[7][2],o_data.data[7][3],
					 o_data.data[7][4],o_data.data[7][5],o_data.data[7][6],
					 o_data.data[7][7],0); break;
				case 1 : simp_window(18,4,24,4,o_data.data[7][0],o_data.data[7][1],
					 o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
					 o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0); break;
				case 2 : simp_window(31,4,39,4,o_data.data[7][0],o_data.data[7][1],
					 o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
					 o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0); break;
				case 3 : simp_window(45,4,50,4,o_data.data[7][0],o_data.data[7][1],
					 o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
					 o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0); break;
			}
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 6; break;
				case CURSOR_RIGHT : i = i + 1; break;
				case CURSOR_LEFT : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_D : choice = 2; break;
				case ALT_T : choice = 3; break;
				case ALT_X : choice = 5; break;
				case ALT_O : choice = 4; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if(mousey == 4)
			{
				if(((mousex > 5) & (mousex < 11)) |
					((mousex > 17) & (mousex < 24)) |
					((mousex > 30) & (mousex < 39)) |
					((mousex > 44) & (mousex < 50)))
				{
					choice = 1;
				}
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	pick = 1;
	switch(choice)
	{
		case 2 : while(demo_menu()){} break;
		case 3 : while(tutor_menu()){} break;
		case 4 : while(o_menu()){} break;
		case 6 :
		case 5 : pick = quit(); break;
	}
	return(pick);
}

/*************************************************************************

	this modual ask if you are shure you wish to quit

************************************************************************/

int quit(void)
{
	int pick = 1;

	show_cursor();
	call_window(QUIT_WIN);
	write_window(3,2,"Quit Y/N ?");
	if(get_choice(14,2,"N"))
	{
		pick = 0;
	}
	uncall_window(QUIT_WIN);
	hide_cursor();
	return(pick);
}

int demo_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[6][13] = {"Capacity","Shadow","Boarder","Form",
		"Music","Enteries"};

	if(display_switch)
	{
		load_screen(2);
		call_window(DEMO_WIN);
		call_menu(DEMO_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(o_data.hk_color);
	write_window(3,2,"C");
	write_window(3,3,"S");
	write_window(3,4,"B");
	write_window(3,5,"F");
	write_window(3,6,"M");
	write_window(3,7,"E");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 7) & (mousex < 19))
			{
				i = mousey - 5;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_C : choice = 2; break;
				case ALT_S : choice = 3; break;
				case ALT_B : choice = 4; break;
				case ALT_F : choice = 5; break;
				case ALT_M : choice = 6; break;
				case ALT_E : choice = 7; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 5)
		{
			i = 5;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(8,5 + i,18,5 + i,o_data.data[7][0],o_data.data[7][1],
			o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
			o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 7) & (mousex < 19) & (mousey > 4) & (mousey < 11))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : while(demo_popup()){} break;
		case 3 : while(shad_demo()){} break;
		case 4 : while(boarder_demo()){} break;
		case 5 : while(scr_form()){} break;
		case 6 : while(song_demo()){} break;
		case 7 : while(enter_demo()){} break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}

int tutor_menu(void)
{
	int pick,choice,i = 0,old_i = 12,mousex = 0,mousey = 0;
	char lable[10][13] = {"Genral Info","Registration","Disclaimer",
		"Fungtions","Later","Support","Quarks","Mouse21","dEfines","maKefile"};

	if(display_switch)
	{
		load_screen(2);
		call_window(TEXT_WIN);
		call_menu(TEXT_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(o_data.hk_color);
	write_window(3,2,"G");
	write_window(3,3,"R");
	write_window(3,4,"D");
	write_window(3,5,"F");
	write_window(3,6,"L");
	write_window(3,7,"S");
	write_window(3,8,"Q");
	write_window(3,9,"M");
	write_window(4,10,"E");
	write_window(5,11,"K");
	save_screen_buff();
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 17) & (mousex < 32))
			{
				i = mousey - 5;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 12; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_G : choice = 2; break;
				case ALT_R : choice = 3; break;
				case ALT_D : choice = 4; break;
				case ALT_F : choice = 5; break;
				case ALT_L : choice = 6; break;
				case ALT_S : choice = 7; break;
				case ALT_Q : choice = 8; break;
				case ALT_M : choice = 9; break;
				case ALT_E : choice = 10; break;
				case ALT_K : choice = 11; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 9)
		{
			i = 9;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(18,5 + i,31,5 + i,o_data.data[7][0],o_data.data[7][1],
			o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
			o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 17) & (mousex < 32) & (mousey > 4) & (mousey < 15))
			{
				choice = 1;
			}
			else
			{
				choice = 12;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : view_text(0); break;
		case 3 : reg_form(); break;
		case 4 : reed_text("disclam.doc"); break;
		case 5 : while(tut_menu()){} break;
		case 6 : view_text(1); break;
		case 7 : view_text(2); break;
		case 8 : view_text(3); break;
		case 9 : while(mou_menu()){} break;
		case 10 : reed_text("defines.txt"); break;
		case 11 : reed_text("makefile.txt"); break;
		case 12 : pick = 0; break;
	}
	display_switch = 0;
	unpopup_window(3);
	return(pick);
}

/**************************************************************************

	this is a complex menuing system with cursor and mouse

**************************************************************************/

int tut_menu(void)
{
	int pick,choice,i,j,old_i = 100,old_j = 4;
	int mousex = 0,mousey = 0;
		char lable[3][21][25] = {"simp_window\(\)","popup_window\(\)","make_window\(\)","call_window\(\)",
		"uncall_window\(\)","unpopup_window\(\)","load_win_data\(\)","","",
		"make_menu\(\)","load_menu_text\(\)","call_menu\(\)","load_text\(\)","","",
		"get_choice\(\)","get_int_date\(\)","edit_string\(\)","get_string\(\)",
		"get_int\(\)","get_long\(\)","print_printf\(\)","print_putch\(\)",
		"print_horizontal_line\(\)","print_vertical_line\(\)","print_window\(\)",
		"clear_print_buff\(\)","print_buff\(\)","load_form\(\)","print_char\(\)","","",
		"draw_horizontal_line\(\)","draw_vertical_line\(\)","clear_window\(\)",
		"move_window\(\)","show_cursor\(\)","hide_cursor\(\)","move_cursor\(\)",
		"load_screen_form\(\)","write_window\(\)","read_text\(\)","set_tempo\(\)",
		"tone\(\)","cord\(\)","playsong\(\)","","","read_file\(\)",
		"write_file\(\)","file_to_file\(\)","copy_file\(\)","creat_file\(\)","read_directory\(\)",
		"","","save_screen\(\)","load_screen\(\)","save_screen_buff\(\)",
		"load_screen_buff\(\)","","init_window\(\)","uninit_window\(\)"};

	if(display_switch)
	{
		call_window(FUNG_WIN);
		call_menu(FUNG_MENU,5,3);
		write_window((80 - strlen("FUNCTION MENU ")) / 2,1," FUNGTION MENU ");
		write_window((80 - strlen(" ESC to exit ")) / 2,25," ESC to exit ");
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	save_screen_buff();
	i = 0;
	j = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 3) & (mousex < 25))
			{
				i = mousey - 4;
				if((mousey > 2) & (mousey < 23))
				{
					j = 0;
				}
			}
			else if((mousex > 27) & (mousex < 56))
			{
				i = mousey - 4;
				if((mousey > 3) & (mousey < 23))
				{
					j = 1;
				}
			}
			else if((mousex > 58) & (mousex < 80))
			{
				i = mousey - 4;
				if((mousey > 3) & (mousey < 25))
				{
					j = 2;
				}
			}

		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 100; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_RIGHT : j = j + 1; break;
				case CURSOR_LEFT : j = j - 1; break;
			}
		}
		switch(j)
		{
			case 0 : switch(i)
				 {
					case 7 : i = 9; break;
					case 8 : i = 6; break;
					case 13 : i = 15; break;
					case 14 : i = 12; break;
				 }
				 if(i < 0)
				 {
					i = 0;
				 }
				 if(i > 20)
				 {
					i = 0;
					j = 1;
				 }
				 break;
			case 1 : switch(i)
				 {
					case 9 : i = 11; break;
					case 10 : i = 8; break;
				 }
				 if(i < 0)
				 {
					i = 20;
					j = 0;
				 }
				 else if(i > 20)
				 {
					i = 0;
					j = 2;
				 }
				 break;
			case 2 : switch(i)
				 {
					case 4 : i = 6; break;
					case 5 : i = 3; break;
					case 12 : i = 14; break;
					case 13 : i = 11; break;
				 }
				 if((old_i < i) & (i == 18))
				 {
					i = 19;
				 }
				 if((old_i > i) & (i == 18))
				 {
					i = 17;
				 }
				 if(i < 0)
				 {
					i = 20;
					j = 1;
				 }
				 else if(i > 20)
				 {
					i = 20;
				 }
				 break;
		}
		if(j < 0)
		{
			j = 0;
		}
		if(j > 2)
		{
			j = 2;
		}
		if((old_i != i) | (old_j != j))
		{
			mouhide();
			old_i = i;
			old_j = j;
			load_screen_buff();
			switch(j)
			{
				case 0 : simp_window(4,4 + i,4 + strlen(lable[j][i]) + 1,4 + i,
						o_data.data[7][0],o_data.data[7][1],o_data.data[7][2],
						o_data.data[7][3],o_data.data[7][4],o_data.data[7][5],
						o_data.data[7][6],o_data.data[7][7],0); break;
				case 1 : simp_window(28,4 + i,28 + strlen(lable[j][i]) + 1,4 + i,
						o_data.data[7][0],o_data.data[7][1],o_data.data[7][2],
						o_data.data[7][3],o_data.data[7][4],o_data.data[7][5],
						o_data.data[7][6],o_data.data[7][7],0); break;
				case 2 : simp_window(59,4 + i,59 + strlen(lable[j][i]) + 1,4 + i,
						o_data.data[7][0],o_data.data[7][1],o_data.data[7][2],
						o_data.data[7][3],o_data.data[7][4],o_data.data[7][5],
						o_data.data[7][6],o_data.data[7][7],0); break;
			}
			write_window(2,1,"%s",lable[j][i]);
			moushow();
		}
		if(moubuttonrelease(LEFTBUTTON))
		{
			if(((mousex > 3) & (mousex < strlen(lable[0][i]) + 5)) |
				((mousex > 27) & (mousex < strlen(lable[1][i]) + 31)) |
				((mousex > 58) & (mousex < strlen(lable[2][i]) + 62)))
			{
				choice = 1;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		switch(j)
		{
			case 0 : switch(i)
				 {
					case 0 : choice = 0; break;
					case 1 : choice = 1; break;
					case 2 : choice = 2; break;
					case 3 : choice = 3; break;
					case 4 : choice = 4; break;
					case 5 : choice = 5; break;
					case 6 : choice = 6; break;
					case 9 : choice = 7; break;
					case 10 : choice = 8; break;
					case 11 : choice = 9; break;
					case 12 : choice = 10; break;
					case 15 : choice = 11; break;
					case 16 : choice = 12; break;
					case 17 : choice = 13; break;
					case 18 : choice = 15; break;
					case 19 : choice = 16; break;
					case 20 : choice = 17; break;
				 }
				 break;
			case 1 : switch(i)
				 {
					case 0 : choice = 18; break;
					case 1 : choice = 19; break;
					case 2 : choice = 20; break;
					case 3 : choice = 21; break;
					case 4 : choice = 22; break;
					case 5 : choice = 23; break;
					case 6 : choice = 24; break;
					case 7 : choice = 25; break;
					case 8 : choice = 52; break;
					case 11 : choice = 26; break;
					case 12 : choice = 27; break;
					case 13 : choice = 28; break;
					case 14 : choice = 29; break;
					case 15 : choice = 30; break;
					case 16 : choice = 31; break;
					case 17 : choice = 32; break;
					case 18 : choice = 33; break;
					case 19 : choice = 34; break;
					case 20 : choice = 35; break;
				 }
				 break;
			case 2 : switch(i)
				 {
					case 0 : choice = 36; break;
					case 1 : choice = 37; break;
					case 2 : choice = 38; break;
					case 3 : choice = 39; break;
					case 6 : choice = 40; break;
					case 7 : choice = 41; break;
					case 8 : choice = 42; break;
					case 9 : choice = 43; break;
					case 10 : choice = 44; break;
					case 11 : choice = 45; break;
					case 14 : choice = 46; break;
					case 15 : choice = 47; break;
					case 16 : choice = 48; break;
					case 17 : choice = 49; break;
					case 19 : choice = 50; break;
					case 20 : choice = 51; break;
				 }
		}
		view_tut(choice,lable[j][i]);
		switch(choice)
		{
			case 13 : view_tut(14,lable[j][i]); break;
		}
	}
	pick = 1;
	if(choice == 100)
	{
		pick = 0;
	}
	display_switch = 0;
	return(pick);
}

int demo_popup(void)
{
	long int free_space,block = 4056L,convert = 1;
	struct dfree space;
	int i,x,y,fore,back,num_file,done = 0;
	unsigned temp_num;

	call_window(DEMO_TEXT);
	call_menu(CAP_MENU,3,2);
	write_window(25,16," HIT ANY KEY ");
	bioskey(0);

/*************************************************************************

	this code asks for a drive letter and selects that drive
	for the utilitie files checking to see if there is enough
	memory

*************************************************************************/

	call_window(ENTER_WIN);
	getdfree(getdisk(),&space);
	free_space = (convert * space.df_avail * space.df_bsec * space.df_sclus);
	temp_num = free_space / block - 25 ;
	if(temp_num < 1)
	{
		popup_window(0,1,25,80,25,0,0,14,4,1,0,0,0,0);
		write_window(3,2,"Not enough disk space !");
		bioskey(0);
		unpopup_window(0);
		uncall_window(ENTER_WIN);
		uncall_window(DEMO_TEXT);
		return(1);
	}
	if(temp_num > 10000)
	{
		temp_num = 10000;
	}
/****************************************************************************/

	clear_window(0);
	write_window(3,2,"Enter number of popups:");
	num_file = temp_num;
	while(done == 0)
	{
		if(get_int(&num_file,5,27,2) == 1)
		{
			unpopup_window(9);
			unpopup_window(8);
			return(0);
		}
		if(num_file < 0)
		{
			clear_window(0);
			write_window(3,2,"Can't do negitive windows !");
			bioskey(0);
			clear_window(0);
			write_window(3,2,"Enter number of popups:");
			num_file = temp_num;
		}
		else
		{
			if(num_file > temp_num)
			{
				clear_window(0);
				write_window(3,2,"To many popups !");
				bioskey(0);
				clear_window(0);
				write_window(3,2,"Enter number of popups:");
				num_file = temp_num;
			}
			else
			{
				done = 1;
			}
		}
	}
	unpopup_window(9);
	unpopup_window(8);
	for(i = 25;i < num_file + 25;i++)
	{
		x = (random(69) + 3);
		y = (random(20) + 2);
		fore = random(16);
		back = random(8);
		popup_window(i,x,y,x + 7,y + 2,1,2,fore,back,1,8,0,0,0);
		write_window(3,2,"%d",i);
	}
	popup_window(num_file,35,10,42,12,1,2,14,12,1,8,0,0,0);
	write_window(3,2,"%d",num_file);
	done = 0;
	while(done == 0)
	{
		for(i = 500;i < 1000;i++)
		{
			sound(i);
			delay(5);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
		}
		if(done == 1)
		{
			break;
		}
		for(i = 1000;i > 500;i--)
		{
			sound(i);
			delay(5);
			if(bioskey(1))
			{
				done = 1;
				break;
			}
		}
	}
	nosound();
	for(i = num_file + 24; i > 24;i--)
	{
		unpopup_window(i);
	}
	display_switch = 0;
	return(0);
}

int shad_demo(void)
{
	int fore,back,i;

	call_window(DEMO_TEXT);
	call_menu(SHADOW_MENU,8,5);
	write_window(25,16," HIT ANY KEY ");
	bioskey(0);

	for(i = 0;i < 3;i++)
	{
		popup_window(24,20,10,63,15,2,i,14,2,1,8,0,0,0);
		switch(i)
		{
			case 0 : write_window(3,3,"This is the 0 or NO_SHADOW style."); break;
			case 1 : write_window(3,3,"This is the 1 or WIDE_SHADOW style"); break;
			case 2 : write_window(3,3,"This is the 2 or NARROW_SHADOW style"); break;
		}
		write_window(15,6," HIT ANY KEY ");
		bioskey(0);
		unpopup_window(24);
	}
	for(i = 1;i < 5;i++)
	{
		popup_window(24,20,10,63,15,2,1,14,2,i,8,0,0,0);
		switch(i)
		{
			case 1 : write_window(3,3,"This is the 1 or LOWER LEFT location"); break;
			case 2 : write_window(3,3,"This is the 2 or UPPER_LEFT location"); break;
			case 3 : write_window(3,3,"This is the 3 or LOWER_RIGHT location"); break;
			case 4 : write_window(3,3,"This is the 4 or UPPER_RIGHT location"); break;
		}
		write_window(15,6," HIT ANY KEY ");
		bioskey(0);
		unpopup_window(24);
	}
	for(;;)
	{
		fore = random(16);
		back = random(8);
		popup_window(24,20,10,63,15,2,2,14,2,1,fore,back,0,0);
		write_window(15,6," HIT ANY KEY ");
		write_window(6,3,"These are the diffrent colors that");
		write_window(11,4,"you can use for shadows.");
		delay(700);
		if(bioskey(1))
		{
			bioskey(0);
			unpopup_window(24);
			break;
		}
	}
	uncall_window(DEMO_TEXT);
	display_switch = 0;
	return(0);
}

int boarder_demo(void)
{
	int i,char_boarder;

	save_screen_buff();
	strcpy(font_string,o_data.font);
	strcat(font_string," > font.tem");
	system(font_string);
	load_screen_buff();
	call_window(DEMO_TEXT);
	call_menu(BOARDER_MENU,10,5);
	write_window(25,16," HIT ANY KEY ");
	bioskey(0);
	for(i = 0;i <5;i++)
	{
		popup_window(24,20,10,60,15,i,2,14,2,1,8,0,0,0);
		switch(i)
		{
			case 0 : write_window(3,3,"This is the 0 or NO_BOARDER style."); break;
			case 1 : write_window(3,3,"This is the 1 or SINGLE_BOARDER style"); break;
			case 2 : write_window(3,3,"This is the 2 or DOUBLE_BOARDER style"); break;
			case 3 : write_window(3,3,"This is the 3 or SIG_DUB_BOARDER style"); break;
			case 4 : write_window(3,3,"This is the 4 or DUB_SIG_BOARDER style"); break;
		}
		write_window(15,6," HIT ANY KEY ");
		bioskey(0);
	}
	for(;;)
	{
		char_boarder = random(255);
		if(char_boarder < 15)
		{
			char_boarder = char_boarder + 15;
		}
		popup_window(24,20,10,60,15,5,2,14,2,1,8,0,char_boarder,0);
		write_window(15,3," HIT ANY KEY ");
		delay(700);
		if(bioskey(1))
		{
			bioskey(0);
			unpopup_window(24);
			break;
		}
	}
	uncall_window(DEMO_TEXT);
	display_switch = 0;
	return(0);
}

int enter_demo(void)
{
	int int_data = 0,date[3] = {4,1,94},j,i,done = 0,pick;
	long int long_data = 0;
	char enter_string[30] = "";

	creat_file("edit.tem");
	read_file(edit_buff,"edit.tem",(22 * 80),0L);
	call_window(DEMO_TEXT);
	call_menu(ENTER_MENU,10,5);
	write_window(25,16," HIT ANY KEY ");
	save_screen(4);
	bioskey(0);
	show_cursor();
	for(i = 0;i < 5;i++)
	{
		popup_window(24,20,10,60,15,o_data.data[6][0],o_data.data[6][1],
			o_data.data[6][2],o_data.data[6][3],o_data.data[6][4],
			o_data.data[6][5],o_data.data[6][6],o_data.data[6][7],0);
		switch(i)
		{
			case 0 : write_window(3,3,"Enter Int :");
				 get_int(&int_data,4,16,3);
				 write_window(3,4,"You entered %d",int_data);
				 break;
			case 1 : write_window(3,3,"Enter Long :");
				 get_long(&long_data,8,17,3);
				 write_window(3,4,"You entered %ld",long_data);
				 break;
			case 2 : write_window(3,3,"Enter String :");
				 get_string(enter_string,"          --        ","**********  ********",18,3,1,0);
				 write_window(3,4,"You entered %s",enter_string);
				 break;
			case 3 : write_window(3,3,"Enter date :");
				 get_int_date(date,16,3);
				 write_window(3,4,"You enterd %d %d %d",date[0],date[1],date[2]);
				 break;
			case 4 : write_window(3,3,"Chose Y/N ?");
				 if(get_choice(15,3,"Y"))
				 {
					write_window(3,4,"You choose YES");
				 }
				 else
				 {
					write_window(3,4,"You coose NO");
				 }
				 break;
		}
		write_window(15,5," HIT ANY KEY ");
		bioskey(0);
		clear_window(0);
	}
	load_screen(4);
	call_window(EDIT_WIN);
	call_menu(EDIT_MENU,10,8);
	write_window(33,25," HIT ANY KEY ");
	bioskey(0);

/*************************************************************************

	this code is a full screen editor with edit_string()

**************************************************************************/
	clear_window(0);
	for(i = 0;i < 22;i++)
	{
		write_window(3,3 + i,"%s",edit_buff + (80 * i));
	}
	i = 0;
	while(done == 0)
	{
		write_window(31,25," F1 Help F2 Quit ");
		if((bioskey(2) & 0x0080) == 128)
		{
			write_window(3,2,"Insert");
		}
		else
		{
			write_window(3,2,"      ");
		}
		pick = edit_string(edit_buff + (80 * i),
			"***************************************************************************",
			3,3 + i,"TP");
		switch(pick)
		{
			case 0 : i = i + 1; break;
			case ALT_I : for(j = 20;j > i;j--)
				     {
					memmove(edit_buff + (80 * (j + 1)),edit_buff + (80 * j),80);
				     }
				     memset(edit_buff + (80 * (i + 1)),0,80);
				     clear_window(0);
				     for(j = 0;j < 22;j++)
				     {
					write_window(3,3 + j,"%s",edit_buff + (80 * j));
				     }
				     i = i + 1; 
				     break;
			case ESC : clear_window(0);
				   return(0);
			case CURSOR_UP : i = i - 1; break;
			case CURSOR_DN : i = i + 1; break;
			case F2 : done = data_ok(); 
				  if(done == 0)
				  {
					read_file(edit_buff,"edit.tem",22 * 80,0L);
					clear_window(0);
					for(j = 0;j < 22;j++)
					{
						write_window(3,3 + j,"%s",edit_buff + (80 * j));
					}
				  }
				  break;
			case F1 : save_screen_buff();
				  clear_window(0);
				  call_menu(EDIT_MENU,10,8);
				  write_window(31,25,"   HIT ANY KEY   ");
				  bioskey(0);
				  load_screen_buff();
				  break;
			case ALT_D : for(j = i;j < 22;j++)
				     {
					memmove(edit_buff + (80 * j),edit_buff + (80 * (j + 1)),80);
				     }
				     memset(edit_buff + (80 * 21),0,80);
				     clear_window(0);
				     for(j = 0;j < 22;j++)
				     {
					write_window(3,3 + j,"%s",edit_buff + (80 * j));
				     }
				     break;
		}
		if(i > 21)
		{
			i = 21;
		}
		if(i < 0)
		{
			i = 0;
		}
	}

/**************************************************************************/

	write_file(edit_buff,"edit.tem",(22 * 80),0L);
	clear_window(0);
	popup_window(24,50,20,78,22,1,2,15,4,1,8,0,0,0);
	write_window(3,2,"Display Changes Y/N ?");
	if(get_choice(25,2,"Y"))
	{
		unpopup_window(24);
		for(i = 0;i < 22;i++)
		{
			write_window(3,3 + i,"%s",edit_buff + (80 * i));
		}
		write_window(31,25,"   HIT ANY KEY   ");
		bioskey(0);
	}
	hide_cursor();
	unpopup_window(24);
	uncall_window(EDIT_WIN);
	uncall_window(DEMO_TEXT);
	display_switch = 0;
	return(0);
}

/**************************************************************************

	this modual is a typical select y/n

************************************************************************/

int data_ok(void)
{
	popup_window(24,50,20,69,22,o_data.data[5][0],o_data.data[5][1],o_data.data[5][2],
		o_data.data[5][3],o_data.data[5][4],o_data.data[5][5],o_data.data[5][6],
		o_data.data[5][7],0);
	write_window(3,2,"Data OK Y/N ?");
	if(get_choice(17,2,"Y"))
	{
		unpopup_window(24);
		return(1);
	}
	unpopup_window(24);
	return(0);
}

int scr_form(void)
{
	int i,data[10],j,y,total[10];
	char name[9][15] = {"Don","Ted","Sue","Mary","Bruce","Mike","Sam","Paul","John"};

	call_window(DEMO_TEXT);
	for(j = 0;j < 10;j++)
	{
		total[j] = 0;
	}
	call_menu(SCREEN_MENU,9,6);
	write_window(25,16," HIT ANY KEY ");
	bioskey(0);
/*********************************************************************

	this code draws a form on screen

*********************************************************************/
	call_window(EDIT_WIN);
	load_screen_form(1,"simptut.scr");
	write_window(33,25," HIT ANY KEY ");
	bioskey(0);
	y = 6;
	for(i = 0;i < 9;i++)
	{
		for(j = 0;j < 10;j++)
		{
			data[j] = random(100);
		}
		write_window(4,y,"%-s",name[i]);
		write_window(17,y,"%2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d",
			data[0],data[1],data[2],data[3],data[4],data[5],data[6],
			data[7],data[8],data[9]);
		for(j = 0;j < 10;j++)
		{
			total[j] = total[j] + data[j];
		}
		y = y + 2;
	}
	write_window(16,24,"%3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d",
		total[0],total[1],total[2],total[3],total[4],total[5],total[6],total[7],
		total[8],total[9]);
	bioskey(0);

	call_window(DEMO_TEXT);
	call_menu(FORM_MENU,9,6);
	write_window(25,16," HIT ANY KEY ");
	bioskey(0);

/*************************************************************************

	this code loads a print form and prints it

**************************************************************************/

	load_form(0,"simptut.prn");
	y = 6;
	for(i = 0;i < 10;i++)
	{
		total[i] = 0;
	}
	for(i = 0;i < 9;i++)
	{
		for(j = 0;j < 10;j++)
		{
			data[j] = random(100);
		}
		print_printf(4,y,"%s",name[i]);
		print_printf(17,y,"%2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d   %2d",
			data[0],data[1],data[2],data[3],data[4],data[5],data[6],
			data[7],data[8],data[9]);
		for(j = 0;j < 10;j++)
		{
			total[j] = total[j] + data[j];
		}
		y = y + 2;
	}
	print_printf(16,24,"%3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d  %3d",
		 total[0],total[1],total[2],total[3],total[4],total[5],total[6],
		 total[7],total[8],total[9]);
	popup_window(24,30,10,55,13,o_data.data[5][0],o_data.data[5][1],o_data.data[5][2],
		o_data.data[5][3],o_data.data[5][4],o_data.data[5][5],
		o_data.data[5][6],o_data.data[5][7],0);

	if(print_char(0x0c) != 0)
	{
		clear_window(0);
		write_window(8,2,"Printer error !");
		bioskey(0);
		unpopup_window(24);
		uncall_window(DEMO_TEXT);
		uncall_window(EDIT_WIN);
		return(0);
	}
	write_window(5,2,"Align Paper Now !");
	write_window(8,3,"HIT ANY KEY");
	bioskey(0);
	clear_window(0);
	write_window(8,2,"PRINTING!");
	if(print_buff() != 0)
	{
		clear_window(0);
		write_window(8,2,"Printer error !");
		bioskey(0);
	}
	unpopup_window(24);
	uncall_window(DEMO_TEXT);
	uncall_window(EDIT_WIN);
	display_switch = 0;
	return(0);
}

int song_demo(void)
{
	call_window(DEMO_TEXT);
	call_menu(SONG_MENU,10,6);
	write_window(25,16," HIT ANY KEY ");
	bioskey(0);
	while(playsong(0,"simptut.sng") == 0)
	{}
	while(playsong(0,"little.sng") == 0)
	{}
	uncall_window(DEMO_TEXT);
	display_switch = 0;
	return(0);
}

/***********************************************************************

	this modual shows how to use load_text()

*************************************************************************/

void view_text(int file_num)
{
	char lable[4][20] = {" GENRAL INFO "," FUTURE "," SUPPORT "," QUARKS "};

	call_window(EDIT_WIN);
	write_window((80 - strlen(lable[file_num]) - 2) / 2,1," %s ",lable[file_num]);
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	switch(file_num)
	{
		case 0 : load_text(0,"simptext.men");
			 bioskey(0);
			 clear_window(0);
			 load_text(1,"simptext.men");
			 bioskey(0);
			 break;
		case 1 : load_text(4,"simptext.men");
			 bioskey(0);
			 break;
		case 2 : load_text(5,"simptext.men");
			 bioskey(0);
			 break;
		case 3 : load_text(6,"simptext.men");
			 bioskey(0);
			 break;
		case 4 : load_text(7,"simptext.men");
			 bioskey(0);
			 break;
	}
	uncall_window(EDIT_WIN);
	display_switch = 0;
}

int reg_form(void)
{
	char data_string[6][30] = {"","","","","",""};
	int data_quant[6] = {0,0,0,0,0,0};
	int done = 0,i = 0,pick;
	int j;
	float price[6] = {0,0,0,0,0,0};
	float total_price = 0;
	int total_quant = 0;
	float sub_total_price = 0;
	float total_s_h = 0L;

	call_window(EDIT_WIN);
	load_text(18,"simptut.men");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	clear_window(0);
	load_text(19,"simptut.men");
	while(done == 0)
	{
		show_cursor();
		switch(i)
		{
			case 0 : pick = edit_string(data_string[0],
					"****************************",13,2,"TAP");
				 break;
			case 1 : pick = edit_string(data_string[1],
					"****************************",13,4,"TAP");
				 break;
			case 2 : pick = edit_string(data_string[2],
					"****************************",13,5,"TAP");
				 break;
			case 3 : pick = edit_string(data_string[3],
					"****************************",13,6,"TAP");
				 break;
			case 4 : pick = edit_string(data_string[4],
					"############",13,9,"TAP");
				 break;
			case 5 : pick = edit_string(data_string[5],
					"****************",20,10,"TAP");
				 break;
		}
		switch(pick)
		{
			case ESC : done = 1; break;
			case CURSOR_UP : i = i - 1; break;
			case CURSOR_DN : i = i + 1; break;
			case 0 : i = i + 1; break;
		}
		if(i == 6)
		{
			if((done = data_ok()) == 0)
			{
				i = 0;
			}
		}
	}
	clear_window(0);
	load_text(20,"simptut.men");
	done = 0;
	i = 0;
	while(done == 0)
	{
		show_cursor();
		get_int(&data_quant[i],2,34,i + 5);
		switch(i)
		{
			case 5 : price[5] = data_quant[5] * 100.00; break;
			default : price[i] = data_quant[i] * 25.00; break;
		}
		i++;
		if(i == 6)
		{
			total_quant = 0;
			total_price = 0;
                        sub_total_price = 0;
			for(j = 0;j < 6;j++)
			{
				write_window(51,5 + j,"%8.2f",price[j]);
				sub_total_price = price[j] + sub_total_price;
				total_quant = data_quant[j] + total_quant;
				total_s_h = total_quant * 3.00;
				if(total_s_h > 50.00)
				{
					total_s_h = 50.00;
				}
				total_price = sub_total_price + total_s_h;
			}
			write_window(34,12,"%-3d",total_quant);
			write_window(51,12,"%8.2f",sub_total_price);
			write_window(51,13,"%8.2f",total_s_h);
			write_window(50,15,"%9.2f",total_price);
			if((done = data_ok()) == 0)
			{
				i = 0;
			}
		}
	}
	hide_cursor();
	load_form(1,"simptut.prn");
	print_printf(13,18,"%s",data_string[0]);
	print_printf(13,20,"%s",data_string[1]);
	print_printf(13,21,"%s",data_string[2]);
	print_printf(13,22,"%s",data_string[3]);
	print_printf(13,25,"%s",data_string[4]);
	print_printf(21,27,"%s",data_string[5]);
	for(i = 0;i < 6;i++)
	{
		print_printf(36,36 + i,"%2d",data_quant[i]);
		print_printf(53,36 + i,"%8.2f",price[i]);
	}
	print_printf(36,43,"%-4d",total_quant);
	print_printf(53,43,"%8.2f",sub_total_price);
	print_printf(53,44,"%8.2f",total_s_h);
	print_printf(52,46,"%9.2f",total_price);
	popup_window(24,30,10,55,13,o_data.data[5][0],o_data.data[5][1],o_data.data[5][2],
		o_data.data[5][3],o_data.data[5][4],o_data.data[5][5],
		o_data.data[5][6],o_data.data[5][7],0);
	if(print_char(0x0c) != 0)
	{
		clear_window(0);
		write_window(4,2,"Printer error !");
		bioskey(0);
		unpopup_window(24);
		uncall_window(EDIT_WIN);
		return(0);
	}
	write_window(4,2,"Align Paper Now !");
	write_window(5,3,"HIT ANY KEY");
	bioskey(0);
	clear_window(0);
	write_window(8,2,"PRINTING!");
	if(print_buff() != 0)
	{
		clear_window(0);
		write_window(4,2,"Printer error !");
		bioskey(0);
	}
	unpopup_window(24);
	uncall_window(EDIT_WIN);
	display_switch = 0;
	return(0);
}

void view_tut(int file_num,char *lable)
{
	call_window(EDIT_WIN);
	textcolor(14);
	write_window((80 - strlen(lable) - 2) / 2,1," %s ",lable);
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	load_text(file_num,"stuttext.men");
	bioskey(0);
	uncall_window(EDIT_WIN);
}

/***************************************************************************

	this modual reads a text file and displays it on the screen

**************************************************************************/

void reed_text(char *file_name)
{
	call_window(EDIT_WIN);
	write_window((80 - strlen(file_name) - 2) / 2,1," %s ",file_name);
	write_window((80 - strlen("PGUP/PGDN ESC ")) / 2,25," PGUP/PGDN ESC ");
	read_text(file_name,0);
	uncall_window(EDIT_WIN);
	display_switch = 0;
}

/*************************************************************************

	this modual is the parameter selects for the option fungtion

**************************************************************************/

int option_menu(void)
{
	int done = 0,i = 0,j ,k,oldi = 7,choice,pick,mousex = 0,mousey = 0;
	char lable[9][15] = {" DESK TOP "," FULL TEXT "," MENU "," PULL DOWN "," TEXT ",
				" EXIT "," ENTERY "," Highlite"," Hot key"};

	popup_window(25,1,1,80,25,1,0,0,7,1,0,0,0,0);
	write_window(35,1," OPTIONS ");
	for(i = 11;i < 19;i++)
	{
		call_window(i);
		if(i == 18)
		{
			write_window(2,1,"%s",lable[7]);
		}
		else
		{
			write_window(3,1,"%s",lable[i - 11]);
		}
		if(i == 14)
		{
			write_window(3,3,"%s",lable[8]);
			textcolor(o_data.hk_color);
			write_window(4,3,"H");
		}
	}
	simp_window(44,5,52,13,0,0,0,0,0,0,0,0,0);
	window(1,1,80,25);
	k = 0;
	for(i = 0;i < 9;i++)
	{
		for(j = 0;j < 9;j++)
		{
			switch(i)
			{
				case 1 :
				case 3 :
				case 5 :
				case 7 : textbackground(0);
					 textcolor(k);
					 gotoxy(j + 44,i + 5);
					 switch(j)
					 {
						case 1 :
						case 3 :
						case 5 :
						case 7 : putch(219);
							 k = k + 1;
							 break;
					 }
			}
		}
	}
	textattr(0 + (7<<4));
	write_window(44,3,"Change window:");
	call_menu(OPT_MENU_1,59,6);
	call_menu(OPT_MENU_2,42,18);
	write_window(5,22,"Load colors");
	write_window(5,23,"eXit");
	textcolor(o_data.hk_color);
	write_window(5,22,"L");
	write_window(6,23,"X");
	write_window(59,3,"%s",lable[win_num]);
	save_screen_buff();
	i = 0;
	moushow();
	while(done == 0)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 43) & (mousex < 60) & (mousey == 3))
			{
				i = 0;
			}
			else if((mousex > 58) & (mousex < 68) & (mousey == 6))
			{
				i = 1;
			}
			else if((mousex > 58) & (mousex < 68) & (mousey == 11))
			{
				i = 2;
			}
			else if((mousex > 48) & (mousex < 57) & (mousey == 18))
			{
				i = 3;
			}
			else if((mousex > 4) & (mousex < 18))
			{
				switch(mousey)
				{
					case 22 : i = 4; break;
					case 23 : i = 5; break;
				}
			}

		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 7; break;
				case ENTER : choice = 1; break;
				case ALT_L : choice = 6; break;
				case ALT_X : choice = 7; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		else if(i > 5)
		{
			i = 5;
		}
		if(oldi != i)
		{
			mouhide();
			load_screen_buff();
			oldi = i;
			switch(i)
			{
				case 0 : simp_window(43,3,58,3,0,0,14,1,1,8,0,0,0);
					 write_window(2,1,"Change window:");
					 break;
				case 1 : simp_window(58,6,67,6,0,0,14,1,1,8,0,0,0);
					 write_window(2,1,"Boarder:");
					 break;
				case 2 : simp_window(58,11,66,11,0,0,14,1,1,8,0,0,0);
					 write_window(2,1,"Shadow:");
					 break;
				case 3 : simp_window(48,18,55,18,0,0,14,1,1,8,0,0,0);
					 write_window(2,1,"Colors");
					 break;
				case 4 : simp_window(4,22,16,22,0,0,14,1,1,8,0,0,0);
					 write_window(2,1,"Load colors");
					 break;
				case 5 : simp_window(4,23,9,23,0,0,14,1,1,8,0,0,0);
					 write_window(2,1,"eXit");
					 break;
			}
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if(((mousex > 43) & (mousex < 60) & (mousey == 3)) |
				((mousex > 58) & (mousex < 68) & ((mousey == 6) | (mousey == 11))) |
				((mousex > 48) & (mousex < 57) & (mousey == 18)) |
				((mousex > 4) & (mousex < 18) & ((mousey == 23) | (mousey == 22))))
			{
				choice = 1;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : win_num = change_window(lable); break;
		case 3 : while(boarder_select()){} break;
		case 4 : while(shadow_select()){} break;
		case 5 : while(get_color()){} break;
		case 6 : pick = save_option(0); break;
		case 7 : pick = 0; break;
	}
	display_switch = 0;
	unpopup_window(25);
	return(pick);
}

int save_option(int save_switch)
{
	char file_name[257] = "*.opt";
	char file_buff[15][13] = {"","","","","","","","","","","","","","",""};
	int i,oldi = 18,choice,count,mousex = 0,mousey = 0;

	if(save_switch)
	{
		load_screen(3);
	}

/*****************************************************************************

	this code reads a enter directory and displays it for selection

****************************************************************************/

	popup_window(22,45,3,75,5,1,2,0,7,1,8,0,0,0);
	if(get_string(file_name,"                  ","******************",3,2,1,1) == 27)
	{
		unpopup_window(22);
		return(0);
	}
	if(strcmp(file_name,"*.opt") == 0)
	{
		popup_window(23,45,7,65,23,1,2,0,7,1,8,0,0,0);
		read_directory(file_buff[0],15,file_name);
		count = 0;
		for(i = 0;i < 15;i++)
		{
			if(strcmp(file_buff[0],"") == 0)
			{
				unpopup_window(23);
				return(0);
			}
			if(strcmp(file_buff[i],"") != 0)
			{
				write_window(3,2 + i,"%s",file_buff[i]);
				count = count + 1;
			}
		}
		count = count - 1;

/****************************************************************************        

	this code selects a file name

****************************************************************************/

		save_screen_buff();
		i = 0;
		moushow();
		for(;;)
		{
			choice = 0;
			if(mouposition(&mousex,&mousey))
			{
				if((mousex > 46) & (mousex < 65))
				{
					i = mousey - 8;
				}
			}
			if(bioskey(1) | (mou_switch == 0))
			{
				switch(bioskey(0))
				{
					case ESC : choice = 18; break;
					case ENTER : choice = 1; break;
					case CURSOR_UP : i = i - 1; break;
					case CURSOR_DN : i = i + 1; break;
				}
			}
			if(i < 0)
			{
				i = 0;
			}
			if(i > count)
			{
				i = count;
			}
			if(oldi != i)
			{
				oldi = i;
				mouhide();
				load_screen_buff();
				simp_window(46,8 + i,64,i + 8,0,2,14,1,1,8,0,0,0);
				write_window(2,1,"%s",file_buff[i]);
				moushow();
			}
			if(moubuttonpressed(LEFTBUTTON))
			{
				if((mousex > 46) & (mousex < 65) & (mousey > 7) & (mousey < 23))
				{
					choice = 1;
				}
				else
				{
					choice = 18;
				}
			}
			if(choice != 0)
			{
				break;
			}
		}
		mouhide();
		load_screen_buff();
		unpopup_window(23);
		if(choice == 1)
		{
			strcpy(file_name,file_buff[i]);
		}
	}

/****************************************************************************/

	unpopup_window(22);
	if(strcmp(file_name,"") == 0)
	{
		return(0);
	}
	else
	{
		strtok(file_name,".");
		strcat(file_name,".opt");
	}
	if(save_switch == 0)
	{
		read_file(&o_data,file_name,sizeof(O_DATA),0L);
		save_data();
	}
	else
	{
		creat_file(file_name);
		creat_file("simptut.sys");
		write_file(&o_data,file_name,sizeof(O_DATA),0L);
		write_file(&o_data,"simptut.sys",sizeof(O_DATA),0L);
	}
	display_switch = 0;
	return(0);
}

int o_menu(void)
{
	int pick,choice,i = 0,old_i = 8,mousex = 0,mousey = 0;
	char lable[4][15] = {"Graphics","Fonts","Printer Port","Save options"};

	if(display_switch)
	{
		load_screen(2);
		call_window(OPT_WIN);
		call_menu(OPT_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(o_data.hk_color);
	write_window(3,2,"G");
	write_window(3,3,"F");
	write_window(3,4,"P");
	write_window(3,5,"S");
	save_screen_buff();
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 33) & (mousex < 48))
			{
				i = mousey - 5;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ALT_G : choice = 2; break;
				case ALT_F : choice = 3; break;
				case ALT_P : choice = 4; break;
				case ALT_S : choice = 5;
				case ENTER : choice = 1; break;
				case ESC : choice = 6; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(old_i != i)
		{
			mouhide();
			load_screen_buff();
			old_i = i;
			simp_window(33,5 + i,46,5 + i,o_data.data[7][0],o_data.data[7][1],
				o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
				o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 33) & (mousex < 48) & (mousey > 4) & (mousey < 9))
			{
				choice = 1;
			}
			else
			{
				choice = 6;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}


	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : while(option_menu()){} break;
		case 3 : font_demo(); 
			 pick = 2;
			 break;
		case 4 : get_port(); 
			 pick = 3;
			 break;
		case 5 : save_option(1); 
			 pick = 3;
			 break;
		case 6 : pick = 0; break;
	}
	if((choice == 3) | (choice == 2))
	{
		if((pick == 2) | (pick == 1))
		{
			strcpy(font_string,"swloadft ");
			strcat(font_string,o_data.font);
			system(font_string);
		}
		if(pick == 1)
		{
			simp_window(1,1,80,25,o_data.data[0][0],o_data.data[0][1],o_data.data[0][2],
				o_data.data[0][3],o_data.data[0][4],o_data.data[0][5],
				o_data.data[0][6],o_data.data[0][7],0);
			load_screen_form(0,"simptut.scr");
			save_screen(1);
			call_window(MAIN_WIN);
			call_menu(MAIN_MENU,3,2);
			save_screen(2);
			display_switch = 1;
		}
	}
	else
	{
		display_switch = 0;
	}
	return(pick);
}

void get_port(void)
{
	load_screen(3);
	call_window(ENTER_WIN);
	write_window(3,2,"Enter LP port number:");
	get_int(&port_number,1,25,2);
	uncall_window(ENTER_WIN);
	if((port_number > 4) | (port_number < 1))
	{
		port_number = 0;
	}
	o_data.port = port_number;
}

int change_window(char lable[9][15])
{
	int i,choice,oldi = 12,mousex = 0,mousey = 0;


	call_window(20);
	for(i = 0;i < 9;i++)
	{
		write_window(3,2 + i,"%s",lable[i]);
	}
	i = 0;
	save_screen_buff();
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 40) & (mousex < 55))
			{
				i = mousey - 6;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 8)
		{
			i = 8;
		}
		if(oldi != i)
		{
			oldi = i;
			mouhide();
			load_screen_buff();
			simp_window(41,6 + i,54,6 + i,0,2,14,1,1,8,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 40) & (mousex < 55) & (mousey > 5) & (mousey < 15))
			{
				choice = 1;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	uncall_window(20);
	if(choice == 1)
	{
		choice = i;
	}
	if(choice == 9)
	{
		choice = 0;
	}
	return(choice);
}

int boarder_select(void)
{
	int i = 0,choice,oldi = 4,mousex = 0,mousey = 0;
	char lable[4][20] = {"No boarser","Single boarder","Double boarder","Any boarder"};

	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 61) & (mousex < 79))
			{
				i = mousey - 7;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 6; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(oldi != i)
		{
			mouhide();
			load_screen_buff();
			oldi = i;
			simp_window(61,7 + i,77,7 + i,0,2,14,1,1,8,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 61) & (mousex < 79) & (mousey > 6) & (mousey < 11))
			{
				choice = 1;
			}
			else
			{
				choice = 6;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : o_data.data[win_num][0] = 0; break;
		case 3 : o_data.data[win_num][0] = 1; break;
		case 4 : o_data.data[win_num][0] = 2; break;
		case 5 : o_data.data[win_num][0] = 5;
			 popup_window(26,30,10,57,12,1,2,0,7,1,8,0,0,0);
			 write_window(3,2,"Enter ASCII code:");
			 show_cursor();
			 if(get_int(&o_data.data[win_num][7],3,22,2) == 1)
			 {
				o_data.data[win_num][7] = 0;
			 }
			 hide_cursor();
			 unpopup_window(26);
			 break;
		case 6 : return(0);

	}
	save_data();
	return(0);
}

/****************************************************************************

	this modual save the program system file

*******************************************************************************/

void save_data(void)
{
	int i,temp;

	temp = win_num;
	for(i = 0;i < 8;i++)
	{
		win_num = i;
		switch(win_num)
		{
			case 0 : write_data(11); break;
			case 1 : write_data(7);
				 write_data(10);
				 write_data(12);
				 break;
			case 2 : write_data(1);
				 write_data(13);
				 break;
			case 3 : write_data(2);
				 write_data(3);
				 write_data(4);
				 write_data(5);
				 write_data(19);
				 write_data(14);
				 write_data(21);
				 break;
			case 4 : write_data(8);
				 write_data(15);
				 break;
			case 5 : write_data(6);
				 write_data(16);
				 break;
			case 6 : write_data(9);
				 write_data(17);
				 break;
			case 7 : write_data(18); break;
		}
	}
	win_num = temp;
}

int shadow_select(void)
{
	int choice,oldi = 10,i = 0,mousex = 0,mousey = 0;
	char lable[8][20] = {"No shadow","Wide shadow","Narrow shadow","",
				"Upper left","Lower left","Upper right","Lower right"};

	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 61) & (mousex < 76))
			{
				i = mousey - 12;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 10; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if((i == 3) & (oldi < 3))
		{
			i = 4;
		}
		if((i == 3) & (oldi > 3))
		{
			i = 2;
		}
		if(i > 7)
		{
			i = 7;
		}
		if(oldi != i)
		{
			mouhide();
			load_screen_buff();
			oldi = i;
			switch(i)
			{
				case 0 :
				case 1 :
				case 2 : simp_window(61,12 + i,77,12 + i,0,2,14,1,1,8,0,0,0);
					 write_window(2,1,"%s",lable[i]);
					 break;
				case 4 :
				case 5 :
				case 6 :
				case 7 : simp_window(64,12 + i,77,12 + i,0,2,14,1,1,8,0,0,0);
					 write_window(2,1,"%s",lable[i]);
					 break;
			}
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			switch(i)
			{
				case 0 :
				case 1 :
				case 2 : if((mousex > 61) & (mousex < 79))
					 {
						choice = 1;
					 }
				case 4 :
				case 5 :
				case 6 :
				case 7 : if((mousex > 64) & (mousex < 79))
					 {
						choice = 1;
					 }
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : o_data.data[win_num][1] = 0; break;
		case 3 : o_data.data[win_num][1] = 1; break;
		case 4 : o_data.data[win_num][1] = 2; break;
		case 6 : o_data.data[win_num][4] = 2; break;
		case 7 : o_data.data[win_num][4] = 1; break;
		case 8 : o_data.data[win_num][4] = 4; break;
		case 9 : o_data.data[win_num][4] = 3; break;
		case 10 : return(0);
	}
	save_data();
	return(0);
}

int color_select(void)
{
	int choice,i = 0,oldi = 18,mousex = 0,mousey = 0;

	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			switch(mousex)
			{
				case 45 : switch(mousey)
					  {
						case 6 : i = 0; break;
						case 8 : i = 4; break;
						case 10 : i = 8; break;
						case 12 : i = 12; break;
					  }
					  break;
				case 47 : switch(mousey)
					  {
						case 6 : i = 1; break;
						case 8 : i = 5; break;
						case 10 : i = 9; break;
						case 12 : i = 13; break;
					  }
					  break;
				case 49 : switch(mousey)
					  {
						case 6 : i = 2; break;
						case 8 : i = 6; break;
						case 10 : i = 10; break;
						case 12 : i = 14; break;
					  }
					  break;
				case 51 : switch(mousey)
					  {
						case 6 : i = 3; break;
						case 8 : i = 7; break;
						case 10 : i = 11; break;
						case 12 : i = 15; break;
					  }
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 18; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 4; break;
				case CURSOR_DN : i = i + 4; break;
				case CURSOR_LEFT : i = i - 1; break;
				case CURSOR_RIGHT : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 15)
		{
			i = 15;
		}
		if(oldi != i)
		{
			mouhide();
			load_screen_buff();
			oldi = i;
			switch(i)
			{
				case 0 : simp_window(44,5,46,7,0,0,0,15,0,0,0,0,0); break;
				case 1 : simp_window(46,5,48,7,0,0,1,8,0,0,0,0,0); break;
				case 2 : simp_window(48,5,50,7,0,0,2,8,0,0,0,0,0); break;
				case 3 : simp_window(50,5,52,7,0,0,3,8,0,0,0,0,0); break;
				case 4 : simp_window(44,7,46,9,0,0,4,8,0,0,0,0,0); break;
				case 5 : simp_window(46,7,48,9,0,0,5,8,0,0,0,0,0); break;
				case 6 : simp_window(48,7,50,9,0,0,6,8,0,0,0,0,0); break;
				case 7 : simp_window(50,7,52,9,0,0,7,8,0,0,0,0,0); break;
				case 8 : simp_window(44,9,46,11,0,0,8,8,0,0,0,0,0); break;
				case 9 : simp_window(46,9,48,11,0,0,9,8,0,0,0,0,0); break;
				case 10 : simp_window(48,9,50,11,0,0,10,8,0,0,0,0,0); break;
				case 11 : simp_window(50,9,52,11,0,0,11,8,0,0,0,0,0); break;
				case 12 : simp_window(44,11,46,13,0,0,12,8,0,0,0,0,0); break;
				case 13 : simp_window(46,11,48,13,0,0,13,8,0,0,0,0,0); break;
				case 14 : simp_window(48,11,50,13,0,0,14,8,0,0,0,0,0); break;
				case 15 : simp_window(50,11,52,13,0,0,15,8,0,0,0,0,0); break;
			}
			gotoxy(2,2);
			putch(219);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 44) & (mousex < 52) & (mousey > 5) & (mousey < 13))
			{
				choice = 1;
			}
			else
			{
				choice = 18;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		color_code = i;
	}
	return(0);
}

/***************************************************************************

	this code changes the window parameters with option

***************************************************************************/

void write_data(int record)
{
	write_file(o_data.data[win_num],"win.dat",16,(4056L * record) + 4036);
}

int get_color(void)
{
	int choice,i = 0,oldi = 7,mousex = 0,mousey = 0;
	char lable[5][20] = {"Foreground","Background","","Foreground","Background"};

	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 43) & (mousex < 54))
			{
				i = mousey - 20;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 7; break;
				case ENTER : choice = 1; break;
				case CURSOR_UP : i = i - 1; break;
				case CURSOR_DN : i = i + 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 4)
		{
			i = 4;
		}
		if((oldi > i) & (i == 2))
		{
			i = 1;
		}
		if((oldi < i) & (i == 2))
		{
			i = 3;
		}
		if(oldi != i)
		{
			mouhide();
			load_screen_buff();
			oldi = i;
			if(i != 2)
			{
				simp_window(46,i + 20,59,i + 20,0,2,14,1,1,8,0,0,0);
				write_window(2,1,"%s",lable[i]);
			}
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 43) & (mousex < 54))
			{
				switch(mousey)
				{
					case 20 :
					case 21 :
					case 22 :
					case 23 : choice = 1; break;
					default : choice = 7; break;
				}
			}
			else
			{
				choice = 7;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 :
		case 3 :
		case 5 :
		case 6 : color_select();
			 o_data.data[win_num][choice] = color_code;
			 if(win_num == 8)
			 {
				o_data.hk_color = color_code;
			 }
			 break;
		case 7 : return(0);
	}
	save_data();
	return(1);
}


int mou_menu(void)
{
	int pick,choice,i = 0,old_i = 18,mousex = 0,mousey = 0;
	char lable[11][22] = {"mouinstalled\(\)","moureset\(\)","moubuttonpressed\(\)",
		"moushow\(\)","mouhide\(\)","moucursortype\(\)",
		"mousetposition\(\)","mousetmaxposition\(\)","moubuttonreleased\(\)",
		"loadcurs\(\)","mouposition\(\)"};

	if(display_switch)
	{
		load_screen(3);
		call_window(21);
		call_menu(17,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	save_screen_buff();
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 19) & (mousex < 46))
			{
				i = mousey - 6;
			}
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 14; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 10)
		{
			i = 10;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(20,6 + i,42,6 + i,o_data.data[7][0],o_data.data[7][1],
			o_data.data[7][2],o_data.data[7][3],o_data.data[7][4],
			o_data.data[7][5],o_data.data[7][6],o_data.data[7][7],0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 19) & (mousex < 46) & (mousey > 5) & (mousey < 18))
			{
				choice = 1;
			}
			else
			{
				choice = 14;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 :
		case 3 :
		case 4 :
		case 5 :
		case 6 :
		case 7 :
		case 8 :
		case 9 :
		case 10 :
		case 11 :
		case 12 : view_tut(i + 53,lable[i]);break;
		case 14 : pick = 0; break;
	}
	display_switch = 0;
	unpopup_window(21);
	return(pick);


}
