/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* dateconv.h  -  header file for date conversions (Gregorian, Julian, etc.) */

#ifndef DATECONV_HEADER
#define DATECONV_HEADER 1

/* Calender -> ? */

char *CaltoGreg(double cal);                /* convert Calendar to Gregorian (US) */
char *CaltoGregEuro(double cal);            /* convert Calendar to Gregorian (Europe) */
char *CaltoGregJap(double cal);             /* convert Calendar to Gregorian (Japan) */
double CaltoJul(double cal);                /* convert Calendar to Julian (Type E) */
double CaltoJulA(double cal);               /* convert Calendar to Julian (Type A) */
double CaltoJulB(double cal);               /* convert Calendar to Julian (Type B) */
double CaltoCalCent(double cal);            /* convert Calendar to Calendar (w/century) */
double CalCenttoCal(double cal);            /* convert Calendar (w/century) to Calendar */

/* struct ddate -> ?   and reverse for non Calendar/Gregorian/Julian */

struct ddate *strtoddate(char *source);     /* convert a string to struct */
struct ddate *fulltoddate(char *source);    /* convert full english string to struct */
struct ddate *shorttoddate(char *source);   /* convert short english string to struct */
char *ddatetostr(struct ddate *source);     /* convert struct to a string */
char *ddatetofull(struct ddate *source);    /* convert struct to a full english string */
char *ddatetoshort(struct ddate *source);   /* convert struct to a short english string */

int dayofyear(struct ddate *d);    /* calc day # of year (1-365) */
int daysleft(struct ddate *d);     /* calc # days left in year (0-365) */
long int diffddate(struct ddate *start, struct ddate *fini);  /* calc fini - start, in days */

/* Gregorian -> ? */

double GregtoCal(char *greg);               /* convert Gregorian (US) to Calendar */
double GregEurotoCal(char *greg);           /* convert Gregorian (Europe) to Calendar */
double GregJaptoCal(char *greg);            /* convert Gregorian (Japan) to Calendar */

double GregtoCalCent(char *greg);           /* convert Gregorian (US) to Calendar (w/century) */
double GregEurotoCalCent(char *greg);       /* convert Gregorian (Europe) to Calendar (w/century) */
double GregJaptoCalCent(char *greg);        /* convert Gregorian (Japan) to Calendar (w/century) */

/* Julian Type E -> ? */

double JultoCal(double jul);                /* convert Julian (Type E) to Calendar */
double JultoCalCent(double jul);            /* convert Julian (Type E) to Calendar (w/century) */
char *JultoGreg(double jul);                /* Julian (Type E) to Gregorian (US) */
char *JultoGregEuro(double jul);            /* Julian (Type E) to Gregorian (Europe) */
char *JultoGregJap(double jul);             /* Julian (Type E) to Gregorian (Japan) */
struct ddate *Jultoddate(double jul);       /* Julian (Type E) to struct */

/* Julian Type A -> ? */

double JulAtoCal(double jul);               /* convert Julian (Type A) to Calendar */
double JulAtoCalCent(double jul);           /* convert Julian (Type A) to Calendar (w/century) */
char *JulAtoGreg(double jul);               /* Julian (Type A) to Gregorian (US) */
char *JulAtoGregEuro(double jul);           /* Julian (Type A) to Gregorian (Europe) */
char *JulAtoGregJap(double jul);            /* Julian (Type A) to Gregorian (Japan) */
struct ddate *JulAtoddate(double jul);      /* Julian (Type A) to struct */

/* Julian Type A -> ? */

double JulBtoCal(double jul);               /* convert Julian (Type B) to Calendar */
double JulBtoCalCent(double jul);           /* convert Julian (Type B) to Calendar (w/century) */
char *JulBtoGreg(double jul);               /* Julian (Type B) to Gregorian (US) */
char *JulBtoGregEuro(double jul);           /* Julian (Type B) to Gregorian (Europe) */
char *JulBtoGregJap(double jul);            /* Julian (Type B) to Gregorian (Japan) */
struct ddate *JulBtoddate(double jul);      /* Julian (Type B) to struct */

#endif              /* DATECONV_HEADER */
