/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* datehk.h  -  header file for DATEHK.C - date routines */

#ifndef DATEHK_HEADER
#define DATEHK_HEADER   1

#include <howard.h>

typedef enum { Sun, Mon, Tues, Wed, Thrus, Fri, Sat } days;
typedef enum { Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec } months;
typedef struct ddate {
            int dyear;             /* Year - 1900 */
            int dday;              /* Day of month (1-31) */
            months dmon;           /* Month (Jan = 0) */
        };
#define DATENULL        "  -  -  "
#define DATECHAR        '-'
#define DATECHARSTR     "-"
#define DATECHARTEST    "/- "
#define BASE_LEAP_YEAR  1980
#define BASE_JUL_YEAR   1720982.0
#define isleap(yr)      isleapyear(yr)

/* function prototypes */
boolean valid_date(int month, int day, int yearnum);  /* check if a date is valid */
boolean isleapyear(int checkyear);          /* is checkyear a leap year */
char *monthexpand(int month);               /* convert # to month name */
boolean isvaliddate(void *check, int id);   /* is d a valid date of type id */

#endif              /* DATEHK_HEADER */
