/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* keyboard.h  -  header file for KEYBOARD.C - keyboard input routines */

#ifndef KEYBOARD_HEADER
#define KEYBOARD_HEADER 1

#include <howard.h>

#define SHIFT_STATUS    *((byte far *) 0x417lu)    /* key shift status */
#define WAITFORKEY          1
#define kbdclear()          clear_typeahead()

/* function prototypes */
byte getk(boolean wait);      /* get key, like getchar() for IBM */
int inkey(boolean wait);      /* get key, returns ASCII + 256 for extended */
int inkeyc(boolean wait);     /* get key, returns ASCII + 256 for extended, all letters are Capitalized */
int inkeydv(boolean wait);    /* get key, returns ASCII + 256 for extended, DESQview aware */
int inkeycdv(boolean wait);   /* get key, returns ASCII + 256 for extended, all letters are Capitalized, DESQview aware */
char getyn(int output);       /* get Yes/No, output = 0: no output */
char getlogical(int output);  /* get True/False, output = 0: no output */
char *getdatehk(void);        /* get date: 11/24/87 */
char *getdouble(void);        /* get double */
char *getint(void);           /* get integer */
char *getreal(int size, int decimal);          /* get real number */
char getc_match(boolean output, char *match);  /* get char, case matters, one of match */
char getci_match(boolean output, char *match); /* get char, case independent, one of match */
char getk_match(boolean output, char *match);  /* get key, one of match */
boolean getpw(int size, char *pw, char c);     /* get a password, max size, display c */
char *getstr(int size, char *pattern);  /* get a string, max size, pattern */
int getget(int col, int row, char *returnstr, int size, char *pattern,
           int argn, int argk[], unsigned flags);   /* get a string, max size, pattern, with editing */
           /* Flags: xxxxxxxx UDJJBLRI = call _idle_get() during keyboard waits, DESQview free time slice, Justify mode, Bell */
           /*                            Left/Right trim on exit, Insert mode on to start */
#ifndef UDFIDLE                 /* also defined in MENUHK.H */
#define UDFIDLE     0x0080      /* call user-defined function during keyboard wait */
#endif
#ifndef DVFREESLICE             /* also defined in MENUHK.H */
#define DVFREESLICE 0x0040      /* free time slice during keyboard wait in DESQview */
#endif
#define JCENTER     0x0030
#define JLEFT       0x0020
#define JRIGHT      0x0010
#define JNONE       0x0000
#define BELL        0x0008
#define TRIMLEFT    0x0004
#define TRIMRIGHT   0x0002
#define INSERTMODE  0x0001
#define TRIMALL     TRIMLEFT|TRIMRIGHT
#define NOFLAGS     0x0000
           
int clear_typeahead(void);      /* clears typeahead buffer, return # keys cleared */
boolean isEnhanceKbd(void);       /* is keyboard the enahnced (100+ key) */
int tocapkey(int k);            /* make keystroke uppercased */
void InsLock(boolean on);       /* toggle Insert on? */
void CapsLock(boolean on);      /* toggle Caps Lock on? */
void NumLock(boolean on);       /* toggle Num Lock on? */
void ScrollLock(boolean on);    /* toggle Scroll Lock on? */
void keyclick(boolean on);      /* turn keyclick on/off (Jr, Convertible only) */
void initkeyvars(void);         /* initialize keyboard variables */
boolean isdate(int c);          /* Character classification macro (0-9 and - /) */
boolean isfilename(int c);      /* Character classification macro (valid in DOS filename) */
boolean ispathname(int c);      /* Character classification macro (valid in DOS filename) */

#endif              /* KEYBOARD_HEADER */
