/* TCHK 2.1 - Howard Kapustein's Turbo C library        6-6-89      */
/* Copyright (C) 1988,1989 Howard Kapustein.  All rights reserved.  */

/* menuhk.h  -  header file for menu routines */

#ifndef MENUHK_HEADER
#define MENUHK_HEADER   1

#include <howard.h>
#include <video.h>

typedef struct popup_field {        /* doubly circular linked list */
                char *command;          /* ptr to command text (string) */
                int y;                  /* y-coord of command on screen */
                char flag;              /* flags, i.e. Disabled, etc. */
                char key;               /* 1-touch key */
                char offset;            /* offset of key in string */
                int retval;             /* value returned when selected ( != 0 ) */
                struct popup_header *submenu;   /* submenu (used in hierarchial menus) */
                struct popup_field *next;       /* next item in list */
                struct popup_field *previous;   /* previous item in list */
            };

typedef struct popup_header {
                char *videosave;                /* ptr to saved video buffer */
                struct text_info inforec;       /* saved video info */
                int left, top, right, bottom;   /* menu coordinates */
                int margc;                      /* menu arguments */
                struct popup_field *margv;      /* ptr to list of menu args (commands) */
                struct popup_field *current;    /* current item hilited */
                char *menusave;                 /* ptr to menu video buffer */
                int colnorm;                    /* Colors:     normal */
                int colcmdkey;                              /* 1-touch command key */
                int colhilite;                              /* hilited/selected item */
                int coldisabled;                            /* disabled command */
                int coldishilite;                           /* hilited disabled item */
                unsigned flags;                 /* Flags: QEFxxxxH = Quit, ESC equals Quit, Free memory on quit, Hierarchial */
                                                /*        xDIRCEDW = DESQview free time slice, case Independent for 1-touch keys, Restore cursor before return */
                                                /*                   return don't hide Cursor, Erase menu on cleanup/free, */
                                                /*                   Disabled not hiliteable, Wraparound */
                char internal;                  /* Internal flags: xxxxxxx1 = 1st time */
            };

typedef struct litebar_field {      /* doubly circular linked list (w/4-way directional) */
                char *command;          /* ptr to command text (string) */
                int x, y;               /* x/y-coord of command on screen (rel to litebar window) */
                char flag;              /* flags, i.e. Disabled, etc. */
                char key;               /* 1-touch key */
                char offset;            /* offset of key in string */
                char *message;          /* ptr to message text (string) */
                int retval;             /* value returned when selected ( != 0 ) */
                struct litebar_header *submenu;   /* submenu (used in hierarchial menus) */
                struct litebar_field *next;       /* next field */
                struct litebar_field *previous;   /* previous field */
                struct litebar_field *left;       /* left item in menu (left arrow) */
                struct litebar_field *right;      /* right item in menu (right arrow) */
                struct litebar_field *up;         /* up item in menu (up arrow) */
                struct litebar_field *down;       /* down item in menu (down arrow) */
            };

typedef struct litebar_header {
                char *videosave;                /* ptr to saved video buffer */
                struct text_info inforec;       /* saved video info */
                int left, top, right, bottom;   /* litebar coordinates */
                int margc;                      /* menu arguments */
                struct litebar_field *margv;    /* ptr to list of menu args (commands) */
                struct litebar_field *current;  /* current item hilited */
                int msgx, msgy;                 /* x/y-coord for message */
                char *menusave;                 /* ptr to menu video buffer */
                struct keylist *quitkey;        /* Quitkey - leave litebar menu */
                int colnorm;                    /* Colors:     normal */
                int colcmdkey;                              /* 1-touch command key */
                int colhilite;                              /* hilited/selected item */
                int coldisabled;                            /* disabled command */
                int coldishilite;                           /* hilited disabled item */
                int colmessage;                             /* message */
                unsigned flags;                 /* Flags: QEFxxxxH = = Quit, ESC equals Quit, Free memory on quit, Hierarchial */
                                                /*        UDIRCEDW = call _idle_menu() during keyboard waits, DESQview free time slice, */
                                                /*                   case Independent for 1-touch keys, Restore cursor before return, */
                                                /*                   don't hide Cursor, Erase menu on cleanup/free, Disabled not hiliteable, */
                                                /*                   Wraparound */
                char internal;                  /* Internal flags: xxxxxxx1 = 1st time */
            };

typedef struct keylist {                    /* linked list of key values (1-512) */
                int keyval;                     /* key code (1-512) */
                struct keylist *next;           /* ptr to next key */
            };

                                /* Header flags */
#define QUITMENU        0x8000                /* quit */
#define ESCQUIT         0x4000                /* ESC equals Quit */
#define FREEMENU        0x2000                /* free memory on quit */
#define HIERARCHIAL     0x0100                /* hierarchial menus */
#ifndef UDFIDLE                               /* also defined in KEYBOARD.H */
#define UDFIDLE         0x0080                /* call user-defined function during keyboard wait */
#endif
#ifndef DVFREESLICE                           /* also defined in KEYBOARD.H */
#define DVFREESLICE     0x0040                /* free time slice during keyboard wait in DESQview */
#endif
#define CASEINDEP       0x0020                /* case independent 1-touch keys */
#define RESTORECURSOR   0x0010                /* restore cursor before returning */
#define CURSORON        0x0008                /* leave curson on (no hide) */
#define ERASEMENU       0x0004                /* erase menu from screen on cleanup */
#define DISABLENOHILITE 0x0002                /* disabled not hiliteable */
#define WRAPAROUND      0x0001                /* wraparound (over top -> bottom) */

                                /* Internal flags (don't muck with these) */
#define FIRSTTIME       0x01                /* first time menu ..._get() is called */

                                /* Command (Field) flags */
#define ENABLED         0x01                /* enabled */
#define DISABLED        0x02                /* disabled */
#define NOTOPTION       0x04                /* not an option (static text) */
#define STATICTEXT      NOTOPTION           /* not an option (static text) */

/* function prototypes */
char menu_lotus(int argc, char cmdkey[], char *command[], int col[],
            char *message[], int msglen[], int normal, int highlite,
            int cmdrow, boolean clockon, int clockrow, int clockcol, int clockcolor);
                        /* lotus slash-bar menu */
void lotus_setup(int argc, byte *command[], char cmdkey[], int col[],
                 byte *message[], int msglen[]);
                        /* generates info needed for menu_lotus */

struct lotus_header *lotus_alloc(int argc, int cmdrow, char *command[], int cmdkey[],
                                 char cmdflag[], char *message[], struct lotus_clock *clk,
                                 int colnorm, int colcmdkey, int colhilite, int coldisable,
                                 int coldishilite, int colmessage, int defaultcommand,
                                 int spacing, unsigned flags);

int menu_popup(int left, int top, int right, int bottom, char frame[],
               char *title, int titlejustify, char *command[], int cmdkey[],
               char cmdflag[], int colframe, int coltitle, int colnorm,
               int colcmdkey, int colhilite, int coldisable, int coldishilite,
               int colnotopt, int defaultcommand, unsigned flags);

struct popup_header *popup_alloc(int left, int top, int right, int bottom, char *frame,
                                 char *title, int titlejustify, char *command[], int cmdkey[],
                                 char cmdflag[], int colframe, int coltitle, int colnorm,
                                 int colcmdkey, int colhilite, int coldisable, int coldishilite,
                                 int colnotopt, int defaultcommand, unsigned flags);
int popup_get(struct popup_header *ph);     /* get menu popup choice */
void popup_free(struct popup_header *ph);   /* free memory allocated by popup header */
void popunlite(struct popup_header *ph);
void pophilite(struct popup_header *ph);
int popup_setcurrent(struct popup_header *ph, int current);     /* set current (hilited) item */
void popup_restore(struct popup_header *ph);            /* restore video */

int menu_litebar(int left, int top, int right, int bottom, char *frame,
                 char *title, int titlejustify, int count, char *command[], int cmdleft[],
                 int cmdright[], int cmdup[], int cmddown[], int cmdkey[], char cmdflag[],
                 int cmdx[], int cmdy[], char *message[], int msgx, int msgy, int argq,
                 int quitkey[], int colframe, int coltitle, int colnorm, int colcmdkey,
                 int colhilite, int coldisable, int coldishilite, int colnotopt,
                 int colmessage, int defaultcommand, unsigned flags);

struct litebar_header *litebar_alloc(int left, int top, int right, int bottom, char *frame,
                                     char *title, int titlejustify, int count, char *command[], int cmdleft[],
                                     int cmdright[], int cmdup[], int cmddown[], int cmdkey[], char cmdflag[],
                                     int cmdx[], int cmdy[], char *message[], int msgx, int msgy, int argq,
                                     int quitkey[], int colframe, int coltitle, int colnorm, int colcmdkey,
                                     int colhilite, int coldisable, int coldishilite, int colnotopt,
                                     int colmessage, int defaultcommand, unsigned flags);
int litebar_get(struct litebar_header *lh);
void litebar_free(struct litebar_header *lh);
void changelitebar(struct litebar_header *lh, struct litebar_field *lf);
void liteunlite(struct litebar_header *lh);
void litehilite(struct litebar_header *lh);
void litemessage(struct litebar_header *lh, int len);
boolean isHiliteable(char cmdtype, unsigned flagparms);

#endif              /* MENUHK_HEADER */
