'**********************************************************
'program DRAWDEMO.BAS
'demonstration of Turbo Basic DRAW command
'requires EGA or CGA adapter
'**********************************************************

CLS : SCREEN 9		'change to SCREEN 2 for CGA

'Loop accepts messages and passes them to subroutine BIGPRINT

DO
  CLS : LOCATE 1,1
  INPUT "Enter text: ", MESSAGE$
  IF MESSAGE$ = "" THEN EXIT LOOP     'exit loop if null entry
  CALL BIGPRINT(1, 100, MESSAGE$)
  LOCATE 24,37
  PRINT "HIT ANY KEY";
  WHILE NOT INSTAT : WEND
LOOP

SCREEN 0
END

'*********************************************************

SUB BIGPRINT(XLOC%, YLOC%, MESSAGE$)

LOCAL MESSAGE.LENGTH%

'Declare and initialize array.  The array is dimensioned 26
'elements long with subscripts 65 thru 90, so that the array
'subscript will match the ASCII code of the corresponding letter.
'Thus, ASC("A") = 65, and the commands to draw an "A" are in
'LETTER$(65)

DIM LETTER$(65:90)

'DRAW commands for letters A thru Z in order

LETTER$(65) = "TA-20 U21 TA-160 U21 D10 TA0 L11"
LETTER$(66) = "U20 R10 F2 D6 G2 L10 R10 F2 D7 G2 L10"
LETTER$(67) = "BU2 F2 R8 E2 BL12 U16 E2 R8 F2"
LETTER$(68) = "U20 R9 F3 D14 G3 L9
LETTER$(69) = "U20 NR10 D10 NR10 D10 R10"
LETTER$(70) = "U20 NR10 D10 R9"
LETTER$(71) = "BU2 F2 R8 E2 U4 NL2 NR2 BD4 BL12 U16 E2 R8 F2"
LETTER$(72) = "U20 D10 R11 U10 D20"
LETTER$(73) = "BR6 R4 BL2 U20 L2 R4"
LETTER$(74) = "BU4 D2 F2 R6 E2 U18 L4 R8"
LETTER$(75) = "U20 D9 TA-35 U11 BD11 TA-137 U15 TA0"
LETTER$(76) = "NU20 R14"
LETTER$(77) = "U20 TA-142 U10 TA-36 U10 TA0 D20"
LETTER$(78) = "U20 TA -155 U22 TA0 U20"
LETTER$(79) = "BU3 U14 E3 R8 F3 D14 G3 L8 H3"
LETTER$(80) = "U20 R10 F2 D6 G2 L10"
LETTER$(81) = "BU3 U14 E3 R8 F3 D14 G1 H2 F4 BH2 G2 L8 H3"
LETTER$(82) = "U20 R10 F2 D6 G2 L10 R4 TA-150 U11 TA0"
LETTER$(83) = "BU3 F3 R6 E3 U4 H3 L6 H3 U4 E3 R6 F3"
LETTER$(84) = "BR8 U20 NL8 R8"
LETTER$(85) = "BU20 D18 F2 R10 E2 U18"
LETTER$(86) = "BU20 TA-160 U22 TA-20 U22 TA0"
LETTER$(87) = "BU20 BL3 TA-170 U20 TA-20 U9 TA-160 U9 TA-10 U20 TA0"
LETTER$(88) = "TA-30 U22 TA0 BL14 TA-150 U22 TA0"
LETTER$(89) = "BR8 U10 NH10 E10"
LETTER$(90) = "BU20 R16 TA150 U23 TA0 R16"

'code begins

MESSAGE.LENGTH% = LEN(MESSAGE$)		'# characters in MESSAGE$

DO UNTIL MESSAGE.LENGTH% = 0

'get the ASCII value of leftmost character in MESSAGE$

	CODE% = ASC(MESSAGE$)		

'convert lower case codes to corresponding upper case codes

	IF CODE% > 96 AND CODE% < 123 THEN CODE% = CODE% - 32

'decrement length and strip off leftmost character

	DECR MESSAGE.LENGTH%			
	MESSAGE$ = RIGHT$(MESSAGE$,MESSAGE.LENGTH%)

'if not uppercase or space, loop

	IF CODE% < 65 OR CODE% > 90 THEN_
		IF CODE% <> 32 THEN GOTO ENDLOOP

'move to start point for next character

	DRAW "BM= "+ VARPTR$(XLOC%) + ", =" + VARPTR$(YLOC%)

'if not a space, draw the letter

	IF CODE% <> 32 THEN DRAW LETTER$(CODE%)

'next letter will be 25 pixels to the right

	XLOC% = XLOC% + 25			

ENDLOOP:  					
	LOOP

END SUB

                                                                                                                   